;-------------------------------------------------------------------------------
;
; DW2BSTR             PROTO :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
;   useage prototype
;    invoke DW2BSTR pbstrResult, dwData
;   Description: Converts a dword quantity to a unicode bstr string dwData
;    and returns it in *bstrResult
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------
include 	\masm32\include\kernel32.inc
include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc

.LISTALL
wsprintfA   PROTO C :DWORD,:VARARG
wsprintf    equ     <wsprintfA>

;-------------------------------------------------------------------------------
.code
;-------------------------------------------------------------------------------
DW2BSTR PROC pbstrResult:DWORD, dwValue:DWORD
    LOCAL wszResult[8]:wchar, szResult[6]:BYTE, fMtStrinG:DWORD

    ; init format string for wsprintf
    mov fMtStrinG, 00756C25H  ; "%lu",0 in hex
    ; use the wsprintf method to convert dword to ascii
    invoke wsprintf, ADDR szResult, ADDR fMtStrinG, dwValue
    ; convert the ascii string to unicode
    invoke MultiByteToWideChar, CP_ACP, 0, ADDR szResult, -1, ADDR wszResult, 8
    ; allocate the unicode string to the return bstr
    invoke SysReAllocString, pbstrResult, ADDR wszResult
    ret

DW2BSTR ENDP
END