;-------------------------------------------------------------------------------
;
; bstrRight procedure 
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke bstrRight, bstrSource, dwCCount, ADDR bstrReturn
;
; Description: extracts the last dwCCount characters from bstrSource, 
;   and returns it in *bstrName
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
bstrRight	PROC PUBLIC bstrSource:DWORD, dwCCount:DWORD, pbstrReturn:DWORD
	LOCAL len:DWORD
	
	; get length of target
	invoke SysStringLen, bstrSource
	mov len, eax
	; check start param
	mov eax, dwCCount
	.IF dwCCount > eax 
		; adjust the count
		mov dwCCount, eax
	.ENDIF
	; make a pointer to the first char we want
	mov ecx, len
	sub ecx, dwCCount
	rol ecx, 1			; ecx = 2*(len - dwCCount)
	add ecx, bstrSource
	invoke SysReAllocString, pbstrReturn, ecx
	; return retval from SysReAllocStringLen
	ret
bstrRight	ENDP
;-------------------------------------------------------------------------------

END