;-------------------------------------------------------------------------------
;
; bstrMid procedure 
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke bstrMid, bstrSource, dwStart, dwCCount, ADDR bstrReturn
;
; Description: extracts dwCCount characters from bstrSource, 
;   starting at dwStart, and returns it in *bstrName
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
bstrMid	PROC PUBLIC bstrSource:DWORD, dwStart:DWORD, 
                    dwCCount:DWORD, pbstrReturn:DWORD
	LOCAL len:DWORD, pStart:DWORD
	
	; get length of target
	invoke SysStringLen, bstrSource
	mov len, eax
	; check start param
	mov eax, dwStart
	.IF eax > len
		; this is not gonna work
		mov ecx, pbstrReturn
		xor eax, eax
		mov [ecx], eax	; return a null string
		mov eax, S_FALSE
		ret
	.ENDIF
	; check character count
	mov eax, dwStart
	add eax, dwCCount
	.IF eax > len
		; adjust count for reamining chars
		mov eax, len
		sub eax, dwStart
		mov dwCCount, eax
	.ENDIF
	; get starting position ptr
	mov ecx, dwStart
	dec ecx
	rol ecx, 1			; start pos * 2
	add ecx, bstrSource
	invoke SysReAllocStringLen, pbstrReturn, ecx, dwCCount
	; return retval from SysReAllocStringLen
	ret
bstrMid	ENDP
;-------------------------------------------------------------------------------

END