;-------------------------------------------------------------------------------
;
; bstrLeft procedure 
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke bstrLeft, bstrSource, dwCCount, ADDR bstrReturn
;
; Description: extracts the first dwCCount characters from bstrSource, 
;   and returns it in *bstrName
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
bstrLeft	PROC PUBLIC bstrSource:DWORD, dwCCount:DWORD, pbstrReturn:DWORD
	LOCAL len:DWORD
	
	; get length of target
	invoke SysStringLen, bstrSource
	mov len, eax
	; check start param
	.IF dwCCount > eax 
		; adjust the count
		mov dwCCount, eax
	.ENDIF
	invoke SysReAllocStringLen, pbstrReturn, bstrSource, dwCCount
	; return retval from SysReAllocStringLen
	ret
bstrLeft	ENDP
;-------------------------------------------------------------------------------

END