;-------------------------------------------------------------------------------
;
; bstrGetCL
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
;   useage prototype
;    invoke DW2BSTR pbstrResult, dwData
;   Description: Converts a dword quantity to a unicode bstr string dwData
; -------------------------------------------------
; parses the WIDE command line for parameters. 
; Returns wide strings
; arguments returned in "ItemBuffer"
;
; arg 0 = program name
; arg 1 = 1st arg
; arg 2 = 2nd arg etc....
; -------------------------------------------------
; Return values in eax
;
; 1 = successful operation
; 2 = no argument exists at specified arg number
; 3 = non matching quotation marks
; 4 = empty quotation marks
; -------------------------------------------------
;-------------------------------------------------------------------------------
.386                      ; force 32 bit code
.model flat, stdcall      ; memory model & calling convention
option casemap :none      ; case sensitive

include 	\masm32\include\kernel32.inc
include     \masm32\include\oleaut32.inc
include     bstrLib.inc

GetCL  PROTO :DWORD,:DWORD
wchar      TYPEDEF     WORD

.code

;-------------------------------------------------------------------------------
bstrGetCL proc ArgNum:DWORD, pItemBuffer:DWORD

    LOCAL wszTempBuf[192] :wchar, szTempBuf[192] :wchar
    
    invoke GetCL, ArgNum, ADDR szTempBuf
    Ascii2Unicode ADDR wszTempBuf, ADDR szTempBuf, 192
    invoke SysReAllocString, pItemBuffer, ADDR wszTempBuf
    ret

bstrGetCL ENDP
; #########################################################################

end