
sub AddTab(byval hWin as HWND,hEdt as HWND,byval lpFileName as string)
	dim tci as TCITEM
	dim hTab as HWND
	dim lpTABMEM as TABMEM ptr

	buff=lpFileName
	do while instr(buff,"\\")
		buff=mid(buff,instr(buff,"\\")+1)
	loop
	lpTABMEM=GlobalAlloc(GMEM_FIXED,sizeof(TABMEM))
	lpTABMEM->hedit=hREd
	lpTABMEM->filename=lpFileName
	tci.mask=TCIF_TEXT or TCIF_PARAM
	tci.pszText=@buff
	tci.lParam=lpTABMEM
	hTab=GetDlgItem(hWin,IDC_TABSELECT)
	SendMessage(hTab,TCM_SETCURSEL,SendMessage(hTab,TCM_INSERTITEM,999,@tci),0)

end sub

sub DelTab(byval hWin as HWND)
	dim tci as TCITEM
	dim hTab as HWND
	dim lpTABMEM as TABMEM ptr
	dim i as integer

	hTab=GetDlgItem(hWin,IDC_TABSELECT)
	tci.mask=TCIF_PARAM
	i=SendMessage(hTab,TCM_GETCURSEL,0,0)
	SendMessage(hTab,TCM_GETITEM,i,@tci)
	lpTABMEM=tci.lParam
	DestroyWindow(lpTABMEM->hedit)
	GlobalFree(lpTABMEM)
	SendMessage(hTab,TCM_DELETEITEM,i,0)
	if SendMessage(hTab,TCM_GETITEMCOUNT,0,0) then
		SendMessage(hTab,TCM_SETCURSEL,i,0)
		if SendMessage(hTab,TCM_GETCURSEL,0,0)=-1 then
			SendMessage(hTab,TCM_SETCURSEL,i-1,0)
		endif
		tci.mask=TCIF_PARAM
		SendMessage(hTab,TCM_GETITEM,SendMessage(hTab,TCM_GETCURSEL,0,0),@tci)
		lpTABMEM=tci.lParam
		hREd=lpTABMEM->hedit
		FileName=lpTABMEM->filename
		SendMessage(hWin,WM_SIZE,0,0)
		ShowWindow(hREd,SW_SHOW)
		SetFocus(hREd)
		SetWinCaption(hWin)
	else
		SendMessage(hWin,WM_COMMAND,IDM_FILE_NEW,0)
	endif

end sub

sub UpdateTab(byval hWin as HWND)
	dim tci as TCITEM
	dim hTab as HWND
	dim lpTABMEM as TABMEM ptr
	dim i as integer

	hTab=GetDlgItem(hWin,IDC_TABSELECT)
	i=SendMessage(hTab,TCM_GETCURSEL,0,0)
	tci.mask=TCIF_PARAM
	SendMessage(hTab,TCM_GETITEM,i,@tci)
	lpTABMEM=tci.lParam
	buff=FileName
	do while instr(buff,"\\")
		buff=mid(buff,instr(buff,"\\")+1)
	loop
	lpTABMEM->filename=FileName
	tci.mask=TCIF_TEXT
	tci.pszText=@buff
	SendMessage(hTab,TCM_SETITEM,i,@tci)

end sub

function IsFileOpen(byval hWin as HWND,byval fn as string) as BOOL
	dim tci as TCITEM
	dim hTab as HWND
	dim lpTABMEM as TABMEM ptr
	dim i as integer

	hTab=GetDlgItem(hWin,IDC_TABSELECT)
	tci.mask=TCIF_PARAM
	i=0
	do while TRUE
		if SendMessage(hTab,TCM_GETITEM,i,@tci) then
			lpTABMEM=tci.lParam
			if lstrcmpi(fn,lpTABMEM->filename)=0 then
				ShowWindow(hREd,SW_HIDE)
				hREd=lpTABMEM->hedit
				FileName=lpTABMEM->filename
				SendMessage(hWin,WM_SIZE,0,0)
				ShowWindow(hREd,SW_SHOW)
				SendMessage(hTab,TCM_SETCURSEL,i,0)
				SetWinCaption(hWin)
				SetFocus(hREd)
				return TRUE
			endif
		else
			exit do
		endif
		i=i+1
	loop
	return FALSE

end function

sub OpenAFile(byval hWin as HWND)
	dim ofn as OPENFILENAME
	dim hMem as integer
	dim i as integer
	dim pth as string*260
	dim s as string*260

	hMem=GlobalAlloc(GMEM_FIXED or GMEM_ZEROINIT,32*1024)
	ofn.lStructSize=sizeof(OPENFILENAME)
	ofn.hwndOwner=hWin
	ofn.hInstance=hInstance
	buff=string(260,0)
	ofn.lpstrFile=hMem
	ofn.nMaxFile=32*1024
	ofn.lpstrFilter=StrPtr(ALLFilterString)
	ofn.Flags=OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST or OFN_ALLOWMULTISELECT or OFN_EXPLORER
	if GetOpenFileName(@ofn) then
		lstrcpy(@pth,hMem)
		i=lstrlen(@pth)+1
		lstrcpy(@s,hMem+i)
		if asc(s)=0 then
			' Open single file
			if IsFileOpen(hWin,pth)=FALSE then
				FileName=pth
				CreateEdit(hWin)
				AddTab(hWin,hREd,FileName)
				ReadTheFile(hWin)
			endif
		else
			' Open multiple files
			do while asc(s)<>0
				FileName=pth & "\\" & s
				CreateEdit(hWin)
				AddTab(hWin,hREd,FileName)
				ReadTheFile(hWin)
				i=i+lstrlen(@s)+1
				lstrcpy(@s,hMem+i)
			loop
		endif
	endif
	GlobalFree(hMem)

end sub

function SaveFileAs(byval hWin as HWND) as boolean
	dim ofn as OPENFILENAME

	ofn.lStructSize=sizeof(OPENFILENAME)
	ofn.hwndOwner=hWin
	ofn.hInstance=hInstance
	buff=FileName
	ofn.lpstrFile=StrPtr(buff)
	ofn.nMaxFile=260
	ofn.Flags=OFN_HIDEREADONLY or OFN_PATHMUSTEXIST or OFN_OVERWRITEPROMPT
	if GetSaveFileName(@ofn) then
		FileName=buff
		WriteTheFile(hWin)
		UpdateTab(hWin)
		SetWinCaption(hWin)
		return TRUE
	endif
	return FALSE

end function

function WantToSave(byval hWin as HWND) as boolean

	if SendMessage(hREd,EM_GETMODIFY,0,0) then
		select case  MessageBox(hWin,"Want to save changes?","FreeBASIC editor",MB_YESNOCANCEL + MB_ICONQUESTION)
			case IDYES
				if FileName="(Untitled)" then
					return SaveFileAs(hWin) xor TRUE
				else
					WriteTheFile(hWin)
				endif
				'
			case IDCANCEL
				return TRUE
				'
		end select
	endif
	return FALSE

end function

function CloseAllTabs(byval hWin as HWND) as BOOL
	dim tci as TCITEM
	dim hTab as HWND
	dim lpTABMEM as TABMEM ptr
	dim i as integer

	hTab=GetDlgItem(hWin,IDC_TABSELECT)
	tci.mask=TCIF_PARAM
	i=0
	do while TRUE
		if SendMessage(hTab,TCM_GETITEM,i,@tci) then
			lpTABMEM=tci.lParam
			if SendMessage(lpTABMEM->hedit,EM_GETMODIFY,0,0) then
				ShowWindow(hREd,SW_HIDE)
				hREd=lpTABMEM->hedit
				FileName=lpTABMEM->filename
				SendMessage(hWin,WM_SIZE,0,0)
				ShowWindow(hREd,SW_SHOW)
				SendMessage(hTab,TCM_SETCURSEL,i,0)
				SetWinCaption(hWin)
				if WantToSave(hWin) then
					return TRUE
				endif
			endif
		else
			exit do
		endif
		i=i+1
	loop
	do while TRUE
		if SendMessage(hTab,TCM_GETITEM,0,@tci) then
			lpTABMEM=tci.lParam
			DestroyWindow(lpTABMEM->hedit)
			GlobalFree(lpTABMEM)
			SendMessage(hTab,TCM_DELETEITEM,0,0)
		else
			exit do
		endif
	loop
	return FALSE

end function

