
#define IDD_GOTODLG							4000
#define IDC_LINENO							1001

function GotoDlgProc(byval hWin as HWND,byval uMsg as UINT,byval wParam as WPARAM,byval lParam as LPARAM) as integer
	dim as long id,event
	dim chrg as CHARRANGE

	select case uMsg
		case WM_INITDIALOG
			'
		case WM_COMMAND
			id=loword(wParam)
			event=hiword(wParam)
			if event=BN_CLICKED then
				if id=IDOK then
					' Get line number
					id=GetDlgItemInt(hWin,IDC_LINENO,NULL,FALSE)-1
					if SendMessage(hREd,EM_GETLINECOUNT,0,0)>id and id>=0 then
						' Setup CHARRANGE and set selection
						chrg.cpMin=SendMessage(hREd,EM_LINEINDEX,id,0)
						chrg.cpMax=chrg.cpMin
						SendMessage(hREd,EM_EXSETSEL,0,@chrg)
						' Scroll the caret into view
						SendMessage(hREd,EM_SCROLLCARET,0,0)
						' Set the focus
						SetFocus(hREd)
						' Terminate the dialog
						SendMessage(hWin,WM_CLOSE,NULL,NULL)
					else
						' Line number too big
						MessageBeep(MB_ICONASTERISK)
					endif
				elseif id=2 then
					' Terminate the dialog
					SendMessage(hWin,WM_CLOSE,NULL,NULL)
				endif
			endif
			'
		case WM_ACTIVATE
			if wParam<>WA_INACTIVE then
				hFind=hWin
			endif
			'
		case WM_CLOSE
			DestroyWindow(hWin)
			hFind=0
			SetFocus(hREd)
			'
		case else
			return FALSE
			'
	end select
	return TRUE

end function

