
#define IDD_FINDDLG							2000
#define IDC_FINDTEXT							2001
#define IDC_BTN_REPLACE						2007
#define IDC_REPLACETEXT						2002
#define IDC_REPLACESTATIC					2009
#define IDC_BTN_REPLACEALL					2008
#define IDC_CHK_WHOLEWORD					2004
#define IDC_CHK_MATCHCASE					2003
#define IDC_RBN_DOWN							2005
#define IDC_RBN_UP							2006

dim SHARED findbuff as string*260
dim SHARED replacebuff as string*260
dim SHARED fr as long=FR_DOWN
dim SHARED fres as long
dim SHARED ft as FINDTEXTEX

function Find(hWin as HWND,frType as long) as long

	' Get current selection
	SendMessage(hREd,EM_EXGETSEL,0,@ft.chrg)
	' Setup find
	if frType and FR_DOWN then
		if fres<>-1 then
			ft.chrg.cpMin=ft.chrg.cpMin+1
		endif
		ft.chrg.cpMax=-1
	else
		ft.chrg.cpMax=0
	endif
	ft.lpstrText=@findbuff
	' Do the find
	fres=SendMessage(hREd,EM_FINDTEXTEX,frType,@ft)
	if fres<>-1 then
		' Mark the foud text
		SendMessage(hREd,EM_EXSETSEL,0,@ft.chrgText)
		SendMessage(hREd,REM_VCENTER,0,0)
		SendMessage(hREd,EM_SCROLLCARET,0,0)
	else
		' Region searched
		MessageBox(hWin,StrPtr("Region searched"),StrPtr("FreeBASIC editor"),MB_OK or MB_ICONINFORMATION)
	endif
	return fres

end function

function FindDlgProc(byval hWin as HWND,byval uMsg as UINT,byval wParam as WPARAM,byval lParam as LPARAM) as integer
	dim as long id,event,lret
	dim hCtl as HWND

	select case uMsg
		case WM_INITDIALOG
			if lParam then
				PostMessage(hWin,WM_COMMAND,(BN_CLICKED shl 16) or IDC_BTN_REPLACE,0)
			endif
			' Put text in edit boxes
			SendDlgItemMessage(hWin,IDC_FINDTEXT,EM_LIMITTEXT,255,0)
			SendDlgItemMessage(hWin,IDC_FINDTEXT,WM_SETTEXT,0,@findbuff)
			SendDlgItemMessage(hWin,IDC_REPLACETEXT,EM_LIMITTEXT,255,0)
			SendDlgItemMessage(hWin,IDC_REPLACETEXT,WM_SETTEXT,0,@replacebuff)
			' Set check boxes
			if fr and FR_MATCHCASE then
				CheckDlgButton(hWin,IDC_CHK_MATCHCASE,BST_CHECKED)
			endif
			if fr and FR_WHOLEWORD then
				CheckDlgButton(hWin,IDC_CHK_WHOLEWORD,BST_CHECKED)
			endif
			' Set find direction
			if fr and FR_DOWN then
				hCtl=IDC_RBN_DOWN
			else
				hCtl=IDC_RBN_UP
			endif
			CheckDlgButton(hWin,hCtl,BST_CHECKED)
			'
		case WM_ACTIVATE
			if wParam<>WA_INACTIVE then
				hFind=hWin
			endif
			fres=-1
			'
		case WM_COMMAND
			id=loword(wParam)
			event=hiword(wParam)
			if event=BN_CLICKED then
				select case id
					case IDOK
						Find(hWin,fr)
						'
					case IDCANCEL
						SendMessage(hWin,WM_CLOSE,0,0)
						'
					case IDC_BTN_REPLACE
						hCtl=GetDlgItem(hWin,IDC_BTN_REPLACEALL)
						if IsWindowEnabled(hCtl)=FALSE then
							' Enable Replace all button
							EnableWindow(hCtl,TRUE)
							' Set caption to Replace...
							SetWindowText(hWin,StrPtr("Replace..."))
							' Show replace
							hCtl=GetDlgItem(hWin,IDC_REPLACESTATIC)
							ShowWindow(hCtl,SW_SHOWNA)
							hCtl=GetDlgItem(hWin,IDC_REPLACETEXT)
							ShowWindow(hCtl,SW_SHOWNA)
						else
							if fres<>-1 then
								SendMessage(hREd,EM_EXGETSEL,0,@ft.chrg)
								SendMessage(hREd,EM_REPLACESEL,TRUE,@replacebuff)
								lret=lstrlen(@replacebuff)
								ft.chrg.cpMax=ft.chrg.cpMin+lret
								SendMessage(hREd,EM_EXSETSEL,0,@ft.chrg)
							endif
							Find(hWin,fr)
						endif
						'
					case IDC_BTN_REPLACEALL
						if fres=-1 then
							Find(hWin,fr)
						endif
						do while fres<>-1
							SendMessage(hWin,WM_COMMAND,(BN_CLICKED shl 16) or IDC_BTN_REPLACE,0)
						loop
						'
					case IDC_CHK_MATCHCASE
						fr=fr xor FR_MATCHCASE
						fres=-1
						'
					case IDC_CHK_WHOLEWORD
						fr=fr xor FR_WHOLEWORD
						fres=-1
						'
					case IDC_RBN_DOWN
						fr=fr or FR_DOWN
						fres=-1
						'
					case IDC_RBN_UP
						fr=fr and (-1 xor FR_DOWN)
						fres=-1
						'
				end select
				'
			elseif event=EN_CHANGE then
				' Update text buffers
				if id=IDC_FINDTEXT then
					SendDlgItemMessage(hWin,id,WM_GETTEXT,255,@findbuff)
					fres=-1
				elseif id=IDC_REPLACETEXT then
					SendDlgItemMessage(hWin,id,WM_GETTEXT,255,@replacebuff)
					fres=-1
				endif
			endif
			'
		case WM_CLOSE
			DestroyWindow(hWin)
			hFind=0
			SetFocus(hREd)
			'
		case else
			return FALSE
			'
	end select
	return TRUE

end function

