
#define IDD_DLGABOUT							3000
#define IDC_URL								1002

dim SHARED OldUrlProc as integer
dim SHARED fMouseOver as BOOL
dim SHARED hUrlFont as HFONT
dim SHARED hUrlFontU as HFONT
dim SHARED hUrlBrush as HBRUSH

function UrlProc(byval hWin as HWND,byval uMsg as UINT,byval wParam as WPARAM,byval lParam as LPARAM) as integer
	dim rect as RECT
	dim buffer as string*128

	select case uMsg
		case WM_MOUSEMOVE
			' Set the hand cursor
			SetCursor(LoadCursor(NULL,IDC_HAND))
			' Check if mouse is captured
			if GetCapture<>hWin then
				' Mouse is not captured and is over the control
				fMouseOver=TRUE
				SetCapture(hWin)
				SendMessage(hWin,WM_SETFONT,hUrlFontU,TRUE)
			else
				' Mouse is captured
				' Check if mouse has left the control
				GetClientRect(hWin,@rect)
				if loword(lParam)>rect.right or hiword(lParam)>rect.bottom then
					' Mouse has left the control
					fMouseOver=FALSE
					ReleaseCapture
					SendMessage(hWin,WM_SETFONT,hUrlFont,TRUE)
				endif
			endif
			'
		case WM_LBUTTONUP
			' Url was clicked
			fMouseOver=FALSE
			ReleaseCapture
			SendMessage(hWin,WM_SETFONT,hUrlFont,TRUE)
			GetWindowText(hWin,@buffer,sizeof(buffer))
			ShellExecute(hWnd,StrPtr("Open"),@buffer,NULL,NULL,SW_SHOWNORMAL)
			'
	end select
	return CallWindowProc(OldUrlProc,hWin,uMsg,wParam,lParam)

end function

function AboutDlgProc(byval hWin as HWND,byval uMsg as UINT,byval wParam as WPARAM,byval lParam as LPARAM) as integer
	dim as long id,event
	dim lf as LOGFONT

	select case uMsg
		case WM_INITDIALOG
			' Subclass the control
			OldUrlProc=SetWindowLong(GetDlgItem(hWin,IDC_URL),GWL_WNDPROC,@UrlProc)
			' Get dialogs font
			hUrlFont=SendMessage(hWin,WM_GETFONT,0,0)
			GetObject(hUrlFont,sizeof(LOGFONT),@lf)
			' Create an underlined font
			lf.lfUnderline=TRUE
			hUrlFontU=CreateFontIndirect(@lf)
			' Create a back brush
			hUrlBrush=CreateSolidBrush(GetSysColor(COLOR_3DFACE))
			'
		case WM_COMMAND
			id=loword(wParam)
			event=hiword(wParam)
			if event=BN_CLICKED then
				if id=IDOK then
					SendMessage(hWin,WM_CLOSE,NULL,NULL)
				endif
			endif
			'
		case WM_CTLCOLORSTATIC
			if GetDlgItem(hWin,IDC_URL)=lParam then
				' Set Url control colors
				if fMouseOver then
					SetTextColor(wParam,&HFF0000)
				else
					SetTextColor(wParam,0)
				endif
				SetBkMode(wParam,TRANSPARENT)
				return hUrlBrush
			endif
			return 0
		case WM_CLOSE
			' Delete font
			DeleteObject(hUrlFontU)
			' Delete brush
			DeleteObject(hUrlBrush)
			EndDialog(hWin,0)
			'
		case else
			return FALSE
			'
	end select
	return TRUE

end function

