Win32 App
RichEditEditor
RichEdit Editor
[*BEGINPRO*]
[*BEGINDEF*]
[MakeDef]
Menu=1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0
1=4,O,$B\RC.EXE /v,1
2=3,O,$B\ML.EXE /c /coff /Cp /nologo /I"$I",2
3=5,O,$B\LINK.EXE /SUBSYSTEM:WINDOWS /RELEASE /VERSION:4.0 /LIBPATH:"$L" /OUT:"$5",3,4
4=0,0,,5
5=rsrc.obj,O,$B\CVTRES.EXE,rsrc.res
6=*.obj,O,$B\ML.EXE /c /coff /Cp /nologo /I"$I",*.asm
7=0,0,"$E\OllyDbg",5
11=4,O,$B\RC.EXE /v,1
12=3,O,$B\ML.EXE /c /coff /Cp /nologo /I"$I",2
13=5,O,$B\LINK.EXE /SUBSYSTEM:WINDOWS /DEBUG /VERSION:4.0 /LIBPATH:"$L" /OUT:"$5",3,4
14=0,0,,5
15=rsrc.obj,O,$B\CVTRES.EXE,rsrc.res
16=*.obj,O,$B\ML.EXE /c /coff /Cp /nologo /I"$I",*.asm
17=0,0,"$E\OllyDbg",5
[MakeFiles]
0=RichEditEditor.rap
1=RichEditEditor.rc
2=RichEditEditor.asm
3=RichEditEditor.obj
4=RichEditEditor.res
5=RichEditEditor.exe
6=RichEditEditor.def
7=RichEditEditor.dll
8=RichEditEditor.txt
9=RichEditEditor.lib
10=RichEditEditor.mak
11=RichEditEditor.hla
12=RichEditEditor.com
[Resource]
1=IDB_TBRBMP,1212,0,Res\Toolbar.bmp
[StringTable]
[VerInf]
Nme=VERINF1
ID=1
FV=1.0.1.2
PV=1.0.1.2
VerOS=0x00000004
VerFT=0x00000000
VerLNG=0x00000409
VerCHS=0x000004B0
ProductVersion=1.0.1.2
ProductName=
OriginalFilename=RichEditEditor.exe
LegalTrademarks=
LegalCopyright=KetilO (C) 2002
InternalName=
FileDescription=RadASM RichEdit Editor
FileVersion=1.0.1.2
CompanyName=
[*ENDDEF*]
[*BEGINTXT*]
RichEditEditor.Asm
.386
.model flat,stdcall
option casemap:none

include RichEditEditor.Inc

.code

start:

	invoke GetModuleHandle,NULL
	mov		hInstance,eax
	invoke GetCommandLine
	mov		CommandLine,eax
	invoke InitCommonControls
	mov		iccex.dwSize,sizeof INITCOMMONCONTROLSEX    ;prepare common control structure
	mov		iccex.dwICC,ICC_DATE_CLASSES
	invoke InitCommonControlsEx,addr iccex
	invoke LoadLibrary,addr RichEditDLL
	mov		hRichEdDLL,eax
	invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
	push	eax
	invoke FreeLibrary,hRichEdDLL
	pop		eax
	invoke ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL	wc:WNDCLASSEX
	LOCAL	msg:MSG

	mov		wc.cbSize,SIZEOF WNDCLASSEX
	mov		wc.style,CS_HREDRAW or CS_VREDRAW
	mov		wc.lpfnWndProc,OFFSET WndProc
	mov		wc.cbClsExtra,NULL
	mov		wc.cbWndExtra,DLGWINDOWEXTRA
	push	hInst
	pop		wc.hInstance
	mov		wc.hbrBackground,NULL
	mov		wc.lpszMenuName,IDM_MENU
	mov		wc.lpszClassName,OFFSET ClassName
	invoke LoadIcon,NULL,IDI_APPLICATION
	mov		hIcon,eax
	mov		wc.hIcon,eax
	mov		wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov		wc.hCursor,eax
	invoke RegisterClassEx,addr wc
	invoke CreateDialogParam,hInstance,IDD_DLG,NULL,addr WndProc,NULL
	mov		hWnd,eax
	invoke ShowWindow,hWnd,SW_SHOWNORMAL
	invoke UpdateWindow,hWnd
	.while TRUE
		invoke GetMessage,addr msg,NULL,0,0
	  .break .if !eax
		invoke IsDialogMessage,hFind,addr msg
		.if !eax
			invoke TranslateMessage,addr msg
			invoke DispatchMessage,addr msg
		.endif
	.endw
	mov		eax,msg.wParam
	ret

WinMain endp

StreamInProc proc hFile:DWORD,pBuffer:DWORD,NumBytes:DWORD,pBytesRead:DWORD

	invoke ReadFile,hFile,pBuffer,NumBytes,pBytesRead,0
	xor		eax,1
	ret

StreamInProc endp

StreamOutProc proc hFile:DWORD,pBuffer:DWORD,NumBytes:DWORD,pBytesWritten:DWORD

	invoke WriteFile,hFile,pBuffer,NumBytes,pBytesWritten,0
	xor		eax,1
	ret

StreamOutProc endp

SetWinCaption proc
	LOCAL	buffer[sizeof AppName+3+MAX_PATH]:BYTE
	LOCAL	buffer1[4]:BYTE

	;Add filename to windows caption
	invoke lstrcpy,addr buffer,addr AppName
	mov		eax,' - '
	mov		dword ptr buffer1,eax
	invoke lstrcat,addr buffer,addr buffer1
	invoke lstrcat,addr buffer,addr FileName
	invoke SetWindowText,hWnd,addr buffer
	ret

SetWinCaption endp

SaveFile proc lpFileName:DWORD
	LOCAL	hFile:DWORD
	LOCAL	editstream:EDITSTREAM

	invoke CreateFile,lpFileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
	.if eax!=INVALID_HANDLE_VALUE
		mov		hFile,eax
		;stream the text to the file
		mov		editstream.dwCookie,eax
		mov		editstream.pfnCallback,offset StreamOutProc
		invoke SendMessage,hREd,EM_STREAMOUT,SF_TEXT,addr editstream
		invoke CloseHandle,hFile
		;Set the modify state to false
		invoke SendMessage,hREd,EM_SETMODIFY,FALSE,0
   		mov		eax,FALSE
	.else
		invoke MessageBox,hWnd,addr SaveFileFail,addr AppName,MB_OK
		mov		eax,TRUE
	.endif
	ret

SaveFile endp

SaveEditAs proc
	LOCAL	ofn:OPENFILENAME
	LOCAL	buffer[MAX_PATH]:BYTE

	;Zero out the ofn struct
    invoke RtlZeroMemory,addr ofn,sizeof ofn
	;Setup the ofn struct
	mov		ofn.lStructSize,sizeof ofn
	push	hWnd
	pop		ofn.hwndOwner
	push	hInstance
	pop		ofn.hInstance
	mov		ofn.lpstrFilter,NULL
	mov		buffer[0],0
	lea		eax,buffer
	mov		ofn.lpstrFile,eax
	mov		ofn.nMaxFile,sizeof buffer
	mov		ofn.Flags,OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST or OFN_OVERWRITEPROMPT
    mov		ofn.lpstrDefExt,NULL
    ;Show save as dialog
	invoke GetSaveFileName,addr ofn
	.if eax
		invoke SaveFile,addr buffer
		.if !eax
			;The file was saved
			invoke lstrcpy,addr FileName,addr buffer
			invoke SetWinCaption
			mov		eax,FALSE
		.endif
	.else
		mov		eax,TRUE
	.endif
	ret

SaveEditAs endp

SaveEdit proc

	;Check if filrname is (Untitled)
	invoke lstrcmp,addr FileName,addr NewFile
	.if eax
		invoke SaveFile,addr FileName
	.else
		invoke SaveEditAs
	.endif
	ret

SaveEdit endp

WantToSave proc
	LOCAL	buffer[512]:BYTE
	LOCAL	buffer1[2]:BYTE

	invoke SendMessage,hREd,EM_GETMODIFY,0,0
	.if eax
		invoke lstrcpy,addr buffer,addr WannaSave
		invoke lstrcat,addr buffer,addr FileName
		mov		ax,'?'
		mov		word ptr buffer1,ax
		invoke lstrcat,addr buffer,addr buffer1
		invoke MessageBox,hWnd,addr buffer,addr AppName,MB_YESNOCANCEL or MB_ICONQUESTION
		.if eax==IDYES
			invoke SaveEdit
	    .elseif eax==IDNO
		    mov		eax,FALSE
	    .else
		    mov		eax,TRUE
		.endif
	.endif
	ret

WantToSave endp

OpenEdit proc
	LOCAL	ofn:OPENFILENAME
    LOCAL   hFile:DWORD
	LOCAL	editstream:EDITSTREAM
	LOCAL	buffer[MAX_PATH]:BYTE
	LOCAL	chrg:CHARRANGE

	;Zero out the ofn struct
	invoke RtlZeroMemory,addr ofn,sizeof ofn
	;Setup the ofn struct
	mov		ofn.lStructSize,sizeof ofn
	push	hWnd
	pop		ofn.hwndOwner
	push	hInstance
	pop		ofn.hInstance
	mov		ofn.lpstrFilter,NULL
	mov		buffer[0],0
	lea		eax,buffer
	mov		ofn.lpstrFile,eax
	mov		ofn.nMaxFile,sizeof buffer
	mov		ofn.lpstrDefExt,NULL
	mov		ofn.Flags,OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	;Show the Open dialog
	invoke GetOpenFileName,addr ofn
	.if eax
		;Open the file
		invoke CreateFile,addr buffer,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
		.if eax!=INVALID_HANDLE_VALUE
			mov		hFile,eax
			;Copy buffer to FileName
			invoke lstrcpy,addr FileName,addr buffer
			;stream the text into the richedit control
			push	hFile
			pop		editstream.dwCookie
			mov		editstream.pfnCallback,offset StreamInProc
			invoke SendMessage,hREd,EM_STREAMIN,SF_TEXT,addr editstream
			invoke CloseHandle,hFile
			invoke SendMessage,hREd,EM_SETMODIFY,FALSE,0
			mov		chrg.cpMin,0
			mov		chrg.cpMax,0
			invoke SendMessage,hREd,EM_EXSETSEL,0,addr chrg
			invoke SetWinCaption
			mov		eax,FALSE
		.else
			invoke MessageBox,hWnd,addr OpenFileFail,addr AppName,MB_OK
			mov		eax,TRUE
		.endif
	.endif
	ret

OpenEdit endp

FindDlgProc proc hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	LOCAL	hCtl:DWORD

	mov		eax,uMsg
	.if eax==WM_INITDIALOG
		mov		eax,hWin
		mov		hFind,eax
		.if !lParam
			;Disable replace
			invoke GetDlgItem,hWin,IDC_REPLACETEXT
			mov     hCtl,eax
			invoke GetWindowLong,hCtl,GWL_STYLE
			xor     eax,WS_VISIBLE
			invoke SetWindowLong,hCtl,GWL_STYLE,eax
			invoke GetDlgItem,hWin,IDC_REPLACESTATIC
			mov     hCtl,eax
			invoke GetWindowLong,hCtl,GWL_STYLE
			xor     eax,WS_VISIBLE
			invoke SetWindowLong,hCtl,GWL_STYLE,eax
			invoke GetDlgItem,hWin,IDC_BTN_REPLACEALL
			invoke EnableWindow,eax,FALSE
		.else
			invoke SetWindowText,hWin, addr Replace
		.endif
	.elseif eax==WM_COMMAND
		mov		eax,wParam
		mov		edx,eax
		shr		edx,16
		and		eax,0FFFFh
		.if edx==BN_CLICKED
			.if eax==IDOK

			.elseif eax==IDCANCEL
				invoke SendMessage,hWin,WM_CLOSE,NULL,NULL
			.endif
		.endif
	.elseif eax==WM_CLOSE
		mov		hFind,0
		invoke EndDialog,hWin,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov  eax,TRUE
	ret

FindDlgProc endp

DoToolBar proc hInst:DWORD,hToolBar:HWND
	LOCAL	tbab:TBADDBITMAP

	;Set toolbar struct size
	invoke SendMessage,hToolBar,TB_BUTTONSTRUCTSIZE,sizeof TBBUTTON,0
	;Set toolbar bitmap
	push	hInst
	pop		tbab.hInst
	mov		tbab.nID,IDB_TBRBMP
	invoke SendMessage,hToolBar,TB_ADDBITMAP,15,addr tbab
	;Set toolbar buttons
	invoke SendMessage,hToolBar,TB_ADDBUTTONS,ntbrbtns,addr tbrbtns
	mov		eax,hToolBar
	ret

DoToolBar endp

SetFormat proc hWin:DWORD
    LOCAL	chrg1:CHARRANGE
    LOCAL	chrg2:CHARRANGE
	LOCAL	pf:PARAFORMAT2
	LOCAL	cf:CHARFORMAT
	LOCAL	tp:DWORD
	LOCAL	buffer[16]:BYTE
	LOCAL	pt:POINT
	LOCAL	hDC:HDC

	;Save modify state
	invoke SendMessage,hWin,EM_GETMODIFY,0,0
	push	eax
	;Save selection
	invoke SendMessage,hWin,EM_EXGETSEL,0,addr chrg1
	invoke SendMessage,hWin,EM_HIDESELECTION,TRUE,0
	;Select all text
	mov		chrg2.cpMin,0
	mov		chrg2.cpMax,-1
	invoke SendMessage,hWin,EM_EXSETSEL,0,addr chrg2
	;Set font charset
	mov		cf.cbSize,sizeof cf
	mov		cf.dwMask,CFM_CHARSET or CFM_FACE or CFM_SIZE or CFM_COLOR
	mov		al,lfnt.lfCharSet
	mov		cf.bCharSet,al
	mov		al,lfnt.lfPitchAndFamily
	mov		cf.bPitchAndFamily,al
	invoke lstrcpyn,addr cf.szFaceName,addr lfnt.lfFaceName,LF_FACESIZE
	mov		eax,lfnt.lfHeight
	neg		eax
	mov		ecx,15
	mul		ecx
	mov		cf.yHeight,eax
	mov		eax,rgb
	mov		cf.crTextColor,eax
	invoke SendMessage,hWin,EM_SETCHARFORMAT,SCF_SELECTION,addr cf
	;Get tab width
	invoke GetDC,hWin
	mov		hDC,eax
	invoke SelectObject,hDC,hFont
	push	eax
	mov		eax,'WWWW'
	mov		dword ptr buffer,eax
	invoke GetTextExtentPoint32,hDC,addr buffer,4,addr pt
	pop		eax
	invoke SelectObject,hDC,eax
	invoke ReleaseDC,hWin,hDC
	mov		eax,pt.x
	mov		ecx,TabSize
	mul		ecx
	mov		ecx,15
	mul		ecx
	shr		eax,2
	mov		tp,eax
	;Set tab stops
	mov		pf.cbSize,sizeof pf
	mov		pf.dwMask,PFM_TABSTOPS
	mov		pf.cTabCount,MAX_TAB_STOPS
	xor		eax,eax
	xor		edx,edx
	mov		ecx,MAX_TAB_STOPS
  @@:
	add		eax,tp
	mov		dword ptr pf.rgxTabs[edx],eax
	add		edx,4
	loop	@b
	invoke SendMessage,hWin,EM_SETPARAFORMAT,0,addr pf
	;Restore modify state
	pop		eax
	invoke SendMessage,hWin,EM_SETMODIFY,eax,0
	;Restore selection
	invoke SendMessage,hWin,EM_EXSETSEL,0,addr chrg1
	invoke SendMessage,hWin,EM_HIDESELECTION,FALSE,0
	ret

SetFormat endp

WndProc proc hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	LOCAL	pt:POINT
	LOCAL	rect:RECT
	LOCAL	ht:DWORD
	LOCAL	hCtl:HWND
	LOCAL	chrg:CHARRANGE
	LOCAL	cf:CHOOSEFONT

	mov		eax,uMsg
	.if eax==WM_INITDIALOG
		push	hWin
		pop		hWnd
		mov		fView,3
		mov		TabSize,4
		;Set the toolbar buttons
		invoke GetDlgItem,hWin,IDC_TBR
		invoke DoToolBar,hInstance,eax
		;Set FileName to NewFile
		invoke lstrcpy,addr FileName,addr NewFile
		invoke SetWinCaption
		;Get handle of RichEdit window and give it focus
		invoke GetDlgItem,hWin,IDC_RED
		mov		hREd,eax
		invoke SendMessage,hREd,EM_SETTEXTMODE,0,TM_PLAINTEXT
		;Set event mask
		invoke SendMessage,hREd,EM_SETEVENTMASK,0,ENM_SELCHANGE
		;Set the text limit. The default is 64K
		invoke SendMessage,hREd,EM_LIMITTEXT,-1,0
		;Create font
		invoke lstrcpy,addr lfnt.lfFaceName,offset szFont
		mov		lfnt.lfHeight,-12
		mov		lfnt.lfWeight,400
		invoke CreateFontIndirect,addr lfnt
		mov     hFont,eax
		;Set font & format
		invoke SetFormat,hREd
		;Init RichEdit
		invoke SendMessage,hREd,EM_SETMODIFY,FALSE,0
		invoke SendMessage,hREd,EM_EMPTYUNDOBUFFER,0,0
		invoke SetFocus,hREd
	.elseif eax==WM_COMMAND
		;Menu and toolbar has the same ID's
		mov		eax,wParam
		and		eax,0FFFFh
		.if eax==IDM_FILE_NEW
			invoke WantToSave
			.if !eax
				invoke SetWindowText,hREd,addr szNULL
				invoke lstrcpy,addr FileName,addr NewFile
				invoke SetWinCaption
			.endif
			invoke SetFocus,hREd
		.elseif eax==IDM_FILE_OPEN
			invoke WantToSave
			.if !eax
				invoke OpenEdit
			.endif
			invoke SetFocus,hREd
		.elseif eax==IDM_FILE_SAVE
			invoke SaveEdit
			invoke SetFocus,hREd
		.elseif eax==IDM_FILE_SAVEAS
			invoke SaveEditAs
			invoke SetFocus,hREd
		.elseif eax==IDM_FILE_PRINT
		.elseif eax==IDM_FILE_EXIT
			invoke SendMessage,hWin,WM_CLOSE,0,0
		.elseif eax==IDM_EDIT_UNDO
			invoke SendMessage,hREd,EM_UNDO,0,0
		.elseif eax==IDM_EDIT_REDO
			invoke SendMessage,hREd,EM_REDO,0,0
		.elseif eax==IDM_EDIT_DELETE
			invoke SendMessage,hREd,EM_REPLACESEL,TRUE,0
		.elseif eax==IDM_EDIT_CUT
			invoke SendMessage,hREd,WM_CUT,0,0
		.elseif eax==IDM_EDIT_COPY
			invoke SendMessage,hREd,WM_COPY,0,0
		.elseif eax==IDM_EDIT_PASTE
			invoke SendMessage,hREd,WM_PASTE,0,0
		.elseif eax==IDM_EDIT_SELECTALL
			mov		chrg.cpMin,0
			mov		chrg.cpMax,-1
			invoke SendMessage,hREd,EM_EXSETSEL,0,addr chrg
		.elseif eax==IDM_EDIT_FIND
			.if hFind==0
				invoke CreateDialogParam,hInstance,IDD_FINDDLG,hWin,addr FindDlgProc,FALSE
			.else
				invoke SetFocus,hFind
			.endif
		.elseif eax==IDM_EDIT_REPLACE
			.if hFind==0
				invoke CreateDialogParam,hInstance,IDD_FINDDLG,hWin,addr FindDlgProc,TRUE
			.else
				invoke SetFocus,hFind
			.endif
		.elseif eax==IDM_VIEW_TOOLBAR
			invoke GetDlgItem,hWin,IDC_TBR
			mov		hCtl,eax
			xor		fView,1
			mov		eax,fView
			and		eax,1
			.if eax
				invoke ShowWindow,hCtl,SW_SHOWNA
			.else
				invoke ShowWindow,hCtl,SW_HIDE
			.endif
			invoke SendMessage,hWin,WM_SIZE,0,0
		.elseif eax==IDM_VIEW_STATUSBAR
			invoke GetDlgItem,hWin,IDC_SBR
			mov		hCtl,eax
			xor		fView,2
			mov		eax,fView
			and		eax,2
			.if eax
				invoke ShowWindow,hCtl,SW_SHOWNA
			.else
				invoke ShowWindow,hCtl,SW_HIDE
			.endif
			invoke SendMessage,hWin,WM_SIZE,0,0
		.elseif eax==IDM_OPTION_FONT
			invoke RtlZeroMemory,addr cf,sizeof cf
			mov		cf.lStructSize,sizeof cf
			mov		eax,hWin
			mov		cf.hwndOwner,eax
			mov		cf.lpLogFont,offset lfnt
			mov		cf.Flags,CF_SCREENFONTS or CF_EFFECTS or CF_INITTOLOGFONTSTRUCT
			mov		eax,rgb
			mov		cf.rgbColors,eax
			invoke ChooseFont,addr cf
			.if eax
				invoke DeleteObject,hFont
				invoke CreateFontIndirect,addr lfnt
				mov     hFont,eax
				mov		eax,cf.rgbColors
				mov		rgb,eax
				invoke SetFormat,hREd
			.endif
			invoke SetFocus,hREd
		.elseif eax==IDM_HELP_ABOUT
			invoke ShellAbout,hWin,addr AppName,addr AboutMsg,hIcon
			invoke SetFocus,hREd
		.endif
	.elseif eax==WM_NOTIFY
		.if wParam==IDC_RED
			;Auto horizontal scroll text into view
			invoke GetCaretPos,addr pt
			invoke GetClientRect,hREd,addr rect
			mov		eax,rect.right
			sub		eax,pt.x
			.if eax<20
				;Caret near right edge
				invoke SendMessage,hREd,EM_GETSCROLLPOS,0,addr pt
				add		pt.x,70
				invoke SendMessage,hREd,EM_SETSCROLLPOS,0,addr pt
			.endif
		.endif
	.elseif eax==WM_SIZE
		mov		eax,fView
		and		eax,1
		.if eax
			;Resize toolbar
			invoke GetDlgItem,hWin,IDC_TBR
			mov		hCtl,eax
			invoke MoveWindow,hCtl,0,0,0,0,TRUE
			;Get height of toolbar
			invoke GetWindowRect,hCtl,addr rect
			mov		eax,rect.bottom
			sub		eax,rect.top
		.endif
		push	eax
		mov		eax,fView
		and		eax,2
		.if eax
			;Resize statusbar
			invoke GetDlgItem,hWin,IDC_SBR
			mov		hCtl,eax
			invoke MoveWindow,hCtl,0,0,0,0,TRUE
			;Get height of statusbar
			invoke GetWindowRect,hCtl,addr rect
			mov		eax,rect.bottom
			sub		eax,rect.top
		.endif
		push	eax
		;Get size of windows client area
		invoke GetClientRect,hWin,addr rect
		;Subtract height of statusbar from bottom
		pop		eax
		sub		rect.bottom,eax
		;Add height of toolbar to top
		pop		eax
		add		rect.top,eax
		;Get new height of RichEdit window
		mov		eax,rect.bottom
		sub		eax,rect.top
		mov		ht,eax
		;Resize RichEdit window
		invoke MoveWindow,hREd,0,rect.top,rect.right,ht,TRUE
	.elseif eax==WM_CLOSE 
		invoke WantToSave
		.if !eax
			invoke DestroyWindow,hWin
		.endif
	.elseif eax==WM_DESTROY
		invoke DeleteObject,hFont
		invoke PostQuitMessage,NULL
	.else
		invoke DefWindowProc,hWin,uMsg,wParam,lParam
		ret
	.endif
	xor    eax,eax
	ret

WndProc endp

end start
[*ENDTXT*]
[*BEGINTXT*]
RichEditEditor.Inc

include windows.inc
include user32.inc
include kernel32.inc
include shell32.inc
include comctl32.inc
include comdlg32.inc
include gdi32.inc

includelib user32.lib
includelib kernel32.lib
includelib shell32.lib
includelib comctl32.lib
includelib comdlg32.lib
includelib gdi32.lib

WinMain				PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc				PROTO :DWORD,:DWORD,:DWORD,:DWORD

;Find.dlg
IDD_FINDDLG			equ 2000
IDC_FINDTEXT		equ 2001
IDC_BTN_REPLACE		equ 2007
IDC_REPLACETEXT		equ 2002
IDC_REPLACESTATIC	equ 2009
IDC_BTN_REPLACEALL	equ 2008
IDC_CHK_WHOLEWORD	equ 2004
IDC_CHK_MATCHCASE	equ 2003
IDC_RBN_DOWN		equ 2005
IDC_RBN_UP			equ 2006

;RichEditEditor.dlg
IDD_DLG				equ 1000
IDC_SBR				equ 1003
IDC_TBR				equ 1001
IDC_RED				equ 1002
IDB_TBRBMP			equ 1212
IDM_MENU			equ 10000

;RichEditEditor.mnu
IDM_FILE_NEW		equ 10001
IDM_FILE_OPEN		equ 10002
IDM_FILE_SAVE		equ 10003
IDM_FILE_SAVEAS		equ 10004
IDM_FILE_PRINT		equ 10005
IDM_FILE_EXIT		equ 10006
IDM_EDIT_UNDO		equ 10101
IDM_EDIT_REDO		equ 10102
IDM_EDIT_DELETE		equ 10103
IDM_EDIT_CUT		equ 10104
IDM_EDIT_COPY		equ 10105
IDM_EDIT_PASTE		equ 10106
IDM_EDIT_SELECTALL	equ 10107
IDM_EDIT_FIND		equ 10108
IDM_EDIT_FINDNEXT	equ 10110
IDM_EDIT_FINDPREV	equ 10111
IDM_EDIT_REPLACE	equ 10109
IDM_VIEW_TOOLBAR	equ 10008
IDM_VIEW_STATUSBAR	equ 10009
IDM_OPTION_FONT		equ 10007
IDM_HELP_ABOUT		equ 10201

.const

;structure for ToolBar buttons
tbrbtns				TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
					TBBUTTON <6,IDM_FILE_NEW,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <7,IDM_FILE_OPEN,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <8,IDM_FILE_SAVE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
					TBBUTTON <0,IDM_EDIT_CUT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <1,IDM_EDIT_COPY,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <2,IDM_EDIT_PASTE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
					TBBUTTON <3,IDM_EDIT_UNDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <4,IDM_EDIT_REDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <5,IDM_EDIT_DELETE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
					TBBUTTON <12,IDM_EDIT_FIND,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <13,IDM_EDIT_REPLACE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
					TBBUTTON <14,IDM_FILE_PRINT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
					TBBUTTON <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
;Number of buttons in tbbtns
ntbrbtns			equ 18

RichEditDLL			db 'riched20.dll',0
ClassName			db 'DLGCLASS',0
AppName				db 'RichEdit editor',0
AboutMsg			db 'RadASM RichEdit editor',13,10,'KetilO (C) 2002',0
Replace				db 'Replace ..',0
OpenFileFail        db 'Cannot open the file',0
SaveFileFail		db 'Cannot save the file',0
WannaSave           db 'Want to save changes to',0Dh,0
NewFile             db '(Untitled)',0
szNULL				db 0
szFont				db 'Courier New',0

.data?

hRichEdDLL			dd ?
hInstance			dd ?
CommandLine			dd ?
hIcon				dd ?
hWnd				HWND ?
hREd				HWND ?
hFind				HWND ?
FileName			db MAX_PATH dup(?)
;structure for DateTimePicker
iccex				INITCOMMONCONTROLSEX <?>

fView				dd ?
TabSize				dd ?
lfnt				LOGFONT <?>
hFont				dd ?
rgb					dd ?
[*ENDTXT*]
[*BEGINTXT*]
RichEditEditor.Rc
#include "res/RichEditEditorRes.rc"
#include "res/RichEditEditorVer.rc"
#include "res/RichEditEditorMnu.rc"
#include "res/RichEditEditorDlg.rc"
#include "res/FindDlg.rc"
[*ENDTXT*]
[*BEGINBIN*]
RichEditEditor.dlg
6400000001000000444C47434C41535300000000000000000000000000000000
00000000000000005269636845646974456469746F722E6D6E75000000000000
00000000000000004D532053616E732053657269660000000000000000000000
000000000000000008000000F6FFFFFF00000000E903000000000000500D0000
4C0D0000010000000000000000000000480D000001000000D32B4100440D0000
000000000008CF16000000000A0000000A000000D50100008501000052696368
4564697420656469746F7200696E646F77000000000000000000000000000000
0000000000000000E80300004944445F444C4700000000000000000000000000
00000000000000000000000000000000000000004C0D000000000000068FE9BF
480D00000000000000000050000000000000000043010000CD01000014000000
5374617475734261720000000000000000000000000000000000000000000000
130000000000000000000000EB0300004944435F534252000000000000000000
000000000000000000000000000000000000000000000000500D000000000000
7B39E9BF480D00000000000000080052000000000000000000000000CD010000
1C00000054657374000000000000000000000000000000000000000000000000
00000000120000000000000001000000E90300004944435F5442520000000000
00000000000000000000000000000000000000000000000000000000540D0000
0000000038A20048480D000000000000C410305000020000000000001B000000
CC01000027010000000000000000000000000000000000000000000000000000
0000000000000000160000000000000002000000EA0300004944435F52454400
0000000000000000000000000000000000000000000000000000000000000000
[*ENDBIN*]
[*BEGINBIN*]
RichEditEditor.mnu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[*ENDBIN*]
[*BEGINBIN*]
Find.dlg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[*ENDBIN*]
[*BEGINTXT*]
RichEditEditor.tbr


[Tbr]
Tbr=,0,1
Bmp=Res\Toolbar.bmp,IDB_TBRBMP,15
Mnu=RichEditEditor.mnu
0=-,0,0,0
1=IDM_FILE_NEW,0,0,6
2=IDM_FILE_OPEN,0,0,7
3=IDM_FILE_SAVE,0,0,8
4=-,0,0,0
5=IDM_EDIT_CUT,0,0,0
6=IDM_EDIT_COPY,0,0,1
7=IDM_EDIT_PASTE,0,0,2
8=-,0,0,0
9=IDM_EDIT_UNDO,0,0,3
10=IDM_EDIT_REDO,0,0,4
11=IDM_EDIT_DELETE,0,0,5
12=-,0,0,0
13=IDM_EDIT_FIND,0,0,12
14=IDM_EDIT_REPLACE,0,0,13
15=-,0,0,0
16=IDM_FILE_PRINT,0,0,14
17=-,0,0,0
[*ENDTXT*]
[*BEGINBIN*]
Res\Toolbar.bmp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[*ENDBIN*]
[*ENDPRO*]
[*BEGINTXT*]
Res\FindDlg.Rc
#define IDD_FINDDLG 2000
#define IDC_FINDTEXT 2001
#define IDC_BTN_REPLACE 2007
#define IDC_REPLACETEXT 2002
#define IDC_REPLACESTATIC 2009
#define IDC_BTN_REPLACEALL 2008
#define IDC_CHK_WHOLEWORD 2004
#define IDC_CHK_MATCHCASE 2003
#define IDC_RBN_DOWN 2005
#define IDC_RBN_UP 2006
IDD_FINDDLG DIALOGEX 6,6,185,66
CAPTION "Find ..."
FONT 8,"MS Sans Serif"
STYLE 0x10C80000
EXSTYLE 0x00000080
BEGIN
  LTEXT "Find what:",-1,3,5,33,9,0x50000100,0x00000000
  EDITTEXT IDC_FINDTEXT,41,3,94,11,0x50010080,0x00000200
  LTEXT "Replace:",IDC_REPLACESTATIC,3,20,31,9,0x40000000,0x00000000
  EDITTEXT IDC_REPLACETEXT,41,18,94,11,0x40010080,0x00000200
  AUTOCHECKBOX "Match Case",IDC_CHK_MATCHCASE,3,36,60,9,0x50010003,0x00000000
  AUTOCHECKBOX "Whole Word",IDC_CHK_WHOLEWORD,3,51,60,9,0x50010003,0x00000000
  GROUPBOX "Direction",-1,71,31,64,30,0x50000007,0x00000000
  AUTORADIOBUTTON "Down",IDC_RBN_DOWN,75,40,50,7,0x50010009,0x00000000
  AUTORADIOBUTTON "Up",IDC_RBN_UP,75,49,50,7,0x50010009,0x00000000
  PUSHBUTTON "Find",1,139,3,40,11,0x50010000,0x00000000
  PUSHBUTTON "Replace",IDC_BTN_REPLACE,139,18,40,11,0x50010000,0x00000000
  PUSHBUTTON "Replace All",IDC_BTN_REPLACEALL,139,33,40,11,0x58010000,0x00000000
  PUSHBUTTON "Cancel",2,139,47,40,11,0x50010000,0x00000000
END
[*ENDTXT*]
[*BEGINTXT*]
Res\RichEditEditorDlg.Rc
#define IDD_DLG 1000
#define IDC_SBR 1003
#define IDC_TBR 1001
#define IDC_RED 1002
IDD_DLG DIALOGEX 6,6,307,222
CAPTION "RichEdit editor"
FONT 8,"MS Sans Serif"
CLASS "DLGCLASS"
STYLE 0x16CF0800
EXSTYLE 0x00000000
BEGIN
  CONTROL "StatusBar",IDC_SBR,"msctls_statusbar32",0x50000000,0,198,307,12,0x00000000
  CONTROL "Test",IDC_TBR,"ToolbarWindow32",0x52000800,0,0,307,17,0x00000000
  CONTROL "",IDC_RED,"RichEdit20A",0x503010C4,0,16,306,181,0x00000200
END
[*ENDTXT*]
[*BEGINTXT*]
Res\RichEditEditorMnu.Rc
#define IDM_MENU 10000
#define IDM_FILE_NEW 10001
#define IDM_FILE_OPEN 10002
#define IDM_FILE_SAVE 10003
#define IDM_FILE_SAVEAS 10004
#define IDM_FILE_PRINT 10005
#define IDM_FILE_EXIT 10006
#define IDM_EDIT_UNDO 10101
#define IDM_EDIT_REDO 10102
#define IDM_EDIT_DELETE 10103
#define IDM_EDIT_CUT 10104
#define IDM_EDIT_COPY 10105
#define IDM_EDIT_PASTE 10106
#define IDM_EDIT_SELECTALL 10107
#define IDM_EDIT_FIND 10108
#define IDM_EDIT_FINDNEXT 10110
#define IDM_EDIT_FINDPREV 10111
#define IDM_EDIT_REPLACE 10109
#define IDM_VIEW_TOOLBAR 10008
#define IDM_VIEW_STATUSBAR 10009
#define IDM_OPTION_FONT 10007
#define IDM_HELP_ABOUT 10201
IDM_MENU MENUEX
BEGIN
  POPUP "&File",,,
  BEGIN
    MENUITEM "&New\tCtrl+N",IDM_FILE_NEW,,
    MENUITEM "&Open\tCtrl+O",IDM_FILE_OPEN,,
    MENUITEM "&Save\tCtrl+S",IDM_FILE_SAVE,,
    MENUITEM "Save &As ...",IDM_FILE_SAVEAS,,
    MENUITEM "",,0x00000800,
    MENUITEM "&Print",IDM_FILE_PRINT,,
    MENUITEM "",,0x00000800,
    MENUITEM "E&xit",IDM_FILE_EXIT,,
  END
  POPUP "&Edit",,,
  BEGIN
    MENUITEM "&Undo",IDM_EDIT_UNDO,,
    MENUITEM "R&edo",IDM_EDIT_REDO,,
    MENUITEM "&Delete",IDM_EDIT_DELETE,,
    MENUITEM "",,0x00000800,
    MENUITEM "&Cut",IDM_EDIT_CUT,,
    MENUITEM "C&opy",IDM_EDIT_COPY,,
    MENUITEM "&Paste",IDM_EDIT_PASTE,,
    MENUITEM "Select &All",IDM_EDIT_SELECTALL,,
    MENUITEM "",,0x00000800,
    MENUITEM "&Find...\tCtrl+F",IDM_EDIT_FIND,,
    MENUITEM "Find &Next\tF3",IDM_EDIT_FINDNEXT,,
    MENUITEM "Find &Previous\tCtrl+F3",IDM_EDIT_FINDPREV,,
    MENUITEM "&Replace...\tCtrl+R",IDM_EDIT_REPLACE,,
  END
  POPUP "&View",,,
  BEGIN
    MENUITEM "&Toolbar",IDM_VIEW_TOOLBAR,,
    MENUITEM "&Statusbar",IDM_VIEW_STATUSBAR,,
  END
  POPUP "&Option",,,
  BEGIN
    MENUITEM "&Font",IDM_OPTION_FONT,,
  END
  POPUP "&Help",,,
  BEGIN
    MENUITEM "&About",IDM_HELP_ABOUT,,
  END
END
[*ENDTXT*]
[*BEGINTXT*]
Res\RichEditEditorRes.rc
#define IDB_TBRBMP						1212
IDB_TBRBMP				BITMAP   DISCARDABLE "Res/Toolbar.bmp"
[*ENDTXT*]
[*BEGINTXT*]
Res\RichEditEditorVer.rc
#define VERINF1 1
VERINF1 VERSIONINFO
FILEVERSION 1,0,1,2
PRODUCTVERSION 1,0,1,2
FILEOS 0x00000004
FILETYPE 0x00000000
BEGIN
  BLOCK "StringFileInfo"
  BEGIN
    BLOCK "040904B0"
    BEGIN
      VALUE "FileVersion", "1.0.1.2\0"
      VALUE "FileDescription", "RadASM RichEdit Editor\0"
      VALUE "LegalCopyright", "KetilO (C) 2002\0"
      VALUE "OriginalFilename", "RichEditEditor.exe\0"
      VALUE "ProductVersion", "1.0.1.2\0"
    END
  END
  BLOCK "VarFileInfo"
  BEGIN
    VALUE "Translation", 0x0409, 0x04B0
  END
END
[*ENDTXT*]
