
;property1 starting with bit 31
;
;(Name)			*
;(ID)			*
;Left			*
;Top			*
;Width			*
;Height			*
;Caption		*
;Border			*
;SysMenu
;MaxButton
;MinButton
;Enabled		*
;Visible		*
;Clipping		*
;ScrollBar		*
;Default
;Auto
;Alignment
;Mnemonic
;WordWrap
;MultiLine
;Type
;Locked
;Child			*
;SizeBorder
;TabStop		*
;Font
;Menu
;Class
;Notify
;AutoScroll
;WantCr
;
;property2 starting with bit 31
;
;Sort
;Flat
;(StartID)
;TabIndex		*
;Format
;SizeGrip
;Group			*
;Icon
;UseTabs
;StartupPos
;Orientation
;SetBuddy
;MultiSelect
;HideSel
;TopMost
;xExStyle		*
;xStyle			*
;IntegralHgt
;Image
;Buttons
;PopUp
;OwnerDraw
;Transp
;Timer
;AutoPlay
;WeekNum
;AviClip
;AutoSize
;ToolTip
;Wrap
;Divider
;
;Note:
;Only some of the properties are general and can be used by the custom control.
;These properties are marked with *
;
;
;Used by RadASM 1.2.0.5. See RadASMini.rtf for more info
CCDEF struct
	ID			dd ?						;Controls uniqe ID
	lptooltip	dd ?						;Pointer to tooltip text
	hbmp		dd ?						;Handle of bitmap
	lpcaption	dd ?						;Pointer to default caption text
	lpname		dd ?						;Pointer to default id-name text
	lpclass		dd ?						;Pointer to class text
	style		dd ?						;Default style
	exstyle		dd ?						;Default ex-style
	property1	dd ?						;Property listbox 1 (bitflags on what properties are enabled)
	property2	dd ?						;Property listbox 2 (bitflags on what properties are enabled)
	disable		dd ?						;Disable controls child windows. 0=No, 1=Use method 1, 2=Use method 2
CCDEF ends

;Used by RadASM 2.1.0.4
CCDEFEX struct
	ID			dd ?		;Controls uniqe ID
	lptooltip	dd ?		;Pointer to tooltip text
	hbmp		dd ?		;Handle of bitmap
	lpcaption	dd ?		;Pointer to default caption text
	lpname		dd ?		;Pointer to default id-name text
	lpclass		dd ?		;Pointer to class text
	style		dd ?		;Default style
	exstyle		dd ?		;Default ex-style
	flist1		dd ?		;Property listbox 1
	flist2		dd ?		;Property listbox 2
	flist3		dd ?		;Property listbox 3
	flist4		dd ?		;Property listbox 4
	lpproperty	dd ?		;Pointer to properties text
	lpmethod	dd ?		;Pointer to property methods descriptor
CCDEFEX ends

PROP_STYLETRUEFALSE		equ 1
PROP_EXSTYLETRUEFALSE	equ 2
PROP_STYLEMULTI			equ 3

WSTYLE					equ WS_CHILD or WS_VISIBLE or WS_CLIPCHILDREN
WEXSTYLE				equ 200h
IDB_BMP					equ 100

.const

szToolTip				db 'RadASM Video Custom Control',0
szCap					db 0
szName					db 'IDC_RAVID',0

PropertyBar				dd -1 xor STYLE_PLAYBAR,0
						dd -1 xor STYLE_PLAYBAR,STYLE_PLAYBAR
PropertyAspect			dd -1 xor STYLE_KEEPASPECT,STYLE_KEEPASPECT
						dd -1 xor STYLE_KEEPASPECT,0

Methods					dd PROP_STYLETRUEFALSE,offset PropertyBar
						dd PROP_STYLETRUEFALSE,offset PropertyAspect
.data

szProperty				db 'PlayBar,KeepAspect',0

ccdef					CCDEF 	<902,offset szToolTip,0,offset szCap,offset szName,offset szClassName,WSTYLE,WEXSTYLE,11111101000111000000000000000000b,00010000000000011000000000000000b,0>
ccdefex					CCDEFEX	<902,offset szToolTip,0,offset szCap,offset szName,offset szClassName,WSTYLE,WEXSTYLE,11111101000111000000000000000000b,00010000000000011000000000000000b,00000000000000000000000000000000b,00000000000000000000000000000000b,offset szProperty,offset Methods>

.code

DllEntry proc hInst:HINSTANCE, reason:DWORD, reserved1:DWORD

	.if reason==DLL_PROCESS_DETACH
		.if hLib
			invoke FreeLibrary,hLib
		.endif
	.elseif reason==DLL_PROCESS_ATTACH
	    mov		eax,hInst
	    mov		hInstance,eax
		invoke CreateClass
		invoke LoadLibrary,addr szLib
		mov		hLib,eax
	.endif
    mov     eax,TRUE
    ret

DllEntry Endp

;NOTE: RadASM 1.2.0.5 uses GetDef method.
;In RadASM.ini section [CustCtrl], x=CustCtrl.dll,y
;x is next free number.
;y is number of controls in the dll. In this case there is only one control.
;
;x=RAVideo.dll,1
;Copy RAVideo.dll to c:\radasm or to c:\windows\system
;
GetDef proc nInx:DWORD

	mov		eax,nInx
	.if !eax
		;Get the toolbox bitmap
		invoke LoadBitmap,hInstance,IDB_BMP
		mov		ccdef.hbmp,eax
		;Return pointer to inited struct
		mov		eax,offset ccdef
	.else
		xor		eax,eax
	.endif
	ret

GetDef endp

;Used by RadASM 2.1.0.4
GetDefEx proc nInx:DWORD

	mov		eax,nInx
	.if !eax
		;Get the toolbox bitmap
		invoke LoadBitmap,hInstance,IDB_BMP
		mov		ccdefex.hbmp,eax
		;Return pointer to inited struct
		mov		eax,offset ccdefex
	.else
		xor		eax,eax
	.endif
	ret

GetDefEx endp

