.386
.model flat,stdcall
option casemap:none

include Data.inc
include ..\RAVideo.inc
include RAVideoDll.asm

.code

CreateClass proc
	LOCAL	wc:WNDCLASSEX

	;Create a windowclass for the user control
	mov		wc.cbSize,sizeof WNDCLASSEX
	mov		wc.style,CS_HREDRAW or CS_VREDRAW or CS_GLOBALCLASS or CS_PARENTDC or CS_DBLCLKS
	mov		wc.lpfnWndProc,offset ControlProc
	mov		wc.cbClsExtra,NULL
	mov		wc.cbWndExtra,4
	push	hInstance
	pop		wc.hInstance
	invoke GetStockObject,BLACK_BRUSH
	mov		wc.hbrBackground,eax
	mov		wc.lpszMenuName,NULL
	mov		wc.lpszClassName,offset szClassName
	mov		eax,NULL
	mov		wc.hIcon,eax
	mov		wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov		wc.hCursor,eax
	invoke RegisterClassEx,addr wc
	ret

CreateClass endp

;--------------------------------------------------------------------------------

MCIWndProc proc hWin:dword,uMsg:dword,wParam:dword,lParam:dword
	LOCAL	ps:PAINTSTRUCT

	mov		eax,uMsg
	.if eax==WM_LBUTTONDOWN
	.elseif eax==WM_ERASEBKGND
		xor		eax,eax
		ret
	.elseif eax==WM_PAINT
		invoke BeginPaint,hWin,addr ps
		invoke GetStockObject,BLACK_BRUSH
		invoke FillRect,ps.hdc,addr ps.rcPaint,eax
		invoke EndPaint,hWin,addr ps
	.else
		invoke CallWindowProc,OldMCIWndProc,hWin,uMsg,wParam,lParam
	.endif
	ret

MCIWndProc endp

ControlProc proc uses ebx,hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	LOCAL	rect:RECT
	LOCAL	rect1:RECT

	mov		eax,uMsg
	.if eax==WM_CREATE
		invoke GlobalAlloc,GMEM_FIXED or GMEM_ZEROINIT,sizeof RAVID
		mov		ebx,eax
		invoke SetWindowLong,hWin,0,ebx
		invoke GetWindowLong,hWin,GWL_STYLE
		mov		[ebx].RAVID.Style,eax
	.elseif eax==WM_SIZE
		invoke GetWindowLong,hWin,0
		mov		ebx,eax
		.if [ebx].RAVID.hMCIWnd
			call	SizeIt
		.endif
	.elseif eax==WM_STYLECHANGED
		invoke GetWindowLong,hWin,0
		mov		ebx,eax
		invoke GetWindowLong,hWin,GWL_STYLE
		mov		[ebx].RAVID.Style,eax
		.if [ebx].RAVID.hMCIWnd
			call	SizeIt
		.endif
	.elseif eax==RAVID_PLAY
		invoke GetWindowLong,hWin,0
		mov		ebx,eax
		.if hLib
			.if [ebx].RAVID.hMCIWnd
				invoke SendMessage,[ebx].RAVID.hMCIWnd,MCI_STOP,0,0
				invoke DestroyWindow,[ebx].RAVID.hMCIWnd
				mov		[ebx].RAVID.hMCIWnd,0
			.endif
			invoke GetProcAddress,hLib,addr szMCIWndCreate
			.if eax
				push	eax
				invoke GetWindowLong,hWin,GWL_STYLE
				mov		edx,MCIWNDF_NOERRORDLG or MCIWNDF_NOAUTOSIZEMOVIE or MCIWNDF_NOMENU or MCIWNDF_NOPLAYBAR or MCIWNDF_NOTIFYMODE
				test	eax,STYLE_PLAYBAR
				.if !ZERO?
					xor		edx,MCIWNDF_NOPLAYBAR
				.else
					xor		edx,MCIWNDF_NOAUTOSIZEMOVIE
				.endif
				mov		[ebx].RAVID.MCIStyle,edx
				pop		eax
				push	lParam
				push	edx
				push	hInstance
				push	hWin
				call	eax
				.if eax
					mov		[ebx].RAVID.hMCIWnd,eax
					add		esp,10h
					invoke SetWindowLong,[ebx].RAVID.hMCIWnd,GWL_WNDPROC,addr MCIWndProc
					mov		OldMCIWndProc,eax
					call	SizeIt
					invoke SendMessage,[ebx].RAVID.hMCIWnd,MCI_PLAY,0,0
				.endif
			.endif
		.endif
		xor		eax,eax
		jmp		Ex
	.elseif eax==RAVID_STOP
		invoke GetWindowLong,hWin,0
		mov		ebx,eax
		.if [ebx].RAVID.hMCIWnd
			invoke SendMessage,[ebx].RAVID.hMCIWnd,MCI_STOP,0,0
			invoke DestroyWindow,[ebx].RAVID.hMCIWnd
			mov		[ebx].RAVID.hMCIWnd,0
		.endif
		xor		eax,eax
		jmp		Ex
	.elseif eax==MCIWNDM_NOTIFYMODE
		.if lParam==MCI_MODE_STOP
			invoke GetWindowLong,hWin,0
			mov		ebx,eax
			invoke SendMessage,[ebx].RAVID.hMCIWnd,MCIWNDM_GETLENGTH,0,0
			push	eax
			invoke SendMessage,[ebx].RAVID.hMCIWnd,MCIWNDM_GETPOSITIONA,0,0
			pop		edx
			.if eax>=edx
				invoke DestroyWindow,[ebx].RAVID.hMCIWnd
				mov		[ebx].RAVID.hMCIWnd,0
			.endif
		.endif
		xor		eax,eax
		jmp		Ex
	.endif
	invoke DefWindowProc,hWin,uMsg,wParam,lParam
  Ex:
	ret

SizeIt:
	invoke GetClientRect,hWin,addr rect
	test	[ebx].RAVID.Style,STYLE_KEEPASPECT
	.if ZERO?
		invoke SendMessage,[ebx].RAVID.hMCIWnd,MCIWNDM_GET_SOURCE,0,addr rect1
		test	[ebx].RAVID.MCIStyle,MCIWNDF_NOPLAYBAR
		.if ZERO?
			sub		rect.bottom,28
		.endif
		mov		eax,rect1.right
		shl		eax,8
		mov		ecx,rect.right
		xor		edx,edx
		div		ecx
		push	eax
		mov		eax,rect1.bottom
		shl		eax,8
		mov		ecx,rect.bottom
		xor		edx,edx
		div		ecx
		pop		edx
		.if edx>eax
			mov		ecx,edx
			mov		eax,rect1.right
			shl		eax,8
			xor		edx,edx
			div		ecx
			mov		rect1.right,eax
			mov		eax,rect1.bottom
			shl		eax,8
			xor		edx,edx
			div		ecx
			.if eax>rect.bottom
				mov		eax,rect.bottom
			.endif
			mov		rect1.bottom,eax
		.else
			mov		ecx,eax
			mov		eax,rect1.right
			shl		eax,8
			xor		edx,edx
			div		ecx
			.if eax>rect.right
				mov		eax,rect.right
			.endif
			mov		rect1.right,eax
			mov		eax,rect1.bottom
			shl		eax,8
			xor		edx,edx
			div		ecx
			mov		rect1.bottom,eax
		.endif
		mov		edx,rect.right
		sub		edx,rect1.right
		.if CARRY?
			xor		edx,edx
		.endif
		shr		edx,1
		mov		rect1.left,edx
		mov		eax,rect.bottom
		sub		eax,rect1.bottom
		.if CARRY?
			xor		eax,eax
		.endif
		shr		eax,1
		mov		rect1.top,eax
		test	[ebx].RAVID.MCIStyle,MCIWNDF_NOPLAYBAR
		.if ZERO?
			add		rect1.right,edx
			add		rect1.bottom,eax
			add		rect.bottom,28
			invoke MoveWindow,[ebx].RAVID.hMCIWnd,0,0,rect.right,rect.bottom,TRUE
			invoke SendMessage,[ebx].RAVID.hMCIWnd,MCIWNDM_PUT_DEST,0,addr rect1
		.else
			invoke MoveWindow,[ebx].RAVID.hMCIWnd,rect1.left,rect1.top,rect1.right,rect1.bottom,TRUE
		.endif
	.else
		invoke MoveWindow,[ebx].RAVID.hMCIWnd,0,0,rect.right,rect.bottom,TRUE
		test	[ebx].RAVID.MCIStyle,MCIWNDF_NOPLAYBAR
		.if ZERO?
			sub		rect.bottom,28
			invoke SendMessage,[ebx].RAVID.hMCIWnd,MCIWNDM_PUT_DEST,0,addr rect
		.endif
	.endif
	retn

ControlProc endp

End DllEntry
