.386
.model flat, stdcall  ;32 bit memory model
option casemap :none  ;case sensitive

include RAVideoApp.inc

.code

start:
	invoke	GetModuleHandle,NULL
	mov	hInstance,eax
	invoke	InitCommonControls
	invoke LoadLibrary,addr szLib
	.if eax
		mov		hLib,eax
		invoke	DialogBoxParam,hInstance,IDD_MAIN,NULL,addr DlgProc,NULL
		invoke FreeLibrary,hLib
	.endif
	invoke	ExitProcess,0

;########################################################################

OpenVideo proc hWin:HWND,lpFileName:DWORD
	LOCAL	ofn:OPENFILENAME

	;Zero out the ofn struct
	invoke RtlZeroMemory,addr ofn,sizeof ofn
	;Setup the ofn struct
	mov		ofn.lStructSize,sizeof ofn
	push	hWin
	pop		ofn.hwndOwner
	push	hInstance
	pop		ofn.hInstance
	mov		ofn.lpstrFilter,offset szVideoFilterString
	mov		eax,lpFileName
	mov		byte ptr [eax],0
	mov		ofn.lpstrFile,eax
	mov		ofn.nMaxFile,MAX_PATH
	mov		ofn.lpstrDefExt,0
	mov		ofn.Flags,OFN_FILEMUSTEXIST or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	;Show the Open dialog
	invoke GetOpenFileName,addr ofn
	ret

OpenVideo endp

DlgProc	proc hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	LOCAL	rect:RECT
	LOCAL	buffer[MAX_PATH]:BYTE

	mov		eax,uMsg
	.if	eax==WM_INITDIALOG
		;initialization here
	.elseif	eax==WM_COMMAND
		mov edx,wParam
		movzx eax,dx
		shr edx,16
		.if edx==BN_CLICKED
			.if eax==IDM_FILE_OPEN
				invoke OpenVideo,hWin,addr buffer
				.if eax
					invoke SendDlgItemMessage,hWin,1001,RAVID_PLAY,0,addr buffer
				.endif
			.elseif eax==IDM_FILE_CLOSE
				invoke SendDlgItemMessage,hWin,1001,RAVID_STOP,0,0
			.elseif eax==IDM_FILE_EXIT
				invoke	SendMessage,hWin,WM_CLOSE,NULL,NULL
			.elseif eax==IDM_VIEW_PLAYBAR
				invoke GetDlgItem,hWin,1001
				push	eax
				invoke GetWindowLong,eax,GWL_STYLE
				xor		eax,STYLE_PLAYBAR
				pop		edx
				invoke SetWindowLong,edx,GWL_STYLE,eax
			.elseif eax==IDM_VIEW_ASPECT
				invoke GetDlgItem,hWin,1001
				push	eax
				invoke GetWindowLong,eax,GWL_STYLE
				xor		eax,STYLE_KEEPASPECT
				pop		edx
				invoke SetWindowLong,edx,GWL_STYLE,eax
			.endif
		.endif
	.elseif	eax==WM_SIZE
		invoke GetClientRect,hWin,addr rect
		invoke GetDlgItem,hWin,1001
		invoke MoveWindow,eax,0,0,rect.right,rect.bottom,TRUE
	.elseif	eax==WM_CLOSE
		invoke	EndDialog,hWin,0
	.else
		mov		eax,FALSE
		ret
	.endif
	mov		eax,TRUE
	ret

DlgProc endp

end start
