.386
.model flat,stdcall

procCBmp		proto	:dword,:dword,:dword,:dword,:dword
procCButton		proto	:dword,:dword,:dword,:dword,:dword,:dword,:dword,:dword
procCEdit		proto	:dword,:dword,:dword,:dword,:dword,:dword,:dword
WinMain			proto	:dword,:dword,:dword,:dword

			include advapi32.inc
			include gdi32.inc
			include kernel32.inc
			include user32.inc
			include windows.inc

			includelib advapi32.lib
			includelib gdi32.lib
			includelib kernel32.lib
			includelib user32.lib

			include	ASMcontrols.asm
			include	ASMcomputeprocs.asm

.const

IDB_ABOUTUP		equ	200
IDB_ABOUTDOWN		equ	201
IDB_BACKUP		equ	202
IDB_BACKDOWN		equ	203
IDB_CLOSEUP		equ	204
IDB_CLOSEDOWN		equ	205
IDB_ABOUTBMP		equ	206
IDB_COPYUP		equ	207
IDB_COPYDOWN		equ	208
IDB_INFOS		equ	209
IDB_GREETZ		equ	210
IDB_LOGO		equ	211
IDB_ANGLE		equ	212
IDB_NAME		equ	213
IDB_SERIAL		equ	214

IDI_ICON		equ	100

ID_ABOUTTIMER		equ	1

CHEIGHT			equ	20
WWIDTH			equ	310
WHEIGHT			equ	150

ABOUTLEFT		equ	13
ABOUTTOP		equ	WHEIGHT - 59
ABOUTRIGHT		equ	ABOUTLEFT + 287
ABOUTBOTTOM		equ	ABOUTTOP + 56
ABOUTWIDTH		equ	ABOUTRIGHT - ABOUTLEFT
ABOUTHEIGHT		equ	ABOUTBOTTOM - ABOUTTOP
ABOUTTEXTLEFT		equ	1
ABOUTTEXTTOP		equ	SCROLLBLANKSPACEHEIGHT
ABOUTTEXTRIGHT		equ	ABOUTWIDTH - 1
ABOUTTEXTWIDTH		equ	ABOUTTEXTRIGHT - ABOUTTEXTLEFT

COLORCAPTION	equ	0cfcfcfh

SCROLLBLANKSPACEHEIGHT	equ	4
SCROLLTIME		equ	40
SCROLLPAUSE		equ	10

MAXSIZE			equ	260

.data

bfBuffer		db	MAXSIZE dup (0)

stRectCaption		RECT	<0,0,WWIDTH,CHEIGHT>
stRectAbout		RECT	<ABOUTTEXTLEFT,ABOUTTEXTTOP,ABOUTTEXTRIGHT,0>

szAboutInfo		db	'keygenerator for',13,10,
				'by roy|fleur',13,10,13,10,
				'simple unprotected algorithm',13,10,13,10,
				'the effervescence network of knowledge and research:',13,10,
				'http://www.effervescence.com',0
szAboutGreetz		db	'(in no particular order)',13,10,
				'razzia, lucifer48, thigo, seifer, promethee, extasy, lutin, tam, the analyst,',
				' vrom, the egoiste, inferno, syntax',0
szFormat		db	'%x',0
szNoChar		db	'please enter a name',0
szWindowCaption		db	'keygenerator for',0

szArial			db	'arial',0
szButtonClass		db	'button',0
szEditClass		db	'edit',0
szStaticClass		db	'static',0
szWindowClass		db	'window',0

.data?

dtScrollDirection	db	?
dtScrollPause		db	?
dtScrollPosition	dd	?

hInstance		HINSTANCE ?

hScrollDC		dd	?
hWindowDC		dd	?

hBrushCaption		dd	?
hIcon			dd	?
hFont			dd	?

.code

start:			invoke	GetModuleHandle,0
			mov	hInstance,eax

			invoke	WinMain,hInstance,0,0,SW_SHOWDEFAULT

			invoke	DeleteDC,hScrollDC

			invoke	DeleteObject,hBrushCaption
			invoke	DeleteObject,hFont

; _______________________________________________________________________________________________
;  delete the bmp objects associated with the bmp and buttons
; 
			mov	esi,offset dtBmpHandles

@@:			lodsd

			test	eax,eax
			jz	@f

			invoke	DeleteObject,eax

			jmp	@b

@@:			invoke	ExitProcess,eax

WinMain			proc	hInst:HINSTANCE,hPrevInst:HINSTANCE,ptCommandLine:LPSTR,cmdShow:dword
			local	clsWc:WNDCLASSEX,msg:MSG,hwnd:HWND

			mov	clsWc.cbSize,SIZEOF WNDCLASSEX
			mov	clsWc.style,CS_HREDRAW or CS_VREDRAW
			mov	clsWc.lpfnWndProc,offset WndProc
			mov	clsWc.cbClsExtra,0
			mov	clsWc.cbWndExtra,0
			mov	clsWc.hbrBackground,COLOR_WINDOW+1
			mov	clsWc.lpszMenuName,0
			mov	clsWc.lpszClassName,offset szWindowClass

			invoke	LoadIcon,hInst,IDI_ICON
			mov	hIcon,eax
			mov	clsWc.hIcon,eax
			mov	clsWc.hIconSm,eax

			invoke	LoadCursor,0,IDC_ARROW
			mov	clsWc.hCursor,eax

			push	hInstance
			pop	clsWc.hInstance

			invoke	RegisterClassEx,addr clsWc

; _______________________________________________________________________________________________
;  center the window
; 
			invoke	GetSystemMetrics,SM_CXSCREEN

			sub	eax,WWIDTH
			shr	eax,1
			mov	ebx,eax

			invoke	GetSystemMetrics,SM_CYSCREEN

			sub	eax,WHEIGHT
			shr	eax,1

			invoke	CreateWindowEx,WS_EX_TOPMOST,addr szWindowClass,addr szWindowCaption,WS_POPUP or\
				WS_SYSMENU,ebx,eax,WWIDTH,WHEIGHT,0,0,hInst,0
			mov	hwnd,eax

; _______________________________________________________________________________________________
;  create controls
; 
			cbmp	<Angle>,WWIDTH-11,CHEIGHT-1,IDB_ANGLE
			cbmp	<About>,ABOUTLEFT,ABOUTTOP,IDB_ABOUTBMP
			cbmp	<Name>,3,27,IDB_NAME
			cbmp	<Serial>,3,59,IDB_SERIAL

			cedit	<Name>,3,37,297,20
			cedit	<Serial>,3,69,280,20,ES_READONLY

			invoke	SetWindowTextA,hEditSerial,addr szNoChar

			cbutton	<About>,3,ABOUTTOP,10,56,IDB_ABOUTUP,IDB_ABOUTDOWN
			cbutton	<Back>,3,ABOUTTOP,10,56,IDB_BACKUP,IDB_BACKDOWN
			cbutton	<Close>,WWIDTH - 15,3,12,11,IDB_CLOSEUP,IDB_CLOSEDOWN
			cbutton	<Copy>,285,73,15,13,IDB_COPYUP,IDB_COPYDOWN

; _______________________________________________________________________________________________
;  special initialization actions
; 
			invoke	SetFocus,hEditName
			invoke	ShowWindow,stBtnBack.hWnd,SW_HIDE

.data

; _______________________________________________________________________________________________
;  bitmap handles
; 
dtBmpHandles		dd	numbmphandles + 1 dup (0)

dtBtnPtr		dd	numbtnstructs + 1 dup (0)

.code

			invoke	ShowWindow,hwnd,cmdShow
			invoke	UpdateWindow,hwnd

@@:			invoke	GetMessage,addr msg,0,0,0

			test	eax,eax
			jz	@f

			invoke	TranslateMessage,addr msg
			invoke	DispatchMessage,addr msg

			jmp	@b
@@:			mov	eax,msg.wParam

			ret

WinMain			endp

WndProc			proc	uses ebx esi edi,hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
			local	stPaint:PAINTSTRUCT,hDC:HDC,hMem:dword,ptMem:dword,hBmp:dword,\
			stRectTemp:RECT 

			cmp	uMsg,WM_DESTROY
			jz	destroy

			cmp	uMsg,WM_PAINT
			jz	paint

			cmp	uMsg,WM_COMMAND
			jz	command

			cmp	uMsg,WM_LBUTTONDOWN
			jz	lbuttondown

			cmp	uMsg,WM_CREATE
			jz	create

			cmp	uMsg,WM_DRAWITEM
			jz	drawitem

			cmp	uMsg,WM_CTLCOLORSTATIC
			jz	coloredit

			cmp	uMsg,WM_TIMER
			jz	timer

return:			invoke	DefWindowProc,hWnd,uMsg,wParam,lParam

			ret

endcheck:		xor	eax,eax

			jmp	return

			ret

command:		mov	edx,wParam
			mov	eax,lParam

			shr	edx,16

			cmp	edx,BN_CLICKED
			jnz	checkedit

			cmp	eax,stBtnAbout.hWnd
			jnz	@f

; _______________________________________________________________________________________________
;  about - show the scroller
; 
			invoke	ShowWindow,stBtnBack.hWnd,SW_SHOW
			invoke	ShowWindow,stBtnAbout.hWnd,SW_HIDE
			invoke	ShowWindow,stBmpAbout.hWnd,SW_HIDE

			mov	dtScrollDirection,0
			mov	dtScrollPause,0
			mov	dtScrollPosition,0

			invoke	SetTimer,hWnd,ID_ABOUTTIMER,SCROLLTIME,0

			jmp	endcheck

@@:			cmp	eax,stBtnBack.hWnd
			jnz	@f

; _______________________________________________________________________________________________
;  back - hide the scroller
; 
			invoke	ShowWindow,stBtnAbout.hWnd,SW_SHOW
			invoke	ShowWindow,stBtnBack.hWnd,SW_HIDE
			invoke	ShowWindow,stBmpAbout.hWnd,SW_SHOW

			invoke	KillTimer,hWnd,ID_ABOUTTIMER

			jmp	endcheck

@@:			cmp	eax,stBtnClose.hWnd
			jnz	@f

; _______________________________________________________________________________________________
;  close
; 
			invoke	PostQuitMessage,0

			jmp	endcheck

@@:			cmp	eax,stBtnCopy.hWnd
			jnz	endcheck

; _______________________________________________________________________________________________
;  copy
; 
			invoke	OpenClipboard,hWnd

			invoke	EmptyClipboard

			invoke	GetWindowText,hEditSerial,addr bfBuffer,MAXSIZE

			invoke	GlobalAlloc,GMEM_MOVEABLE or GMEM_DDESHARE,eax
			mov	hMem,eax

			invoke	GlobalLock,eax
			mov	ptMem,eax

			invoke	lstrcpy,eax,addr bfBuffer

			invoke	GlobalUnlock,hMem

			invoke	SetClipboardData,CF_TEXT,hMem

			invoke	CloseClipboard

			jmp	endcheck

checkedit:		cmp	edx,EN_CHANGE
			jnz	endcheck

; _______________________________________________________________________________________________
;  compute the serial corresponding to the name
; 
			include	ASMcompute.asm

; _______________________________________________________________________________________________
;  initializes some objects
; 
create:			invoke	CreateFont,16,0,0,0,0,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,\
				PROOF_QUALITY,DEFAULT_PITCH,addr szArial
			mov	hFont,eax

			invoke	CreateSolidBrush,COLORCAPTION
			mov	hBrushCaption,eax

			invoke	GetDC,hWnd
			mov	hDC,eax

			invoke	CreateCompatibleDC,eax
			mov	hScrollDC,eax

			invoke	CreateCompatibleDC,eax
			mov	stPaint.hdc,eax

			invoke	CreateCompatibleDC,eax
			mov	hWindowDC,eax

; _______________________________________________________________________________________________
;  draw the scroll bitmap
; 
			invoke	SelectObject,hScrollDC,hFont

			mov	stRectTemp.left,ABOUTTEXTLEFT
			mov	stRectTemp.top,ABOUTTEXTTOP
			mov	stRectTemp.right,ABOUTTEXTRIGHT

			invoke	DrawText,hScrollDC,addr szAboutInfo,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK or DT_CALCRECT

			mov	eax,stRectTemp.bottom
			mov	stRectAbout.bottom,eax

			mov	stRectTemp.right,ABOUTTEXTRIGHT

			invoke	DrawText,hScrollDC,addr szAboutGreetz,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK or DT_CALCRECT

			mov	eax,stRectTemp.bottom
			sub	eax,stRectTemp.top
			add	eax,2*SCROLLBLANKSPACEHEIGHT+17+4+16+17+4+16+17
			add	stRectAbout.bottom,eax

			mov	eax,stRectAbout.bottom
			sub	eax,stRectAbout.top

			invoke	CreateCompatibleBitmap,hDC,ABOUTWIDTH,eax

			invoke	SelectObject,hScrollDC,eax

			invoke	ReleaseDC,hWnd,hDC

			invoke	GetStockObject,WHITE_BRUSH
			invoke	SelectObject,hScrollDC,eax

			invoke	GetStockObject,WHITE_PEN
			invoke	SelectObject,hScrollDC,eax

			mov	eax,stRectAbout.bottom
			sub	eax,stRectAbout.top

			invoke	Rectangle,hScrollDC,0,0,ABOUTWIDTH,eax

			invoke	SetBkMode,hScrollDC,TRANSPARENT
			invoke	SelectObject,hScrollDC,hFont

			invoke	LoadBitmap,hInstance,IDB_INFOS
			mov	hBmp,eax

			invoke	SelectObject,stPaint.hdc,eax

			mov	eax,stRectAbout.bottom

			invoke	BitBlt,hScrollDC,(ABOUTTEXTWIDTH-44)/2-65,SCROLLBLANKSPACEHEIGHT,109,17,stPaint.hdc,0,0,SRCCOPY

			add	stRectTemp.top,14+4

			mov	stRectTemp.right,ABOUTTEXTRIGHT

			invoke	DrawText,hScrollDC,addr szAboutInfo,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK or DT_CALCRECT

			mov	eax,ABOUTTEXTWIDTH
			sub	eax,stRectTemp.right
			add	eax,stRectTemp.left
			shr	eax,1

			add	stRectTemp.left,eax
			add	stRectTemp.right,eax

			invoke	DrawText,hScrollDC,addr szAboutInfo,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK

			mov	eax,stRectTemp.bottom
			add	eax,16
			mov	stRectTemp.top,eax

			invoke	LoadBitmap,hInstance,IDB_GREETZ
			mov	hBmp,eax

			invoke	SelectObject,stPaint.hdc,eax

			invoke	BitBlt,hScrollDC,(ABOUTTEXTWIDTH-57)/2-59,stRectTemp.top,116,17,stPaint.hdc,0,0,SRCCOPY

			add	stRectTemp.top,14+4

			mov	stRectTemp.left,ABOUTTEXTLEFT
			mov	stRectTemp.right,ABOUTTEXTRIGHT

			invoke	DrawText,hScrollDC,addr szAboutGreetz,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK or DT_CALCRECT

			mov	eax,ABOUTTEXTWIDTH
			sub	eax,stRectTemp.right
			add	eax,stRectTemp.left
			shr	eax,1

			add	stRectTemp.left,eax
			add	stRectTemp.right,eax

			invoke	DrawText,hScrollDC,addr szAboutGreetz,-1,addr stRectTemp,DT_EXPANDTABS or DT_CENTER or\
				DT_WORDBREAK

			mov	eax,stRectTemp.bottom
			add	eax,16
			mov	stRectTemp.top,eax

			invoke	LoadBitmap,hInstance,IDB_LOGO
			mov	hBmp,eax

			invoke	SelectObject,stPaint.hdc,eax

			invoke	BitBlt,hScrollDC,(ABOUTTEXTWIDTH-47)/2-64,stRectTemp.top,146,17,stPaint.hdc,0,0,SRCCOPY

			invoke	DeleteObject,hBmp

			invoke	DeleteDC,stPaint.hdc

; _______________________________________________________________________________________________
;  draw the window background
; 
			invoke	CreateCompatibleBitmap,hDC,WWIDTH,WHEIGHT

			invoke	SelectObject,hWindowDC,eax

			invoke	SetBkMode,hWindowDC,TRANSPARENT
			invoke	SelectObject,hWindowDC,hFont

			invoke	GetStockObject,WHITE_BRUSH
			invoke	SelectObject,hWindowDC,eax

			invoke	Rectangle,hWindowDC,0,0,WWIDTH,WHEIGHT

			invoke	GetStockObject,NULL_PEN
			invoke	SelectObject,hWindowDC,eax

			invoke	SelectObject,hWindowDC,hBrushCaption

			invoke	Rectangle,hWindowDC,0,0,WWIDTH,CHEIGHT

			invoke	Rectangle,hWindowDC,WWIDTH-8,CHEIGHT-1,WWIDTH,WHEIGHT

			invoke	GetStockObject,NULL_BRUSH
			invoke	SelectObject,hWindowDC,eax

			invoke	GetStockObject,BLACK_PEN
			invoke	SelectObject,hWindowDC,eax

			invoke	Rectangle,hWindowDC,0,0,WWIDTH,WHEIGHT

			invoke	Rectangle,hWindowDC,ABOUTLEFT,ABOUTTOP,ABOUTRIGHT,ABOUTBOTTOM

			invoke	DrawIconEx,hWindowDC,2,2,hIcon,16,16,0,hBrushCaption,DI_NORMAL

			add	stRectCaption.left,20
			sub	stRectCaption.right,18

			invoke	DrawText,hWindowDC,addr szWindowCaption,-1,addr stRectCaption,DT_LEFT or DT_VCENTER or\
				DT_SINGLELINE

			jmp	endcheck

; _______________________________________________________________________________________________
;  destroy the window
; 
destroy:		invoke	PostQuitMessage,0

			invoke	KillTimer,hWnd,ID_ABOUTTIMER

			jmp	endcheck

; _______________________________________________________________________________________________
;  draw the owner-drawn controls
; 
drawitem:		mov	esi,lParam

			assume	esi:ptr DRAWITEMSTRUCT

			mov	eax,[esi].hwndItem

			mov	edi,offset dtBtnPtr

			assume	ebx:ptr BTNCONTROL

@@:			mov	ebx,dword ptr [edi]

			cmp	[ebx].hWnd,0
			jz	endcheck

			cmp	eax,[ebx].hWnd
			jz	@f

			add	edi,4

			jmp	@b

@@:			invoke	CreateCompatibleDC,[esi].hdc
			mov	hDC,eax

			mov	eax,[esi].itemState
			and	eax,ODS_SELECTED

			test	eax,eax
			jnz	@f

			invoke	SelectObject,hDC,[ebx].hBmpUp

			jmp	drawbutton

@@:			invoke	SelectObject,hDC,[ebx].hBmpDown

drawbutton:		invoke	BitBlt,[esi].hdc,[esi].rcItem.left,[esi].rcItem.top,[esi].rcItem.right,[esi].rcItem.bottom,\
				hDC,0,0,SRCCOPY

			invoke	DeleteDC,hDC

			jmp	endcheck

; _______________________________________________________________________________________________
;  check if we clicked in the title bar
; 
lbuttondown:		mov	eax,lParam
			mov	edx,eax

			and	edx,0ffffh
			shr	eax,16

			invoke	PtInRect,addr stRectCaption,edx,eax

			test	eax,eax
			jz	endcheck

			invoke	SendMessage,hWnd,WM_NCLBUTTONDOWN,HTCAPTION,0

			jmp	endcheck

; _______________________________________________________________________________________________
;  paint the window background
; 
paint:			invoke	BeginPaint,hWnd,addr stPaint

			invoke	BitBlt,stPaint.hdc,0,0,WWIDTH,WHEIGHT,hWindowDC,0,0,SRCCOPY

			invoke	EndPaint,hWnd,addr stPaint

			jmp	endcheck

; _______________________________________________________________________________________________
;  make the serial edit control appear white
; 
coloredit:		mov	eax,lParam
			cmp	eax,hEditSerial
			jnz	endcheck

			invoke	GetStockObject,WHITE_BRUSH

			ret

			jmp	endcheck

; _______________________________________________________________________________________________
;  update the scroller
; 
timer:			mov	eax,stRectAbout.bottom
			sub	eax,stRectAbout.top

			cmp	eax,ABOUTHEIGHT
			jb	drawtext

			cmp	dtScrollDirection,0
			jz	scrollup

			cmp	dtScrollPause,0
			jz	@f

			dec	dtScrollPause

			jmp	drawtext

@@:			dec	dtScrollPosition

			cmp	dtScrollPosition,0
			ja	drawtext

			mov	dtScrollDirection,0

			jmp	drawtext

scrollup:		cmp	dtScrollPause,SCROLLPAUSE
			jz	@f

			inc	dtScrollPause

			jmp	drawtext

@@:			inc	dtScrollPosition

			mov	eax,stRectAbout.bottom
			sub	eax,ABOUTHEIGHT - SCROLLBLANKSPACEHEIGHT

			cmp	dtScrollPosition,eax
			jb	drawtext

			mov	dtScrollDirection,1

drawtext:		invoke	GetDC,hWnd
			mov	stPaint.hdc,eax

			invoke	BitBlt,stPaint.hdc,ABOUTLEFT+1,ABOUTTOP+1,ABOUTWIDTH-2,ABOUTHEIGHT-2,hScrollDC,0,dtScrollPosition,SRCCOPY

			invoke	ReleaseDC,hWnd,stPaint.hdc

			jmp	endcheck

WndProc			endp

; _______________________________________________________________________________________________
;  procedures for control creation
; 
			include	ASMprocs.asm

			end	start
