--[[--------------------------------------------------------------------
	PhanxBuffs
	Replacement player buff, debuff, and temporary enchant frames.
	Copyright (c) 2010-2016 Phanx <addons@phanx.net>. All rights reserved.
	https://github.com/Phanx/PhanxBuffs
	https://mods.curse.com/addons/wow/phanxbuffs
	http://www.wowinterface.com/downloads/info16874-PhanxBuffs.html
----------------------------------------------------------------------]]

local ADDON_NAME, ns = ...
local L = {}
ns.L = L

setmetatable(L, { __index = function(t, k)
	local v = tostring(k)
	t[k] = v
	return v
end })

L["%d minutes remaining"] = SPELL_TIME_REMAINING_MIN -- "%d |4minute:minutes; remaining"
L["%d seconds remaining"] = SPELL_TIME_REMAINING_SEC -- "%d |4second:seconds; remaining"

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED. SEE:
-- https://wow.curseforge.com/addons/phanxbuffs/localization/

------------------------------------------------------------------------
-- English
------------------------------------------------------------------------

local CURRENT_LOCALE = GetLocale()
if CURRENT_LOCALE == "enUS" then return end

------------------------------------------------------------------------
-- German
------------------------------------------------------------------------

if CURRENT_LOCALE == "deDE" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "Die maximale Dauer in Sekunden anpassen, um den Timertext einer Stärkungs- oder Schwächungszauber anzeigen."
L["Adjust the number of buff icons to show on each row."] = "Die Anzahl der Stärkungszaubersymbole ändern, die auf jeder Zeile anzeigt werden."
L["Adjust the number of debuff icons to show on each row."] = "Die Anzahl der Schwächungszaubersymbole ändern, die auf jeder Zeile angezeigt werden."
L["Adjust the size of each buff icon."] = "Die Größe jedes Stärkungszaubersymbols ändern."
L["Adjust the size of each debuff icon."] = "Die Größe jedes Schwächungszaubersymbols ändern."
L["Adjust the size of the stack count and timer text."] = "Die Größe des Zahlen- und Timertext anpassen."
L["Adjust the space between buff icons."] = "Der Abstand zwischen den Stärkungszaubersymbolen ändern."
L["Adjust the space between debuff icons."] = "Der Abstand zwischen den Schwächungszaubersymbolen ändern."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "Einfache Ersätze für die Stärkungszauber-, Schwächungszauber- und Waffenverzauberungssymbole des Spielers."
L["Bottom"] = "Unten"
L["buff"] = "stärkungszauber"
L["Buff Anchor"] = "Ankerpunkt der Stärkungszauber"
L["Buff Columns"] = "Stärkungszauberspalten"
L["Buff Size"] = "Stärkungszaubergröße"
L["Buff Sources"] = "Stärkungszauberquellen"
L["Buff Spacing"] = "Stärkungszauberabstand"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "Stärkungszauber mit dem ersten Klick statt des zweiten abbrechen. Dies funktioniert nur außerhalb des Kampfes. Einige geschützte Zauber (z.B. Gestalten der Druiden und Waffenverzauberungen) benötigen trotzdem noch zwei Klicks, um abzubrechen."
L["Cast by %s"] = "Von %s aufgebracht"
L["Choose whether the buff icons grow from left to right, or right to left."] = "Wählen, ob die Stärkungszaubersymbole von links nach rechts oder von rechts nach links wachsen."
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "Wählen, ob die Stärkungszaubersymbole von oben nach unten order von unten nach oben wachsen."
L["Choose whether the debuff icons grow from left to right, or right to left."] = "Wählen, ob die Schwächungszaubersymbole von links nach rechts oder von rechts nach links wachsen."
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "Wählen, ob die Schwächungszaubersymbole von oben nach unten oder von unten nach oben wachsen."
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d Stärkungszauber werden ignoriert."
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d Schwächungszauber werden ignoriert."
L["debuff"] = "schwächungszauber"
L["Debuff Anchor"] = "Ankerpunkt der Schwächungszauber"
L["Debuff Columns"] = "Schwächungszauberspalten"
L["Debuff Size"] = "Schwächungszaubergröße"
L["Debuff Spacing"] = "Schwächungszauberabstand"
L["Left"] = "Links"
L["lock"] = "fixieren"
L["Lock Frames"] = "Symbole sperren"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Die Stärkungs- und Schwächungszaubersymbole sperren, um den Hintergrund zu verstecken und die Bewegung zu verhindern."
L["Max Timer Duration"] = "Höchstdauer"
L["No buffs are being ignored."] = "Keine Stärkungszauber werden ignoriert."
L["No debuffs are being ignored."] = "Keine Schwächungszauber werden ignoriert."
L["No longer ignoring buff: %s"] = "Stärkungszauber wird nicht mehr ignoriert: %s"
L["No longer ignoring debuff: %s"] = "Schwächungszauber wird nicht mehr ignoriert: %s"
L["None"] = "Keiner"
L["Now ignoring buff: %s"] = "Stärkungszauber wird jetzt ignoriert: %s"
L["Now ignoring debuff: %s"] = "Schwächungszauber wird jetzt ignoriert: %s"
L["One-Click Cancel"] = "Mit einem Klick abbrechen"
L["Right"] = "Rechts"
L["Set the outline weight for the stack count and timer text."] = "Den Schriftumriss des Zahlen- und Timertext wählen."
L["Set the typeface for the stack count and timer text."] = "Die Schriftart des Zahlen- und Timertext wählen."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Den Namen des Gruppen- oder Schlachtzugsmitglieds, der einen Stärkungszauber auf euch gewirkt hat, im Tooltip dieses Stärkungszaubers anzeigen."
L["Text Outline"] = "Schriftumriss"
L["Text Size"] = "Schriftgröße"
L["Thick"] = "Dick"
L["Thin"] = "Dünn"
L["Top"] = "Oben"
L["Typeface"] = "Schriftart"
L["unlock"] = "freigeben"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Mit diesen Optionen könnt Ihr die Stärkungszauber-, Schwächungszauber- und Waffenverzauberungssymbole dieses Addon konfigurieren."

return end

------------------------------------------------------------------------
-- Spanish
------------------------------------------------------------------------

if CURRENT_LOCALE == "esES" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "Ajustar el máximo de tiempo restante, en segundos, para mostrar el texto de tiempo."
L["Adjust the number of buff icons to show on each row."] = "Ajustar el número de iconos de beneficios para mostrar en cada fila."
L["Adjust the number of debuff icons to show on each row."] = "Ajustar el número de iconos de perjuicios para mostrar en cada fila."
L["Adjust the size of each buff icon."] = "Ajustar el tamaño de los iconos de beneficios."
L["Adjust the size of each debuff icon."] = "Ajustar el tamaño de los icons de perjuicios."
L["Adjust the size of the stack count and timer text."] = "Ajustar el tamaño del texto de aplicaciones y tiempo."
L["Adjust the space between buff icons."] = "Ajustar el espaciamiento entre los iconos de beneficios."
L["Adjust the space between debuff icons."] = "Ajustar el espaciamiento entre los iconos de perjuicios."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "Sustitutos básicos de los iconos del jugador de beneficios, perjuicios y encancamientos de armas."
L["Bottom"] = "Abajo"
L["buff"] = "beneficio"
L["Buff Anchor"] = "Ancla de beneficios"
L["Buff Columns"] = "Columnas de beneficios"
L["Buff Size"] = "Tamaño de beneficios"
L["Buff Sources"] = "Taumaturgos de beneficios"
L["Buff Spacing"] = "Espaciamiento de beneficios"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "Cancelar beneficios desprotegidos en el primer clic, en vez del segundo. Esto sólo funciona fuera de combate y los beneficios protegidos, como las cambiados de forma y los encantamientos de armas, todavía requieren dos clics para cancelar."
L["Cast by %s"] = "Aplicada por %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "Seleccionar entre extender los iconos de beneficios de la derecha a la izquierda, o de la izquierda a la derecha."
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "Seleccionar entre extender los iconos de beneficios de arriba a abajo, o de abajo a arriba."
L["Choose whether the debuff icons grow from left to right, or right to left."] = "Seleccionar entre extender los iconos de perjuicios de la derecha a la izquierda, o de la izquierda a la derecha."
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "Seleccionar entre extender los iconos de perjuicios de la arriba a abajo, o de abajo a arriba."
L["%d |4buff:buffs; |4is:are; being ignored:"] = "Estás ignorando a %d |4beneficio:beneficios;:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "Estás ignorando a %d |perjuicio:perjuicios;:"
L["debuff"] = "perjuicio"
L["Debuff Anchor"] = "Ancla de perjuicios"
L["Debuff Columns"] = "Columnas de perjuicios"
L["Debuff Size"] = "Tamaño de perjuicios"
L["Debuff Spacing"] = "Espaciamiento de perjuicios"
L["Left"] = "Izquierda"
L["lock"] = "bloquear"
L["Lock Frames"] = "Bloquear iconos"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Bloquear las iconos de beneficios y perjuicios, para ocultar el fondo y prevenir el movimiento."
L["Max Timer Duration"] = "Tiempo máximo"
L["No buffs are being ignored."] = "No estás ignorando a ningún beneficios."
L["No debuffs are being ignored."] = "No estás ignorando a ningún perjuicios."
L["No longer ignoring buff: %s"] = "Ya no estás ignorando al beneficio: %s"
L["No longer ignoring debuff: %s"] = "Ya no estás ignorando al perjucio: %s"
L["None"] = "Ninguno"
L["Now ignoring buff: %s"] = "Estás ignorando al beneficio: %s"
L["Now ignoring debuff: %s"] = "Estás ignorando al perjuicio: %s"
L["One-Click Cancel"] = "Solo clic para cancelar"
L["Right"] = "Derecha"
L["Set the outline weight for the stack count and timer text."] = "Establecer el grueso del perfil del texto de aplicaciones y tiempo."
L["Set the typeface for the stack count and timer text."] = "Establecer el tipo de letra del texto de aplicaciones y tiempo."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Mostrar el nombre del miembro del grupo o banda que ha aplicado un beneficio a te en su descripción."
L["Text Outline"] = "Perfil de texto"
L["Text Size"] = "Tamaño de texto"
L["Thick"] = "Grueso"
L["Thin"] = "Fino"
L["Top"] = "Arriba"
L["Typeface"] = "Tipo de letra"
L["unlock"] = "desbloquear"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Estes opciones te permiten configurar los iconos de beneficios, perjuicios, y encancamientos de armas."

return end

------------------------------------------------------------------------
-- Latin American Spanish
------------------------------------------------------------------------

if CURRENT_LOCALE == "esMX" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "Ajustar el máximo de tiempo restante, en segundos, para mostrar el texto de tiempo."
L["Adjust the number of buff icons to show on each row."] = "Ajustar el número de iconos de beneficios para mostrar en cada fila."
L["Adjust the number of debuff icons to show on each row."] = "Ajustar el número de iconos de perjuicios para mostrar en cada fila."
L["Adjust the size of each buff icon."] = "Ajustar el tamaño de los iconos de beneficios."
L["Adjust the size of each debuff icon."] = "Ajustar el tamaño de los icons de perjuicios."
L["Adjust the size of the stack count and timer text."] = "Ajustar el tamaño del texto de aplicaciones y tiempo."
L["Adjust the space between buff icons."] = "Ajustar el espaciamiento entre los iconos de beneficios."
L["Adjust the space between debuff icons."] = "Ajustar el espaciamiento entre los iconos de perjuicios."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "Sustitutos básicos de los iconos del jugador de beneficios, perjuicios y encancamientos de armas."
L["Bottom"] = "Abajo"
L["buff"] = "beneficio"
L["Buff Anchor"] = "Ancla de beneficios"
L["Buff Columns"] = "Columnas de beneficios"
L["Buff Size"] = "Tamaño de beneficios"
L["Buff Sources"] = "Taumaturgos de beneficios"
L["Buff Spacing"] = "Espaciamiento de beneficios"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "Cancelar beneficios desprotegidos en el primer clic, en vez del segundo. Esto sólo funciona fuera de combate y los beneficios protegidos, como las cambiados de forma y los encantamientos de armas, todavía requieren dos clics para cancelar."
L["Cast by %s"] = "Aplicada por %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "Seleccionar entre extender los iconos de beneficios de la derecha a la izquierda, o de la izquierda a la derecha."
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "Seleccionar entre extender los iconos de beneficios de arriba a abajo, o de abajo a arriba."
L["Choose whether the debuff icons grow from left to right, or right to left."] = "Seleccionar entre extender los iconos de perjuicios de la derecha a la izquierda, o de la izquierda a la derecha."
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "Seleccionar entre extender los iconos de perjuicios de la arriba a abajo, o de abajo a arriba."
L["%d |4buff:buffs; |4is:are; being ignored:"] = "Estás ignorando a %d |4beneficio:beneficios;:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "Estás ignorando a %d |perjuicio:perjuicios;:"
L["debuff"] = "perjuicio"
L["Debuff Anchor"] = "Ancla de perjuicios"
L["Debuff Columns"] = "Columnas de perjuicios"
L["Debuff Size"] = "Tamaño de perjuicios"
L["Debuff Spacing"] = "Espaciamiento de perjuicios"
L["Left"] = "Izquierda"
L["lock"] = "bloquear"
L["Lock Frames"] = "Bloquear iconos"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Bloquear las iconos de beneficios y perjuicios, para ocultar el fondo y prevenir el movimiento."
L["Max Timer Duration"] = "Tiempo máximo"
L["No buffs are being ignored."] = "No estás ignorando a ningún beneficios."
L["No debuffs are being ignored."] = "No estás ignorando a ningún perjuicios."
L["No longer ignoring buff: %s"] = "Ya no estás ignorando al beneficio: %s"
L["No longer ignoring debuff: %s"] = "Ya no estás ignorando al perjucio: %s"
L["None"] = "Ninguno"
L["Now ignoring buff: %s"] = "Estás ignorando al beneficio: %s"
L["Now ignoring debuff: %s"] = "Estás ignorando al perjuicio: %s"
L["One-Click Cancel"] = "Solo clic para cancelar"
L["Right"] = "Derecha"
L["Set the outline weight for the stack count and timer text."] = "Establecer el grueso del perfil del texto de aplicaciones y tiempo."
L["Set the typeface for the stack count and timer text."] = "Establecer el tipo de letra del texto de aplicaciones y tiempo."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Mostrar el nombre del miembro del grupo o banda que ha aplicado un beneficio a te en su descripción."
L["Text Outline"] = "Perfil de texto"
L["Text Size"] = "Tamaño de texto"
L["Thick"] = "Grueso"
L["Thin"] = "Fino"
L["Top"] = "Arriba"
L["Typeface"] = "Tipo de letra"
L["unlock"] = "desbloquear"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Estes opciones te permiten configurar los iconos de beneficios, perjuicios, y encancamientos de armas."

return end

------------------------------------------------------------------------
-- French
------------------------------------------------------------------------

if CURRENT_LOCALE == "frFR" then

L["Adjust the number of buff icons to show on each row."] = "Configure le nombre d'icônes de Buffs à afficher par ligne."
L["Adjust the number of debuff icons to show on each row."] = "Configure le nombre d'icônes de Debuffs à afficher par ligne."
L["Adjust the size of each buff icon."] = "Configure la taille de chaque icône de buff."
L["Adjust the size of each debuff icon."] = "Configure la taille de chaque icône de debuff."
L["Adjust the space between buff icons."] = "Configure l'espacement entre les icônes des buffs."
L["Adjust the space between debuff icons."] = "Configure l'espacement entre les icônes des debuffs."
L["Buff Anchor"] = "Ancrage des Buffs"
L["Buff Columns"] = "Colonnes de Buffs"
L["Buff Size"] = "Taille des Buffs"
L["Buff Sources"] = "Origines des Buffs"
L["Buff Spacing"] = "Espacement des Buffs"
L["Cast by %s"] = "Incanté par %s"
L["%d |4buff:buffs; |4is:are; being ignored:"] = "Aucun debuffs sont ignorés."
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d debuffs actuellement ignorés :"
L["Debuff Anchor"] = "Ancrage des Debuffs"
L["Debuff Columns"] = "Colonnes de Debuffs"
L["Debuff Size"] = "Taille des Debuffs"
L["Debuff Spacing"] = "Espacement des Debuffs"
L["Left"] = "Gauche"
L["lock"] = "verrouiller"
L["Lock Frames"] = "Verrouiller les cadres"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Verrouille les cadres de Buffs et Debuffs, masquant le fond et empechant de les déplacer."
L["No buffs are being ignored."] = "Aucun buffs sont ignorés."
L["No debuffs are being ignored."] = "%d buffs actuellement ignorés :"
L["No longer ignoring buff: %s"] = "Buff n'étant à présent plus ignoré : %s"
L["No longer ignoring debuff: %s"] = "Debuff n'étant à présent plus ignoré : %s"
L["None"] = "Aucun"
L["Now ignoring buff: %s"] = "Buff à présent ignoré : %s"
L["Now ignoring debuff: %s"] = "Debuff à présent ignoré : %s"
L["Right"] = "Droite"
L["Set the outline weight for the stack count and timer text."] = "Configure l'épaisseur du contour des textes de stack et timer."
L["Set the typeface for the stack count and timer text."] = "Configure la police de texte des compteurs de stack et du timer."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Affiche dans le tooltip du buff le nom du membre du groupe ou raid qui l'a incanté."
L["Text Outline"] = "Contour du Texte"
L["Thick"] = "Epais"
L["Thin"] = "Fin"
L["Typeface"] = "Police"
L["unlock"] = "déverrouiller"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Utilisez cette fenêtre pour ajuster des réglages basiques pour les icônes de buffs, debuffs, et buffs d'arme."

return end

------------------------------------------------------------------------
-- Italian
------------------------------------------------------------------------

if CURRENT_LOCALE == "itIT" then

L["Bottom"] = "Basso"
L["buff"] = "beneficio"
L["Buff Anchor"] = "Ancoraggio di benefici"
L["Buff Columns"] = "Colonne di benefici"
L["Buff Size"] = "Dimensione di benefici"
L["Buff Sources"] = "Origini di benefici"
L["Buff Spacing"] = "Spaziatura di benefici"
L["Cast by %s"] = "Lanciato da %s"
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d |4beneficio viene ignorato:benefici vengono ignorati;:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d |4maleficio viene ignorato:malefici vengono ignorati;:"
L["debuff"] = "maleficio"
L["Debuff Anchor"] = "Ancoraggio di malefici"
L["Debuff Columns"] = "Colonne di malefici"
L["Debuff Size"] = "Dimensioni di malefici"
L["Debuff Spacing"] = "Spaziatura di malefici"
L["Left"] = "Sinistra"
L["lock"] = "blocca"
L["Lock Frames"] = "Blocca icone"
L["Max Timer Duration"] = "Durata massima per testo"
L["No buffs are being ignored."] = "Nessun benefici vengono ignorati."
L["No debuffs are being ignored."] = "Nessun malefici vengono ignorati."
L["No longer ignoring buff: %s"] = "Non più ignorando il beneficio: %s"
L["No longer ignoring debuff: %s"] = "Non più ignorando il maleficio: %s"
L["None"] = "Nessuno"
L["Now ignoring buff: %s"] = "Ora ignorando il beneficio: %s"
L["Now ignoring debuff: %s"] = "Ora ignorando il maleficio: %s"
L["One-Click Cancel"] = "Rimuovi con un click"
L["Right"] = "Destra"
L["Text Outline"] = "Contorno di carattere"
L["Text Size"] = "Dimensione di carattere"
L["Thick"] = "Spesso"
L["Thin"] = "Sottile"
L["Top"] = "Alto"
L["Typeface"] = "Tipo di carattere"
L["unlock"] = "sblocca"

return end

------------------------------------------------------------------------
-- Brazilian Portuguese
------------------------------------------------------------------------

if CURRENT_LOCALE == "ptBR" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "Alterar o máximo de tempo restante, em segundos, para mostrar o texto de tempo para um bônus ou penalidade."
L["Adjust the number of buff icons to show on each row."] = "Alterar o número de ícones de bônus para mostrar em cada linha."
L["Adjust the number of debuff icons to show on each row."] = "Alterar o número de ícones de penalidades para mostrar em cada linha."
L["Adjust the size of each buff icon."] = "Alterar o tamanho de cada ícone de bônus."
L["Adjust the size of each debuff icon."] = "Alterar o tamanho de cada ícone de penalidade."
L["Adjust the size of the stack count and timer text."] = "Ajustar o tamanho do texto da contagem de aplicação e tempo restante."
L["Adjust the space between buff icons."] = "Alterar o espaço entre ícones de bônus."
L["Adjust the space between debuff icons."] = "Alterar o espaço entre ícones de penalidades."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "Substituições básicas para os ícones do jogador de bônus, penalidades e encantamentos de armas."
L["Bottom"] = "Fundo"
L["buff"] = "bônus"
L["Buff Anchor"] = "Ponto inicial dos bônus"
L["Buff Columns"] = "Colunas dos bônus"
L["Buff Size"] = "Tamanho dos bônus"
L["Buff Sources"] = "Origens dos bônus"
L["Buff Spacing"] = "Espaçamento dos bônus"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "Cancelar bónus desprotegidos no primeiro clique, em vez do segundo. Isso só funciona fora de combate, e bônus protegidas como formas e encantamentos de armas ainda requerem dois cliques."
L["Cast by %s"] = "Aplicada por %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "Escolher se estender os ícones de bônus de direita a esquerda, ou de esquerda a direita."
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "Escolher se estender os ícones de bônus de topo a fundo, ou de fundo a topo."
L["Choose whether the debuff icons grow from left to right, or right to left."] = "Escolher se estender os ícones de penalidades de direita a esquerda, ou de esquerda a direita."
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "Escolher se estender os ícones de penalidades de topo a fundo, ou de fundo a topo."
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d bônus |4é:são; |4ignorada:ignoradas;:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d |4penalidade:penalidades; |4é:são; |4ignorada:ignoradas;:"
L["debuff"] = "penalidade"
L["Debuff Anchor"] = "Ponto inicial dos bônus"
L["Debuff Columns"] = "Colunas dos bônus"
L["Debuff Size"] = "Tamanho das penalidades"
L["Debuff Spacing"] = "Espaçamento das penalidades"
L["Left"] = "Esquerda"
L["lock"] = "travar"
L["Lock Frames"] = "Travar ícones"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Travar os ícones no lugar e esconder o fundo."
L["Max Timer Duration"] = "Duração máxima da cronometrista"
L["No buffs are being ignored."] = "Não há bônus são ignorados."
L["No debuffs are being ignored."] = "Não há penalidades são ignoradas."
L["No longer ignoring buff: %s"] = "Já não ignorando o bônus: %s"
L["No longer ignoring debuff: %s"] = "Já não ignorando o penalidade: %s"
L["None"] = "Nenhum"
L["Now ignoring buff: %s"] = "Agora ignorando o bônus: %s"
L["Now ignoring debuff: %s"] = "Agora ignorando o penalidade: %s"
L["One-Click Cancel"] = "Só clique para cancelar"
L["Right"] = "Direita"
L["Set the outline weight for the stack count and timer text."] = "Escolher a espessura da linha de contorno para o texto da contagem de aplicação e tempo restante."
L["Set the typeface for the stack count and timer text."] = "Escolher o tipo de letra para o texto da contagem de aplicação e tempo restante."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Mostrar na dica o nome do membro do grupo que aplicou em você o bônus."
L["Text Outline"] = "Contorno do texto"
L["Text Size"] = "Tamanho do texto"
L["Thick"] = "Espesso"
L["Thin"] = "Fino"
L["Top"] = "Topo"
L["Typeface"] = "Tipo de letra"
L["unlock"] = "destravar"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Estas opções permitem alterar algumas configurações básicas para os ícones de bônus, penalidades, e encantamentos de armas."

return end

------------------------------------------------------------------------
-- Russian
------------------------------------------------------------------------

if CURRENT_LOCALE == "ruRU" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "Установите максимальное количество времени в секундах, чтобы показать отметчик времени для эффект."
L["Adjust the number of buff icons to show on each row."] = "Настроить числа положительный эффект значков для отображения на каждой строке."
L["Adjust the number of debuff icons to show on each row."] = "Настроить числа отрицательных эффекта значков для отображения на каждой строке."
L["Adjust the size of each buff icon."] = "Настроить размера значков положительного эффекта."
L["Adjust the size of each debuff icon."] = "Настроить размера значков отрицательного эффекта."
L["Adjust the size of the stack count and timer text."] = "Настроить размера шрифта."
L["Adjust the space between buff icons."] = "Настроить расстояния между значков положительного эффекта."
L["Adjust the space between debuff icons."] = "Настроить расстояния между значков отрицательного эффекта."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "Простая замена иконки игрока баффы, дебаффы и чары, связанных с оружием."
L["Bottom"] = "Низ"
L["buff"] = "бафф"
L["Buff Anchor"] = "Бафф Якорь"
L["Buff Columns"] = "Столбцов баффы"
L["Buff Size"] = "Размер баффы"
L["Buff Sources"] = "Источники баффы"
L["Buff Spacing"] = "Расстояние баффы"
L["Cast by %s"] = "Наносится %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "Будут ли иконки баффа расти с лева на право или с права на лева "
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "Будут ли иконки баффа расти с верху в низ или с низу в верх"
L["Choose whether the debuff icons grow from left to right, or right to left."] = "Будут ли иконки дебаффа расти с лева на право или с права на лева "
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "Будут ли иконки дебаффа расти с верху в низ или с низу в верх"
L["%d |4buff:buffs; |4is:are; being ignored:"] = "Вы игнорируете %d |4бафф:баффы;."
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "Вы игнорируете %d |4дебафф:дебаффы;."
L["debuff"] = "дебафф"
L["Debuff Anchor"] = "Дебафф Якорь"
L["Debuff Columns"] = "Столбцов дебаффы"
L["Debuff Size"] = "Размер дебаффы"
L["Debuff Spacing"] = "Расстояние дебаффы"
L["Left"] = "Слева"
L["lock"] = "заблокировать"
L["Lock Frames"] = "Заблокировать значки"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "Заблокировать значки, предотвращение перемещения и скрытия фона."
L["Max Timer Duration"] = "Максимальное время"
L["No buffs are being ignored."] = "Вы не игнорируя любые баффы."
L["No debuffs are being ignored."] = "Вы не игнорируя любые дебаффы"
L["No longer ignoring buff: %s"] = "Больше не игнорируя бафф: %s"
L["No longer ignoring debuff: %s"] = "Больше не игнорируя дебафф: %s"
L["None"] = "Нету"
L["Now ignoring buff: %s"] = "Теперь игнорируя бафф: %s"
L["Now ignoring debuff: %s"] = "Теперь игнорируя дебафф: %s"
L["One-Click Cancel"] = "Одно нажатие - отмена"
L["Right"] = "Справа"
L["Set the outline weight for the stack count and timer text."] = "Настроить контура шрифта."
L["Set the typeface for the stack count and timer text."] = "Настроить шрифт для имя и заряд счетчиков."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "Показать имя персонажа который наложил положительный эффект на вас во всплывающих подсказках."
L["Text Outline"] = "Контур шрифта"
L["Text Size"] = "Размер шрифта"
L["Thick"] = "Толстый"
L["Thin"] = "Тонкий"
L["Top"] = "Верх"
L["Typeface"] = "Шрифт"
L["unlock"] = "разблокировать"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "Эти настройки позволяют настроить значков для положительных и отрицательных эффектов, и чар, связанных с оружием."

return end

------------------------------------------------------------------------
-- Korean
------------------------------------------------------------------------

if CURRENT_LOCALE == "koKR" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "최대 시간, 초, 타이머를 표시합니다."
L["Adjust the number of buff icons to show on each row."] = "각각의 행에 보여질 버프 아이콘의 갯수를 설정합니다."
L["Adjust the number of debuff icons to show on each row."] = "각각의 행에 보여질 디버프 아이콘의 갯수를 설정합니다."
L["Adjust the size of each buff icon."] = "각각의 버프 아이콘 크기를 설정합니다."
L["Adjust the size of each debuff icon."] = "디버프 아이콘 크기를 설정합니다."
L["Adjust the size of the stack count and timer text."] = "중첩 카운트와 타이머 텍스트를 위해 글꼴 크기를 설정합니다."
L["Adjust the space between buff icons."] = "버프 아이콘 사이의 공간을 설정합니다."
L["Adjust the space between debuff icons."] = "디버프 아이콘 사이의 공간을 설정합니다."
L["Bottom"] = "하단"
L["Buff Anchor"] = "버프 성장 기준점"
L["Buff Columns"] = "버프 열"
L["Buff Size"] = "버프 크기"
L["Buff Sources"] = "버프 출처"
L["Buff Spacing"] = "버프 간격"
L["Cast by %s"] = "시전자: %s"
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d 버프가 차단 목록에 있습니다:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d 디버프가 차단 목록에 있습니다:"
L["Debuff Anchor"] = "디버프 성장 기준점"
L["Debuff Columns"] = "디버프 열"
L["Debuff Size"] = "디버프 크기"
L["Debuff Spacing"] = "디버프 간격"
L["Left"] = "왼쪽"
L["lock"] = "잠금"
L["Lock Frames"] = "프레임 잠금"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "해당 위치에 버프와 디버프 프레임을 잠급니다. 배경을 숨기고 움직이지 못하도록 합니다."
L["Max Timer Duration"] = "최대 시간"
L["No buffs are being ignored."] = "아니 디버프가 차단 목록에 있습니다."
L["No debuffs are being ignored."] = "아니 버프가 차단 목록에 있습니다."
L["No longer ignoring buff: %s"] = "버프%s 님이 차단 목록에서 제외되었습니다."
L["No longer ignoring debuff: %s"] = "디버프 %s 님이 차단 목록에서 제외되었습니다."
L["None"] = "없음"
L["Now ignoring buff: %s"] = "버프 %s 님이 차단 목록에 등록되었습니다."
L["Now ignoring debuff: %s"] = "디버프 %s 님이 차단 목록에 등록되었습니다."
L["Right"] = "오른쪽"
L["Set the outline weight for the stack count and timer text."] = "중첩 카운트와 타이머 텍스트를 위해 외곽선 두께를 설정합니다."
L["Set the typeface for the stack count and timer text."] = "중첩 카운트와 타이머 텍스트를 위해 글꼴을 설정합니다."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "파티원 또는 공격대원 중 당신에게 버프를 시전한 누군가의 이름을 툴팁에 보여줍니다."
L["Text Outline"] = "글꼴 외각선"
L["Text Size"] = "글꼴 크기"
L["Thick"] = "두껍게"
L["Thin"] = "얇게"
L["Top"] = "상단"
L["Typeface"] = "글꼴"
L["unlock"] = "해제"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "이 패널을 이용해서 버프, 디버프 그리고 무기 버프 아이콘을 위해 약간의 간단한 설정을 조정하세요."

return end

------------------------------------------------------------------------
-- Simplified Chinese
------------------------------------------------------------------------

if CURRENT_LOCALE == "zhCN" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "调整显示buff或debuff剩余时间的最大值(秒)."
L["Adjust the number of buff icons to show on each row."] = "调整每行buff图标的个数."
L["Adjust the number of debuff icons to show on each row."] = "调整每行debuff图标的个数."
L["Adjust the size of each buff icon."] = "调整每个buff图标的大小."
L["Adjust the size of each debuff icon."] = "调整每个debuff图标的大小."
L["Adjust the size of the stack count and timer text."] = "调整层数与持续时间文字的大小."
L["Adjust the space between buff icons."] = "调整每个buff图标之间的距离."
L["Adjust the space between debuff icons."] = "调整每个debuff图标之间的距离."
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "为玩家buff,debuff以及临时附魔框体提供简单的替换"
L["Bottom"] = "底部"
L["buff"] = "增益"
L["Buff Anchor"] = "Buff 增长锚点"
L["Buff Columns"] = "Buff 栏"
L["Buff Size"] = "Buff 大小"
L["Buff Sources"] = "Buff 来源"
L["Buff Spacing"] = "Buff 间距"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "通过首次点击而非第二次取消未受保护的buff,只在非战斗状态下生效,并且类似变形和武器buff之类的受保护buff依然需要两次点击."
L["Cast by %s"] = "来自 %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "选择buff图标的增长方向是 从左到右 还是 从右到左."
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "选择buff图标的增长方向是 从上到下 还是 从下到上."
L["Choose whether the debuff icons grow from left to right, or right to left."] = "选择debuff图标的增长方向是 从左到右 还是 从右到左."
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "选择debuff图标的增长方向是 从上到下 还是 从下到上."
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d个 |4buff:buffs; 已被忽略:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d |4debuff:debuffs; |4已被忽略:"
L["debuff"] = "减益"
L["Debuff Anchor"] = "Debuff 增长锚点"
L["Debuff Columns"] = "Debuff 栏"
L["Debuff Size"] = "Debuff 大小"
L["Debuff Spacing"] = "Debuff 间距"
L["Left"] = "左侧"
L["lock"] = "锁定"
L["Lock Frames"] = "锁定框体"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "锁定buff与debuff框体,隐藏背景并防止它们被移动."
L["Max Timer Duration"] = "最大持续时间"
L["No buffs are being ignored."] = "没有忽略的buff"
L["No debuffs are being ignored."] = "没有忽略的debuff"
L["No longer ignoring buff: %s"] = "不再忽略buff: %s"
L["No longer ignoring debuff: %s"] = "不再忽略debuff: %s"
L["None"] = "无"
L["Now ignoring buff: %s"] = "从现在起忽略buff: %s"
L["Now ignoring debuff: %s"] = "从现在起忽略debuff: %s"
L["One-Click Cancel"] = "单击取消"
L["Right"] = "右侧"
L["Set the outline weight for the stack count and timer text."] = "调整层数与持续时间文字的轮廓."
L["Set the typeface for the stack count and timer text."] = "选择层数与持续时间文字的字体."
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "在鼠标提示中显示对你施放此buff的小队/团队成员姓名"
L["Text Outline"] = "轮廓"
L["Text Size"] = "字体大小"
L["Thick"] = "粗轮廓"
L["Thin"] = "轮廓"
L["Top"] = "顶部"
L["Typeface"] = "字体"
L["unlock"] = "解锁"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "在当前面板进行增益、减益、武器临时附魔图标的基本设置."

return end

------------------------------------------------------------------------
-- Traditional Chinese
------------------------------------------------------------------------

if CURRENT_LOCALE == "zhTW" then

L["Adjust the maximum remaining duration, in seconds, to show the timer text for a buff or debuff."] = "剩餘時間為多少秒時才要顯示增益或減益效果的計時數字，以秒為單位。"
L["Adjust the number of buff icons to show on each row."] = "調整每一個橫列要顯示多少個增益效果圖示。"
L["Adjust the number of debuff icons to show on each row."] = "調整每一個橫列要顯示多少個減益效果圖示。"
L["Adjust the size of each buff icon."] = "調整增益效果圖示的大小。"
L["Adjust the size of each debuff icon."] = "調整減益效果圖示的大小。"
L["Adjust the size of the stack count and timer text."] = "調整堆疊層數和計時文字的大小。"
L["Adjust the space between buff icons."] = "調整增益效果圖示之間的距離。"
L["Adjust the space between debuff icons."] = "調整減益效果圖示之間的距離。"
L["Basic replacement for player buff, debuff, and temporary enchant frames."] = "取代玩家增益、減益效果，和暫時性增強效果原本的框架。"
L["Bottom"] = "底部"
L["buff"] = "增益效果"
L["Buff Anchor"] = "增益效果對齊"
L["Buff Columns"] = "增益效果行數"
L["Buff Size"] = "增益效果圖示大小"
L["Buff Sources"] = "增益效果施法者名字"
L["Buff Spacing"] = "增益效果圖示間距"
L["Cancel unprotected buffs on the first click, instead of the second. Only works out of combat, and protected buffs like shapeshift forms and weapon buffs will still require two clicks."] = "點一下來取消未受保護的增益效果，而不是點兩下，只在非戰鬥中有效。受保護的增益效果，例如改變形態和武器特效仍然需要點兩下。"
L["Cast by %s"] = "施法者: %s"
L["Choose whether the buff icons grow from left to right, or right to left."] = "選擇增益圖示增加時，要從左到右延伸，還是從右到左。"
L["Choose whether the buff icons grow from top to bottom, or bottom to top."] = "選擇增益圖示增加時，要從上到下延伸，還是從下到上。"
L["Choose whether the debuff icons grow from left to right, or right to left."] = "選擇減益圖示增加時，要從左到右延伸，還是從右到左。"
L["Choose whether the debuff icons grow from top to bottom, or bottom to top."] = "選擇減益圖示增加時，要從上到下延伸，還是從下到上。"
L["%d |4buff:buffs; |4is:are; being ignored:"] = "%d 個增益效果被忽略:"
L["%d |4debuff:debuffs; |4is:are; being ignored:"] = "%d 個減益效果被忽略:"
L["debuff"] = "減益效果"
L["Debuff Anchor"] = "減益效果對齊"
L["Debuff Columns"] = "減益效果行數"
L["Debuff Size"] = "減益效果圖示大小"
L["Debuff Spacing"] = "減益效果圖示間距"
L["Left"] = "左"
L["lock"] = "鎖定"
L["Lock Frames"] = "鎖定框架位置"
L["Lock the buff and debuff frames in place, hiding the backdrop and preventing them from being moved."] = "將增益和減益效果圖示的框架鎖定在目前的位置，隱藏位置展示方塊並且防止被移動。"
L["Max Timer Duration"] = "最大剩餘時間"
L["No buffs are being ignored."] = "沒有被忽略的增益效果。"
L["No debuffs are being ignored."] = "沒有被忽略的減益效果。"
L["No longer ignoring buff: %s"] = "不要忽略的增益效果: %s"
L["No longer ignoring debuff: %s"] = "不要忽略的減益效果: %s"
L["None"] = "無"
L["Now ignoring buff: %s"] = "現在忽略的增益效果: %s"
L["Now ignoring debuff: %s"] = "現在忽略的減益效果: %s"
L["One-Click Cancel"] = "點一下取消效果"
L["Right"] = "右"
L["Set the outline weight for the stack count and timer text."] = "設定堆疊層數和計時數字文字的外框粗細。"
L["Set the typeface for the stack count and timer text."] = "設定堆疊層數和計時數字文字的字型。"
L["Show the name of the party or raid member who cast a buff on you in its tooltip."] = "在滑鼠提示中顯示對你施放增益效果的隊伍或團隊成員名字。"
L["Text Outline"] = "文字外框"
L["Text Size"] = "文字大小"
L["Thick"] = "粗"
L["Thin"] = "細"
L["Top"] = "頂部"
L["Typeface"] = "字型"
L["unlock"] = "解鎖"
L["Use this panel to adjust some basic settings for buff, debuff, and weapon buff icons."] = "這裡可以調整增益、減益效果和武器特效圖示的基本設定。"

return end
