local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "ovale_shaman_spells"
	local desc = "[7.0] Ovale: Shaman spells"
	local code = [[

Define(ascendance_elemental 114050)
	SpellInfo(ascendance_elemental cd=180 gcd=0 offgcd=1)
	SpellAddBuff(ascendance_elemental ascendance_elemental_buff=1)
Define(ascendance_elemental_buff 114050)
	SpellInfo(ascendance_elemental_buff duration=15)
Define(ascendance_enhancement 114051)
	SpellInfo(ascendance_enhancement cd=180 gcd=0 offgcd=1)
	SpellAddBuff(ascendance_enhancement ascendance_enhancement_buff=1)
Define(ascendance_enhancement_buff 114051)
	SpellInfo(ascendance_enhancement_buff duration=15)
Define(bloodlust 2825)
	SpellInfo(bloodlust cd=300 gcd=0)
	SpellAddBuff(bloodlust bloodlust_buff=1)
Define(bloodlust_buff 2825)
	SpellInfo(bloodlust_buff duration=40)
Define(boulderfist 201897)
	SpellInfo(boulderfist cd=6 cd_haste=melee charges=2 maelstrom=-25)
	SpellAddBuff(boulderfist boulderfist_buff=1)
Define(boulderfist_buff 218825)
	SpellInfo(boulderfist_buff duration=10)
Define(chain_lightning 421)
	SpellInfo(chain_lightning maelstrom=-6)
	SpellAddBuff(chain_lightning stormkeeper_buff=-1)
Define(crash_lightning 187874)
	SpellInfo(crash_lightning maelstrom=20 cd=6 cd_haste=melee)
Define(crash_lightning_buff 187878)
Define(doom_winds 204945)
	SpellInfo(doom_winds cd=60 gcd=0 offgcd=1)
	SpellAddBuff(doom_winds doom_winds_buff=1)
Define(doom_winds_buff 204945)
	SpellInfo(doom_winds_buff duration=6)
Define(earth_shock 8042)
	SpellInfo(earth_shock maelstrom=10 extra_maelstrom=90)
Define(earthen_spike 188089)
	SpellInfo(earthen_spike cd=20 maelstrom=20)
	SpellAddTargetDebuff(earthen_spike earthen_spike_debuff=1)
Define(earthen_spike_debuff 188089)
	SpellInfo(earthen_spike_debuff duration=10)
Define(earthquake 61882)
	SpellInfo(earthquake maelstrom=50)
	SpellRequire(earthquake maelstrom 0=buff,echoes_of_the_great_sundering_buff)
Define(elemental_blast 117014)
	SpellInfo(elemental_blast cd=12 travel_time=1)
Define(elemental_focus_buff 16246)
Define(elemental_mastery 16166)
	SpellInfo(elemental_mastery cd=120 gcd=0)
	SpellAddBuff(elemental_mastery elemental_mastery_buff=1)
Define(elemental_mastery_buff 16166)
	SpellInfo(elemental_mastery_buff duration=20)
Define(feral_lunge 196884)
	SpellInfo(feral_lunge cd=30)
Define(feral_spirit 51533)
	SpellInfo(feral_spirit cd=120 duration=15)
Define(fire_elemental 198067)
	SpellInfo(fire_elemental cd=300)
	SpellInfo(fire_elemental replace=storm_elemental talent=storm_elemental_talent)
Define(flame_shock 188389)
	SpellInfo(flame_shock maelstrom=0 extra_maelstrom=20)
	SpellAddTargetDebuff(flame_shock flame_shock_debuff=1)
Define(flame_shock_debuff 188389)
	SpellInfo(flame_shock_debuff duration=15 haste=spell tick=3)
Define(flametongue 193796)
	SpellInfo(flametongue cd=12 cd_haste=melee)
	SpellAddBuff(flametongue flametongue_buff=1)
Define(flametongue_buff 193796)
	SpellInfo(flametongue_buff duration=16)
Define(frost_shock 196840)
	SpellAddBuff(frost_shock icefury_buff=-1)
Define(frostbrand 196834)
	SpellInfo(frostbrand maelstrom=20)
	SpellAddBuff(frostbrand frostbrand_buff=1)
Define(frostbrand_buff 196834)
	SpellInfo(flametongue_buff duration=15)
Define(fury_of_air 197211)
	SpellInfo(fury_of_air maelstrom=5)
	SpellAddBuff(fury_of_air fury_of_air_buff=1)
	SpellAddTargetDebuff(fury_of_air fury_of_air_debuff=1)
	SpellRequire(fury_of_air unusable 1=buff,fury_of_air_buff)
Define(fury_of_air_buff 197211)
Define(fury_of_air_debuff 197385)
	SpellInfo(fury_of_air_debuff duration=3)
Define(heroism 32182)
	SpellInfo(heroism cd=300 gcd=0)
	SpellAddBuff(heroism heroism_buff=1)
Define(heroism_buff 32182)
	SpellInfo(heroism_buff duration=40)
Define(hex 51514)
Define(hot_hand_buff 215785)
Define(icefury 210714)
	SpellInfo(icefury maelstrom=-24)
	SpellAddBuff(icefury icefury_buff=4)
Define(icefury_buff 210714)
	SpellInfo(icefury_buff duration=15)
Define(landslide_buff 202004)
	SpellInfo(landslide_buff duration=10)
Define(lava_beam 114074)
	SpellRequire(lava_beam unusable 1=buff,!ascendance_elemental_buff)
Define(lava_burst 51505)
	SpellInfo(lava_burst cd=8 travel_time=1 maelstrom=-12 charges=1)
	SpellInfo(lava_burst charges=2 talent=echo_of_the_elements_talent)
Define(lava_lash 60103)
	SpellInfo(lava_lash maelstrom=30)
	SpellRequire(lava_lash maelstrom 0=buff,hot_hand_buff)
Define(lava_surge_buff 77762)
	SpellInfo(lava_surge_buff duration=10)
Define(lightning_bolt_elemental 188196)
	SpellInfo(lightning_bolt_elemental maelstrom=-8 cd=0)
	SpellAddBuff(lightning_bolt_elemental stormkeeper_buff=-1)
Define(lightning_bolt_enhancement 187837)
	SpellInfo(lightning_bolt maelstrom=-8 cd=9 cd_haste=melee talent=overcharge_talent)
Define(lightning_crash_buff 187874)
Define(lightning_rod_debuff 197209)
Define(lightning_shield 192106)
	SpellAddBuff(lightning_shield lightning_shield_buff=1)
	SpellRequire(lightning_shield unusable 1=buff,lightning_shield_buff)
Define(lightning_shield_buff 192106)
	SpellInfo(lightning_shield_buff duration=3600)
Define(lightning_surge_totem 192058)
Define(liquid_magma_totem 192222)
	SpellInfo(liquid_magma_totem cd=60)
Define(resonance_totem_buff 202192)
Define(rockbiter 193786)
	SpellInfo(rockbiter maelstrom=-15 charges=2 cd=6)
Define(storm_elemental 192249)
Define(stormbringer 201845)
Define(stormbringer_buff 201846)
	SpellInfo(stormbringer_buff duration=12)
Define(stormkeeper 205495)
	SpellInfo(stormkeeper cd=60 tag=main)
	SpellAddBuff(stormkeeper stormkeeper_buff=3)
Define(stormkeeper_buff 205495)
	SpellInfo(stormkeeper_buff duration=15)
Define(stormstrike 17364)
	SpellInfo(stormstrike cd=15 cd_haste=melee maelstrom=40)
	SpellAddBuff(stormstrike stormbringer_buff=-1)
	SpellRequire(stormstrike replace windstrike=buff,ascendance_enhancement_buff)
	SpellRequire(stormstrike cd 0=buff,stormbringer_buff)
	SpellRequire(stormstrike maelstrom_percent 50=buff,stormbringer_buff)
Define(sundering 197214)
	SpellInfo(sundering maelstrom=20 cd=40 tag=main)
Define(totem_mastery 210643)
	SpellInfo(totem_mastery totem=fire buff_totem=resonance_totem_buff duration=120 tag=main)
Define(windsong 201898)
	SpellInfo(windsong cd=45)
Define(windstrike 115356)
	SpellInfo(windstrike maelstrom=8 cd=3 cd_haste=melee)
	SpellRequire(windstrike unusable 1=buff,!ascendance_enhancement_buff)
	SpellAddBuff(windstrike stormbringer_buff=-1)
	SpellRequire(windstrike cd 0=buff,stormbringer_buff)
	SpellRequire(windstrike maelstrom_percent 50=buff,stormbringer_buff)
Define(wind_shear 57994)
	SpellInfo(wind_shear cd=12 gcd=0 offgcd=1 interrupt=1)
	
# Talents
Define(ascendance_talent 19)
Define(boulderfist_talent 3)
Define(crashing_storm_talent 16)
Define(echo_of_the_elements_talent 18)
Define(fury_of_air_talent 17)
Define(hailstorm_talent 12)
Define(hot_hand_talent 2)
Define(icefury_talent 21)
Define(landslide_talent 20)
Define(lightning_rod_talent 20)
Define(overcharge_talent 14)
Define(storm_elemental_talent 17)
	
# Artifact traits
Define(alpha_wolf 198434)
Define(seismic_storm 238141)
Define(swelling_maelstrom 238105)

Define(fiery_wolf_alpha_wolf_buff 198434)
Define(frost_wolf_alpha_wolf_buff 198434)
Define(lightning_wolf_alpha_wolf_buff 198434)

Define(power_of_the_maelstrom_buff 191877)
	SpellAddBuff(lightning_bolt_elemental power_of_the_maelstrom_buff=-1)

# Legendary items
Define(echoes_of_the_great_sundering_buff 208723)
	SpellAddBuff(earthquake echoes_of_the_great_sundering_buff=0)

	
]]

	OvaleScripts:RegisterScript("SHAMAN", nil, name, desc, code, "include")
end
