--[[--------------------------------------------------------------------
    Copyright (C) 2014 Johnny C. Lam.
    See the file LICENSE.txt for copying permission.
--]]--------------------------------------------------------------------

local OVALE, Ovale = ...

local rawset = rawset
local setmetatable = setmetatable
local tostring = tostring

local L = nil
do
	-- Default value is the key itself.
	local MT = {
		__index = function(self, key)
			local value = tostring(key)
			rawset(self, key, value)
			return value
		end,
	}
	L = setmetatable({}, MT)
	Ovale.L = L
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.
-- UPDATE TRANSLATIONS AT:
--     http://wow.curseforge.com/addons/ovale/localization

local locale = GetLocale()

if locale == "deDE" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "Numerische Anzeige"
L["Affiche le temps de recharge sous forme numérique"] = "Zeige die verbleibende Zeit in numerischer Form"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Zeige zwei Fähigkeiten und nicht nur eine"
L["Afficher la fenêtre"] = "Ovale anzeigen"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Zeige Tastaturkürzel in der linken unteren Ecke des Icons"
L["aoe"] = "Flächenschaden"
L["AOE"] = "Flächenschaden"
L["Apparence"] = "Aussehen"
L["arcane_mage_burn_phase"] = "Vorschlagen von Burn-Aktionen"
--Translation missing 
-- L["Artifact traits"] = ""
L["Aura lag"] = "Aura-Verzögerung"
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Blut"
L["buff"] = "Stärkungszauber"
L["Cacher bouton vide"] = "Leere Buttons ausblenden"
L["Cacher dans les véhicules"] = "In Fahrzeugen ausblenden"
L["Cacher la fenêtre"] = "Ovale ausblenden"
L["Cacher si cible amicale ou morte"] = "Ausblenden bei freundlichem oder totem Ziel"
L["Caractère de portée"] = "Reichweitenanzeige"
L["cd"] = [=[Fähigkeit mit langer Abklingzeit.
So bald wie möglich benutzen oder für besondere Phasen aufheben.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Dieser Text wird auf dem Icon angezeigt, um anzuzeigen ob das Ziel in Reichweite ist"
L["Click to select the script."] = "Anklicken, um das Skript auszuwählen"
L["Cliquer pour afficher/cacher les options"] = "Klicken, um Optionen anzuzeigen/zu verbergen"
L["Code"] = "Code"
L["Colors"] = "Farben"
L["Copier sur Script personnalisé"] = "In eigenes Skript kopieren"
L["Correction de la latence"] = "Latenzkorrektur"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "Aura-Management nachverfolgen"
L["Debug compile"] = "Wenn das Skript übersetzt wird, nachverfolgen"
L["Debug enemies"] = "Feinderkennung nachverfolgen"
L["Debug GUID"] = "Änderungen in der UnitID/GUID-Paarung nachverfolgen"
L["Debug missing spells"] = "Warnen, wenn eine bekannte Spell-ID benutzt wird, die nicht im Zauberbuch vorhanden ist."
L["Debug unknown spells"] = "Warnen, wenn eine unbekannte Spell-ID im Skript verwendet wird."
L["Décalage horizontal des options"] = "Optionen horizontal verschieben"
L["Décalage vertical des options"] = "Optionen vertikal verschieben"
L["Défilement"] = "Scrollend"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "Existierendes eigenes Skript überschreiben?"
L["En combat uniquement"] = "Nur im Kampf anzeigen"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "Aufblitz-Leuchtkraft"
L["Flash size"] = "Aufblitz-Größe"
L["Flash spells"] = "Aufblitzende Zauber"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Aufblitzende Zauber in der Aktionsleiste, wenn sie zur Nutzung bereit sind. Benötigt SpellFlashCore."
L["Flash threshold"] = "Aufblitz-Schwellenwert"
L["Focus"] = "Fokus"
L["Groupe d'icônes"] = "Icon-Gruppe"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "Icon"
L["Ignorer les clics souris"] = "Mausklicks ignorieren"
L["Illuminer l'icône"] = "Icon hervorheben"
L["Illuminer l'icône quand la technique doit être spammée"] = "Icon hervorheben, wenn Fähigkeit gespammt werden sollte"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Icon blinken lassen, wenn die Fähigkeit bereit ist"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "Unterbrechungen"
L["Interrupts"] = "Unterbrechungen"
L["Inverser la boîte à cocher "] = "Checkbox umschalten"
L["La taille des icônes"] = "Die Icongröße"
L["La taille des petites icônes"] = "Die Größe der kleinen Icons"
L["La taille des polices"] = "Die Schriftgröße"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Verzögerung (in Millisekunden) zwischen Auslösen des Zaubers und dem Zeitpunkt, wenn der Effekt eintritt oder entfernt wird"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Die Icons scrollen"
L["Long cooldown abilities"] = "Fähigkeiten mit langer Abklingzeit"
L["main"] = "Hauptangriff"
L["Main attack"] = "Hauptangriff"
L["mana"] = "Managewinn"
L["Marge entre deux icônes"] = "Abstand zwischen den Icons"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "Angriffe während der Bewegung"
L["multidot"] = "Schaden über Zeit auf mehreren Zielen"
L["None"] = "Nichts"
L["not_in_melee_range"] = "nicht in Nahkampfreichweite"
L["offgcd"] = [=[Fähigkeit ohne globalem Cooldown.
Neben dem Hauptangriff benutzen.]=]
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
L["Only count tagged enemies"] = "Zählt nur markierte Gegner"
L["Opacité des icônes"] = "Undurchsichtigkeit der Icons"
L["Opacité des options"] = "Undurchsichtigkeit der Optionen"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "Auswahl"
--Translation missing 
-- L["Output"] = ""
L["Overrides"] = "Überschreibungen"
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "vorhersagen"
L["Prédictif"] = "Zwei Fähigkeiten"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Tastaturkürzel"
L["Reset"] = "zurücksetzen"
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "Rechts-Klick für Optionen"
L["Script"] = "Skript"
L["Script défaut"] = "Standardscript"
L["Script personnalisé"] = "Eigenes Skript"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "Fähigkeiten mit kurzer Abklingzeit"
L["shortcd"] = [=[Fähigkeiten mit kurzer Abklingzeit
Benutzen, sobald sie bereit sind.]=]
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "zeige versteckte"
L["Show minimap icon"] = "Minikartensymbol zeigen"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "Zeige das Warte-Icon"
L["Si cible uniquement"] = "nur mit Ziel"
L["SimulationCraft Profile"] = "SimulationCraft-Profil"
--Translation missing 
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
L["Spellbook"] = "Zauberbuch"
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "Begleiter beschwören"
L["Taille des icônes"] = "Icongröße"
L["Taille des petites icônes"] = "Größe der kleinen Icons"
L["Taille des polices"] = "Schriftgröße"
L["Taille du second icône"] = "Größe des zweiten Icons"
--Translation missing 
-- L["Talents"] = ""
L["The contents of a SimulationCraft profile."] = "Der Inhalt eines SimulationCraft-Profils."
L["The script translated from the SimulationCraft profile."] = "Das Skript aus dem SimulationCraft Profil übersetzt."
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Zeit (ms) des Aufblitzens eines Zaubers, bevor er benutzbar ist."
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Position sperren"
L["Vertical"] = "Vertikal"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "Sichtbarkeit"

elseif locale == "enUS" then
L["Action bar"] = "Action bar"
L["Affichage numérique"] = "Numeric display"
L["Affiche le temps de recharge sous forme numérique"] = "Show the remaining time in numerical form"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Display two abilities and not only one"
L["Afficher la fenêtre"] = "Show Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Show keyboard shortcuts in the icon bottom-left corner"
L["aoe"] = [=[Attack multiple targets.
Adapts to the total number of enemies.]=]
L["AOE"] = "Multiple-targets rotation"
L["Apparence"] = "Appearance"
L["arcane_mage_burn_phase"] = "Suggest Burn actions"
L["Artifact traits"] = "Artifact traits"
L["Aura lag"] = "Aura lag"
L["Auras (player)"] = "Auras (player)"
L["Auras (target)"] = "Auras (target)"
L["Auras on the player"] = "Auras on the player"
L["Auras on the target"] = "Auras on the target"
L["Blood"] = "Blood"
L["buff"] = "Buffs"
L["Cacher bouton vide"] = "Hide empty buttons"
L["Cacher dans les véhicules"] = "Hide in vehicles"
L["Cacher la fenêtre"] = "Hide Ovale"
L["Cacher si cible amicale ou morte"] = "Hide if friendly or dead target"
L["Caractère de portée"] = "Range indicator"
L["cd"] = [=[Long cooldown abilities.
Cast as soon as possible or for increased-damage phases.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "This text is displayed on the icon to show if the target is in range"
L["Click to select the script."] = "Click to select the script."
L["Cliquer pour afficher/cacher les options"] = "Click to hide/show options"
L["Code"] = "Code"
L["Colors"] = "Colors"
L["Copier sur Script personnalisé"] = "Copy to custom script"
L["Correction de la latence"] = "Latency correction"
L["Debug"] = "Debug"
L["Debug aura"] = "Track aura management."
L["Debug compile"] = "Track when the script is compiled."
L["Debug enemies"] = "Track enemy detection."
L["Debug GUID"] = "Track changes to the UnitID/GUID pairings."
L["Debug missing spells"] = "Warn if a known spell ID is used that is missing from the spellbook."
L["Debug unknown spells"] = "Warn if an unknown spell ID is used in the script."
L["Décalage horizontal des options"] = "Options horizontal shift"
L["Décalage vertical des options"] = "Options vertical shift"
L["Défilement"] = "Scrolling"
L["Disabled"] = "Disabled"
L["Display refresh statistics"] = "Display refresh statistics"
L["Ecraser le Script personnalisé préexistant?"] = "Overwrite existing custom script?"
L["En combat uniquement"] = "Show in combat only"
L["Enable debugging messages for the %s module."] = "Enable debugging messages for the %s module."
L["Enable profiling for the %s module."] = "Enable profiling for the %s module."
L["Enabled"] = "Enabled"
L["Flash brightness"] = "Flash brightness"
L["Flash size"] = "Flash size"
L["Flash spells"] = "Flash spells"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"
L["Flash threshold"] = "Flash threshold"
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Icon group"
L["Horizontal offset"] = "Horizontal offset"
L["Horizontal offset from the center of the screen."] = "Horizontal offset from the center of the screen."
L["Icône"] = "Icon"
L["Ignorer les clics souris"] = "Ignore mouse clicks"
L["Illuminer l'icône"] = "Highlight icon"
L["Illuminer l'icône quand la technique doit être spammée"] = "Hightlight icon when ability should be spammed"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Flash the icon when the ability is ready"
L["Input"] = "Input"
L["interrupt"] = "Interrupts"
L["Interrupts"] = "Interrupts"
L["Inverser la boîte à cocher "] = "Toggle check box"
L["La taille des icônes"] = "The icons scale"
L["La taille des petites icônes"] = "The small icons scale"
L["La taille des polices"] = "The font scale"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"
L["Layout"] = "Layout"
L["Les icônes se déplacent"] = "Scroll the icons"
L["Long cooldown abilities"] = "Long cooldown abilities"
L["main"] = "Main attack"
L["Main attack"] = "Main attack"
L["mana"] = "Mana gain"
L["Marge entre deux icônes"] = "Margin between icons"
L["Middle-Click to toggle the script options panel."] = "Middle-Click to toggle the script options panel."
L["Modules"] = "Modules"
L["moving"] = "Attacks to use while moving"
L["multidot"] = "Damage-over-time on multiple targets"
L["None"] = "None"
L["not_in_melee_range"] = "Not in melee range"
L["offgcd"] = [=[Out of global cooldown ability.
Cast alongside your main attack.]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "Only count a mob as an enemy if it is directly affected by a player's spells."
L["Only count tagged enemies"] = "Only count tagged enemies"
L["Opacité des icônes"] = "Icons opacity"
L["Opacité des options"] = "Options opacity"
L["Open configuration panel in a separate, movable window."] = "Open configuration panel in a separate, movable window."
L["Options"] = "Options"
L["Output"] = "Output"
L["Overrides"] = "Overrides"
L["Ping for Ovale users in group"] = "Ping for Ovale users in group"
L["Power"] = "Power"
L["predict"] = "Next non-filler attack."
L["Prédictif"] = "Two abilities"
L["Profiling"] = "Profiling"
L["Raccourcis clavier"] = "Keyboard shortcuts"
L["Reset"] = "Reset"
L["Reset the profiling statistics."] = "Reset the profiling statistics."
L["Right-Click for options."] = "Right-Click for options."
L["Script"] = "Script"
L["Script défaut"] = "Default script"
L["Script personnalisé"] = "Custom script"
L["Shift-Right-Click for the current trace log."] = "Shift-Right-Click for the current trace log."
L["Short cooldown abilities"] = "Short cooldown abilities"
L["shortcd"] = [=[Short cooldown abilities.
Cast as soon as possible.]=]
L["Show"] = "Show"
L["Show hidden"] = "Show hidden"
L["Show minimap icon"] = "Show minimap icon"
L["Show the profiling statistics."] = "Show the profiling statistics."
L["Show Trace Log"] = "Show Trace Log"
L["Show version number"] = "Show version number"
L["showwait"] = "Show the wait icon"
L["Si cible uniquement"] = "If has target"
L["SimulationCraft Profile"] = "SimulationCraft Profile"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Script code inserted immediately after Include() script statements to override standard definitions, e.g., |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["Spellbook"] = "Spellbook"
L["Stances"] = "Stances"
L["Standalone options"] = "Standalone options"
L["summon_pet"] = "Summon pet."
L["Taille des icônes"] = "Icon scale"
L["Taille des petites icônes"] = "Small icon scale"
L["Taille des polices"] = "Font scale"
L["Taille du second icône"] = "Second icon size"
L["Talents"] = "Talents"
L["The contents of a SimulationCraft profile."] = "The contents of a SimulationCraft profile."
L["The script translated from the SimulationCraft profile."] = "The script translated from the SimulationCraft profile."
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Time (in milliseconds) to begin flashing the spell to use before it is ready."
L["Top 3"] = "Top 3"
L["Trace"] = "Trace"
L["Trace Log"] = "Trace Log"
L["Trace the next frame update."] = "Trace the next frame update."
L["Verrouiller position"] = "Lock position"
L["Vertical"] = "Vertical"
L["Vertical offset"] = "Vertical offset"
L["Vertical offset from the center of the screen."] = "Vertical offset from the center of the screen."
L["Visibilité"] = "Visibility"

elseif locale == "esES" then
L["Action bar"] = "Barra de acción"
L["Affichage numérique"] = "Visualización numérica"
L["Affiche le temps de recharge sous forme numérique"] = "Ver tiempo restante de forma numérica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar dos habilidades y no solo una"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atajo de teclado en la esquina inferior izquierda del icono"
L["aoe"] = [=[Atacar a múltiples objetivos.
Se adapta al número total de enemigos.]=]
L["AOE"] = "Rotación multi-target"
L["Apparence"] = "Apariencia"
L["arcane_mage_burn_phase"] = "Acción de daño rápido sugerida"
L["Artifact traits"] = "Características de artefacto"
L["Aura lag"] = "Retardo de aura"
L["Auras (player)"] = "Auras (jugador)"
L["Auras (target)"] = "Auras (objetivo)"
L["Auras on the player"] = "Auras sobre el jugador"
L["Auras on the target"] = "Auras sobre el objetivo"
L["Blood"] = "Sangre"
L["buff"] = "Buffos"
L["Cacher bouton vide"] = "Ocultar botones vacios"
L["Cacher dans les véhicules"] = "Ocultar en vehiculo"
L["Cacher la fenêtre"] = "Ocultar Ovale"
L["Cacher si cible amicale ou morte"] = "Ocultar si el objetivo es aliado o está muerto"
L["Caractère de portée"] = "Indicador de distancia"
L["cd"] = [=[Habilidades con largo cooldown.
Utilízalas lo antes posible para fases que requieran mucho daño.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto se muestra sobre el icono si el objetivo está a rango"
L["Click to select the script."] = "Haz clic para seleccionar el script"
L["Cliquer pour afficher/cacher les options"] = "Click para Ocultar/ver opciones"
L["Code"] = "Código"
L["Colors"] = "Colores"
L["Copier sur Script personnalisé"] = "Copiar al script personalizado"
L["Correction de la latence"] = "Correción de latencia"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "Comprobar gestión de auras."
L["Debug compile"] = "Comprobar cuándo el script se compila."
L["Debug enemies"] = "Comprobar la detección de enemigos."
L["Debug GUID"] = "COmprobar cambios en el emparejamiento UnitID/GUID."
L["Debug missing spells"] = "Avisar si falta algún ID de hechizo del libro de hechizos."
L["Debug unknown spells"] = "Avisar si se utiliza algún ID de hechizo desconocido en el script."
L["Décalage horizontal des options"] = "Desplazamiento horizontal de las opciones"
L["Décalage vertical des options"] = "Desplazamiento vertical de las opciones"
L["Défilement"] = "rueda de desclazamiento"
L["Disabled"] = "Desactivado"
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "¿Deseas sobreescribir el script personalizado actual?"
L["En combat uniquement"] = "Mostrar sólo en combate"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
L["Enabled"] = "Activado"
L["Flash brightness"] = "Brillo del destello"
L["Flash size"] = "Tamaño del destello"
L["Flash spells"] = "Destello de hechizos"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Activar destello de hechizos en las barras de acción cuando éstos están listos para ser utilizados. Requiere SpellFleshCore"
L["Flash threshold"] = "Umbral del destello"
L["Focus"] = "Foco"
L["Groupe d'icônes"] = "Grupo de iconos"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "Icono"
L["Ignorer les clics souris"] = "Ignorar las pulsaciones del ratón"
L["Illuminer l'icône"] = "Iluminar el icono"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar el icono cuando la habilidad debe ser utilizada repetidamente"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar el icono cuando la habilidad esta lista"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "interrumpir"
L["Interrupts"] = "interrupciones"
L["Inverser la boîte à cocher "] = "Activar/desactivar la caja de selección"
L["La taille des icônes"] = "Tamaño de los iconos"
L["La taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["La taille des polices"] = "Tamaño del texto"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Retraso (en milisegundos) entre el lanzamiento de un hechizo y el momento en que el aura correspondiente es aplicada"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Los iconos pueden desplazarse"
L["Long cooldown abilities"] = "Cooldowns largos"
L["main"] = "principal"
L["Main attack"] = "Ataque Principal"
L["mana"] = "maná"
L["Marge entre deux icônes"] = "Separación entre los iconos"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "Ataques a utilizar en situaciones de movimiento"
L["multidot"] = "DOTs en múltiples objetivos"
L["None"] = "Nada"
L["not_in_melee_range"] = "Fuera del rango de melé"
L["offgcd"] = "Habilidad fuera del cooldown global"
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidad de los iconos"
L["Opacité des options"] = "Opacidad de las opciones"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "Opciones"
--Translation missing 
-- L["Output"] = ""
L["Overrides"] = "Forzados"
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "predecir"
L["Prédictif"] = "Dos habilidades"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Accesos directos de teclado"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "Pulsar con el botón derecho para mostrar opciones"
L["Script"] = "Script"
L["Script défaut"] = "Script por defecto"
L["Script personnalisé"] = "Script personalizado"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "Habilidades de cooldown corto"
L["shortcd"] = "cd corto"
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "Mostrar ocultos"
L["Show minimap icon"] = "Mostrar el icono del minimapa"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "mostrar el icono de pausa"
L["Si cible uniquement"] = "Si hay objetivo"
L["SimulationCraft Profile"] = "Perfil de SimulationCraft"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Utilizar el código insertado inmediatamente después de las sentencias Include() para forzar las definiciones estándar, p.e. |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "Invocar mascota"
L["Taille des icônes"] = "Tamaño de los iconos"
L["Taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["Taille des polices"] = "Tamaño del texto"
L["Taille du second icône"] = "Tamaño del segundo icono"
--Translation missing 
-- L["Talents"] = ""
L["The contents of a SimulationCraft profile."] = "Los contenidos del perfil de SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "El script traducido del perfil de SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Tiempo de antelación(en milisegundos) para que comience el destello de un hechizo antes de que esté listo"
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Bloquear posición"
L["Vertical"] = "Vertical"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "Visibilidad"

elseif locale == "esMX" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "Visualización numérica"
L["Affiche le temps de recharge sous forme numérique"] = "Ver tiempo restante de forma numérica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar dos habilidades y no solo una"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atajo de teclado en la esquina inferior izquierda del icono"
L["aoe"] = [=[Atacar a múltiples objetivos.
Se adapta al número total de enemigos.]=]
L["AOE"] = "Rotación multi-target"
L["Apparence"] = "Apariencia"
L["arcane_mage_burn_phase"] = "Acción de daño rápido sugerida"
--Translation missing 
-- L["Artifact traits"] = ""
L["Aura lag"] = "Retardo de aura"
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Sangre"
L["buff"] = "Buffs"
L["Cacher bouton vide"] = "Ocultar botones vacíos"
L["Cacher dans les véhicules"] = "Ocultar en vehículo"
L["Cacher la fenêtre"] = "Ocultar Ovale"
L["Cacher si cible amicale ou morte"] = "Ocultar si el objetivo es aliado o está muerto"
L["Caractère de portée"] = "Indicador de distancia"
L["cd"] = [=[Habilidades con cooldown largo.
Utilízalas lo antes posible o para fases que requieran mucho daño.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto se muestra sobre el icono si el objetivo está en el rango"
L["Click to select the script."] = "Haz clic para seleccionar el script."
L["Cliquer pour afficher/cacher les options"] = "Click para ocultar/ver opciones"
L["Code"] = "Código"
--Translation missing 
-- L["Colors"] = ""
L["Copier sur Script personnalisé"] = "Copiar al script personalizado"
L["Correction de la latence"] = "Correción de latencia"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "Comprobar gestión de auras."
L["Debug compile"] = "Comprobar cuando el script se compila."
L["Debug enemies"] = "Comprobar la detección de enemigos."
L["Debug GUID"] = "Comprobar cambios en el emparejamiento UnitID/GUID."
L["Debug missing spells"] = "Avisar si falta algún ID de hechizo del libro de hechizos."
L["Debug unknown spells"] = "Avisar si se utiliza algún ID de hechizo desconocido en el script."
L["Décalage horizontal des options"] = "Desplazamiento horizontal de las opciones"
L["Décalage vertical des options"] = "Desplazamiento vertical de las opciones"
L["Défilement"] = "Rueda de desplazamiento"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "¿Deseas sobrescribir el script personalizado actual?"
L["En combat uniquement"] = "Mostrar sólo en combate"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "Brillo del destello"
L["Flash size"] = "Tamaño del destello"
L["Flash spells"] = "Destello del hechizo"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Activar destello de hechizos en las barras de acción cuando éstos están listos para ser utilizados. Requiere SpellFleshCore"
L["Flash threshold"] = "Umbral del destello"
L["Focus"] = "Foco"
L["Groupe d'icônes"] = "Grupo de iconos"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "Icono"
L["Ignorer les clics souris"] = "Ignorar las pulsaciones del ratón"
L["Illuminer l'icône"] = "Iluminar el icono"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar el icono cuando la habilidad debe ser utilizada repetidamente"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar el icono cuando la habilidad está lista"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "Interrupciones"
L["Interrupts"] = "Interrupciones"
L["Inverser la boîte à cocher "] = "Activar/desactivar la caja de selección"
L["La taille des icônes"] = "Tamaño de los iconos"
L["La taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["La taille des polices"] = "Tamaño del texto"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Retraso (en milisegundos) entre el lanzamiento de un hechizo y el momento en que el aura correspondiente es aplicada o removida"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Los iconos pueden desplazarse"
L["Long cooldown abilities"] = "Cooldowns largos"
L["main"] = "Ataque principal"
L["Main attack"] = "Ataque Principal"
L["mana"] = "Aumento de maná"
L["Marge entre deux icônes"] = "Separación entre los iconos"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "Ataques a utilizar en situaciones de movimiento"
L["multidot"] = "DOTs en múltiples objetivos"
L["None"] = "Nada"
L["not_in_melee_range"] = "Fuera del rango de melé"
L["offgcd"] = "Habilidad fuera del cooldown global"
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidad de los iconos"
L["Opacité des options"] = "Opacidad de las opciones"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "Opciones"
--Translation missing 
-- L["Output"] = ""
L["Overrides"] = "Forzados"
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "Siguiente ataque no de relleno."
L["Prédictif"] = "Dos habilidades"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Atajos del teclado"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "Pulsar con el botón derecho para mostrar opciones."
L["Script"] = "Script"
L["Script défaut"] = "Script por defecto"
L["Script personnalisé"] = "Script personalizado"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "Habilidades de cooldown corto"
L["shortcd"] = [=[Habilidades de cooldown corto.
Lánzalas tan pronto sea posible.]=]
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "Mostrar scripts ocultos"
L["Show minimap icon"] = "Mostrar el icono del minimapa"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "Mostrar el icono de pausa"
L["Si cible uniquement"] = "Si hay objetivo"
L["SimulationCraft Profile"] = "Perfil de SimulationCraft"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Utilizar el código insertado inmediatamente después de las sentencias Include() para forzar las definiciones estándar, ej: |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "Invocar mascota."
L["Taille des icônes"] = "Tamaño de los iconos"
L["Taille des petites icônes"] = "Tamaño de los iconos pequeños"
L["Taille des polices"] = "Tamaño del texto"
L["Taille du second icône"] = "Tamaño del segundo icono"
--Translation missing 
-- L["Talents"] = ""
L["The contents of a SimulationCraft profile."] = "Contenidos del perfil de SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "Script traducido del perfil de SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Tiempo de antelación (en milisegundos) para que comience el destello de un hechizo antes de que esté listo"
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Bloquear posición"
L["Vertical"] = "Vertical"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "Visibilidad"

elseif locale == "frFR" then
L["Action bar"] = "Barre d'action"
L["Affichage numérique"] = "Affichage numérique"
L["Affiche le temps de recharge sous forme numérique"] = "Affiche le temps de recharge sous forme numérique"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Affiche les deux prochains sorts et pas uniquement le suivant"
L["Afficher la fenêtre"] = "Afficher la fenêtre"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"
L["aoe"] = "Attaque multi-cible"
L["AOE"] = "Rotation multicible"
L["Apparence"] = "Apparence"
L["arcane_mage_burn_phase"] = "Phase de burn"
L["Artifact traits"] = "Caractéristiques d'armes prodigieuses"
L["Aura lag"] = "Latence de l'aura"
L["Auras (player)"] = "Auras (joueur)"
L["Auras (target)"] = "Auras (cible)"
L["Auras on the player"] = "Auras sur le joueur"
L["Auras on the target"] = "Auras sur la cible"
L["Blood"] = "Saignement"
L["buff"] = "Améliorations"
L["Cacher bouton vide"] = "Cacher bouton vide"
L["Cacher dans les véhicules"] = "Cacher dans les véhicules"
L["Cacher la fenêtre"] = "Cacher la fenêtre"
L["Cacher si cible amicale ou morte"] = "Cacher si cible amicale ou morte"
L["Caractère de portée"] = "Caractère de portée"
L["cd"] = [=[Techniques à longs temps de recharge.
Lancer dès que possible ou conserver pour les phases de dégâts amplifiés.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"
L["Click to select the script."] = "Cliquez pour sélectionner le script."
L["Cliquer pour afficher/cacher les options"] = "Cliquer pour afficher/cacher les options"
L["Code"] = "Code"
L["Colors"] = "Couleurs"
L["Copier sur Script personnalisé"] = "Copier sur Script personnalisé"
L["Correction de la latence"] = "Correction de la latence"
L["Debug"] = "Debug"
L["Debug aura"] = "Suivre la gestion des auras."
L["Debug compile"] = "Suivre lorsque le script est compilé."
L["Debug enemies"] = "Suivre la détection des ennemis."
L["Debug GUID"] = "Suivre les changements des paires de UnitID et GUID."
L["Debug missing spells"] = "Prévenir si le ID d'un sort qui n'est pas dans le livre de sorts est utilisé."
L["Debug unknown spells"] = "Prévenir si le ID d'un sort inconnu est utilisé dans le script."
L["Décalage horizontal des options"] = "Décalage horizontal des options"
L["Décalage vertical des options"] = "Décalage vertical des options"
L["Défilement"] = "Défilement"
L["Disabled"] = "Désactivé"
L["Display refresh statistics"] = "Afficher les statistiques de rafraîchissement"
L["Ecraser le Script personnalisé préexistant?"] = "Ecraser le Script personnalisé préexistant?"
L["En combat uniquement"] = "En combat uniquement"
L["Enable debugging messages for the %s module."] = "Activer les messages de debug pour le module %s"
L["Enable profiling for the %s module."] = "Activer le profiling sur le module %s"
L["Enabled"] = "Activé"
L["Flash brightness"] = "Luminosité du flash"
L["Flash size"] = "Taille du flash"
L["Flash spells"] = "Flash des sorts"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Illuminer les sorts des barres d'action quand ils sont prêts à être lancés. Requiert SpellFlashCore."
L["Flash threshold"] = "Tolérance pour le flash "
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Groupe d'icônes"
L["Horizontal offset"] = "Décalage horizontal"
L["Horizontal offset from the center of the screen."] = "Décalage horizontal depuis le centre de l'écran"
L["Icône"] = "Icône"
L["Ignorer les clics souris"] = "Ignorer les clics souris"
L["Illuminer l'icône"] = "Illuminer l'icône"
L["Illuminer l'icône quand la technique doit être spammée"] = "Illuminer l'icône quand la technique doit être spammée"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Illuminer l'icône quand le temps de recharge est écoulé"
L["Input"] = "Entrée"
L["interrupt"] = "Interruptions"
L["Interrupts"] = "Interruptions"
L["Inverser la boîte à cocher "] = "Inverser la boîte à cocher "
L["La taille des icônes"] = "La taille des icônes"
L["La taille des petites icônes"] = "La taille des petites icônes"
L["La taille des polices"] = "La taille des polices"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Latence (en milliseconde) quand un sort est lancé et qu'une aura est appliquée ou retirée."
L["Layout"] = "Disposition"
L["Les icônes se déplacent"] = "Les icônes se déplacent"
L["Long cooldown abilities"] = "Techniques à longs temps de recharge"
L["main"] = "Attaque principale"
L["Main attack"] = "Attaque principale"
L["mana"] = "Regain de mana"
L["Marge entre deux icônes"] = "Marge entre deux icônes"
L["Middle-Click to toggle the script options panel."] = "Clic milieu pour basculer l'affichage du panneau des options de script"
L["Modules"] = "Modules"
L["moving"] = "Attaques à utiliser en mouvement"
L["multidot"] = "Multicible pour DoTs"
L["None"] = "Aucun"
L["not_in_melee_range"] = "Pas à distance pour corps à corps"
L["offgcd"] = [=[Attaque hors temps de recharge globale.
Lancer en parallèle de l'attaque principale.]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "Ne compter un ennemi que s'il est directement affecté par un sort du joueur."
L["Only count tagged enemies"] = "Ne compter que les ennemis taggés."
L["Opacité des icônes"] = "Opacité des icônes"
L["Opacité des options"] = "Opacité des options"
L["Open configuration panel in a separate, movable window."] = "Ouvrir le panneau de configuration dans une fenêtre séparée"
L["Options"] = "Options"
L["Output"] = "Sortie"
L["Overrides"] = "Surcharges"
L["Ping for Ovale users in group"] = "Vérifier la présence d'utilisateurs d'Ovale dans le groupe"
L["Power"] = "Puissance"
L["predict"] = "Prochaine attaque hors remplissage"
L["Prédictif"] = "Deux sorts"
L["Profiling"] = "Profiling"
L["Raccourcis clavier"] = "Raccourcis clavier"
L["Reset"] = "Réinitialiser"
L["Reset the profiling statistics."] = "Réinitialiser les statistiques de profiling"
L["Right-Click for options."] = "Clic droit pour les options"
L["Script"] = "Script"
L["Script défaut"] = "Script par défaut"
L["Script personnalisé"] = "Script personnalisé"
L["Shift-Right-Click for the current trace log."] = "Maj-clic-droit pour les journaux de trace courants"
L["Short cooldown abilities"] = "Compétences à court temps de recharge"
L["shortcd"] = [=[Compétence à court temps de recharge.
Lancer dès que possible.]=]
L["Show"] = "Afficher"
L["Show hidden"] = "Voir les scripts cachés"
L["Show minimap icon"] = "Montrer l’icône de la minicarte"
L["Show the profiling statistics."] = "Afficher les statistiques de profiling"
L["Show Trace Log"] = "Afficher le journal des traces"
L["Show version number"] = "Afficher le numéro de version"
L["showwait"] = "Montrer l'icône d'attente"
L["Si cible uniquement"] = "Si cible uniquement"
L["SimulationCraft Profile"] = "Profil SimulationCraft"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Code inséré immédiatement après les commandes Include() pour surcharger les définitions standard, par ex. |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["Spellbook"] = "Livre des sorts"
L["Stances"] = "Postures"
L["Standalone options"] = "Options autonomes"
L["summon_pet"] = "Invoquer familier"
L["Taille des icônes"] = "Taille des icônes"
L["Taille des petites icônes"] = "Taille des petites icônes"
L["Taille des polices"] = "Taille des polices"
L["Taille du second icône"] = "Taille du second icône"
L["Talents"] = "Talents"
L["The contents of a SimulationCraft profile."] = "Le contenu d'un profil SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "Le script traduit d'un profil SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Temps (en millisecondes) avant de faire flasher le sort à utiliser quand il est prêt"
L["Top 3"] = "Top 3"
L["Trace"] = "Trace"
L["Trace Log"] = "Journal des traces"
L["Trace the next frame update."] = "Tracer la prochaine frame"
L["Verrouiller position"] = "Verrouiller position"
L["Vertical"] = "Vertical"
L["Vertical offset"] = "Décalage vertical"
L["Vertical offset from the center of the screen."] = "Décalage vertical depuis le centre de l'écran"
L["Visibilité"] = "Visibilité"

elseif locale == "itIT" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "Esposizione Numerica"
L["Affiche le temps de recharge sous forme numérique"] = "Mostra il tempo rimanente in forma numerica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Espone due abilita' e non solo una"
L["Afficher la fenêtre"] = "Mostra Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostra le scorciatoie da tastiera nell'icona in basso a sinistra"
L["aoe"] = "Attacchi a Bersaglio Multiplo"
L["AOE"] = "AdE"
L["Apparence"] = "Apparenza"
--Translation missing 
-- L["arcane_mage_burn_phase"] = ""
--Translation missing 
-- L["Artifact traits"] = ""
L["Aura lag"] = "Aura lag"
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Sangue"
L["buff"] = "Benefici"
L["Cacher bouton vide"] = "Nascondi bottoni vuoti"
L["Cacher dans les véhicules"] = "Nascondi nei veicoli"
L["Cacher la fenêtre"] = "Nascondi Ovale"
L["Cacher si cible amicale ou morte"] = "Nascondi se il bersaglio e' amico o morto"
L["Caractère de portée"] = "Indicatori distanza"
L["cd"] = [=[Abilita' con cooldown lungo.
Lanciare quando possibile o mantenere per moltiplicare i danni un specifiche fasi.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Questo testo e' mostrato sull'icona per mostrare se il bersaglio e' nel raggio d'azione"
L["Click to select the script."] = "Clicca per selezionare lo script."
L["Cliquer pour afficher/cacher les options"] = "Premere per nascondere/mostrare le opzioni"
L["Code"] = "Codice"
--Translation missing 
-- L["Colors"] = ""
L["Copier sur Script personnalisé"] = "Copia in script personalizzato"
L["Correction de la latence"] = "Correzione Latenza"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "Debug aura"
L["Debug compile"] = "Debug compilazione"
L["Debug enemies"] = "Debug nemici"
L["Debug GUID"] = "Debug GUID"
L["Debug missing spells"] = "Debug instantesimi mancanti"
L["Debug unknown spells"] = "Debug Incantesimi sconosciuti"
L["Décalage horizontal des options"] = "Opzioni spostamento orizzontare"
L["Décalage vertical des options"] = "Opzioni spostamento verticale"
L["Défilement"] = "Scorrimento"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "Sovrascrivere lo script personalizzato esistente ?"
L["En combat uniquement"] = "Mostra solo in combattimento"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "Mostra luminosità"
L["Flash size"] = "Mostra grandezza"
L["Flash spells"] = "Mostra incantesimi"
--Translation missing 
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
--Translation missing 
-- L["Flash threshold"] = ""
L["Focus"] = "Focus"
L["Groupe d'icônes"] = "Gruppo d'Icone"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "Icona"
L["Ignorer les clics souris"] = "Ignora pressioni mouse"
L["Illuminer l'icône"] = "Evidenzia icona"
L["Illuminer l'icône quand la technique doit être spammée"] = "Evidenzia icona quando l'abilita' dovrebbe essere spammata"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Illumina l'icona quando l'abilita' e' pronta"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "Interrompi"
L["Interrupts"] = "Interrompi"
L["Inverser la boîte à cocher "] = "Inverti spunta"
L["La taille des icônes"] = "La scala dell'icona"
L["La taille des petites icônes"] = "La scala dell'icona piccola"
L["La taille des polices"] = "La scala del carattere"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Lag (in millisecondi) tra quando un incantesimo è lanciato e quando l'aura d'effetto è applicata o rimossa"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Scorri le icone"
L["Long cooldown abilities"] = "Abilita' con cooldown lungo"
L["main"] = "Attacco Principale"
L["Main attack"] = "Attacco Principale"
L["mana"] = "Guadagno Mana"
L["Marge entre deux icônes"] = "Margine tra le icone"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "in movimento"
L["multidot"] = "Danni a Tempo su bersagli multipli"
L["None"] = "Nessuno"
L["not_in_melee_range"] = "non in mischia"
L["offgcd"] = [=[Abilita' fuori dal Cooldown globale.
Da lanciare assieme agli attacchi principali.]=]
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacita' icone"
L["Opacité des options"] = "Opzioni di opacita'"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "Opzioni"
--Translation missing 
-- L["Output"] = ""
--Translation missing 
-- L["Overrides"] = ""
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "predizione"
L["Prédictif"] = "Due abilita'"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Scorciatoie da tastiera"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "Click-Destro per opzioni."
L["Script"] = "Script"
--Translation missing 
-- L["Script défaut"] = ""
L["Script personnalisé"] = "Script Personalizzato"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "Recupero corto"
L["shortcd"] = "recupero corto"
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "Mostra nascosti"
L["Show minimap icon"] = "Mostra icona minimappa"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "mostra aspetta"
L["Si cible uniquement"] = "Se si ha un bersaglio"
--Translation missing 
-- L["SimulationCraft Profile"] = ""
--Translation missing 
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "evoca pet"
L["Taille des icônes"] = "Scala icone"
L["Taille des petites icônes"] = "Scala piccole icone"
L["Taille des polices"] = "Scala caratteri"
L["Taille du second icône"] = "Dimensione seconda icona"
--Translation missing 
-- L["Talents"] = ""
--Translation missing 
-- L["The contents of a SimulationCraft profile."] = ""
--Translation missing 
-- L["The script translated from the SimulationCraft profile."] = ""
--Translation missing 
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Blocca Posizione"
L["Vertical"] = "Verticale"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "Visibilità"

elseif locale == "koKR" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "숫자 표시"
L["Affiche le temps de recharge sous forme numérique"] = "숫자 형태로 남은 시간을 표시합니다."
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "두번째 능력을 표시합니다."
L["Afficher la fenêtre"] = "Ovale 표시"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "아이콘 좌측 하단 코너에 단축키를 표시합니다."
L["aoe"] = "다중 대상 공격"
L["AOE"] = "AOE"
L["Apparence"] = "외형"
--Translation missing 
-- L["arcane_mage_burn_phase"] = ""
--Translation missing 
-- L["Artifact traits"] = ""
--Translation missing 
-- L["Aura lag"] = ""
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Blood"
L["buff"] = "버프"
L["Cacher bouton vide"] = "빈 버튼 숨김"
L["Cacher dans les véhicules"] = "차량 탑승시 숨김"
L["Cacher la fenêtre"] = "Ovale 숨김"
L["Cacher si cible amicale ou morte"] = "우호적 대상이나 죽은 대상 선택시 숨김"
L["Caractère de portée"] = "범위 지시기"
L["cd"] = [=[긴 재사용 대기시간 능력입니다.
Cast as soon as possible or keep for multiplied damage phases.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "이 문자는 대상이 범위에 있을때 아이콘에 표시됩니다."
--Translation missing 
-- L["Click to select the script."] = ""
L["Cliquer pour afficher/cacher les options"] = "클릭시 옵션 숨김/표시"
L["Code"] = "코드"
--Translation missing 
-- L["Colors"] = ""
--Translation missing 
-- L["Copier sur Script personnalisé"] = ""
L["Correction de la latence"] = "대기시간 수정"
--Translation missing 
-- L["Debug"] = ""
--Translation missing 
-- L["Debug aura"] = ""
--Translation missing 
-- L["Debug compile"] = ""
--Translation missing 
-- L["Debug enemies"] = ""
--Translation missing 
-- L["Debug GUID"] = ""
--Translation missing 
-- L["Debug missing spells"] = ""
--Translation missing 
-- L["Debug unknown spells"] = ""
L["Décalage horizontal des options"] = "가로 간격"
L["Décalage vertical des options"] = "세로 간격"
L["Défilement"] = "스크룰"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
--Translation missing 
-- L["Ecraser le Script personnalisé préexistant?"] = ""
L["En combat uniquement"] = "전투 상태일때만 표시"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "번쩍임 밝기"
L["Flash size"] = "번쩍임 크기"
L["Flash spells"] = "주문 번쩍임"
--Translation missing 
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
--Translation missing 
-- L["Flash threshold"] = ""
L["Focus"] = "주시 대상"
--Translation missing 
-- L["Groupe d'icônes"] = ""
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
--Translation missing 
-- L["Icône"] = ""
L["Ignorer les clics souris"] = "마우스 클릭 무시"
L["Illuminer l'icône"] = "아이콘 강조"
L["Illuminer l'icône quand la technique doit être spammée"] = "Hightlight icon when ability should be spammed"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "능력이 준비되면 아이콘을 반짝입니다."
--Translation missing 
-- L["Input"] = ""
--Translation missing 
-- L["interrupt"] = ""
--Translation missing 
-- L["Interrupts"] = ""
L["Inverser la boîte à cocher "] = "체크 박스 토글"
L["La taille des icônes"] = "아이콘 크기"
L["La taille des petites icônes"] = "작은 아이콘의 크기를 설정합니다."
L["La taille des polices"] = "폰크 크기"
--Translation missing 
-- L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = ""
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "아이콘 스크룰"
L["Long cooldown abilities"] = "긴 재사용 대기시간 능력입니다"
L["main"] = "Main Attack"
--Translation missing 
-- L["Main attack"] = ""
L["mana"] = "마나 획득"
L["Marge entre deux icônes"] = "아이콘 간격"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
--Translation missing 
-- L["moving"] = ""
L["multidot"] = "Damage Over Time on multiple targets"
L["None"] = "None"
--Translation missing 
-- L["not_in_melee_range"] = ""
L["offgcd"] = [=[전역 재사용 대기시간 능력입니다.
Cast alongside your Main Attack.]=]
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "아이콘 투명도"
L["Opacité des options"] = "투명도 옵션을 설정합니다."
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
--Translation missing 
-- L["Options"] = ""
--Translation missing 
-- L["Output"] = ""
--Translation missing 
-- L["Overrides"] = ""
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
--Translation missing 
-- L["predict"] = ""
L["Prédictif"] = "두번째 능력"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "키보드 단축키"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
--Translation missing 
-- L["Right-Click for options."] = ""
--Translation missing 
-- L["Script"] = ""
--Translation missing 
-- L["Script défaut"] = ""
--Translation missing 
-- L["Script personnalisé"] = ""
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
--Translation missing 
-- L["Short cooldown abilities"] = ""
--Translation missing 
-- L["shortcd"] = ""
--Translation missing 
-- L["Show"] = ""
--Translation missing 
-- L["Show hidden"] = ""
--Translation missing 
-- L["Show minimap icon"] = ""
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
--Translation missing 
-- L["showwait"] = ""
L["Si cible uniquement"] = "만약 대상이 있다면"
--Translation missing 
-- L["SimulationCraft Profile"] = ""
--Translation missing 
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
--Translation missing 
-- L["summon_pet"] = ""
L["Taille des icônes"] = "아이콘 크기"
L["Taille des petites icônes"] = "작은 아이콘 크기"
L["Taille des polices"] = "폰트 크기"
L["Taille du second icône"] = "두번째 아이콘 크기"
--Translation missing 
-- L["Talents"] = ""
--Translation missing 
-- L["The contents of a SimulationCraft profile."] = ""
--Translation missing 
-- L["The script translated from the SimulationCraft profile."] = ""
--Translation missing 
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "위치 잠금"
L["Vertical"] = "수직선"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
--Translation missing 
-- L["Visibilité"] = ""

elseif locale == "ptBR" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "Mostrar números"
L["Affiche le temps de recharge sous forme numérique"] = "Mostrar o tempo restante de forma numérica"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Mostrar duas habilidades e não apenas uma"
L["Afficher la fenêtre"] = "Mostrar Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Mostrar atalhos do teclado canto inferior esquerdo do ícone"
L["aoe"] = "Atacar alvos múltiplos"
L["AOE"] = "AOE"
L["Apparence"] = "Aparência"
--Translation missing 
-- L["arcane_mage_burn_phase"] = ""
--Translation missing 
-- L["Artifact traits"] = ""
--Translation missing 
-- L["Aura lag"] = ""
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Sangue"
L["buff"] = "Buffs"
L["Cacher bouton vide"] = "Esconder botões vazios"
L["Cacher dans les véhicules"] = "Esconder em veículos"
L["Cacher la fenêtre"] = "Esconder Ovale"
L["Cacher si cible amicale ou morte"] = "Esconder se o alvo for amigável ou morto"
L["Caractère de portée"] = "Indicador de alcance"
L["cd"] = [=[Habilidades de cooldown longo.
Use assim que possível ou espere por fases com dano maior.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Este texto é mostrado no ícone para apontar se o alvo está no alcance"
--Translation missing 
-- L["Click to select the script."] = ""
L["Cliquer pour afficher/cacher les options"] = "Clique para mostrar/esconder opções"
L["Code"] = "Código"
--Translation missing 
-- L["Colors"] = ""
--Translation missing 
-- L["Copier sur Script personnalisé"] = ""
L["Correction de la latence"] = "Correção de latência"
--Translation missing 
-- L["Debug"] = ""
--Translation missing 
-- L["Debug aura"] = ""
--Translation missing 
-- L["Debug compile"] = ""
--Translation missing 
-- L["Debug enemies"] = ""
--Translation missing 
-- L["Debug GUID"] = ""
--Translation missing 
-- L["Debug missing spells"] = ""
--Translation missing 
-- L["Debug unknown spells"] = ""
L["Décalage horizontal des options"] = "Opções de mudança horizontal"
L["Décalage vertical des options"] = "Opções de mduança vertical"
L["Défilement"] = "Rolagem"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
--Translation missing 
-- L["Ecraser le Script personnalisé préexistant?"] = ""
L["En combat uniquement"] = "Mostrar só em combate"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "Intensidade do brilho"
L["Flash size"] = "Tamanho do brilho"
L["Flash spells"] = "Brilho do feitiço"
--Translation missing 
-- L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = ""
--Translation missing 
-- L["Flash threshold"] = ""
L["Focus"] = "Foco"
--Translation missing 
-- L["Groupe d'icônes"] = ""
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
--Translation missing 
-- L["Icône"] = ""
L["Ignorer les clics souris"] = "Ignorar cliques do mouse"
L["Illuminer l'icône"] = "Iluminar ícone"
L["Illuminer l'icône quand la technique doit être spammée"] = "Iluminar ícone quando habilidade deverá ser spamada"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Iluminar ícone quando habilidade estiver pronta"
--Translation missing 
-- L["Input"] = ""
--Translation missing 
-- L["interrupt"] = ""
--Translation missing 
-- L["Interrupts"] = ""
L["Inverser la boîte à cocher "] = "Alternar checar caixa"
L["La taille des icônes"] = "Escala dos ícones"
L["La taille des petites icônes"] = "Escala dos ícones pequenos"
L["La taille des polices"] = "Escala da fonte"
--Translation missing 
-- L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = ""
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Rolar os ícones"
L["Long cooldown abilities"] = "Habilidades de cooldown longo"
L["main"] = "Ataque principal"
L["Main attack"] = "Ataque principal"
L["mana"] = "Ganho de mana"
L["Marge entre deux icônes"] = "Margem entre ícones"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
--Translation missing 
-- L["moving"] = ""
L["multidot"] = "Dano Através do Tempo em múltiplos alvos"
L["None"] = "Nenhum"
--Translation missing 
-- L["not_in_melee_range"] = ""
L["offgcd"] = [=[Habilidade fora do cooldown global.
Use junto do seu Ataque Principal.]=]
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "Opacidade dos ícones"
L["Opacité des options"] = "Opacidade das opções"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
--Translation missing 
-- L["Options"] = ""
--Translation missing 
-- L["Output"] = ""
--Translation missing 
-- L["Overrides"] = ""
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
--Translation missing 
-- L["predict"] = ""
L["Prédictif"] = "Duas habilidades"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Atalhos do teclado"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
--Translation missing 
-- L["Right-Click for options."] = ""
--Translation missing 
-- L["Script"] = ""
--Translation missing 
-- L["Script défaut"] = ""
--Translation missing 
-- L["Script personnalisé"] = ""
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
--Translation missing 
-- L["Short cooldown abilities"] = ""
--Translation missing 
-- L["shortcd"] = ""
--Translation missing 
-- L["Show"] = ""
--Translation missing 
-- L["Show hidden"] = ""
--Translation missing 
-- L["Show minimap icon"] = ""
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
--Translation missing 
-- L["showwait"] = ""
L["Si cible uniquement"] = "Se tiver alvo"
--Translation missing 
-- L["SimulationCraft Profile"] = ""
--Translation missing 
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
--Translation missing 
-- L["summon_pet"] = ""
L["Taille des icônes"] = "Escala do ícone"
L["Taille des petites icônes"] = "Escala do ícone pequeno"
L["Taille des polices"] = "Escala da fonte"
L["Taille du second icône"] = "Tamanho do segundo ícone"
--Translation missing 
-- L["Talents"] = ""
--Translation missing 
-- L["The contents of a SimulationCraft profile."] = ""
--Translation missing 
-- L["The script translated from the SimulationCraft profile."] = ""
--Translation missing 
-- L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = ""
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Travar posição"
L["Vertical"] = "Vertical"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
--Translation missing 
-- L["Visibilité"] = ""

elseif locale == "ruRU" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "Цифровой дисплей"
L["Affiche le temps de recharge sous forme numérique"] = "Показать отсчет времени в цифровой форме"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "Показать две способности вместо одной"
L["Afficher la fenêtre"] = "Показать Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "Показывать сочетания клавиш в левом нижнем углу"
L["aoe"] = "Атака нескольких противников. Адаптировано к полному количеству врагов."
L["AOE"] = "Приоритет при атаке нескольких противников"
L["Apparence"] = "Внешний вид"
L["arcane_mage_burn_phase"] = "Предложить действия для поджигания"
--Translation missing 
-- L["Artifact traits"] = ""
L["Aura lag"] = "Задержка ауры"
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "Кровь"
L["buff"] = "Баффы"
L["Cacher bouton vide"] = "Скрыть пустые кнопки"
L["Cacher dans les véhicules"] = "Скрывать на транспорте"
L["Cacher la fenêtre"] = "Скрыть Ovale"
L["Cacher si cible amicale ou morte"] = "Скрывать если союзник или цель мертва"
L["Caractère de portée"] = "Индикатор дистанции"
L["cd"] = [=[Способности с большим кулдауном (временем восстановления). 
Использовать сразу, как только возможно или придерживать для фаз повышенного урона.]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "Этот текст показывается на иконке если цель в радиусе досягаемости"
L["Click to select the script."] = "Клик для выбора скрипта"
L["Cliquer pour afficher/cacher les options"] = "Нажмите, чтобы скрыть/показать опции"
L["Code"] = "Код"
--Translation missing 
-- L["Colors"] = ""
L["Copier sur Script personnalisé"] = "Скопировать в Пользовательский скрипт"
L["Correction de la latence"] = "Коррекция задержки"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "Отслеживать управление аурами."
L["Debug compile"] = "Отслеживать компиляцию скрипта."
L["Debug enemies"] = "Отслеживать появление противников."
L["Debug GUID"] = "Отслеживать изменения в парах UnitID/GUID."
L["Debug missing spells"] = "Предупреждать, если используется ID заклинания отсутствующего в книге заклинаний"
L["Debug unknown spells"] = "Предупреждать о неизвестном ID заклинания в скрипте."
L["Décalage horizontal des options"] = "Горизонтальное смещение опций"
L["Décalage vertical des options"] = "Вертикальное смещение опций"
L["Défilement"] = "Прокрутка (Скроллинг)"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "Перезаписать существующий Пользовательский скрипт?"
L["En combat uniquement"] = "Показывать только в бою"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "Яркость подсветки"
L["Flash size"] = "Размер подсветки"
L["Flash spells"] = "Подсветка умения"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "Подсвечивать способности, на панели умений, когда они готовы. Требуется SpellFlashCore"
L["Flash threshold"] = "Преддверие вспышкой"
L["Focus"] = "Фокус"
L["Groupe d'icônes"] = "Группа иконок"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "Иконка"
L["Ignorer les clics souris"] = "Игнорировать клики мыши"
L["Illuminer l'icône"] = "Подсветка иконок"
L["Illuminer l'icône quand la technique doit être spammée"] = "Подсвечивать иконки когда способность должна \"спамиться\""
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "Мигать когда способность готова"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "Прерывания"
L["Interrupts"] = "Прерывания"
L["Inverser la boîte à cocher "] = "Переключить флажок"
L["La taille des icônes"] = "Размер иконок"
L["La taille des petites icônes"] = "Размер маленьких иконок"
L["La taille des polices"] = "Размер шрифта"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "Задержка (в милисекундах) между произнесением заклинания и применением/пропаданием ауры"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "Переместить иконки"
L["Long cooldown abilities"] = "Способности с большим кулдауном"
L["main"] = "Основная атака"
L["Main attack"] = "Основная атака"
L["mana"] = "Мана (очки маны)"
L["Marge entre deux icônes"] = "Расстояние между иконками"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "Атаки, используемые при движении"
L["multidot"] = "ДОТы на нескольких целях"
L["None"] = "Нет"
L["not_in_melee_range"] = "Вне радиуса ближней атаки"
L["offgcd"] = [=[Не участвуют в глобальном КД.
Активируются вне зависимости от Ваших атак.
]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "Считать мобов как врагов, только если они напрямую пострадали от способностей игрока."
L["Only count tagged enemies"] = "Считать только помеченные цели."
L["Opacité des icônes"] = "Прозрачность иконок"
L["Opacité des options"] = "Прозрачность настроек"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "Опции"
--Translation missing 
-- L["Output"] = ""
L["Overrides"] = "Перезаписанные"
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "Следующая не \"заполняющая\" атака."
L["Prédictif"] = "Две способности"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "Горячие клавиши"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "Правая кнопка для настроек"
L["Script"] = "Скрипт"
L["Script défaut"] = "Скрипт по умолчанию"
L["Script personnalisé"] = "Пользовательский скрипт"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "Способности с малым временем восстановления"
L["shortcd"] = [=[Способности с малым временем восстановления.
Используются так часто, как только возможно.]=]
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "показать скрытые скрипты"
L["Show minimap icon"] = "Показать иконку на миникарте"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "Показывать иконку ожидания"
L["Si cible uniquement"] = "Если выбрана цель"
L["SimulationCraft Profile"] = "Профайл SimulationCraft"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "Код скрипта вставляется сразу после выражения Include() для перезаписи стандартных определений, например  |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "Призвать питомца."
L["Taille des icônes"] = "Размер иконки"
L["Taille des petites icônes"] = "Масштаб маленькой иконки"
L["Taille des polices"] = "Размер шрифта"
L["Taille du second icône"] = "Размер второй иконки"
--Translation missing 
-- L["Talents"] = ""
L["The contents of a SimulationCraft profile."] = "Содержимре профайла SimulationCraft"
L["The script translated from the SimulationCraft profile."] = "Преобразованный скрипт из профайла SimulationCraft"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "Время (в миллисекундах) за которое, до готовности, способность подсветится."
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "Блокировка позиции"
L["Vertical"] = "Вертикально"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "Показывать"

elseif locale == "zhCN" then
--Translation missing 
-- L["Action bar"] = ""
L["Affichage numérique"] = "数字显示"
L["Affiche le temps de recharge sous forme numérique"] = "用数字显示剩余时间"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "显示下2个需要释放的技能而不仅是1个"
L["Afficher la fenêtre"] = "显示Ovale"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "在图标左下角显示快捷键"
L["aoe"] = "多目标攻击"
L["AOE"] = "AOE输出循环"
L["Apparence"] = "环境"
--Translation missing 
-- L["arcane_mage_burn_phase"] = ""
--Translation missing 
-- L["Artifact traits"] = ""
L["Aura lag"] = "触发与移除效果延迟"
--Translation missing 
-- L["Auras (player)"] = ""
--Translation missing 
-- L["Auras (target)"] = ""
--Translation missing 
-- L["Auras on the player"] = ""
--Translation missing 
-- L["Auras on the target"] = ""
L["Blood"] = "鲜血"
L["buff"] = "增益"
L["Cacher bouton vide"] = "隐藏空按钮的背景"
L["Cacher dans les véhicules"] = "使用载具时隐藏"
L["Cacher la fenêtre"] = "隐藏Ovale"
L["Cacher si cible amicale ou morte"] = "当目标是友方或已死亡时隐藏"
L["Caractère de portée"] = "距离显示"
L["cd"] = [=[长CD的爆发技能与物品。
卡CD使用或在boss增伤阶段使用。]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "显示在技能图标上的符号以检测与目标的距离"
L["Click to select the script."] = "点击以选取脚本"
L["Cliquer pour afficher/cacher les options"] = "点击来隐藏/显示选项"
L["Code"] = "代码"
--Translation missing 
-- L["Colors"] = ""
L["Copier sur Script personnalisé"] = "复制到自定义脚本"
L["Correction de la latence"] = "延迟修正"
--Translation missing 
-- L["Debug"] = ""
L["Debug aura"] = "追踪光环管理."
L["Debug compile"] = "追踪已编译脚本."
L["Debug enemies"] = "追踪敌人侦测."
L["Debug GUID"] = "追踪UnitID/GUID配对变化."
L["Debug missing spells"] = "使用的已知法术ID在法术书中无法找到时提醒."
L["Debug unknown spells"] = "脚本中使用了未知的法术ID时提醒."
L["Décalage horizontal des options"] = "选项水平移位"
L["Décalage vertical des options"] = "选项垂直移位"
L["Défilement"] = "滑动动画显示下一个技能"
--Translation missing 
-- L["Disabled"] = ""
--Translation missing 
-- L["Display refresh statistics"] = ""
L["Ecraser le Script personnalisé préexistant?"] = "覆盖已存在的自定义脚本?"
L["En combat uniquement"] = "仅在战斗中显示"
--Translation missing 
-- L["Enable debugging messages for the %s module."] = ""
--Translation missing 
-- L["Enable profiling for the %s module."] = ""
--Translation missing 
-- L["Enabled"] = ""
L["Flash brightness"] = "闪光亮度"
L["Flash size"] = "闪光尺寸"
L["Flash spells"] = "法术闪光"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "当技能冷却结束时显示闪光效果。需要插件SpellFLashCore"
L["Flash threshold"] = "闪光阈值"
L["Focus"] = "焦点"
L["Groupe d'icônes"] = "图标分组"
--Translation missing 
-- L["Horizontal offset"] = ""
--Translation missing 
-- L["Horizontal offset from the center of the screen."] = ""
L["Icône"] = "图标"
L["Ignorer les clics souris"] = "忽略鼠标点击"
L["Illuminer l'icône"] = "高亮显示图标"
L["Illuminer l'icône quand la technique doit être spammée"] = "当技能应重复使用时高亮显示图标"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "技能就绪时闪烁图标"
--Translation missing 
-- L["Input"] = ""
L["interrupt"] = "打断施法"
L["Interrupts"] = "打断施法"
L["Inverser la boîte à cocher "] = "开启/关闭选择框"
L["La taille des icônes"] = "图标大小"
L["La taille des petites icônes"] = "小型图标大小"
L["La taille des polices"] = "字体大小"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "释放一个技能与其触发/移除效果之间的延迟"
--Translation missing 
-- L["Layout"] = ""
L["Les icônes se déplacent"] = "滚动图标"
L["Long cooldown abilities"] = "长CD的技能与物品"
L["main"] = "主要攻击技能"
L["Main attack"] = "主要攻击技能"
L["mana"] = "法力获取"
L["Marge entre deux icônes"] = "图标间距"
--Translation missing 
-- L["Middle-Click to toggle the script options panel."] = ""
--Translation missing 
-- L["Modules"] = ""
L["moving"] = "移动中使用攻击"
L["multidot"] = "多目标持续伤害"
L["None"] = "无"
L["not_in_melee_range"] = "脱离近战范围"
L["offgcd"] = [=[无公共冷却的技能与物品
可以在你使用主攻技能的同时使用。]=]
--Translation missing 
-- L["Only count a mob as an enemy if it is directly affected by a player's spells."] = ""
--Translation missing 
-- L["Only count tagged enemies"] = ""
L["Opacité des icônes"] = "图标透明度"
L["Opacité des options"] = "选项透明度"
--Translation missing 
-- L["Open configuration panel in a separate, movable window."] = ""
L["Options"] = "选项"
--Translation missing 
-- L["Output"] = ""
--Translation missing 
-- L["Overrides"] = ""
--Translation missing 
-- L["Ping for Ovale users in group"] = ""
--Translation missing 
-- L["Power"] = ""
L["predict"] = "下一个非填充性技能。"
L["Prédictif"] = "两个技能"
--Translation missing 
-- L["Profiling"] = ""
L["Raccourcis clavier"] = "快捷键"
--Translation missing 
-- L["Reset"] = ""
--Translation missing 
-- L["Reset the profiling statistics."] = ""
L["Right-Click for options."] = "右键点击打开选项"
L["Script"] = "脚本"
L["Script défaut"] = "默认脚本"
L["Script personnalisé"] = "自定义脚本"
--Translation missing 
-- L["Shift-Right-Click for the current trace log."] = ""
L["Short cooldown abilities"] = "短CD技能"
L["shortcd"] = [=[短CD技能.
卡CD使用]=]
--Translation missing 
-- L["Show"] = ""
L["Show hidden"] = "显示隐藏的脚本"
L["Show minimap icon"] = "在小地图上显示图标"
--Translation missing 
-- L["Show the profiling statistics."] = ""
--Translation missing 
-- L["Show Trace Log"] = ""
--Translation missing 
-- L["Show version number"] = ""
L["showwait"] = "显示等待图标"
L["Si cible uniquement"] = "当目标存在时"
--Translation missing 
-- L["SimulationCraft Profile"] = ""
--Translation missing 
-- L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = ""
--Translation missing 
-- L["Spellbook"] = ""
--Translation missing 
-- L["Stances"] = ""
--Translation missing 
-- L["Standalone options"] = ""
L["summon_pet"] = "召唤宠物。"
L["Taille des icônes"] = "图标大小"
L["Taille des petites icônes"] = "小型图标大小"
L["Taille des polices"] = "字体大小"
L["Taille du second icône"] = "第二图标大小"
--Translation missing 
-- L["Talents"] = ""
--Translation missing 
-- L["The contents of a SimulationCraft profile."] = ""
--Translation missing 
-- L["The script translated from the SimulationCraft profile."] = ""
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "在技能冷却时间结束之前开始闪光的提前量（毫秒）"
--Translation missing 
-- L["Top 3"] = ""
--Translation missing 
-- L["Trace"] = ""
--Translation missing 
-- L["Trace Log"] = ""
--Translation missing 
-- L["Trace the next frame update."] = ""
L["Verrouiller position"] = "锁定位置"
L["Vertical"] = "垂直"
--Translation missing 
-- L["Vertical offset"] = ""
--Translation missing 
-- L["Vertical offset from the center of the screen."] = ""
L["Visibilité"] = "可见设置"

elseif locale == "zhTW" then
L["Action bar"] = "快捷列"
L["Affichage numérique"] = "顯示數字"
L["Affiche le temps de recharge sous forme numérique"] = "技能剩餘時間以數字顯示"
L["Affiche les deux prochains sorts et pas uniquement le suivant"] = "顯示兩組技能圖示"
L["Afficher la fenêtre"] = "顯示輸出助手"
L["Afficher les raccourcis clavier dans le coin inférieur gauche des icônes"] = "顯示快捷列左下角的超出距離提醒圖示"
L["aoe"] = [=[AOE 範圍攻擊
根據敵人的總數來選擇。]=]
L["AOE"] = "AOE 範圍攻擊"
L["Apparence"] = "外觀"
L["arcane_mage_burn_phase"] = "奧法暴衝階段"
L["Artifact traits"] = "神兵武器特長"
L["Aura lag"] = "增益/減益效果延遲"
L["Auras (player)"] = "光環 (玩家)"
L["Auras (target)"] = "光環 (目標)"
L["Auras on the player"] = "玩家身上的光環"
L["Auras on the target"] = "目標身上的光環"
L["Blood"] = "血量"
L["buff"] = "提示能施放的增益法術"
L["Cacher bouton vide"] = "隱藏空的按鈕"
L["Cacher dans les véhicules"] = "使用載具時隱藏"
L["Cacher la fenêtre"] = "隱藏輸出助手"
L["Cacher si cible amicale ou morte"] = "隱藏友好或已死亡的目標"
L["Caractère de portée"] = "範圍提醒"
L["cd"] = [=[冷卻時間長的技能 (大招)
盡快施放，或在爆發期使用。]=]
L["Ce caractère est affiché dans un coin de l'icône pour indiquer si la cible est à portée"] = "自訂一段文字，如果目標是在範圍內，這段文字會在圖示上顯示提醒你。"
L["Click to select the script."] = "左鍵選擇腳本。"
L["Cliquer pour afficher/cacher les options"] = "左鍵點擊 隱藏/顯示選項"
L["Code"] = "程式碼"
L["Colors"] = "顏色"
L["Copier sur Script personnalisé"] = "複製到自訂腳本"
L["Correction de la latence"] = "延遲校正"
L["Debug"] = "除錯"
L["Debug aura"] = "追蹤光環管理。"
L["Debug compile"] = "追蹤已編譯腳本。"
L["Debug enemies"] = "追蹤敵人偵測。"
L["Debug GUID"] = "追蹤UnitID/GUID配對變化。"
L["Debug missing spells"] = "使用的已知法術ID在法術書中無法找到時提醒。"
L["Debug unknown spells"] = "腳本中使用了未知法術ID時提醒。"
L["Décalage horizontal des options"] = "水平移動框架"
L["Décalage vertical des options"] = "垂直移動框架"
L["Défilement"] = "滾動圖示"
L["Disabled"] = "停用"
L["Display refresh statistics"] = "顯示刷新統計"
L["Ecraser le Script personnalisé préexistant?"] = "是否要覆寫已有的自訂腳本?"
L["En combat uniquement"] = "只在戰鬥中顯示"
L["Enable debugging messages for the %s module."] = "啟用 %s 模組的除錯訊息。"
L["Enable profiling for the %s module."] = "啟用 %s 模組的描述檔。"
L["Enabled"] = "啟用"
L["Flash brightness"] = "閃爍亮度"
L["Flash size"] = "閃爍尺寸"
L["Flash spells"] = "法術閃爍"
L["Flash spells on action bars when they are ready to be cast. Requires SpellFlashCore"] = "法術技能可以施放時，閃爍快捷列中的圖示。需要 SpellFlashCore 插件。"
L["Flash threshold"] = "閃爍條件"
L["Focus"] = "專注目標"
L["Groupe d'icônes"] = "圖示群組"
L["Horizontal offset"] = "水平位置"
L["Horizontal offset from the center of the screen."] = "距離畫面正中央的水平方向移動距離。"
L["Icône"] = "圖示"
L["Ignorer les clics souris"] = "忽略滑鼠點擊"
L["Illuminer l'icône"] = "顯著標示圖示"
L["Illuminer l'icône quand la technique doit être spammée"] = "技能應該大量使用時顯著標示技能圖示"
L["Illuminer l'icône quand le temps de recharge est écoulé"] = "技能可用時閃爍圖示"
L["Input"] = "輸入"
L["interrupt"] = "斷法技能"
L["Interrupts"] = "斷法技能"
L["Inverser la boîte à cocher "] = "勾選或取消核取方塊"
L["La taille des icônes"] = "調整圖示大小"
L["La taille des petites icônes"] = "調整小圖示大小"
L["La taille des polices"] = "調整字體大小"
L["Lag (in milliseconds) between when an spell is cast and when the affected aura is applied or removed"] = "法術施放後和受到光環影響之間的延遲時間 (毫秒)"
L["Layout"] = "版面配置"
L["Les icônes se déplacent"] = "圖示以滾動方式顯示"
L["Long cooldown abilities"] = "冷卻時間長的大招"
L["main"] = "主要攻擊"
L["Main attack"] = "主要攻擊"
L["mana"] = "獲得法力"
L["Marge entre deux icônes"] = "圖示間距"
L["Middle-Click to toggle the script options panel."] = "中鍵切換腳本選項面板。"
L["Modules"] = "模組"
L["moving"] = "移動時可使用的攻擊技能"
L["multidot"] = "對多個目標的持續性傷害 DOT"
L["None"] = "無"
L["not_in_melee_range"] = "超出近戰範圍指示"
L["offgcd"] = [=[不受共用冷卻時間影響的技能
和主要攻擊技能一起施放。]=]
L["Only count a mob as an enemy if it is directly affected by a player's spells."] = "計算直接受到玩家法術影響的敵人。"
L["Only count tagged enemies"] = "只有直接受影響的敵人"
L["Opacité des icônes"] = "圖示透明度"
L["Opacité des options"] = "選項透明度"
L["Open configuration panel in a separate, movable window."] = "選項設定面板開啟為可以移動的獨立視窗。"
L["Options"] = "選項"
L["Output"] = "輸出"
L["Overrides"] = "覆寫"
L["Ping for Ovale users in group"] = "隊伍中其他玩家的輸出助手版本"
L["Power"] = "能量"
L["predict"] = "下一個非填補攻擊。"
L["Prédictif"] = "預測"
L["Profiling"] = "描述檔"
L["Raccourcis clavier"] = "顯示快捷鍵"
L["Reset"] = "重置"
L["Reset the profiling statistics."] = "重置描述檔統計。"
L["Right-Click for options."] = "右鍵開啟選項。"
L["Script"] = "腳本"
L["Script défaut"] = "預設腳本"
L["Script personnalisé"] = "自訂腳本"
L["Shift-Right-Click for the current trace log."] = "Shift+右鍵顯示目前追蹤記錄。"
L["Short cooldown abilities"] = "冷卻時間短的技能"
L["shortcd"] = [=[冷卻時間短的技能
儘快施放，或卡GCD、無招可放時使用。]=]
L["Show"] = "顯示"
L["Show hidden"] = "顯示隱藏的腳本"
L["Show minimap icon"] = "顯示小地圖按鈕"
L["Show the profiling statistics."] = "顯示描述檔統計。"
L["Show Trace Log"] = "顯示追蹤記錄"
L["Show version number"] = "顯示版本編號"
L["showwait"] = "顯示等待圖示"
L["Si cible uniquement"] = "有目標才顯示"
L["SimulationCraft Profile"] = "SimulationCraft 設定檔"
L["SIMULATIONCRAFT_OVERRIDES_DESCRIPTION"] = "緊接在 Include() 之後的程式碼會覆寫標準定義，例如 |cFFFFFF00SpellInfo(tigers_fury tag=main)|r"
L["Spellbook"] = "法術書"
L["Stances"] = "姿勢形態"
L["Standalone options"] = "獨立設定視窗"
L["summon_pet"] = "召喚寵物。"
L["Taille des icônes"] = "圖示大小"
L["Taille des petites icônes"] = "小圖示大小"
L["Taille des polices"] = "字體大小"
L["Taille du second icône"] = "第二圖示大小"
L["Talents"] = "天賦"
L["The contents of a SimulationCraft profile."] = "SimulationCraft 設定檔內容。"
L["The script translated from the SimulationCraft profile."] = "依據 SimulationCraft 設定檔轉譯的腳本。"
L["Time (in milliseconds) to begin flashing the spell to use before it is ready."] = "法術能夠使用前，多久開始閃爍 (毫秒)"
L["Top 3"] = "Top 3"
L["Trace"] = "追蹤"
L["Trace Log"] = "追蹤記錄"
L["Trace the next frame update."] = "追蹤下一個畫面更新。"
L["Verrouiller position"] = "鎖定圖示位置"
L["Vertical"] = "垂直圖示"
L["Vertical offset"] = "垂直位置"
L["Vertical offset from the center of the screen."] = "距離畫面正中央的垂直方向移動距離。"
L["Visibilité"] = "顯示"

end
