﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using IMLibrary.Controls;
using IMLibrary.Controls.ListBoxex;

using Ourmsg.FileTransmit;
using Ourmsg.Enum;
using IMLibrary.Security;
using IMLibrary.Controls.ExControls;
using P;
using OurMsg.Controls;

namespace OurMsg
{
    public partial class FormTalkRoom :FormEx //   Form // 
    {
        public FormTalkRoom()
        {
            InitializeComponent();

            #region 初始化其他
            panelMessage1.CreateMsgAfter += (s, e) => OnCreateMsgAfter(e);
            ButClose.Click += (s, e) => this.Close();
            ButSend.Click += (s, e) => panelMessage1.SendMsg();

            tsButChat.Click += (s, e) =>
            {
                tsButChat.Enabled = false;
                tsButFiles.Enabled = true;
                panelChat.Visible=true;
                panelFiles.Visible = false;
            };
            tsButFiles.Click += (s, e) =>
            {
                tsButChat.Enabled = true;
                tsButFiles.Enabled = false;
                panelChat.Visible =false ;
                panelFiles.Visible = true;
            };
            tsButSet.Click += (s, e) =>
            {
                Global.ShowFormSetRoom(RoomID);
            };
            listBoxUser.DoubleClick += (s, e) =>
             {
                 var item = listBoxUser.SelectedItem as ListBoxExItem;
                 if (item != null)
                 {
                     Global.ShowTalkForm((item.Tag as RoomUser));
                 }
             };
            #endregion
        }
  
        #region 属性
        /// <summary>
        /// 当前用户名
        /// </summary>
        public UInt32 RoomID
        {
            get;
            set;
        }
        /// <summary>
        /// 当前用户名
        /// </summary>
        public string UserName
        {
            set { panelMessage1.UserName = value; }
            get { return panelMessage1.UserName; }
        }
        /// <summary>
        /// 当前用户ID
        /// </summary>
        public UInt32  UserID
        {
            set { panelMessage1.UserID = value; }
            get { return panelMessage1.UserID; }
        }
        /// <summary>
        /// 最高允许加入群的人数
        /// </summary>
        private int MaxUsersCount = 0;
        #endregion

        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="Msg">要发送的消息</param>
        public delegate void CreateMsgEventHandler(object sender, Element Msg);
        /// <summary>
        /// 
        /// </summary>
        public event CreateMsgEventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        private void OnCreateMsgAfter(Element msg)
        {
            msg.RoomID = RoomID;
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, msg);
        }
        #endregion

        #region 更新自定义图片
        /// <summary>
        /// 更新自定义图片
        /// </summary>
        /// <param name="MD5"></param>
        /// <param name="image"></param>
        public void UpdateImage(string MD5, Image image)
        {
            this.panelMessage1.UpdateImage(MD5, image);
        }
        #endregion

        #region 添加消息到RichTextBox
        /// <summary>
        /// 添加消息到RichTextBox
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="title"></param>
        public void AddMsg(P.Message msg)
        {
            this.panelMessage1.MsgToRichTextBox(msg);
        }
        #endregion

        #region 窗口加载事件
        private void FormTalkRoom_Load(object sender, EventArgs e)
        {
            this.ToolStrip1.FormBackColor = this.BackColor;
            panelMessage1.Focus();
        }
        #endregion

        #region 设置群信息
        /// <summary>
        /// 设置群信息
        /// </summary>
        /// <param name="user"></param>
        public void SetRoomInfo(RoomBaseInfo r)
        {
            if (r.Notice != null)
                textBoxNotice.Text = r.Notice;
            MaxUsersCount = r.MaxUsersCount;
            this.Text = string.Format("与  {0}({1})  群聊天", r.RoomName , r.RoomID);
            setUserCountInfo();
        }
        #endregion

        #region 添加用户到群
        /// <summary>
        /// 添加用户到群
        /// </summary>
        /// <param name="user"></param>
        public void addUser(RoomUser user)
        {
            foreach (ListBoxExItem it in listBoxUser.Items)
                if ((it.Tag as RoomUser).UserID == user.UserID)
                    return;

            string name = user.UserCard;

            if (name == null || name == string.Empty)
                name = user.UserName;

            if (name == null || name == string.Empty)
                name = user.UserID.ToString();

            var item = new ListBoxExItem(name);

            if (Global.IsRoomCreater(RoomID, user.UserID))
                item.ManagerImage = imageList1.Images[0];
            else if (user.Admin )
                item.ManagerImage = imageList1.Images[0];

            item.Image = Global.GetHeadImage(user.HeadID, ImageSize.P24X24);
            item.Tag = user;
            listBoxUser.Items.Add(item);
            setUserCountInfo();
        }
        #endregion

        #region 删除群用户
        /// <summary>
        /// 删除群用户
        /// </summary>
        /// <param name="userID"></param>
        public void DelUser(UInt32 userID)
        {
            foreach (ListBoxExItem item in listBoxUser.Items)
                if ((item.Tag as RoomUser).UserID == userID)
                {
                    listBoxUser.Items.Remove(item);
                    setUserCountInfo();
                    return;
                }
        }
        #endregion

        #region 设置群成员信息
        private void setUserCountInfo()
        {
            outlookPanelEx2.HeaderText = string.Format("群成员({0}/{1})", listBoxUser.Items.Count, MaxUsersCount);
        }
        #endregion 

        #region 设置群管理员
        /// <summary>
        /// 设置群管理员
        /// </summary>
        /// <param name="userID"></param>
        /// <param name="isManager"></param>
        public void SetManager(UInt32 userID,bool isManager)
        {
            foreach (ListBoxExItem item in listBoxUser.Items)
                if ((item.Tag as RoomUser).UserID == userID)
                {
                    if (isManager)
                        item.ManagerImage = imageList1.Images[0];
                    else
                        item.ManagerImage = null;
                    listBoxUser.Invalidate();
                    setUserCountInfo();
                    return;
                }
        }
        #endregion

        #region 设置群用户名片
        /// <summary>
        /// 设置群用户名片
        /// </summary>
        /// <param name="userID"></param>
        /// <param name="isManager"></param>
        public void SetUserCard(UInt32 userID, string  userCard)
        { 
            foreach (ListBoxExItem item in listBoxUser.Items)
                if ((item.Tag as RoomUser).UserID == userID)
                { 
                    string name = userCard;
                    RoomUser ru = Global.GetRoomUser(RoomID,userID);
                    if (ru == null) return;
                    if (name == null || name == string.Empty)
                        name = ru.UserName;
                    if (name == null || name == string.Empty)
                        name = ru.UserID.ToString();
                    item.Text = name;
                    listBoxUser.Invalidate(); 
                    return;
                }
        }
        #endregion

        #region 设置群基本信息
        /// <summary>
        /// 设置群基本信息
        /// </summary>
        /// <param name="roomBaseInfo"></param>
        public void SetRoomBaseInfo(RoomBaseInfo roomBaseInfo)
        {
            this.Text = string.Format("与群 {0}({1}) 聊天",roomBaseInfo.RoomName,RoomID);
            this.textBoxNotice.Text = roomBaseInfo.Notice;
        }
        #endregion

        #region 添加系统消息
        /// <summary>
        /// 添加系统消息
        /// </summary>
        /// <param name="msg"></param>
        public void AddSystemMsg(string msg)
        {
            this.panelMessage1.AddSystemMessage(msg);
        }
        #endregion

    }
}
