﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Ourmsg.Enum;

using P;
namespace OurMsg
{
    public partial class FormQuery : Form
    {
        public FormQuery()
        {
            InitializeComponent();
            cmdFindRooms.Click += new System.EventHandler(cmdFindRooms_Click);
            cmdFindUsers.Click += new System.EventHandler(cmdFindUsers_Click);
            ListViewUsers.MouseMove += new MouseEventHandler(ListViewUsers_MouseMove);
            listViewRooms.MouseMove += new MouseEventHandler(listViewRooms_MouseMove);

            tsButAddRoom.Click += new System.EventHandler(tsButAddRoom_Click);
            tsButAddFriend.Click += new System.EventHandler(tsButAddFriend_Click);
            tsButShowUserCard.Click += new System.EventHandler(tsButShowUserCard_Click);
            tsButShowRoomCard.Click += new System.EventHandler(tsButShowRoomCard_Click);
        }
         
        #region 字段
        /// <summary>
        /// 查询结果用户总页数
        /// </summary>
        public int UsersPageCount
        { get; set; }
        /// <summary>
        /// 查询结果群总页数
        /// </summary>
        public int RoomsPageCount
        { get; set; }
        /// <summary>
        /// 选中群
        /// </summary>
        ListViewItem SelectItemRoom;
        /// <summary>
        /// 选中用户
        /// </summary>
        ListViewItem SelectItemUser;
        /// <summary>
        /// 当前选中的群
        /// </summary>
        QueryRoom SelectRoom;
        /// <summary>
        /// 当前选中的用户
        /// </summary>
        QueryUser SelectUser;
        /// <summary>
        /// 查询用户
        /// </summary>
        Query qUser = new Query();
        /// <summary>
        /// 查询群
        /// </summary>
        Query qRoom = new Query();
        /// <summary>
        /// 是否返回查询用户结果
        /// </summary>
        bool isReturnQueryUsers = false;
        /// <summary>
        /// 是否返回查询群结果
        /// </summary>
        bool isReturnQueryRooms = false;
        /// <summary>
        /// 查询用户等待时间
        /// </summary>
        int QueryUsersCount = 0;
        /// <summary>
        /// 查询群等待时间
        /// </summary>
        int QueryRoomsCount = 0;
        #endregion
         
        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="Msg">要发送的消息</param>
        public delegate void EventHandler(object sender, Query Msg);
        /// <summary>
        /// 创建消息事件
        /// </summary>
        public event EventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        private void OnCreateMsgAfter(Query msg)
        {
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, msg);
        }
        #endregion

        #region 查询用户
        void cmdFindUsers_Click(object sender, EventArgs e)
        {
            ListViewUsers.Items.Clear();

            qUser.QueryClass = QueryClass.User;

            qUser.NameOrID = textBoxUserName.Text.Trim();

            if (cBoxSex.SelectedIndex == 0)
                qUser.Sex = QuerySex.None;
            else if (cBoxSex.SelectedIndex == 1)
                qUser.Sex = QuerySex.Male;
            else if (cBoxSex.SelectedIndex == 2)
                qUser.Sex = QuerySex.Female;

            if (cBoxAge.SelectedIndex == 0)
                qUser.Age = QueryAge.None;
            else if (cBoxAge.SelectedIndex == 1)
                qUser.Age = QueryAge.Old_17;
            else if (cBoxAge.SelectedIndex == 2)
                qUser.Age = QueryAge.Old18_22;
            else if (cBoxAge.SelectedIndex == 3)
                qUser.Age = QueryAge.Old23_30;
            else if (cBoxAge.SelectedIndex == 4)
                qUser.Age = QueryAge.Old31_40;
            else if (cBoxAge.SelectedIndex == 5)
                qUser.Age = QueryAge.Old41;

            if (checkBoxOnline.Checked)
                qUser.ShowType = true;
            else
                qUser.ShowType = false;

            qUser.PageIndex = 0;//将查询页面索引初始为0
            UsersPageCount = 0;
             
            OnCreateMsgAfter(qUser);

            isReturnQueryUsers = false;
            cmdFindUsers.Enabled = false;
            timerQueryUsers.Enabled = true;

        }
        #endregion 

        #region 查询群
        void cmdFindRooms_Click(object sender, EventArgs e)
        {
            listViewRooms.Items.Clear();

            qRoom.QueryClass = QueryClass.Room;
            qRoom.NameOrID = textBoxRoomName.Text.Trim();
            qRoom.PageIndex = 0;//将查询页面索引初始为0
            RoomsPageCount = 0;

            OnCreateMsgAfter(qRoom);

            isReturnQueryRooms = false;
            cmdFindRooms.Enabled = false;
            timerQueryRoom.Enabled = true;
        }
        #endregion 
         
        #region 添加查询到的用户
        /// <summary>
        /// 添加查询到的用户
        /// </summary>
        /// <param name="qus"></param>
        public void AddQueryUsers(List<QueryUser> qus)
        {
            isReturnQueryUsers = true;

            foreach (QueryUser qu in qus)
            {
                if (imageListUsers.Images[qu.HeadID.ToString()] == null)
                    imageListUsers.Images.Add(qu.HeadID.ToString(), Global.GetHeadImage(qu.HeadID, ImageSize.P20X20));

                ListViewItem item = new ListViewItem(qu.UserName);
                item.ImageKey = qu.HeadID.ToString();

                ListViewItem.ListViewSubItem sub1 = new ListViewItem.ListViewSubItem();
                sub1.Text = qu.UserID.ToString();
                item.SubItems.Add(sub1);

                ListViewItem.ListViewSubItem sub2 = new ListViewItem.ListViewSubItem();
                sub2.Text = "男";
                if (qu.Sex) sub2.Text = "女";
                item.SubItems.Add(sub2);

                ListViewItem.ListViewSubItem sub3 = new ListViewItem.ListViewSubItem();
                sub3.Text = qu.Age.ToString();
                item.SubItems.Add(sub3);

                ListViewItem.ListViewSubItem sub4 = new ListViewItem.ListViewSubItem();
                sub4.Text = "离线";
                if (qu.ShowType > 0) sub4.Text = "在线";
                item.SubItems.Add(sub4);

                item.Tag = qu;
                ListViewUsers.Items.Add(item);
            }
        }
        #endregion

        #region 添加查询到的群
        /// <summary>
        /// 添加查询到的群
        /// </summary>
        /// <param name="qus"></param>
        public void AddQueryRoos(List<QueryRoom> qrs)
        {
            isReturnQueryRooms = true;

            foreach (QueryRoom qr in qrs)
            {
                ListViewItem item = new ListViewItem(qr.RoomName);
                item.ImageIndex = 0;

                ListViewItem.ListViewSubItem sub1 = new ListViewItem.ListViewSubItem();
                sub1.Text = qr.RoomID.ToString();
                item.SubItems.Add(sub1);

                ListViewItem.ListViewSubItem sub2 = new ListViewItem.ListViewSubItem();
                sub2.Text = string.Format("{0}/{1}", qr.UsersCount, qr.MaxUsersCount);
                item.SubItems.Add(sub2);
                 
                item.Tag = qr;
                listViewRooms.Items.Add(item);
            }
        }
        #endregion

        #region FormQuery_Load
        private void FormQuery_Load(object sender, EventArgs e)
        {
            cBoxAge.SelectedIndex = 0;
            cBoxSex.SelectedIndex = 0;
        }
        #endregion

        #region listViewRooms_MouseMove
        void listViewRooms_MouseMove(object sender, MouseEventArgs e)
        {
            SelectItemRoom = listViewRooms.GetItemAt(e.X, e.Y) as ListViewItem; 
            if (SelectItemRoom == null)
            {
                panelLineRoom.Visible = false;
                ToolStripRoom.Visible = false;
                SelectRoom = null;
                return;
            }

            SelectRoom = (SelectItemRoom.Tag as QueryRoom);
            if (Global.GetRoom(SelectRoom.RoomID) == null && SelectRoom.AddCondition != (byte) AddCondition.RefuseALL)
                tsButAddRoom.Visible = true;
            else
                tsButAddRoom.Visible = false;

            ToolStripRoom.Left = listViewRooms.Left + SelectItemRoom.Bounds.Width;
            ToolStripRoom.Top = listViewRooms.Top + SelectItemRoom.Position.Y;
            ToolStripRoom.Visible = true;


            panelLineRoom.Visible = true;
            panelLineRoom.Left = listViewRooms.Left;
            panelLineRoom.Width = SelectItemRoom.Bounds.Width;
            panelLineRoom.Top = listViewRooms.Top + SelectItemRoom.Position.Y + SelectItemRoom.Bounds.Height;
        }
        #endregion

        #region ListViewUsers_MouseMove

        void ListViewUsers_MouseMove(object sender, MouseEventArgs e)
        {
            SelectItemUser = ListViewUsers.GetItemAt(e.X, e.Y) as ListViewItem;
            if (SelectItemUser == null)
            {
                panelLineUser.Visible = false;
                ToolStripUser.Visible = false;
                SelectUser = null;
                return;
            }


            SelectUser = (SelectItemUser.Tag as QueryUser);
            if (Global.GetUser(SelectUser.UserID) == null && SelectUser.AddCondition != (byte) AddCondition.RefuseALL)
                tsButAddFriend.Visible = true;
            else
                tsButAddFriend.Visible = false;

            ToolStripUser.Left = ListViewUsers.Left + SelectItemUser.Bounds.Width;
            ToolStripUser.Top = ListViewUsers.Top + SelectItemUser.Position.Y;
            ToolStripUser.Visible = true;

            panelLineUser.Left = ListViewUsers.Left;
            panelLineUser.Width = SelectItemUser.Bounds.Width;
            panelLineUser.Top = ListViewUsers.Top + SelectItemUser.Position.Y + SelectItemUser.Bounds.Height;
            panelLineUser.Visible = true;

        }
        #endregion




        void tsButShowRoomCard_Click(object sender, EventArgs e)
        {
            
        }

        void tsButShowUserCard_Click(object sender, EventArgs e)
        {
             
        }

        void tsButAddFriend_Click(object sender, EventArgs e)
        {
            if (SelectUser == null) return;
            if (SelectUser.AddCondition == (byte)AddCondition.RefuseALL)
                Global.ShowMessage("对方拒绝任何人添加为好友！");
            else
            {
                var f = Global.GetAddFriendFrm(SelectUser.UserID);
                if (f == null)
                {
                    f = new FormAddFriendorRoom(SelectUser);
                    Global.AddFriendFrms.Add(f);
                    f.FormClosed += (s1, e1) => { Global.AddFriendFrms.Remove(f); };
                }
                f.Show(); f.Activate();
            }
        }

        void tsButAddRoom_Click(object sender, EventArgs e)
        {
            if (SelectRoom == null) return;
            if (SelectRoom.AddCondition == (byte)AddCondition.RefuseALL)
                Global.ShowMessage("对方拒绝任何人加入群！");
            else  
            {
                var f = Global.GetAddRoomFrm(SelectRoom.RoomID);
                if (f == null)
                {
                    f = new FormAddFriendorRoom(SelectRoom);
                    Global.AddRoomFrms.Add(f);
                    f.FormClosed += (s1, e1) => { Global.AddRoomFrms.Remove(f); };
                }
                f.Show(); f.Activate();
            }
        }

       
        private void timerQueryUsers_Tick(object sender, EventArgs e)
        {
            if (isReturnQueryUsers || QueryUsersCount>40)
            {
                timerQueryUsers.Enabled = false;
                cmdFindUsers.Enabled = true;
                QueryUsersCount=0;
            }
            QueryUsersCount++;
        }

        private void timerQueryRoom_Tick(object sender, EventArgs e)
        {
            if (isReturnQueryRooms || QueryRoomsCount > 40)
            {
                timerQueryRoom.Enabled = false;
                cmdFindRooms.Enabled = true;
                QueryRoomsCount = 0;
            }
            QueryRoomsCount++;
        }

 
    }
}
