﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using Ourmsg.Enum;


namespace OurMsg
{
    public partial class FormCreateUser : Form
    {
        #region 头像信息类
        /// <summary>
        /// 头像信息类
        /// </summary>
        class HeadInfo
        {
            /// <summary>
            /// 索引
            /// </summary>
            public Int32 index
            { get; set; }
            /// <summary>
            /// 图像
            /// </summary>
            public Image image
            { get; set; }
        }
        #endregion

        #region 构造函数
        public FormCreateUser()
        {
            InitializeComponent();
            //自绘组合框需要设置的一些属性 
            cBoxHead.DrawMode = DrawMode.OwnerDrawFixed;
            cBoxHead.DropDownStyle = ComboBoxStyle.DropDownList;
            cBoxHead.ItemHeight = 50;
            cBoxHead.Width =80; 
            cBoxHead.DrawItem +=  cBoxHead_DrawItem ;

            for (int i = 0; i < 150; i++)
                cBoxAge.Items.Add(i);
            cBoxAge.SelectedIndex = 20;
            cBoxSex.SelectedIndex = 0;

            linkLabelRegister.Click +=  linkLabelRegister_Click ;
        }
        #endregion

        #region 字段
        /// <summary>
        /// 
        /// </summary>
        int waitCount = 0;
        /// <summary>
        /// 标识是否本次创建群是否收到服务器响应
        /// </summary>
        public bool IsReturn = false;
        /// <summary>
        /// 注册成功的用户ID
        /// </summary>
        public UInt32 UserID;
        #endregion

        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="r">要发送的消息</param>
        public delegate void CreateMsgEventHandler(object sender, P.UserRegister r);
        /// <summary>
        /// 
        /// </summary>
        public event CreateMsgEventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="r"></param>
        private void OnCreateMsgAfter(P.UserRegister r)
        {
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, r);
        }
        #endregion

        #region 注册事件
        void linkLabelRegister_Click(object sender, EventArgs e)
        {
            if (TextBoxUserName.Text.Trim() == string.Empty)
            {
                Global.ShowMessage("用户昵称必须填写！");
                TextBoxUserName.Focus();
                return;
            }
            if (TextBoxPassword.Text.Length < 6)
            {
                Global.ShowMessage("密码必须在6个字符以上！");
                TextBoxPassword.Focus();
                return;
            }
            if (TextBoxCheckPassword.Text.Length < 6)
            {
                Global.ShowMessage("校验密码必须在6个字符以上！");
                TextBoxCheckPassword.Focus();
                return;
            }
            if (TextBoxCheckPassword.Text != TextBoxPassword.Text)
            {
                Global.ShowMessage("两次密码输入不一致，请重新输入！");
                TextBoxCheckPassword.Focus();
                return;
            }

            if (!checkBoxAgree.Checked)
            {
                Global.ShowMessage("您必须同意以上使用协议才能注册新用户！"); return;
            }

            panelRemark.Visible = false;

            panelState.Dock = DockStyle.Fill;
            panelState.Visible = true;
            loadingCircle1.Active = true;


            P.UserRegister r = new P.UserRegister();
            r.UserName = TextBoxUserName.Text.Trim();
            r.Password = TextBoxPassword.Text;
            r.HeadID = (cBoxHead.SelectedItem as HeadInfo).index;
            r.Sex =(byte) cBoxSex.SelectedIndex;
            r.Age = (byte)cBoxAge.SelectedIndex;
            r.AddCondition =  AddCondition.AllowAll;
            if (radioAddCondition2.Checked)
                r.AddCondition = AddCondition.NeedAuditing;
            else if (radioAddCondition3.Checked)
                r.AddCondition = AddCondition.RefuseALL;
            OnCreateMsgAfter(r);

            this.UseWaitCursor = true;
            this.timer1.Enabled = true;

        }
        #endregion

        #region 绘制头像图片
        void cBoxHead_DrawItem(object sender, DrawItemEventArgs e)
        {
            //鼠标选中在这个项上 
            if ((e.State & DrawItemState.Selected) != 0)
            {
                //渐变画刷 
                LinearGradientBrush brush = new LinearGradientBrush(e.Bounds, Color.FromArgb(255, 251, 237),
                                                 Color.FromArgb(255, 236, 181), LinearGradientMode.Vertical);
                //填充区域 
                Rectangle borderRect = new Rectangle(3, e.Bounds.Y, e.Bounds.Width - 5, e.Bounds.Height - 2);

                e.Graphics.FillRectangle(brush, borderRect);

                //画边框 
                Pen pen = new Pen(Color.FromArgb(229, 195, 101));
                e.Graphics.DrawRectangle(pen, borderRect);
            }
            else
            {
                SolidBrush brush = new SolidBrush(Color.FromArgb(255, 255, 255));
                e.Graphics.FillRectangle(brush, e.Bounds);
            }
            if (e.Index == -1) return;

            //获得项图片,绘制图片 
            HeadInfo item = (HeadInfo)cBoxHead.Items[e.Index];
            Image img = item.image;

            //图片绘制的区域 
            Rectangle imgRect = new Rectangle(6, e.Bounds.Y + 3, 45, 45);
            e.Graphics.DrawImage(img, imgRect);

            #region 
            //文本内容显示区域 
            //Rectangle textRect =
            //        new Rectangle(imgRect.Right + 2, imgRect.Y, e.Bounds.Width - imgRect.Width, e.Bounds.Height - 2);

            ////获得项文本内容,绘制文本 
            //String itemText = cBoxHead.Items[e.Index].ToString();

            ////文本格式垂直居中 
            //StringFormat strFormat = new StringFormat();
            //strFormat.LineAlignment = StringAlignment.Center;
            //e.Graphics.DrawString(itemText, new Font("微软雅黑", 12), Brushes.Black, textRect, strFormat); 
            #endregion
        }
        #endregion

        #region 加载所有系统头像
        /// <summary>
        /// 加载所有系统头像
        /// </summary>
        private void LoadHeadImage()
        {
            ///初始化表情
            for (int i = 1; i <= 138; i++)
            {
                try
                {
                    string fileNamePath = @"head\" + i.ToString() + ".bmp";
                    HeadInfo hi = new HeadInfo();
                    hi.index = i;
                    hi.image =System.Drawing.Image.FromFile(fileNamePath);
                    cBoxHead.Items.Add(hi);
                }
                catch { }
            } 
        }
        #endregion

        #region 窗口加载事件
        private void FormCreateUser_Load(object sender, EventArgs e)
        {
            LoadHeadImage();//加载所有系统头像

            //默认选中项索引 
            if (cBoxHead.Items.Count > 0)
                cBoxHead.SelectedIndex = 0;

        }
        #endregion

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (IsReturn)
            {
                timer1.Enabled = false;
                if (UserID != 0)
                    Global.ShowMessage("注册用户成功，请记住用户帐号：" + UserID);
                else
                    Global.ShowMessage("注册用户失败,原因可能是服务器忙!");
                this.Close();
                this.Dispose();
            }
            waitCount++;

            if (waitCount > 8)
            {
                timer1.Enabled = false;
                Global.ShowMessage("注册用户失败,服务器忙,请稍候再试!");
                waitCount = 0;
                this.Close();
                this.Dispose();
            }
        }
    }
}
