﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using IMLibrary.Controls.ExControls;
using IMLibrary.Controls;
using Ourmsg.Enum;

namespace OurMsg
{
    public partial class FormCreateRoom : FormEx 
    {
        public FormCreateRoom()
        {
            InitializeComponent();
            this.panelState.Dock = DockStyle.Fill;
            radioAddCondition1.CheckedChanged += radioAddCondition_CheckedChanged;
            radioAddCondition2.CheckedChanged += radioAddCondition_CheckedChanged;
            radioAddCondition3.CheckedChanged += radioAddCondition_CheckedChanged;
        }

        void radioAddCondition_CheckedChanged(object sender, EventArgs e)
        {
            if (radioAddCondition1.Checked)
                AddCondition = AddCondition.AllowAll;
            else if (radioAddCondition2.Checked)
                AddCondition =  AddCondition.NeedAuditing;
            else if (radioAddCondition3.Checked)
                AddCondition = AddCondition.RefuseALL;
        }

        /// <summary>
        /// 加群条件(0为允许任何人，1为管理员审核，2为不允许任何人加群)
        /// </summary>
         AddCondition  AddCondition =  AddCondition.NeedAuditing ;

        int waitCount = 0;

        /// <summary>
        /// 标识是否本次创建群是否收到服务器响应
        /// </summary>
        public bool IsReturn = false;
        /// <summary>
        /// 服务器所返回创建的群帐号(若为0表示创建失败，失败原因可能是用户创建的群数已达到其权限创建群的最大数）
        /// </summary>
        public UInt32 RoomID = 0;
 
        private void FormCreateRoom_Load(object sender, EventArgs e)
        {
            this.StartPosition = FormStartPosition.CenterScreen;
            this.inviteFriendAddRoom1.LoadUsers();
        }

        private void ButClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void ButSend_Click(object sender, EventArgs e)
        {
            if (textBoxRoomName.Text.Trim() == string.Empty)
            {
                Global.ShowMessage("请输入群名称");
                textBoxRoomName.Focus();
                return;
            }

            var r = new P.RoomBaseInfo ();
            r.RoomName = textBoxRoomName.Text.Trim();
            r.Notice = textBoxNotice.Text;
            r.Remark = textBoxRemark.Text;
            r.InviteUsers = inviteFriendAddRoom1.GetUsersID();
            r.AddCondition =(byte) AddCondition;

            Global.MsgClient.CreateRoom(r);//创建群
             
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
            this.outlookPanelEx1.Visible = false;
            this.outlookPanelEx2.Visible = false;
            this.panelButon.Visible = false;
            this.panelState.Visible = true;
            this.loadingCircle1.Active = true;
             
            timer1.Enabled = true;

            this.UseWaitCursor = true; 
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (IsReturn)
            {
                timer1.Enabled = false;
                if (RoomID != 0)
                    Global.ShowMessage("群创建成功！创建群号：" + RoomID);
                else
                    Global.ShowMessage("群创建失败,原因可能是系统允许您创建的群数已达上限 或 服务器忙!" );
                this.Close();
            }
            waitCount++;

            if (waitCount > 18)//10秒钟的等待时间
            {
                timer1.Enabled = false;
                Global.ShowMessage("群创建失败,服务器忙,请稍候再试!");
                waitCount = 0;
                this.Close();
            }
        }

    }
}
