﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using IMLibrary.Controls.ExControls;
using Ourmsg.Enum;
using P;

namespace OurMsg
{
    public partial class FormAddFriendorRoom : Form // FormEx 
    {
        #region 构造函数
        public FormAddFriendorRoom(QueryUser qu)
        {
            InitializeComponent();

            queryUser = qu;

            this.Text = "添加好友";

            this.labelUserID.Text ="ID： "+ qu.UserID.ToString();
            this.labelUserName.Text = qu.UserName;
            if (qu.Sex)
                this.labelSex.Text = "性别： 女";
            else 
                this.labelSex.Text = "性别： 男";

            this.labelAge.Text ="年龄： "+ qu.Age.ToString();
            this.pictureBoxHead.Image = Global.GetHeadImage(qu.HeadID, ImageSize.P32X32);
            ID = qu.UserID;
             
            if (qu.AddCondition == (byte)AddCondition.NeedAuditing)
            {
                panelCheckInfo.Visible = true;
            }
            else if (qu.AddCondition == (byte)AddCondition.AllowAll)
            {
                panelGroup.Visible = true;
            }

            cBoxGroup.Items.Add("我的好友");

            foreach (var group in Global.Groups.Values) 
                    cBoxGroup.Items.Add(group.GroupName);

            if (cBoxGroup.Items.Count > 0)
                cBoxGroup.SelectedIndex = 0;

        } 

        public FormAddFriendorRoom(QueryRoom qr)
        {
            InitializeComponent();
            queryRoom  = qr;
            IsRoom = true;

            this.Text = "添加群";

            this.labelUserID.Text = "ID： " + qr.RoomID.ToString();
            this.labelUserName.Text =qr.RoomName ;
            this.labelSex.Text =string.Format( "群成员数： {0}/{1}" ,qr.UsersCount,qr.MaxUsersCount);
            this.labelAge.Text = "说明： ";

            ID = qr.RoomID ;
            cBoxGroup.Items.Add("我的群");

            foreach (var group in Global.RoomGroups.Values) 
                cBoxGroup.Items.Add(group.GroupName);
            if (cBoxGroup.Items.Count > 0)
                cBoxGroup.SelectedIndex = 0;

            if (qr.AddCondition == (byte)AddCondition.NeedAuditing)
            {
                panelCheckInfo.Visible = true;
            }
            else if (qr.AddCondition == (byte)AddCondition.AllowAll)
            {
                panelGroup.Visible = true;
            }

        }
        #endregion

        #region 字段
        /// <summary>
        /// 群或好友帐号  
        /// </summary>
        public UInt32  ID = 0;
        /// <summary>
        /// 当前是添加群
        /// </summary>
        public bool IsRoom = false;
        /// <summary>
        /// 
        /// </summary>
        QueryUser queryUser = null;
        /// <summary>
        /// 
        /// </summary>
        QueryRoom queryRoom = null;
        #endregion

        #region 窗口加载
        private void FormAddFriend_Load(object sender, EventArgs e)
        {
            TextBoxAttach.Focus();
        }
        #endregion

        #region 关闭按键
        private void ButClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        #endregion
         
        #region 添加分组 
        private void linkLabelNewGroup_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (IsRoom)
            {
                Global.ShowAddRoomGroupForm(this); 
            }
            else
            {
                Global.ShowAddUserGroupForm(this);
            }
        }
         
        /// <summary>
        /// 添加分组列表
        /// </summary>
        /// <param name="GroupID"></param>
        /// <param name="GroupName"></param>
        public void AddGroup(int GroupID, string GroupName)
        {
            cBoxGroup.Items.Add(GroupName);
            cBoxGroup.SelectedIndex = cBoxGroup.Items.Count - 1;
        } 
        #endregion

        #region 下一步
        private void ButNext_Click(object sender, EventArgs e)
        {
            ButNext.Visible = false;
            panelCheckInfo.Visible = false;
            panelGroup.Visible = false;
            panelOver.Visible = true;

            if (IsRoom)
            {
                int groupID = 0;
                var g = Global.GetRoomGroup(cBoxGroup.Text);
                if (g != null)
                    groupID = g.GroupID;
                else
                    groupID = -1;
                Global.MsgClient.RequestAddRoom(queryRoom.RoomID, queryRoom.RoomName, groupID, this.TextBoxAttach.Text.Trim());
            }
            else
            {
                int groupID = 0;
                var g = Global.GetGroup(cBoxGroup.Text);
                if (g != null)
                    groupID = g.GroupID;
                else
                    groupID = -1;
                Global.MsgClient.RequestAddFriend(queryUser.UserID, this.textBoxRemark.Text.Trim(), groupID, this.TextBoxAttach.Text.Trim());
            }

        }
        #endregion
         
    }
}
