﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms; 

using Ourmsg .Enum;
using IMLibrary.Net.Enum;
using IMLibrary.AV;
using P;

namespace OurMsg.Controls
{
    public partial class videoControlV1 : UserControl
    {
        public videoControlV1(string serverIP, int port, bool isServer = false)
        {
            InitializeComponent();
            AVComponent = new AVComponent(serverIP, port, isServer);
            AVComponent.ServerRegistered += (s, e) =>
                {
                    OnServerRegistered(e.ServerID);
                };
            AVComponent.Connected += (s, e) =>
                {
                    if (AVComponent.ConnectionType == ConnectionType.UDPDirect)
                        this.label1.Text = "已建立UDP直接！";
                    else if (AVComponent.ConnectionType == ConnectionType.UDPTurn)
                        this.label1.Text = "已建立UDP中转连接！"; 
                };
            AVComponent.iniAV(this.picLocal, this.picRemote);
            if (!isServer)
                linkLabelRec.Visible = false;
            else
                linkLabelRec.Visible = true;
        }
         
        /// <summary>
        /// 
        /// </summary>
        AVComponent AVComponent = null;

        #region 事件
        /// <summary>
        /// 获得IPEndPoint事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="local">本地主机信息</param>
        /// <param name="remote">远程主机信息</param>
        public delegate void EventHandler(object sender, AVMsg e);
        public event EventHandler ServerRegistered;
        private void OnServerRegistered(long hostID)
        {
            if (ServerRegistered != null)
            {
                AVMsg av = new AVMsg(OprationType.Set);
                av.RemoteHostID = hostID;
                ServerRegistered(this, av);//触发获取本机主机事件
            }
        }

        /// <summary>
        /// 取消事件
        /// </summary>
        public event EventHandler Cancel;
        private void OnCancel()
        {
            if (Cancel != null)
            {
                AVMsg av = new AVMsg(OprationType.Cancel);
                Cancel(this, av);
            }
        }
        #endregion
         
        private void linkLabelCancel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CancelVideo();
            OnCancel();
        }

        private void linkLabelRec_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            linkLabelRec.Visible = false;
            AVComponent.Start();
        }

        /// <summary>
        /// 请求NAT穿越，实现P2P连接
        /// </summary>
        /// <param name="hostID"></param>
        public void RequestNATIntroduction(long hostID)
        {
            if (!AVComponent.IsStartServer)
                AVComponent.Start();
            AVComponent.RequestNATIntroduction(hostID);
        }

        /// <summary>
        /// 取消视频
        /// </summary>
        public void CancelVideo()
        {
            AVComponent.CancelAV();
        }
    }
}
