﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Windows.Forms;

using  P;
using Ourmsg.Enum;
using IMLibrary.Controls.Toolbox;


namespace OurMsg
{
    #region 用户信息类
    /// <summary>
    /// 用户信息类 
    /// </summary>
    public class ExUser  
    {
         
        #region 事件
        /// <summary>
        /// 事件
        /// </summary>
        /// <param name="sender">产生事件的对象</param>
        public delegate void ChangedEventHandler(object sender,System.EventArgs e);
       
        /// <summary>
        /// 用户在线状态改变事件
        /// </summary>
        public event ChangedEventHandler ShowTypeChanged;
        /// <summary>
        /// 用户姓名更新事件
        /// </summary>
        public event ChangedEventHandler UserNameChanged;
        /// <summary>
        /// 用户部门更新事件
        /// </summary>
        public event ChangedEventHandler GroupIDChanged;
        /// <summary>
        /// 备注更新事件
        /// </summary>
        public event ChangedEventHandler RemarkNameChanged;
        /// <summary>
        /// 头像更新事件
        /// </summary>
        public event ChangedEventHandler HeadIDChanged;
        /// <summary>
        /// 自定义头像更新事件
        /// </summary>
        public event ChangedEventHandler IsCustomHeadChanged;
        /// <summary>
        /// 签名更新事件
        /// </summary>
        public event ChangedEventHandler SignatureChanged;
        #endregion
         
        private UInt32 _UserID =0;// 标识用户身分唯一的ID（暂用计算机名代替）
        /// <summary>
        /// 系统用户ID。 
        /// </summary>
        public UInt32 UserID
        {
            get { return _UserID; }
            set { _UserID = value; }
        }
        private string _UserName = "";
        /// <summary>
        /// 获取或设置用户姓名
        /// </summary>
        public string UserName
        {
            get { return _UserName; }
            set
            {
                _UserName = value;
                if (UserNameChanged != null)
                    UserNameChanged(this, null);
            }
        }

        private int _HeadID=0;
        /// <summary>
        /// 头像索引
        /// </summary>
        public int HeadID
        {
            get { return _HeadID; }
            set
            {
                if (_HeadID != value)
                {
                    _HeadID = value;
                    if (HeadIDChanged != null)
                        HeadIDChanged(this, null);
                }
            }
        }

        private bool _IsCustomHead = false;
        /// <summary>
        /// 是否自定义头像索引
        /// </summary>
        public bool IsCustomHead
        {
            get { return _IsCustomHead; }
            set
            {
                if (_IsCustomHead != value)
                {
                    _IsCustomHead = value;
                    if (IsCustomHeadChanged != null)
                        IsCustomHeadChanged(this, null);
                }
                ;
            }
        }

        string _Signature = string.Empty;
        /// <summary>
        /// 签名
        /// </summary>
        public string Signature
        {
            get { return _Signature; }
            set
            {
                if (_Signature != value)
                {
                    _Signature = value;
                    if (SignatureChanged != null)
                        SignatureChanged(this, null);
                } 
            }
        }

        string _RemarkName = string.Empty;
        /// <summary>
        /// 用户昵称
        /// </summary>
        public string RemarkName
        {
            get { return _RemarkName; }
            set
            {
                if (_RemarkName != value)
                {
                    _RemarkName = value;
                    if (RemarkNameChanged != null)
                        RemarkNameChanged(this, null);
                }
            }
        }


        private Int32 _GroupID = 0;
        /// <summary>
        /// 设置或获取用户所在部门的ID。 
        /// </summary>
        public Int32 GroupID
        {
            get { return _GroupID; }
            set
            {
                if (_GroupID != value)
                {
                    _GroupID = value;
                    if (GroupIDChanged != null)
                        GroupIDChanged(this, null);
                }
            }
        }

        private int _OrderID = 0;//用户所在部门的OrderID
        /// <summary>
        /// 设置或获取用户所在部门的ID。 
        /// </summary>
        public int OrderID
        {
            get { return _OrderID; }
            set
            {
                _OrderID = value;
            }
        }
        private ShowType _ShowType = ShowType.Offline;
        /// <summary>
        /// 获取或设置用户的在线状态。 
        /// </summary>
        public ShowType ShowType
        {
            get { return _ShowType; }
            set
            { 
                if (_ShowType != value)//如果状态改变，则触发事件
                {
                    _ShowType = value;
                    if (ShowTypeChanged != null)
                        ShowTypeChanged(this, null);
                    if (ToolboxItem != null)
                    {

                        if (value !=  ShowType.Offline && value !=  ShowType.Invisible)
                        {
                            if (!ToolboxItem.IsOnline)
                            {
                                ToolboxItem.IsOnline = true;

                                if (ToolboxItem.Owner != null)
                                {
                                    Toolbox.ItemCollection itemCollection = ToolboxItem.Owner.Items;
                                    int index = itemCollection.IndexOf(ToolboxItem);
                                    if (index > 0)
                                    {
                                        itemCollection.RemoveAt(index);
                                        itemCollection.Insert(0, ToolboxItem);
                                    }
                                }
                            }
                        }
                        else
                        {
                            if (ToolboxItem.IsOnline)
                            {
                                ToolboxItem.IsOnline = false;

                                if (ToolboxItem.Owner != null)
                                {
                                    Toolbox.ItemCollection itemCollection = ToolboxItem.Owner.Items;
                                    int index = itemCollection.IndexOf(ToolboxItem);
                                    if (index < itemCollection.Count - 1)
                                    {
                                        itemCollection.RemoveAt(index);
                                        itemCollection.Insert(itemCollection.Count, ToolboxItem);
                                    }
                                }
                            }
                        }
                            

                        switch  (value)
                        {   case  ShowType.away :
                                ToolboxItem.Status = IMLibrary.Controls.Toolbox.Enum.Status.away;
                                break;
                            case  ShowType.dnd:
                                ToolboxItem.Status = IMLibrary.Controls.Toolbox.Enum.Status.mute;
                                break;
                            case  ShowType.xa:
                                ToolboxItem.Status = IMLibrary.Controls.Toolbox.Enum.Status.busy;
                                break;
                            default :
                                ToolboxItem.Status = IMLibrary.Controls.Toolbox.Enum.Status.none;
                                break;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// Tag
        /// </summary>
        public object Tag = null; 
        /// <summary>
        /// 标识是否删除
        /// </summary>
        public bool IsDel = false;
        /// <summary>
        /// 在联系人控件列表中的项
        /// </summary>
        public Toolbox.Item ToolboxItem;
        /// <summary>
        /// 聊天窗体
        /// </summary>
        public FormTalkUser formTalk;
    }
    #endregion
}
