﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using IMLibrary.Controls.Toolbox;

namespace OurMsg
{
    /// <summary>
    /// 分组信息
    /// </summary>
    public class ExGroup
    { 
        #region 事件
        /// <summary>
        /// 事件
        /// </summary>
        /// <param name="sender">产生事件的对象</param>
        public delegate void ChangedEventHandler(object sender, System.EventArgs e);
        /// <summary>
        /// 上级分组改变事件
        /// </summary>
        public event ChangedEventHandler SupGroupIDChanged;
        /// <summary>
        /// 分组名更新事件
        /// </summary>
        public event ChangedEventHandler GroupNameChanged;
        /// <summary>
        /// 排序更新事件
        /// </summary>
        public event ChangedEventHandler OrderIDChanged;
        #endregion

        Int32 _GroupID = 0;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Int32 GroupID
        {
            get { return _GroupID; }
            set { _GroupID = value; }
        }
        Int32 _SupGroupID = 0;
        /// <summary>
        /// 上级分组ID
        /// </summary>
        public Int32 SupGroupID
        {
            get { return _SupGroupID; }
            set
            {
                _SupGroupID = value;
                if ( SupGroupIDChanged != null)
                    SupGroupIDChanged(this, null);
            }
        }
        string _GroupName = string.Empty;
        /// <summary>
        /// 分组名
        /// </summary>
        public string GroupName
        {
            get { return _GroupName; }
            set
            {
                _GroupName = value;
                if ( GroupNameChanged != null)
                    GroupNameChanged(this, null);
            }
        }
        Int32 _OrderID = 0;
        /// <summary>
        /// 排序序号
        /// </summary>
        public Int32 OrderID
        {
            get { return _OrderID; }
            set
            {
                _OrderID = value;
                if ( OrderIDChanged != null)
                    OrderIDChanged(this, null);
            }
        }
        /// <summary>
        /// 是否系统分组
        /// </summary>
        public bool IsSystem
        { get; set; }

        /// <summary>
        /// Tag
        /// </summary>
        public object Tag = null;
        /// <summary>
        /// 标识是否删除
        /// </summary>
        public bool IsDel = false; 
        /// <summary>
        /// 在联系人控件列表中的项
        /// </summary>
        public Toolbox.Tab ToolboxTab;


    }

}
