﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text; 

namespace P
{
    /// <summary>
    /// 用户状态信息
    /// </summary>
    public class UserInfo 
    {
        /// <summary>
        /// 用户名
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 用户密码
        /// </summary>
        public string Password { get; set; }
        /// <summary>
        /// 用户动态密码DynamicPassword
        /// （用于上传离线文件，图片等认证.每一次登录密码不一样）
        /// </summary>
        public string DynPassword { get; set; }
        /// <summary>
        /// 头像索引
        /// </summary>
        public Int32 HeadID { get; set; }
        /// <summary>
        /// 是否自定义头像索引
        /// </summary>
        public bool IsCustomHead { get; set; }
        /// <summary>
        /// 签名
        /// </summary>
        public string Signature { get; set; }
        /// <summary>
        /// 最后登录IP
        /// </summary>
        public string LastLoginIP { get; set; }
        /// <summary>
        /// 上次登录时间
        /// </summary>
        public string LastLoginTime { get; set; }
        /// <summary>
        /// 在线时长
        /// </summary>
        public Int64 OnlineTimeLength { get; set; }
        /// <summary>
        /// VIP等级
        /// </summary>
        public Int32 VIPLevel { get; set; }
        /// <summary>
        /// 系统等级
        /// </summary>
        public Int32 SystemLevel { get; set; }
        /// <summary>
        /// 加好友条件(0为允许任何人，1为需要审核，2为不允许任何人加好友)
        /// </summary>
        public byte AddCondition { get; set; }
        /// <summary>
        /// 是否系统用户
        /// </summary>
        public bool SysUser { get; set; }
        /// <summary>
        ///系统分组
        /// </summary>
        public int SysGroupID { get; set; }
    }
}
 
