﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace  P
{
    /// <summary>
    /// 查询分类
    /// </summary>
    public enum QueryClass:byte
    {
        /// <summary>
        /// 无操作
        /// </summary>
        None=0,
        /// <summary>
        /// 查询用户
        /// </summary>
        User=1,
        /// <summary>
        /// 查询群
        /// </summary>
        Room=2,
    }

    /// <summary>
    /// 查询性别
    /// </summary>
    public enum QuerySex
    {
        /// <summary>
        /// 无条件
        /// </summary>
        None=0,
        /// <summary>
        /// 男性
        /// </summary>
        Male=1,
        /// <summary>
        /// 女性
        /// </summary>
        Female=2,
    }

    /// <summary>
    /// 查询年龄
    /// </summary>
    public enum QueryAge
    {
        /// <summary>
        /// 无条件
        /// </summary>
        None = 0,
        /// <summary>
        /// 18岁以下
        /// </summary>
        Old_17 = 1,
        /// <summary>
        /// 18-22岁
        /// </summary>
        Old18_22 = 2,
        /// <summary>
        /// 23-30岁
        /// </summary>
        Old23_30 = 3,
        /// <summary>
        /// 31-40岁
        /// </summary>
        Old31_40 = 4,
        /// <summary>
        /// 41-岁以上 
        /// </summary>
        Old41 = 5,
    }

    /// <summary>
    /// 查询对像
    /// </summary>
    public class Query
    {
        /// <summary>
        /// 是否查询分类
        /// </summary>
        public QueryClass QueryClass
        { get; set; }
        /// <summary>
        /// 要查询的页面索引
        /// </summary>
        public int PageIndex
        { get; set; }
        /// <summary>
        /// 查询关键字（名称，帐号或手机、邮箱等）
        /// </summary>
        public string NameOrID
        { get; set; }

        /// <summary>
        /// 性别如果查询用户
        /// </summary>
        public QuerySex Sex
        { get; set; }
        /// <summary>
        /// 年龄
        /// </summary>
        public QueryAge Age
        { get; set; }
        /// <summary>
        /// 在线情况
        /// </summary>
        public bool ShowType
        { get; set; }
    }

    /// <summary>
    /// 查询结果
    /// </summary>
    public class QueryResult
    {
        /// <summary>
        /// 是否查询分类
        /// </summary>
        public QueryClass QueryClass
        { get; set; }
        /// <summary>
        /// 要查询的页面索引
        /// </summary>
        public int PageIndex
        { get; set; }
        /// <summary>
        /// 本次查询每一页数据条数
        /// </summary>
        public int PageSize
        { get; set; }
        /// <summary>
        /// 查询结果总页数
        /// </summary>
        public int PageCount
        { get; set; }

        List<object> _Results = new List<object>();
        /// <summary>
        /// 查询结果
        /// </summary>
        public List<object> Results
        {
            set { _Results = value; }
            get { return _Results; }
        }
    }


    /// <summary>
    /// 查询结果返回的用户信息
    /// </summary>
    public class QueryUser
    {
        /// <summary>
        /// 用户帐号
        /// </summary>
        public UInt32 UserID
        { get; set; }
        /// <summary>
        /// 用户名
        /// </summary>
        public string UserName
        { get; set; }
        /// <summary>
        /// 性别（true为女，false为男）
        /// </summary>
        public bool Sex
        { get; set; }
        /// <summary>
        /// 年龄
        /// </summary>
        public byte Age
        { get; set; }
        /// <summary>
        /// 头像索引
        /// </summary>
        public int HeadID  
        { get; set; }
        /// <summary>
        /// 在线状态(非0表示在线)
        /// </summary>
        public int ShowType
        { get; set; }
        /// <summary>
        /// 加好友条件(0为允许任何人，1为需要审核，2为不允许任何人加好友)
        /// </summary>
        public byte AddCondition
        { get; set; }
    }

     
    /// <summary>
    /// 查询结果返回的群信息
    /// </summary>
    public class QueryRoom
    {
        /// <summary>
        /// </summary>
        public UInt32 RoomID
        { get; set; }
        /// <summary>
        /// 群名
        /// </summary>
        public string RoomName
        { get; set; }
        /// <summary>
        /// 群用户数
        /// </summary>
        public int UsersCount
        { get; set; }
        /// <summary>
        /// 群用户数
        /// </summary>
        public int MaxUsersCount
        { get; set; } 
        /// <summary>
        /// 加群条件(0为允许任何人，1为需要审核，2为不允许任何人加好友)
        /// </summary>
        public byte AddCondition
        { get; set; }
    }


}
