﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LumiSoft.Net.TCP;

namespace Ourmsg.NetClient 
{
    /// <summary>
    /// TCP网络客户端
    /// </summary>
    public class TCPClient  
    { 
        exTCP_Client client =null ;

        public void Connect(string host, int port)
        {
            if (client == null || client.IsDisposed)
            {
                client = new exTCP_Client();
                client.PacketReceived += new exTCP_Client.PacketReceivedEventHandler(client_PacketReceived);
                client.Disonnected += new EventHandler(client_Disonnected);
                client.Connected += new EventHandler(client_Connected);
                
            }
            if (!client.IsConnected)
                client.Connect(host, port);
        }

        /// <summary>
        /// 发送数据到服务器
        /// </summary>
        /// <param name="data"></param>
        public void Send(byte[] data)
        {
            if (client != null && client.IsConnected)
            {
                client.TcpStream.WriteLine(data);
            }
        }

        /// <summary>
        /// 关闭套接字连接，并释放资源
        /// </summary>
        public void Disconnect()
        {
            if (client != null && client.IsConnected)
            {
                client.PacketReceived -= new exTCP_Client.PacketReceivedEventHandler(client_PacketReceived);
                client.Disonnected -= new EventHandler(client_Disonnected);
                client.Connected -= new EventHandler(client_Connected);
                client.Disconnect();
                client.Dispose();
            }
        }


        /// <summary>
        /// 关闭套接字并释放资源
        /// </summary>
        public void Dispose()
        {
            if (client != null && client.IsConnected)
            {
                client.Dispose();
            }
        }

        void client_Connected(object sender, EventArgs e)
        {
            IsConnected = true;
            if (Connected != null)
                Connected(this, null);
        }


        void client_Disonnected(object sender, EventArgs e)
        {
            IsConnected = false;
            if (Disonnected != null)
                Disonnected(this, null );
        }

        void client_PacketReceived(object sender, TcpSessionEventArgs e)
        {
            if (PacketReceived != null)
                PacketReceived(this, new TcpClientEventArgs(e.Data));
        }

        /// <summary>
        /// 是否连接
        /// </summary>
        public bool IsConnected
        { set; get; }


        #region 事件

        public delegate void TcpClientEventHandler(object sender, TcpClientEventArgs e);
        /// <summary>
        /// 断开连接事件
        /// </summary>
        public event TcpClientEventHandler Disonnected;
        public event TcpClientEventHandler Connected;
        public event TcpClientEventHandler PacketReceived;

        #region 参数
        /// <summary>
        /// 
        /// </summary>
        public class TcpClientEventArgs : System.EventArgs
        {
            /// <summary>
            /// 套接事件相关参数
            /// </summary>
            public TcpClientEventArgs()
            {

            }


            public TcpClientEventArgs(  byte[] data)
            {
                Data = data;
                
            }


            /// <summary>
            /// 收到的数据
            /// </summary>
            public byte[] Data
            {
                set;
                get;
            }
        }
        #endregion
        #endregion

    }
}


