using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Net;
using System.IO;
using IMLibrary.Security;

namespace Ourmsg.FileTransmit
{
    public partial class WebFile : Component
    {
        /// <summary>
        /// 
        /// </summary>
        public WebFile()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="container"></param>
        public WebFile(IContainer container)
        {
            container.Add(this);
            InitializeComponent();
        }

        #region 
        private System.Net.NetworkCredential netCre;// = new NetworkCredential();
        /// <summary>
        /// ļMD5ֵ
        /// </summary>
        public string FileMD5Value;

        public TFileInfo TFileInfo = new  TFileInfo();
        #endregion

        #region  ļ¼
        /// <summary>
        /// ¼ͻյļ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public delegate void fileTransmitEventHandler(object sender,  fileTransmitEvnetArgs e);//ͻյļ 

        /// <summary>
        /// 
        /// </summary>
        public event fileTransmitEventHandler fileTransmitted;

        /// <summary>
        /// 
        /// </summary>
        public event fileTransmitEventHandler fileTransmitError;

        /// <summary>
        /// 
        /// </summary>
        public event fileTransmitEventHandler fileTransmitting;

        #endregion

        #region Webļ
       
        /// <summary>
        /// Webļ
        /// </summary>
        /// <param name="WebURI"></param>
        /// <param name="LocalFile"></param>
        public void DownloadFile(string WebURI, string LocalFile)
        {
            if (this.netCre == null) this.netCre = new NetworkCredential("", "", "");
            DownloadFile(WebURI, LocalFile, this.netCre.UserName, this.netCre.Password, this.netCre.Password);
        }
         
        /// <summary>
        /// Webļ
        /// </summary>
        /// <param name="webURI">Ҫļַ</param>
        /// <param name="localFile">ļ·</param>
        /// <param name="UserName">û</param>
        /// <param name="password"></param>
        /// <param name="domain"></param>
        public void DownloadFile(string webURI, string localFile, string UserName, string password, string domain)
        {
            if (System.IO.File.Exists(localFile))
                System.IO.File.Delete(localFile);//ļڣɾ

            FileStream fw = null;
            try
            {

                WebClient myWebClient = new WebClient();

                this.netCre = new NetworkCredential(UserName, password, domain);
                myWebClient.Credentials = this.netCre;

                long fileLen = getDownloadFileLen(webURI);//ļĴС

                Stream readStream = myWebClient.OpenRead(webURI);//WEBļ׼

                if (readStream.CanRead)
                {
                    int CurrDownLoadLen = 0;//ļ
                    int maxReadWriteFileBlock = 1024 * 5;//һζļ50k   
                    byte[] FileBlock;
                    FileBlock = new byte[maxReadWriteFileBlock];
                     fw = new FileStream(localFile, FileMode.Append, FileAccess.Write, FileShare.Read);
                    while (true)
                    {
                        int l = readStream.Read(FileBlock, 0, FileBlock.Length);//WEBļ
                        if (l == 0) break;
                        ////////////////////////ļ
                        fw.Write(FileBlock, 0, l);
                        /////////////////////////
                        CurrDownLoadLen += l;

                        TFileInfo.fullName = localFile;
                        TFileInfo.Length =fileLen;
                        TFileInfo.CurrLength=CurrDownLoadLen;
                        TFileInfo.MD5 =FileMD5Value;

                        if (this.fileTransmitting != null)
                            this.fileTransmitting(this,new fileTransmitEvnetArgs( TFileInfo));
                    }
                    fw.Close();
                    fw.Dispose();
                }
                readStream.Close();
                myWebClient.Dispose();

                    if (this.fileTransmitted != null)
                        this.fileTransmitted(this, new fileTransmitEvnetArgs(TFileInfo));

            }
            catch (Exception ex)
            {
                if (fw != null)
                {
                    fw.Close();
                    fw.Dispose();
                }
                if (this.fileTransmitError != null)
                    this.fileTransmitError(this, new  fileTransmitEvnetArgs(TFileInfo));
            }
        }
 
        #endregion
         
        #region webļϴ
        /// <summary>
        /// webļϴ
        /// </summary>
        /// <param name="WebURI">ļϴַ</param>
        /// <param name="LocalFile">ϴļ·</param>
        /// <param name="isMD5file">ļǷҪMD5㷨ȡ</param>
        public void UploadFile(string WebURI, string LocalFile,bool isMD5file)
        {
            if (this.netCre == null) this.netCre = new NetworkCredential("", "", "");
            this.UploadFile(WebURI, LocalFile, this.netCre.UserName, this.netCre.Password, this.netCre.Password, isMD5file);
        }
         
        /// <summary>
        ///  webļϴ
        /// </summary>
        /// <param name="webURI">ļϴַ</param>
        /// <param name="localFile">ϴļ·</param>
        /// <param name="UserName">û</param>
        /// <param name="password"></param>
        /// <param name="domain"></param>
        /// <param name="isMD5file">ļǷҪMD5㷨ȡ</param>
        public void UploadFile(string webURI, string localFile, string UserName, string password, string domain, bool isMD5file)
        {
            try
            {
                // Local Directory File Info
                if (!System.IO.File.Exists(localFile))//ļ
                {
                    //this.TFileInfo.Message ="Ҫϴļڣȷļ·Ƿȷ";
                    if (this.fileTransmitError != null)
                        this.fileTransmitError(this, new fileTransmitEvnetArgs(TFileInfo));
                    return;
                }

                System.IO.FileInfo fInfo = new FileInfo(localFile);//ȡļϢ

                if (isMD5file)//ҪļMD5,ִMD5
                    webURI += "\\" +  Hasher.GetMD5Hash(localFile) + fInfo.Extension;//ȡļMD5ֵ
                else
                    webURI += "\\" + fInfo.Name;// +fInfo.Extension;//ȡļMD5ֵ

                // Create a new WebClient instance.
                WebClient myWebClient = new WebClient();
                this.netCre = new NetworkCredential(UserName, password, domain);
                myWebClient.Credentials = this.netCre;

                if (getDownloadFileLen(webURI) == fInfo.Length)//Ѿдļ˳
                {
                    if (this.fileTransmitted != null)
                        this.fileTransmitted(this, new  fileTransmitEvnetArgs(TFileInfo));
                    return;
                }
                else
                {
                    Stream postStream = myWebClient.OpenWrite(webURI, "PUT");
                    if (postStream.CanWrite)
                    {
                        byte[] FileBlock;
                        int readFileCount = 0;//ļ
                        int maxReadWriteFileBlock = 1024 * 30;//һζļ30k   
                        long offset = 0;

                        readFileCount = (int)fInfo.Length / maxReadWriteFileBlock;//ļд

                        if ((int)fInfo.Length % maxReadWriteFileBlock != 0)
                            readFileCount++;//дļ࣬д1

                        for (int i = 0; i < readFileCount; i++)
                        {   //Ƕһļڴ
                            if (i + 1 == readFileCount)//һζдļļβȫ뵽ڴ
                                FileBlock = new byte[(int)fInfo.Length - i * maxReadWriteFileBlock];
                            else
                                FileBlock = new byte[maxReadWriteFileBlock];

                            ////////////////////////ļ
                            FileStream fw = new FileStream(localFile, FileMode.Open, FileAccess.Read, FileShare.Read);
                            offset = i * maxReadWriteFileBlock;
                            fw.Seek(offset, SeekOrigin.Begin);//ϴη͵λ
                            fw.Read(FileBlock, 0, FileBlock.Length);
                            fw.Close();
                            fw.Dispose();
                            ///////////////////////////

                            postStream.Write(FileBlock, 0, FileBlock.Length);

                            TFileInfo.fullName = localFile;
                            TFileInfo.Name = fInfo.Name;
                            TFileInfo.Length = fInfo.Length;
                            TFileInfo .CurrLength =offset + FileBlock.Length;
                            TFileInfo.MD5 =FileMD5Value;
                            if (this.fileTransmitting != null)
                                this.fileTransmitting(this, new fileTransmitEvnetArgs(TFileInfo));
                        }
                    }
                    postStream.Close();
                    myWebClient.Dispose();
                }
                if (this.fileTransmitted != null)
                    this.fileTransmitted(this, new  fileTransmitEvnetArgs(TFileInfo));
            }
            catch (Exception ex)
            {
                //TFileInfo .Message =ex.Message + ex.Source;
                if (this.fileTransmitError != null)
                    this.fileTransmitError(this, new  fileTransmitEvnetArgs(TFileInfo));
            }
        }
        #endregion
         
        #region ȡҪļĴС
        /// <summary>
        /// ȡҪļĴС
        /// </summary>
        /// <param name="WebURI">ļURI</param>
        /// <returns></returns>
        public long getDownloadFileLen(string WebURI)
        {
            if (this.netCre == null) this.netCre = new NetworkCredential("", "", "");
            return getDownloadFileLen(WebURI, this.netCre.UserName, this.netCre.Password, this.netCre.Password);
        }

        /// <summary>
        /// ȡҪļĴС
        /// </summary>
        /// <param name="WebURI">Ҫļַ</param>
        /// <param name="UserName">û</param>
        /// <param name="password"></param>
        /// <param name="domain"></param>
        /// <returns></returns>
        public long getDownloadFileLen(string WebURI, string UserName, string password, string domain)
        {
            long len = 0;//¼ҪļĴС 
            try
            {
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(WebURI);
                req.Credentials = new NetworkCredential(UserName, password, domain);
                HttpWebResponse res = (HttpWebResponse)req.GetResponse();
                len = res.ContentLength;
                res.Close();
            }
            catch (Exception ex)
            {
                //TFileInfo .Message =ex.Message + ex.Source;
                if (this.fileTransmitError != null)
                    this.fileTransmitError(this, new  fileTransmitEvnetArgs(TFileInfo));
            }
            return len;
        }
        #endregion
    }
}
