﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace IMLibrary.Enum
{
    public enum ServerCommandType:byte 
    {
        /// <summary>
        /// 注册群消息路由服务信息
        /// </summary>
        RegisterRoomRouteInfo=0,
        /// <summary>
        /// 获得用户帐号和密码等认证信息
        /// </summary>
        GetUserAuth = 1,
        /// <summary>
        /// 设置用户密码
        /// </summary>
        SetPassword = 2,
        /// <summary>
        /// 获取用户好友帐号列表
        /// </summary>
        GetUserFriendIDs,
        /// <summary>
        /// 获取用户群帐号列表
        /// </summary>
        GetUserRoomIDs,
        /// <summary>
        /// 获取用户好友信息列表
        /// </summary>
        GetUserBaseFriends,
        /// <summary>
        /// 获取用户群基本信息列表
        /// </summary>
        GetUserBaseRooms,
        /// <summary>
        /// 获取用户分组列表
        /// </summary>
        GetUserGroups,
        /// <summary>
        /// 获取用户群分组信息
        /// </summary>
        GetUserRoomGroups,
        /// <summary>
        /// 获取用户黑名单
        /// </summary>
        GetUserBlacklists,
        /// <summary>
        /// 注册代理服务器
        /// </summary>
        RegisterProxyServer ,
        /// <summary>
        /// 注册消息路由服务器
        /// </summary>
        RegisterRouteServer,
        /// <summary>
        /// 注册数据库操作及缓存服务器
        /// </summary>
        RegisterDBCacheServer,

        /// <summary>
        /// 获得自身服务ID号
        /// </summary>
        GetSelfServerID,
        /// <summary>
        /// 获取代理服务器列表
        /// </summary>
        GetProxyServerList,
        /// <summary>
        /// 获取代理服务器 
        /// </summary>
        GetProxyServer,
        /// <summary>
        /// 代理服务器离线
        /// </summary>
        ProxyServerOffline,
        /// <summary>
        /// 路由服务器离线
        /// </summary>
        RouterServerOffline,
        /// <summary>
        /// 数据缓存服务器离线
        /// </summary>
        DBCacheServerOffline,
        /// <summary>
        /// 用户更改在线状态
        /// </summary>
        SetPresence,
        /// <summary>
        /// 设置用户登录成功
        /// </summary>
        SetLoginCuccess,
        /// <summary>
        /// 错误
        /// </summary>
        Error=255,
    }
}
