﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ourmsg.Server.MemoryObject;

using STSdb4.Database;

namespace Ourmsg.Server
{

    /// <summary>
    /// 群创建服务器
    /// </summary>
    public sealed class CacheCreateRoom
    {
        /// <summary>
        /// 
        /// </summary>
        private static string DBName = "UnusedRooms.stsdb4";
        /// <summary>
        /// 放号
        /// </summary>
        /// <param name="startID"></param>
        /// <param name="endID"></param>
        public static void WriteNumber(UInt32 startID, UInt32 endID)
        {
            using (IStorageEngine engine = STSdb.FromFile(DBName))
            {
                var table = engine.OpenXTable<UInt32, UInt32>("UnusedRooms");
                for (UInt32 i = startID; i <= endID; i++)
                    table[i] = i;
                engine.Commit();
            }
        }


        /// <summary>
        /// 获取一个未使用的群号
        /// </summary>
        /// <returns></returns>
        public static UInt32 GetUnusedID()
        {
            UInt32 ID = 0;
            using (IStorageEngine engine = STSdb.FromFile(DBName))
            {
                var table = engine.OpenXTable<UInt32, UInt32>("UnusedRooms");
                foreach (var id in table)
                {
                    ID = id.Value;
                    break;
                }
                table.Delete(ID);
                engine.Commit();
            }
            return ID;
        }
 
    }
}
