﻿// The MIT License (MIT)
// Copyright (c) 2014 Nicolas Kogler

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

using System;
using System.Text;
using System.Drawing;
using System.Drawing.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Collections.Generic;
 

namespace  IMLibrary.Controls.Win8form
{
    public class SharpToolStrip : ToolStrip
    {
        private Color selectedbordercolor;
        private Color selectedbackcolor;
        private Color clickedbordercolor;
        private Color clickedbackcolor;
        private Color formBackColor=Color.WhiteSmoke ;

        [Browsable(true), Category("SharpToolStrip")]
        public Color SelectedBorderColor
        {
            get
            {
                return selectedbordercolor;
            }
            set
            {
                selectedbordercolor = value;
            }
        }

        [Browsable(true), Category("SharpToolStrip")]
        public Color SelectedBackColor
        {
            get
            {
                return selectedbackcolor;
            }
            set
            {
                selectedbackcolor = value;
            }
        }

        [Browsable(true), Category("SharpToolStrip")]
        public Color ClickedBorderColor
        {
            get
            {
                return clickedbordercolor;
            }
            set
            {
                clickedbordercolor = value;
            }
        }

        [Browsable(true), Category("SharpToolStrip")]
        public Color ClickedBackColor
        {
            get
            {
                return clickedbackcolor;
            }
            set
            {
                clickedbackcolor = value;
            }
        }

        [Browsable(true), Category("SharpToolStrip")]
        public Color FormBackColor
        {
            get
            {
                return formBackColor;
            }
            set
            {
                formBackColor = value;
                if(this.Renderer!=null)
                    ((SharpToolRenderer)this.Renderer).FormBackColor = formBackColor;
                this.Invalidate();
            }
        }

        public SharpToolStrip()
        {
            this.selectedbackcolor = Color.FromArgb(255, 240, 240, 240);
            this.selectedbordercolor = Color.FromArgb(255, 200, 200, 200);
            this.clickedbackcolor = Color.FromArgb(255, 220, 220, 220);
            this.clickedbordercolor = Color.FromArgb(255, 180, 180, 180);

            this.Renderer = new SharpToolRenderer();
            this.GripStyle = ToolStripGripStyle.Hidden;
            this.Location = new Point(0, 28);
            this.Dock = DockStyle.None;

            ((SharpToolRenderer)this.Renderer).FormBackColor = formBackColor;
        }
    }
}