﻿// The MIT License (MIT)
// Copyright (c) 2014 Nicolas Kogler

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;

namespace IMLibrary.Controls.Win8form
{
    public class SharpMenuRenderer : ToolStripRenderer
    {
        private bool _IsDrawLine = true;
        public bool IsDrawLine
        {
            set { _IsDrawLine = value; }
            get { return _IsDrawLine; }
        }

        private bool _IsDrawClose = false ;
        public bool IsDrawClose
        {
            set { _IsDrawClose = value; }
            get { return _IsDrawClose; }
        }

        /// <summary>
        /// Draws the background of the ContextMenu.
        /// </summary>
        protected override void OnRenderImageMargin(ToolStripRenderEventArgs e)
        {
            var bounds = e.AffectedBounds;
            var height = e.ToolStrip.Height;
            var width = e.ToolStrip.Width;

            var border_rect = new Rectangle(0, 0, width - 1, height - 1);
            var back_rect = new Rectangle(1, 1, width - 2, height - 2);
            var point2 = new Point(bounds.Width, bounds.Height);
            var point1 = new Point(bounds.Width, 0);

            var back_brush = new SolidBrush(Color.FromArgb(255, 254, 254, 254));
            var border_pen = new Pen(Color.FromArgb(255, 77, 77, 77));

            e.Graphics.FillRectangle(back_brush, back_rect);
            e.Graphics.FillRectangle(back_brush, bounds);
            e.Graphics.DrawRectangle(border_pen, border_rect);
            if (IsDrawLine)
                e.Graphics.DrawLine(border_pen, point1, point2);

            back_brush.Dispose();
            border_pen.Dispose();
        }
        
        /// <summary>
        /// Draws the selection, in case an item is mouse-overed.
        /// </summary>
        protected override void OnRenderMenuItemBackground(ToolStripItemRenderEventArgs e)
        {
            if (e.Item.Enabled)
            {
                if (e.Item.IsOnDropDown && e.Item.Selected)
                {
                    var rect = new Rectangle(0, 0, e.Item.Width, e.Item.Height);
                    var brush = new SolidBrush(Color.FromArgb(230, 66, 131, 222));//Color.Yellow 

                    if (IsDrawClose)
                    { 
                        Bitmap image = new Bitmap(IMLibrary.Controls.Win8form.Resources.close1 );
                        Point p5 = new Point(rect.Width - image.Width -10, (rect.Height - image.Height) / 2);
                        e.Graphics.DrawImage(image, p5);
                    }
                      
                    e.Graphics.FillRectangle(brush, rect);
                    brush.Dispose();
                }
            }
        } 
   
        /// <summary>
        /// Draws horizontal separators of the ContextMenu.
        /// </summary>
        /// <param name="e"></param>
        protected override void OnRenderSeparator(ToolStripSeparatorRenderEventArgs e)
        {
            if (!e.Vertical)
            {
                var line_rect = new Rectangle(24, 3, e.Item.Width, 1);
                var line_brush = new SolidBrush(Color.FromArgb(255, 77, 77, 77));

                e.Graphics.FillRectangle(line_brush, line_rect);
                line_brush.Dispose();
            }
        }
    }
}