using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace IMLibrary.Controls.Toolbox.Design
{
    [AttributeUsage(AttributeTargets.All)]
    internal sealed class SRDescriptionAttribute : DescriptionAttribute
    {
        // Methods
        public SRDescriptionAttribute(string description)
            : base(description)
        {
        }


        // Properties
        public override string Description
        {
            get
            {
                if (!this.replaced)
                {
                    this.replaced = true;
                    base.DescriptionValue = Properties.Resources.ResourceManager.GetString(base.Description);
                }
                return base.Description;
            }
        }


        // Fields
        private bool replaced;
    }

}
