﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace IMLibrary.Controls.Skinform
{
    /* 作者：Starts_2000
     * 日期：2009-09-20
     * 网站：http://www.csharpwin.com CS 程序员之窗。
     * 你可以免费使用或修改以下代码，但请保留版权信息。
     * 具体请查看 CS程序员之窗开源协议（http://www.csharpwin.com/csol.html）。
     */

    public class SkinFormColorTable
    {
        /// <summary>
        /// 窗口标题栏激活状态颜色
        /// </summary>
        private static readonly Color _captionActive = Color.FromArgb(248, 147, 29); //  Color.FromArgb(75, 188, 254);
        /// <summary>
        /// 窗口标题栏非激活状态颜色
        /// </summary>
        private static readonly Color _captionDeactive = Color.FromArgb(248, 147, 29); // Color.FromArgb(131, 209, 255);
         /// <summary>
         /// 窗口文本颜色值
         /// </summary>
        private static readonly Color _captionText =Color.White;//  Color.FromArgb(40, 111, 152);
        /// <summary>
        /// 窗体外边缘颜色
        /// </summary>
        private static readonly Color _border =Color.FromArgb(248, 147, 29); //Color.Blue;// Color.FromArgb(55, 126, 168);
        /// <summary>
        /// 窗体内边缘颜色
        /// </summary>
        private static readonly Color _innerBorder =Color.FromArgb(248, 147, 29); 
        /// <summary>
        /// 窗体背景颜色
        /// </summary>
        private static readonly Color _back = Color.FromArgb(124, 252,0); //   Color.FromArgb(218, 165, 32); //
        /// <summary>
        /// 窗口按键激活颜色
        /// </summary>
        private static readonly Color _controlBoxActive = Color.FromArgb(248, 147, 29); 
        /// <summary>
        /// 窗口按键非激活颜色
        /// </summary>
        private static readonly Color _controlBoxDeactive = Color.FromArgb(248, 147, 29);  
        /// <summary>
        /// 窗口按钮鼠标盘旋颜色
        /// </summary>
        private static readonly Color _controlBoxHover = Color.FromArgb(213, 66, 22); 
        /// <summary>
        /// 窗口按钮鼠标按下颜色
        /// </summary>
        private static readonly Color _controlBoxPressed = Color.FromArgb(171, 53, 17); 
        /// <summary>
        /// 关闭按钮鼠标盘旋颜色
        /// </summary>
        private static readonly Color _controlCloseBoxHover =Color.FromArgb(213, 66, 22);
        /// <summary>
        /// 关闭按钮鼠标按下颜色
        /// </summary>
        private static readonly Color _controlCloseBoxPressed =  Color.FromArgb(171, 53, 17);
        /// <summary>
        /// 按钮内边缘颜色
        /// </summary>
        private static readonly Color _controlBoxInnerBorder =   Color.FromArgb(128, 250, 250, 250);

        public virtual Color CaptionActive
        {
            get { return _captionActive; }
        }

        public virtual Color CaptionDeactive
        {
            get { return _captionDeactive; }
        }

        public virtual Color CaptionText
        {
            get { return _captionText; }
        }

        public virtual Color Border
        {
            get { return _border; }
        }

        public virtual Color InnerBorder
        {
            get { return _innerBorder; }
        }

        public virtual Color Back
        {
            get { return _back; }
        }

        public virtual Color ControlBoxActive
        {
            get { return _controlBoxActive; }
        }

        public virtual Color ControlBoxDeactive
        {
            get { return _controlBoxDeactive; }
        }

        public virtual Color ControlBoxHover
        {
            get { return _controlBoxHover; }
        }

        public virtual Color ControlBoxPressed
        {
            get { return _controlBoxPressed; }
        }

        public virtual Color ControlCloseBoxHover
        {
            get { return _controlCloseBoxHover; }
        }

        public virtual Color ControlCloseBoxPressed
        {
            get { return _controlCloseBoxPressed; }
        }

        public virtual Color ControlBoxInnerBorder
        {
            get { return _controlBoxInnerBorder; }
        }
    }
}
