﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IMLibrary.Controls.ExControls
{
    /// <summary>
    /// 代表 ToolBar 中项的集合。
    /// </summary>
    [ListBindable(false)]
    public class ToolItemCollectionEx : List<ToolItemEx>
    {
        #region 变量
        /// <summary>
        /// ToolBar
        /// </summary>
        private ToolBarEx _owner = null;

        #endregion

        #region 构造函数
        /// <summary>
        /// 初始化 Paway.Windows.Forms.ToolItemCollection 新的实例。
        /// </summary>
        /// <param name="owner">ToolBar</param>
        public ToolItemCollectionEx(ToolBarEx owner)
        {
            this._owner = owner;
        }

        #endregion

        #region 方法
        /// <summary>
        /// 返回该项在集合中的索引值
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public int GetIndexOfRange(ToolItemEx item)
        {
            int result = -1;
            for (int i = 0; i < base.Count; i++)
            {
                if (item == base[i])
                {
                    result = i;
                    break;
                }
            }
            return result;
        }
        #endregion
    }
}
