﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Text;
using IMLibrary.Controls.ExControls.Enum;


namespace IMLibrary.Controls.ExControls
{
    /// <summary>
    /// 
    /// </summary>
    [DefaultEvent("CheckedChanged")]
    [ToolboxBitmap(typeof(RadioButton))]
    public class RadioButtonEx : RadioButton
    {
        #region 变量
        /// <summary>
        /// 
        /// </summary>
        private MouseState _mouseState = MouseState.Normal;

        #endregion

        #region 构造函数
        /// <summary>
        /// 
        /// </summary>
        public RadioButtonEx()
        {
            this.SetStyle(
                ControlStyles.AllPaintingInWmPaint |
                ControlStyles.OptimizedDoubleBuffer |
                ControlStyles.ResizeRedraw |
                ControlStyles.Selectable |
                ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.Opaque, false);
            this.UpdateStyles();
            this.BackColor = Color.Transparent;
        }

        #endregion

        #region 属性
        /// <summary>
        /// 重写CheckBox的Text属性
        /// </summary>
        [DefaultValue("QQCheckBox")]
        public override string Text
        {
            get { return base.Text; }
            set { base.Text = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        internal MouseState MouseState
        {
            get { return this._mouseState; }
            set
            {
                this._mouseState = value;
                base.Invalidate();
            }
        }
        /// <summary>
        /// 文本区域
        /// </summary>
        internal Rectangle TextRect
        {
            get { return new Rectangle(17, 0, this.Width - 17, this.Height); }
        }
        /// <summary>
        /// 图片显示区域
        /// </summary>
        internal Rectangle ImageRect
        {
            get { return new Rectangle(0, (this.Height - 17) / 2, 17, 17); }
        }
        #endregion

        #region Override 方法
        /// <summary>
        /// 
        /// </summary>
        /// <param name="pevent"></param>
        protected override void OnPaint(PaintEventArgs pevent)
        {
            Graphics g = pevent.Graphics;
            g.SmoothingMode = SmoothingMode.AntiAlias;
            g.TextRenderingHint = TextRenderingHint.AntiAlias;

            Color foreColor = base.Enabled ? this.ForeColor : Color.Gray;
            TextFormatFlags flags = TextFormatFlags.VerticalCenter |
                                    TextFormatFlags.Left |
                                    TextFormatFlags.SingleLine;
            TextRenderer.DrawText(g, this.Text, this.Font, this.TextRect, foreColor, flags);

            switch (this.MouseState)
            {
                case MouseState.Leave:
                case MouseState.Normal:
                    if (base.Checked)
                    {
                        using (Image normal =RadioButtonResources.tick_normal  )
                        {
                            g.DrawImage(normal, this.ImageRect);
                        }
                    }
                    else
                    {
                        using (Image normal =RadioButtonResources.normal  )
                        {
                            g.DrawImage(normal, this.ImageRect);
                        }
                    }

                    break;
                case MouseState.Move:
                case MouseState.Down:
                case MouseState.Up:
                    if (base.Checked)
                    {
                        using (Image high =RadioButtonResources.tick_highlight )
                        {
                            g.DrawImage(high, this.ImageRect);
                        }
                    }
                    else
                    {
                        using (Image high =RadioButtonResources.highlight )
                        {
                            g.DrawImage(high, this.ImageRect);
                        }
                    }
                    break;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="eventargs"></param>
        protected override void OnMouseEnter(EventArgs eventargs)
        {
            base.OnMouseEnter(eventargs);
            this.MouseState = MouseState.Move;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="eventargs"></param>
        protected override void OnMouseLeave(EventArgs eventargs)
        {
            base.OnMouseLeave(eventargs);
            this.MouseState = MouseState.Leave;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="mevent"></param>
        protected override void OnMouseUp(MouseEventArgs mevent)
        {
            base.OnMouseUp(mevent);
            this.MouseState = MouseState.Up;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="mevent"></param>
        protected override void OnMouseDown(MouseEventArgs mevent)
        {
            base.OnMouseDown(mevent);
            this.MouseState = MouseState.Down;
        }
        #endregion
    }
}
