﻿using IMLibrary.Controls;

namespace IMLibrary.Controls.CustomScrollBar
{
   /// <summary>
   /// The scrollbar arrow button states.
   /// </summary>
   internal enum ScrollBarArrowButtonState
   {
      /// <summary>
      /// Indicates the up arrow is in normal state.
      /// </summary>
      UpNormal,

      /// <summary>
      /// Indicates the up arrow is in hot state.
      /// </summary>
      UpHot,

      /// <summary>
      /// Indicates the up arrow is in active state.
      /// </summary>
      UpActive,

      /// <summary>
      /// Indicates the up arrow is in pressed state.
      /// </summary>
      UpPressed,

      /// <summary>
      /// Indicates the up arrow is in disabled state.
      /// </summary>
      UpDisabled,

      /// <summary>
      /// Indicates the down arrow is in normal state.
      /// </summary>
      DownNormal,

      /// <summary>
      /// Indicates the down arrow is in hot state.
      /// </summary>
      DownHot,

      /// <summary>
      /// Indicates the down arrow is in active state.
      /// </summary>
      DownActive,

      /// <summary>
      /// Indicates the down arrow is in pressed state.
      /// </summary>
      DownPressed,

      /// <summary>
      /// Indicates the down arrow is in disabled state.
      /// </summary>
      DownDisabled
   }
}
