﻿using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace OwnerDrawnControls
{
    [ToolboxBitmap(typeof(ComboBox))]
  public   class ComboBoxEx : ComboBox
    {
        public ComboBoxEx()
        {
            this.DrawMode = DrawMode.OwnerDrawFixed;
            this.DrawItem += ComboBoxEx_DrawItem;
            this.DropDownBorderColor = Color.Red;
            this.DropDownBackColor = Color.Yellow;
        }

        [Category("Appearance")]
        [Description("The border color of the drop down list")]
        [DefaultValue(typeof(Color), "Red")]
        public Color DropDownBorderColor { get; set; }

        [Category("Appearance")]
        [Description("The background color of the drop down list")]
        [DefaultValue(typeof(Color), "Yellow")]
        public Color DropDownBackColor { get; set; }

        void ComboBoxEx_DrawItem(object sender, DrawItemEventArgs e)
        {            
            if (e.Index < 0)
                return;

            if ((e.State & DrawItemState.ComboBoxEdit) == DrawItemState.ComboBoxEdit)
                return;

            // Draw the background of the item.
            if (((e.State & DrawItemState.Focus) == DrawItemState.Focus) ||
                ((e.State & DrawItemState.Selected) == DrawItemState.Selected) ||
                ((e.State & DrawItemState.HotLight) == DrawItemState.HotLight)
               )
            {
                e.DrawBackground();
            }
            else
            {
                Brush backgroundBrush = new SolidBrush(DropDownBackColor);
                e.Graphics.FillRectangle(backgroundBrush, e.Bounds);
            }

            //Draw item text
            e.Graphics.DrawString(Items[e.Index].ToString(), this.Font, Brushes.Black, 
              new RectangleF(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height));

            // Draw the focus rectangle if the mouse hovers over an item.
            if ((e.State & DrawItemState.Focus) == DrawItemState.Focus)
                e.DrawFocusRectangle();

            //Draw the border around the whole DropDown area
            Pen borderPen = new Pen(DropDownBorderColor, 1);
            Point start;
            Point end;

            if (e.Index == 0)
            {
                //Draw top border
                start = new Point(e.Bounds.Left, e.Bounds.Top);
                end = new Point(e.Bounds.Left + e.Bounds.Width - 1, e.Bounds.Top);
                e.Graphics.DrawLine(borderPen, start, end);
            }

            //Draw left border
            start = new Point(e.Bounds.Left, e.Bounds.Top);
            end = new Point(e.Bounds.Left, e.Bounds.Top + e.Bounds.Height - 1);
            e.Graphics.DrawLine(borderPen, start, end);

            //Draw Right border
            start = new Point(e.Bounds.Left + e.Bounds.Width - 1, e.Bounds.Top);
            end = new Point(e.Bounds.Left + e.Bounds.Width - 1, e.Bounds.Top + e.Bounds.Height - 1);
            e.Graphics.DrawLine(borderPen, start, end);

            if (e.Index == Items.Count - 1)
            {
                //Draw bottom border
                start = new Point(e.Bounds.Left, e.Bounds.Top + e.Bounds.Height - 1);
                end = new Point(e.Bounds.Left + e.Bounds.Width - 1, e.Bounds.Top + e.Bounds.Height - 1);
                e.Graphics.DrawLine(borderPen, start, end);
            }
        }
    }
}