/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view.widgets.runnable;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.fs.FsNode;
import com.wuntee.oter.view.Gui;
import java.util.List;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class FsListToTreeRunnable
implements Runnable {
    private List<FsNode> fs;
    private Tree tree;

    public FsListToTreeRunnable(List<FsNode> fs, Tree tree) {
        this.fs = fs;
        this.tree = tree;
    }

    @Override
    public void run() {
        this.tree.removeAll();
        for (FsNode node : this.fs) {
            TreeItem trtmTest = new TreeItem(this.tree, 0);
            trtmTest.setData(FsNode.class.getName(), (Object)node);
            if (node.isLink()) {
                trtmTest.setText(String.valueOf(node.getName()) + " -> " + node.getLink());
            } else {
                trtmTest.setText(node.getName());
            }
            if (node.isDirectory()) {
                this.addDirectory(trtmTest, node);
                trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_DIRECTORY));
                continue;
            }
            trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
        }
    }

    private void addDirectory(TreeItem ti, FsNode node) {
        for (FsNode child : node.getChildren()) {
            TreeItem trtmTest = new TreeItem(ti, 0);
            trtmTest.setData(FsNode.class.getName(), (Object)child);
            trtmTest.setText(child.getName());
            if (child.isDirectory()) {
                trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_DIRECTORY));
                this.addDirectory(trtmTest, child);
                continue;
            }
            trtmTest.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_FILE));
        }
    }
}

