/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view.widgets;

import com.wuntee.oter.aapt.androidmanifest.AndroidManifestAttribute;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestElement;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestNamespace;
import com.wuntee.oter.aapt.androidmanifest.AndroidManifestObject;
import com.wuntee.oter.view.widgets.CTabItemWithTree;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class CTabItemWithTreeForAndroidManifest
extends CTabItemWithTree {
    public CTabItemWithTreeForAndroidManifest(CTabFolder parent, int style) {
        super(parent, style);
    }

    public void loadAndroidManifestObjects(AndroidManifestObject root) {
        this.getTree().removeAll();
        this.loadRecur(root, null);
    }

    private void loadRecur(AndroidManifestObject o, TreeItem parent) {
        TreeItem ti = null;
        ti = parent == null ? new TreeItem(this.getTree(), 0) : new TreeItem(parent, 0);
        if (o instanceof AndroidManifestElement) {
            AndroidManifestElement e = (AndroidManifestElement)o;
            ti.setText(e.getName());
            if (e.getName().equalsIgnoreCase("uses-permission")) {
                ti.setForeground(SWTResourceManager.getColor(5));
            } else if (e.getName().equalsIgnoreCase("activity")) {
                ti.setForeground(SWTResourceManager.getColor(9));
            } else if (e.getName().equalsIgnoreCase("receiver") || e.getName().equalsIgnoreCase("provider")) {
                ti.setForeground(SWTResourceManager.getColor(3));
            }
        } else if (o instanceof AndroidManifestNamespace) {
            AndroidManifestNamespace n = (AndroidManifestNamespace)o;
            ti.setText(String.valueOf(n.getName()) + "=" + n.getValue());
        } else if (o instanceof AndroidManifestAttribute) {
            AndroidManifestAttribute a = (AndroidManifestAttribute)o;
            if (a.getRaw().equals("") && a.getType().equals("")) {
                ti.setText(String.valueOf(a.getName()) + "=" + a.getValue());
            } else if (a.getRaw().equals("") && !a.getType().equals("")) {
                ti.setText(String.valueOf(a.getName()) + "[" + a.getType() + "]=" + a.getValue());
            } else if (!a.getRaw().equals("") && a.getType().equals("")) {
                ti.setText(String.valueOf(a.getName()) + "[" + a.getRaw() + "]=" + a.getValue());
            } else {
                ti.setText(String.valueOf(a.getName()) + "[" + a.getType() + ":" + a.getRaw() + "]=" + a.getValue());
            }
        }
        String attributes = " [";
        for (AndroidManifestObject child : o.getChildren()) {
            if (child instanceof AndroidManifestAttribute) {
                AndroidManifestAttribute a = (AndroidManifestAttribute)child;
                attributes = String.valueOf(attributes) + a.getName() + "=" + a.getValue() + ", ";
                continue;
            }
            this.loadRecur(child, ti);
        }
        if (!attributes.equals(" [")) {
            ti.setText(String.valueOf(ti.getText()) + attributes.substring(0, attributes.length() - 2) + "]");
        }
        ti.setExpanded(true);
    }
}

