/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.wb.swt.SWTResourceManager;

public class CTabItemWithHexViewer {
    private static Logger logger = Logger.getLogger(CTabItemWithHexViewer.class);
    private CTabFolder parent;
    private StyledText counter;
    private StyledText hexContent;
    private StyledText binContent;
    private String name;
    private File f;
    private int style;

    public CTabItemWithHexViewer(CTabFolder parent, String name, File f, int style) throws IOException {
        this.parent = parent;
        this.name = name;
        this.f = f;
        this.style = style;
        this.createEditor();
        this.loadFile(f);
    }

    private void loadFile(File f) throws IOException {
        this.hexContent.setText("");
        FileInputStream fis = new FileInputStream(f);
        int size = fis.available();
        byte[] buffer = new byte[size];
        fis.read(buffer);
        fis.close();
        int ctr = 0;
        StringBuffer hexContentStringBuffer = new StringBuffer();
        StringBuffer counterStringBuffer = new StringBuffer("000000");
        StringBuffer binContentStringBuffer = new StringBuffer();
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            ++ctr;
            String hex = String.format("%02X", c);
            char ch = (char)c;
            if (ch < ' ' || ch > '~') {
                ch = '.';
            }
            if (ctr % 8 == 0) {
                hexContentStringBuffer.append(hex).append("\n");
                binContentStringBuffer.append(ch).append("\n");
                counterStringBuffer.append("\n").append(String.format("%06d", ctr));
            } else if (ctr % 4 == 0) {
                hexContentStringBuffer.append(hex).append("  ");
                binContentStringBuffer.append(ch).append(" ");
            } else {
                hexContentStringBuffer.append(hex).append(" ");
                binContentStringBuffer.append(ch);
            }
            ++n2;
        }
        this.hexContent.setText(hexContentStringBuffer.toString());
        this.binContent.setText(binContentStringBuffer.toString());
        this.counter.setText(counterStringBuffer.toString());
    }

    private void createEditor() {
        CTabItem tabItem = new CTabItem(this.parent, this.style);
        tabItem.setText(this.name);
        Composite composite = new Composite((Composite)this.parent, 0);
        tabItem.setControl((Control)composite);
        GridLayout gl_composite = new GridLayout(4, false);
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.counter = new StyledText(composite, 2056);
        this.counter.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.counter.setFont(SWTResourceManager.getFont("Courier New", 11, 0));
        this.addListeners(this.counter);
        this.hexContent = new StyledText(composite, 2568);
        this.hexContent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.hexContent.setFont(SWTResourceManager.getFont("Courier New", 11, 0));
        this.addListeners(this.hexContent);
        this.binContent = new StyledText(composite, 2056);
        this.binContent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.binContent.setFont(SWTResourceManager.getFont("Courier New", 11, 0));
        this.addListeners(this.binContent);
        this.parent.setSelection(tabItem);
    }

    private void addListeners(final StyledText txt) {
        txt.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        txt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }

            public void widgetSelected(SelectionEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        txt.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        txt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        txt.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        txt.addDragDetectListener(new DragDetectListener(){

            public void dragDetected(DragDetectEvent arg0) {
                CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
            }
        });
        ScrollBar vbar = txt.getVerticalBar();
        if (vbar != null) {
            vbar.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    CTabItemWithHexViewer.this.binContent.setTopIndex(txt.getTopIndex());
                    CTabItemWithHexViewer.this.hexContent.setTopIndex(txt.getTopIndex());
                    CTabItemWithHexViewer.this.counter.setTopIndex(txt.getTopIndex());
                }
            });
        }
    }
}

