/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view.widgets;

import com.wuntee.oter.sqlite.SqliteHelper;
import com.wuntee.oter.view.GuiWorkshop;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CTabItemWithDatabase {
    private static Logger logger = Logger.getLogger(CTabItemWithDatabase.class);
    private CTabItem cTabItem;
    private CTabFolder parent;
    private String name;
    private SashForm databaseSashForm;
    private Tree tablesTree;
    private Table contentsTable;
    private SqliteHelper db;

    public CTabItemWithDatabase(CTabFolder parent, String name, File file, int style) throws ClassNotFoundException, SQLException {
        this.parent = parent;
        this.name = name;
        this.db = new SqliteHelper(file);
        this.cTabItem = new CTabItem(parent, style);
        this.cTabItem.setText(name);
        this.databaseSashForm = new SashForm((Composite)parent, 0);
        this.cTabItem.setControl((Control)this.databaseSashForm);
        this.tablesTree = new Tree((Composite)this.databaseSashForm, 2048);
        this.tablesTree.setHeaderVisible(true);
        this.tablesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CTabItemWithDatabase.this.loadTableData(CTabItemWithDatabase.this.tablesTree.getSelection()[0].getText());
            }
        });
        this.contentsTable = new Table((Composite)this.databaseSashForm, 67584);
        this.contentsTable.setHeaderVisible(true);
        this.contentsTable.setLinesVisible(true);
        this.databaseSashForm.setWeights(new int[]{1, 3});
        parent.setSelection(this.cTabItem);
        this.loadTables();
    }

    public void loadTableData(final String tableName) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CTabItemWithDatabase.this.contentsTable.removeAll();
                    TableColumn[] tableColumnArray = CTabItemWithDatabase.this.contentsTable.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn c = tableColumnArray[n2];
                        c.dispose();
                        ++n2;
                    }
                    List<String> columns = CTabItemWithDatabase.this.db.getTableColumnNames(tableName);
                    if (columns.size() > 0) {
                        for (String colName : columns) {
                            TableColumn column = new TableColumn(CTabItemWithDatabase.this.contentsTable, 0);
                            column.setText(colName);
                            column.pack();
                            column.setWidth(column.getWidth() + 20);
                        }
                    }
                    List<List<String>> data = CTabItemWithDatabase.this.db.getTableData(tableName);
                    for (List list : data) {
                        TableItem tableItem = new TableItem(CTabItemWithDatabase.this.contentsTable, 0);
                        tableItem.setText(list.toArray(new String[list.size()]));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Could not load table data: ", (Throwable)e);
                }
            }
        });
    }

    public void loadTables() {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> tables = CTabItemWithDatabase.this.db.getTables();
                    CTabItemWithDatabase.this.tablesTree.removeAll();
                    for (String table : tables) {
                        TreeItem item = new TreeItem(CTabItemWithDatabase.this.tablesTree, 0);
                        item.setText(table);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Could not load tables: ", (Throwable)e);
                    CTabItemWithDatabase.this.cTabItem.dispose();
                    GuiWorkshop.messageError(CTabItemWithDatabase.this.parent.getShell(), "Could not load database: " + e.getMessage());
                }
            }
        });
    }

    public CTabItem getcTabItem() {
        return this.cTabItem;
    }

    public void setcTabItem(CTabItem cTabItem) {
        this.cTabItem = cTabItem;
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public void setParent(CTabFolder parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SashForm getDatabaseSashForm() {
        return this.databaseSashForm;
    }

    public void setDatabaseSashForm(SashForm databaseSashForm) {
        this.databaseSashForm = databaseSashForm;
    }

    public Tree getTablesTree() {
        return this.tablesTree;
    }

    public void setTablesTree(Tree tablesTree) {
        this.tablesTree = tablesTree;
    }

    public Table getContentsTable() {
        return this.contentsTable;
    }

    public void setContentsTable(Table contentsTable) {
        this.contentsTable = contentsTable;
    }
}

