/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.packagemanager.PackageBean;
import com.wuntee.oter.view.GuiWorkshop;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class LoadApkFromDeviceDialog
extends Dialog {
    private static Logger logger = Logger.getLogger(LoadApkFromDeviceDialog.class);
    protected PackageBean result;
    protected Shell shlSelectApk;
    private Table table;
    public static String PACKAGE_BEAN = "bean";

    public LoadApkFromDeviceDialog(Shell parent) {
        this(parent, 67680);
    }

    public LoadApkFromDeviceDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("SWT Dialog");
    }

    public void loadPackages() {
        try {
            List<PackageBean> beans = AdbWorkshop.listPackages();
            for (PackageBean bean : beans) {
                String apk = bean.getApk().substring(bean.getApk().lastIndexOf(47) + 1, bean.getApk().length());
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(new String[]{apk, bean.getClazz()});
                tableItem.setData(PACKAGE_BEAN, (Object)bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error loading packages:", (Throwable)e);
            GuiWorkshop.messageError(this.shlSelectApk, "There was an error loading the packages: " + e.getMessage());
        }
    }

    public PackageBean open() {
        this.createContents();
        this.shlSelectApk.open();
        this.shlSelectApk.layout();
        Display display = this.getParent().getDisplay();
        this.shlSelectApk.update();
        this.shlSelectApk.redraw();
        this.loadPackages();
        while (!this.shlSelectApk.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shlSelectApk = new Shell(this.getParent(), 2160);
        this.shlSelectApk.setSize(592, 486);
        this.shlSelectApk.setText("Select APK");
        this.shlSelectApk.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table((Composite)this.shlSelectApk, 67584);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                LoadApkFromDeviceDialog.this.result = (PackageBean)LoadApkFromDeviceDialog.this.table.getSelection()[0].getData(PACKAGE_BEAN);
                LoadApkFromDeviceDialog.this.shlSelectApk.close();
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setBounds(0, 0, 3, 19);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnApk = new TableColumn(this.table, 0);
        tblclmnApk.setWidth(240);
        tblclmnApk.setText("APK");
        TableColumn tblclmnPackage = new TableColumn(this.table, 0);
        tblclmnPackage.setWidth(338);
        tblclmnPackage.setText("Package");
        String[] keys = new String[]{PACKAGE_BEAN};
        GuiWorkshop.addColumnSorter(this.table, tblclmnApk, 0, keys);
        GuiWorkshop.addColumnSorter(this.table, tblclmnPackage, 1, keys);
        Composite composite = new Composite((Composite)this.shlSelectApk, 0);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        composite.setBounds(0, 0, 64, 64);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.verticalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Button btnLoad = new Button(composite, 0);
        btnLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (LoadApkFromDeviceDialog.this.table.getSelection().length == 0) {
                    GuiWorkshop.messageError(LoadApkFromDeviceDialog.this.shlSelectApk, "Please Select an APK to load.");
                } else {
                    LoadApkFromDeviceDialog.this.result = (PackageBean)LoadApkFromDeviceDialog.this.table.getSelection()[0].getData(PACKAGE_BEAN);
                    LoadApkFromDeviceDialog.this.shlSelectApk.close();
                }
            }
        });
        btnLoad.setText("Load");
        Button btnCancel = new Button(composite, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LoadApkFromDeviceDialog.this.result = null;
                LoadApkFromDeviceDialog.this.shlSelectApk.close();
            }
        });
        btnCancel.setText("Cancel");
    }
}

