/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.avd.AvdController;
import com.wuntee.oter.command.BackgroundCommand;
import com.wuntee.oter.fs.FsDiffController;
import com.wuntee.oter.fs.FsNode;
import com.wuntee.oter.javatosmali.JavaToSmaliController;
import com.wuntee.oter.logcat.LogCatController;
import com.wuntee.oter.packagemanager.PackageBean;
import com.wuntee.oter.packagemanager.PackageManagerController;
import com.wuntee.oter.smali.SmaliController;
import com.wuntee.oter.styler.SmaliLineStyler;
import com.wuntee.oter.view.BuildAndSignApkDialog;
import com.wuntee.oter.view.ConfigurationDialog;
import com.wuntee.oter.view.CreateAvdDialog;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.LoadApkFromDeviceDialog;
import com.wuntee.oter.view.bean.BuildAndSignApkBean;
import com.wuntee.oter.view.bean.CreateAvdBean;
import com.wuntee.oter.view.widgets.ApkTable;
import com.wuntee.oter.view.widgets.CTabItemWithTreeForAndroidManifest;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class Gui {
    protected Shell shlOterTool;
    private Display display;
    private Label statusLabel;
    private Table logcatTable;
    private Text logcatTextFilter;
    private LogCatController logcatController;
    private Button logcatCheckAutoscroll;
    private Button logcatCheckDebug;
    private Button logcatCheckInfo;
    private Button logcatCheckWarn;
    private Button logcatCheckError;
    private Button logcatCheckVerbose;
    private FsDiffController fsDiffController;
    private Tree fsDifferencesTree;
    private Tree fsDiffFirstTree;
    private Tree fsDiffSecondTree;
    private SashForm fsDiffSashForm;
    private SmaliController smaliController;
    private Tree smaliTree;
    private CTabFolder smaliTabFolder;
    private Text smaliSearchText;
    private Table smaliSearchTable;
    private Button smaliSearchIgnoreCase;
    private Button smaliSearchRegex;
    private CTabItem smaliTabSearchTab;
    private AvdController avdController;
    private PackageManagerController packageManagerController;
    private StyledText packageManagerStyledText;
    private ApkTable apkTable;
    private CTabFolder packageManagerTabFolder;
    private Tree packageManagerFilesTree;
    private CTabFolder packageManagerFilesTabs;
    private CTabItemWithTreeForAndroidManifest packageManagerAndroidManifestTab;
    private JavaToSmaliController javaToSmaliController;
    private StyledText javaToSmaliSmaliStyledText;
    private StyledText javaToSmaliJavaStyledText;
    private CTabFolder tabFolder;
    private static Logger logger = Logger.getLogger(Gui.class);

    public static void main(String[] args) {
        Display.setAppName((String)"Otertool");
        try {
            Gui window = new Gui();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createControllers();
        this.createContents();
        this.shlOterTool.open();
        this.shlOterTool.layout();
        this.loadConfig();
        while (!this.shlOterTool.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void createControllers() {
        this.logcatController = new LogCatController(this);
        this.avdController = new AvdController(this);
        this.fsDiffController = new FsDiffController(this);
        this.smaliController = new SmaliController(this);
        this.packageManagerController = new PackageManagerController(this);
        this.javaToSmaliController = new JavaToSmaliController(this);
    }

    public void loadConfig() {
        if (OterStatics.getAndroidHome() == null) {
            GuiWorkshop.messageError(this.shlOterTool, "Could not load a configuration file, please specify the configuration.");
            new ConfigurationDialog(this.shlOterTool).open();
        }
    }

    protected void createContents() {
        this.shlOterTool = new Shell();
        this.shlOterTool.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_APP));
        this.shlOterTool.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                try {
                    Gui.this.logcatController.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.shlOterTool.setMinimumSize(new Point(550, 250));
        this.shlOterTool.setSize(1000, 600);
        this.shlOterTool.setText("Otertool");
        this.shlOterTool.setLayout((Layout)new FormLayout());
        Menu menu = new Menu((Decorations)this.shlOterTool, 2);
        this.shlOterTool.setMenuBar(menu);
        MenuItem mntmFile = new MenuItem(menu, 64);
        mntmFile.setText("File");
        Menu menu_1 = new Menu(mntmFile);
        mntmFile.setMenu(menu_1);
        MenuItem mntmConfigure = new MenuItem(menu_1, 0);
        mntmConfigure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Object ret = new ConfigurationDialog(Gui.this.shlOterTool).open();
            }
        });
        mntmConfigure.setText("Configure");
        new MenuItem(menu_1, 2);
        MenuItem mntmExit = new MenuItem(menu_1, 0);
        mntmExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                System.exit(0);
            }
        });
        mntmExit.setText("Exit");
        MenuItem mntmLogcat = new MenuItem(menu, 64);
        mntmLogcat.setText("LogCat");
        Menu menu_2 = new Menu(mntmLogcat);
        mntmLogcat.setMenu(menu_2);
        MenuItem mntmStart = new MenuItem(menu_2, 0);
        mntmStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    Gui.this.logcatController.start();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not start: " + e.getMessage());
                    logger.error((Object)"Could not start logcat:", (Throwable)e);
                }
            }
        });
        mntmStart.setText("Start");
        MenuItem mntmStop = new MenuItem(menu_2, 0);
        mntmStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.stop();
            }
        });
        mntmStop.setText("Stop");
        new MenuItem(menu_2, 2);
        MenuItem mntmClear = new MenuItem(menu_2, 0);
        mntmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatTable.removeAll();
            }
        });
        mntmClear.setText("Clear");
        MenuItem mntmFsdiff = new MenuItem(menu, 64);
        mntmFsdiff.setText("FsDiff");
        Menu menu_3 = new Menu(mntmFsdiff);
        mntmFsdiff.setMenu(menu_3);
        MenuItem mntmScanFirst = new MenuItem(menu_3, 0);
        mntmScanFirst.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    Gui.this.fsDiffController.scanFirst();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not scan: " + e.getMessage());
                    logger.error((Object)"Could not scan:", (Throwable)e);
                }
            }
        });
        mntmScanFirst.setText("Scan First");
        MenuItem mntmScanSecond = new MenuItem(menu_3, 0);
        mntmScanSecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    Gui.this.fsDiffController.scanSecond();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not scan: " + e.getMessage());
                    logger.error((Object)"Could not scan:", (Throwable)e);
                }
            }
        });
        mntmScanSecond.setText("Scan Second");
        MenuItem mntmGenerateDifferences = new MenuItem(menu_3, 0);
        mntmGenerateDifferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.fsDiffController.generateDifferences();
            }
        });
        mntmGenerateDifferences.setText("Generate Differences");
        new MenuItem(menu_3, 2);
        MenuItem mntmClear_1 = new MenuItem(menu_3, 0);
        mntmClear_1.setText("Clear");
        MenuItem mntmApktool = new MenuItem(menu, 64);
        mntmApktool.setText("Smali");
        Menu menu_4 = new Menu(mntmApktool);
        mntmApktool.setMenu(menu_4);
        MenuItem mntmLoadFile = new MenuItem(menu_4, 0);
        mntmLoadFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String file = GuiWorkshop.selectFile(Gui.this.shlOterTool, new String[]{"*.apk"});
                if (file != null) {
                    Gui.this.smaliController.loadApk(new File(file));
                }
            }
        });
        mntmLoadFile.setText("Load APK");
        MenuItem mntmLoadApkDevice = new MenuItem(menu_4, 0);
        mntmLoadApkDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PackageBean apkBean = new LoadApkFromDeviceDialog(Gui.this.shlOterTool).open();
                if (apkBean != null) {
                    Gui.this.smaliController.loadApkFromDevice(apkBean);
                }
            }
        });
        mntmLoadApkDevice.setText("Load APK From Device");
        MenuItem mntmBuild = new MenuItem(menu_4, 0);
        mntmBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int save;
                if (Gui.this.smaliController.unsavedFilesOpen() && (save = GuiWorkshop.yesNoDialog(Gui.this.getShell(), "Really build?", "You have unsaved smali files; if you do not save them, they will not be applied to the new APK. Are you sure you want to rebuild the APK without saving?")) == 128) {
                    return;
                }
                BuildAndSignApkBean bean = new BuildAndSignApkDialog(Gui.this.getShell()).open();
                if (bean != null && bean.getApkFilename() != null) {
                    if (bean.isSign()) {
                        if (bean.getApkFilename() != null && bean.getCertAlias() != null && bean.getCertFilename() != null && bean.getPassword() != null) {
                            Gui.this.setStatus("Building and signing APK to: " + bean.getApkFilename());
                            Gui.this.smaliController.rebuildAndSignApk(bean);
                        }
                    } else {
                        Gui.this.smaliController.rebuildApk(bean.getApkFilename());
                    }
                }
            }
        });
        mntmBuild.setText("Build APK...");
        MenuItem mntmJavaToSmali = new MenuItem(menu, 64);
        mntmJavaToSmali.setText("Java to Smali");
        Menu menu_8 = new Menu(mntmJavaToSmali);
        mntmJavaToSmali.setMenu(menu_8);
        MenuItem mntmCompile = new MenuItem(menu_8, 0);
        mntmCompile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.javaToSmaliController.tryToCompileJava(Gui.this.javaToSmaliJavaStyledText, Gui.this.javaToSmaliSmaliStyledText);
            }
        });
        mntmCompile.setText("Convert Java to Smali");
        new MenuItem(menu_8, 2);
        MenuItem mntmConfigureClasspath = new MenuItem(menu_8, 0);
        mntmConfigureClasspath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Object ret = new ConfigurationDialog(Gui.this.shlOterTool).open();
            }
        });
        mntmConfigureClasspath.setText("Configure classpath");
        MenuItem mntmAddAndroidjarTo = new MenuItem(menu_8, 0);
        mntmAddAndroidjarTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    OterWorkshop.addAndroidjarToClasspath();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, e.getMessage());
                    return;
                }
                GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Sucessfull added android.jar to classpath. View File->Configure to view changes.");
            }
        });
        mntmAddAndroidjarTo.setText("Add android.jar to classpath");
        MenuItem mntmTools = new MenuItem(menu, 64);
        mntmTools.setText("Tools");
        Menu menu_6 = new Menu(mntmTools);
        mntmTools.setMenu(menu_6);
        MenuItem mntmLaunchAndroid = new MenuItem(menu_6, 0);
        mntmLaunchAndroid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.setStatus("Launging android.");
                BackgroundCommand c = new BackgroundCommand(OterStatics.getAndroidCommand());
                try {
                    c.execute();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not execute android: " + e.getMessage());
                }
                Gui.this.clearStatus();
            }
        });
        mntmLaunchAndroid.setText("Launch android");
        MenuItem mntmRestartAdb = new MenuItem(menu_6, 0);
        mntmRestartAdb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.setStatus("Restarting ADB");
                try {
                    AdbWorkshop.restartAdb();
                    GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Adb has been restarted.");
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not restart ADB: " + e.getMessage());
                    logger.error((Object)"Could not restart ADB:", (Throwable)e);
                }
                Gui.this.clearStatus();
            }
        });
        mntmRestartAdb.setText("Restart ADB");
        MenuItem mntmInstallCertificate = new MenuItem(menu_6, 0);
        mntmInstallCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String certfile = GuiWorkshop.selectFile(Gui.this.shlOterTool, new String[]{"*"});
                if (certfile != null) {
                    Gui.this.setStatus("Installing certificate: " + certfile);
                    try {
                        AdbWorkshop.installCert(new File(certfile), "changeit");
                        GuiWorkshop.messageDialog(Gui.this.shlOterTool, "The certificate has been sucessfully installed");
                    }
                    catch (Exception e) {
                        GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not install cert: " + e.getMessage());
                        logger.error((Object)"Could not install cert:", (Throwable)e);
                    }
                    Gui.this.clearStatus();
                }
            }
        });
        mntmInstallCertificate.setText("Install Certificate");
        MenuItem mntmInstallApk = new MenuItem(menu_6, 0);
        mntmInstallApk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.installApk();
            }
        });
        mntmInstallApk.setText("Install APK");
        MenuItem mntmCreateAvd = new MenuItem(menu_6, 0);
        mntmCreateAvd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CreateAvdBean ret = new CreateAvdDialog(Gui.this.getShell()).open();
                if (ret != null) {
                    Gui.this.avdController.createAvd(ret);
                }
            }
        });
        mntmCreateAvd.setText("Create Android Virtual Device");
        this.tabFolder = new CTabFolder((Composite)this.shlOterTool, 3072);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String selectedTab = Gui.this.tabFolder.getSelection().getText();
                if (selectedTab.equals("Package Manager")) {
                    if (Gui.this.packageManagerTabFolder.getSelection() == null) {
                        Gui.this.packageManagerTabFolder.setSelection(0);
                    }
                    if (Gui.this.apkTable.getTable().getItemCount() == 0) {
                        Gui.this.apkTable.loadPackages();
                    }
                } else if (selectedTab.equals("Smali") && Gui.this.smaliTabFolder.getSelection() == null) {
                    Gui.this.smaliTabFolder.setSelection(0);
                }
            }
        });
        FormData fd_tabFolder = new FormData();
        fd_tabFolder.top = new FormAttachment(0, 3);
        fd_tabFolder.right = new FormAttachment(100);
        fd_tabFolder.left = new FormAttachment(0, 3);
        this.tabFolder.setLayoutData((Object)fd_tabFolder);
        this.tabFolder.setSimple(false);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        CTabItem tbtmLogcat = new CTabItem(this.tabFolder, 0);
        tbtmLogcat.setText("LogCat");
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        tbtmLogcat.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite_1 = new Composite(composite, 0);
        GridLayout gl_composite_1 = new GridLayout(3, false);
        gl_composite_1.horizontalSpacing = 0;
        gl_composite_1.marginHeight = 0;
        gl_composite_1.marginWidth = 0;
        gl_composite_1.verticalSpacing = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        composite_1.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite composite_11 = new Composite(composite_1, 0);
        composite_11.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_11 = new GridLayout(1, false);
        gl_composite_11.horizontalSpacing = 0;
        gl_composite_11.marginHeight = 0;
        gl_composite_11.marginWidth = 0;
        gl_composite_11.verticalSpacing = 0;
        composite_11.setLayout((Layout)gl_composite_11);
        Label lblFilter = new Label(composite_11, 256);
        lblFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lblFilter.setText("Message Filter:");
        this.logcatTextFilter = new Text(composite_11, 2048);
        this.logcatTextFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatTextFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite_2 = new Composite(composite_1, 0);
        composite_2.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        GridLayout gl_composite_2 = new GridLayout(8, false);
        gl_composite_2.verticalSpacing = 0;
        gl_composite_2.horizontalSpacing = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.marginHeight = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        this.logcatCheckDebug = new Button(composite_2, 32);
        this.logcatCheckDebug.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatCheckDebug.setSize(57, 18);
        this.logcatCheckDebug.setSelection(true);
        this.logcatCheckDebug.setText("Debug");
        this.logcatCheckInfo = new Button(composite_2, 32);
        this.logcatCheckInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatCheckInfo.setSize(43, 18);
        this.logcatCheckInfo.setSelection(true);
        this.logcatCheckInfo.setText("Info");
        this.logcatCheckWarn = new Button(composite_2, 32);
        this.logcatCheckWarn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatCheckWarn.setSize(49, 18);
        this.logcatCheckWarn.setSelection(true);
        this.logcatCheckWarn.setText("Warn");
        this.logcatCheckError = new Button(composite_2, 32);
        this.logcatCheckError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatCheckError.setSize(49, 18);
        this.logcatCheckError.setSelection(true);
        this.logcatCheckError.setText("Error");
        this.logcatCheckVerbose = new Button(composite_2, 32);
        this.logcatCheckVerbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.reFilterTable();
            }
        });
        this.logcatCheckVerbose.setSize(66, 18);
        this.logcatCheckVerbose.setSelection(true);
        this.logcatCheckVerbose.setText("Verbose");
        new Label(composite_2, 0);
        new Label(composite_2, 0);
        this.logcatCheckAutoscroll = new Button(composite_2, 32);
        this.logcatCheckAutoscroll.setSize(83, 18);
        this.logcatCheckAutoscroll.setSelection(true);
        this.logcatCheckAutoscroll.setText("Auto-scroll");
        Composite composite_12 = new Composite(composite_1, 0);
        composite_12.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        GridLayout gl_composite_12 = new GridLayout(4, false);
        gl_composite_12.marginLeft = 5;
        gl_composite_12.verticalSpacing = 0;
        gl_composite_12.marginWidth = 0;
        gl_composite_12.horizontalSpacing = 0;
        gl_composite_12.marginHeight = 0;
        composite_12.setLayout((Layout)gl_composite_12);
        Button btnClear = new Button(composite_12, 0);
        btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatTable.removeAll();
            }
        });
        btnClear.setText("Clear");
        Button btnStart = new Button(composite_12, 0);
        btnStart.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    Gui.this.logcatController.start();
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not start: " + e.getMessage());
                    logger.error((Object)"Could not start logcat:", (Throwable)e);
                }
            }
        });
        btnStart.setText("Start");
        Button btnStop = new Button(composite_12, 0);
        btnStop.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.stop();
            }
        });
        btnStop.setText("Stop");
        new Label(composite_12, 0);
        this.logcatTable = new Table(composite, 67586);
        this.logcatTable.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.logcatTable.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent arg0) {
            }
        });
        this.logcatTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.stopAutoscroll();
            }
        });
        this.logcatTable.setHeaderVisible(true);
        this.logcatTable.setLinesVisible(true);
        TableColumn tblclmnDate = new TableColumn(this.logcatTable, 0);
        tblclmnDate.setWidth(111);
        tblclmnDate.setText("Timestamp");
        TableColumn tblclmnNewColumn = new TableColumn(this.logcatTable, 0);
        tblclmnNewColumn.setWidth(55);
        tblclmnNewColumn.setText("Level");
        TableColumn tblclmnClass = new TableColumn(this.logcatTable, 0);
        tblclmnClass.setWidth(86);
        tblclmnClass.setText("Class");
        TableColumn tblclmnPid = new TableColumn(this.logcatTable, 0);
        tblclmnPid.setWidth(34);
        tblclmnPid.setText("PID");
        TableColumn tblclmnMessage = new TableColumn(this.logcatTable, 0);
        tblclmnMessage.setWidth(600);
        tblclmnMessage.setText("Message");
        Menu menu_7 = new Menu((Control)this.logcatTable);
        this.logcatTable.setMenu(menu_7);
        MenuItem mntmCopy = new MenuItem(menu_7, 0);
        mntmCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatController.copy();
            }
        });
        mntmCopy.setText("Copy");
        MenuItem mntmCle = new MenuItem(menu_7, 0);
        mntmCle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.logcatTable.removeAll();
            }
        });
        mntmCle.setText("Clear");
        this.statusLabel = new Label((Composite)this.shlOterTool, 0);
        fd_tabFolder.bottom = new FormAttachment((Control)this.statusLabel, -6);
        CTabItem tbtmFsdiff = new CTabItem(this.tabFolder, 0);
        tbtmFsdiff.setText("FsDiff");
        Composite composite_5 = new Composite((Composite)this.tabFolder, 0);
        tbtmFsdiff.setControl((Control)composite_5);
        composite_5.setLayout((Layout)new FillLayout(256));
        this.fsDiffSashForm = new SashForm(composite_5, 0);
        Composite composite_6 = new Composite((Composite)this.fsDiffSashForm, 0);
        composite_6.setLayout((Layout)new FormLayout());
        Label lblFirst = new Label(composite_6, 0);
        FormData fd_lblFirst = new FormData();
        fd_lblFirst.top = new FormAttachment(1);
        fd_lblFirst.left = new FormAttachment(0);
        lblFirst.setLayoutData((Object)fd_lblFirst);
        lblFirst.setText("First");
        this.fsDiffFirstTree = new Tree(composite_6, 2048);
        FormData fd_tree_2 = new FormData();
        fd_tree_2.bottom = new FormAttachment(100);
        fd_tree_2.right = new FormAttachment(100);
        fd_tree_2.top = new FormAttachment((Control)lblFirst, 0);
        fd_tree_2.left = new FormAttachment(0);
        this.fsDiffFirstTree.setLayoutData((Object)fd_tree_2);
        Composite composite_7 = new Composite((Composite)this.fsDiffSashForm, 0);
        composite_7.setLayout((Layout)new FormLayout());
        Label lblSecond = new Label(composite_7, 0);
        FormData fd_lblSecond = new FormData();
        fd_lblSecond.top = new FormAttachment(1);
        fd_lblSecond.left = new FormAttachment(0);
        lblSecond.setLayoutData((Object)fd_lblSecond);
        lblSecond.setText("Second");
        this.fsDiffSecondTree = new Tree(composite_7, 2048);
        FormData fd_tree_3 = new FormData();
        fd_tree_3.bottom = new FormAttachment(100);
        fd_tree_3.right = new FormAttachment(100);
        fd_tree_3.top = new FormAttachment((Control)lblSecond, 0);
        fd_tree_3.left = new FormAttachment((Control)lblSecond, 0, 16384);
        this.fsDiffSecondTree.setLayoutData((Object)fd_tree_3);
        Composite composite_8 = new Composite((Composite)this.fsDiffSashForm, 0);
        composite_8.setLayout((Layout)new FormLayout());
        Label lblDifferences = new Label(composite_8, 0);
        FormData fd_lblDifferences = new FormData();
        fd_lblDifferences.top = new FormAttachment(1);
        fd_lblDifferences.left = new FormAttachment(0);
        lblDifferences.setLayoutData((Object)fd_lblDifferences);
        lblDifferences.setText("Differences");
        this.fsDifferencesTree = new Tree(composite_8, 2048);
        this.fsDifferencesTree.setHeaderVisible(true);
        FormData fd_tree_4 = new FormData();
        fd_tree_4.bottom = new FormAttachment(100);
        fd_tree_4.right = new FormAttachment(100);
        fd_tree_4.top = new FormAttachment((Control)lblDifferences, 0);
        fd_tree_4.left = new FormAttachment((Control)lblDifferences, 0, 16384);
        this.fsDifferencesTree.setLayoutData((Object)fd_tree_4);
        TreeColumn trclmnName = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnName.setWidth(330);
        trclmnName.setText("Name");
        TreeColumn trclmnPermissions = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnPermissions.setWidth(72);
        trclmnPermissions.setText("Permissions");
        TreeColumn trclmnGroup = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnGroup.setWidth(50);
        trclmnGroup.setText("Group");
        TreeColumn trclmnUser = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnUser.setWidth(50);
        trclmnUser.setText("User");
        TreeColumn trclmnSize = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnSize.setWidth(40);
        trclmnSize.setText("Size");
        TreeColumn trclmnModified = new TreeColumn(this.fsDifferencesTree, 0);
        trclmnModified.setWidth(140);
        trclmnModified.setText("Modified");
        this.fsDiffSashForm.setWeights(new int[]{1, 1, 3});
        CTabItem tbtmApktool = new CTabItem(this.tabFolder, 0);
        tbtmApktool.setText("Smali");
        Composite composite_3 = new Composite((Composite)this.tabFolder, 0);
        tbtmApktool.setControl((Control)composite_3);
        composite_3.setLayout((Layout)new FillLayout(256));
        SashForm sashForm_1 = new SashForm(composite_3, 0);
        this.smaliTree = new Tree((Composite)sashForm_1, 2048);
        this.smaliTree.setLinesVisible(true);
        this.smaliTree.setHeaderVisible(true);
        this.smaliTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TreeItem[] items = Gui.this.smaliTree.getSelection();
                if (items.length > 0) {
                    TreeItem sel = items[0];
                    if (sel.getItemCount() == 0) {
                        String name = sel.getText();
                        Gui.this.setStatus("Loading: " + name);
                        TreeItem parent = sel.getParentItem();
                        String pkg = parent == null ? "" : parent.getText();
                        Gui.this.smaliController.loadSmaliSource(pkg, name);
                    } else {
                        sel.setExpanded(true);
                    }
                    Gui.this.clearStatus();
                }
            }
        });
        this.smaliTabFolder = new CTabFolder((Composite)sashForm_1, 2048);
        this.smaliTabFolder.setSimple(false);
        this.smaliTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.smaliTabSearchTab = new CTabItem(this.smaliTabFolder, 0);
        this.smaliTabSearchTab.setText("Search");
        Composite composite_9 = new Composite((Composite)this.smaliTabFolder, 0);
        this.smaliTabSearchTab.setControl((Control)composite_9);
        GridLayout gl_composite_9 = new GridLayout(1, false);
        gl_composite_9.marginTop = 5;
        gl_composite_9.verticalSpacing = 0;
        gl_composite_9.marginHeight = 0;
        gl_composite_9.horizontalSpacing = 0;
        composite_9.setLayout((Layout)gl_composite_9);
        this.smaliSearchText = new Text(composite_9, 2048);
        this.smaliSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.character == '\r') {
                    Gui.this.smaliController.search();
                }
            }
        });
        this.smaliSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite composite_10 = new Composite(composite_9, 0);
        GridLayout gl_composite_10 = new GridLayout(2, false);
        gl_composite_10.marginBottom = 5;
        gl_composite_10.marginHeight = 0;
        gl_composite_10.verticalSpacing = 0;
        gl_composite_10.marginWidth = 0;
        gl_composite_10.horizontalSpacing = 0;
        composite_10.setLayout((Layout)gl_composite_10);
        this.smaliSearchIgnoreCase = new Button(composite_10, 32);
        this.smaliSearchIgnoreCase.setBounds(0, 0, 93, 18);
        this.smaliSearchIgnoreCase.setText("Ignore Case");
        this.smaliSearchRegex = new Button(composite_10, 32);
        this.smaliSearchRegex.setBounds(0, 0, 93, 18);
        this.smaliSearchRegex.setText("Regex");
        this.smaliSearchTable = new Table(composite_9, 67584);
        this.smaliSearchTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TableItem[] selected = Gui.this.smaliSearchTable.getSelection();
                if (selected.length > 0) {
                    Gui.this.smaliController.loadSmaliSourceWithLineNumber((String)selected[0].getData("package"), (String)selected[0].getData("name"), (Integer)selected[0].getData("linenum"));
                }
            }
        });
        this.smaliSearchTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.smaliSearchTable.setBounds(0, 0, 3, 19);
        this.smaliSearchTable.setHeaderVisible(true);
        this.smaliSearchTable.setLinesVisible(true);
        TableColumn tblclmnClass_1 = new TableColumn(this.smaliSearchTable, 0);
        tblclmnClass_1.setWidth(200);
        tblclmnClass_1.setText("Class");
        TableColumn tblclmnContents = new TableColumn(this.smaliSearchTable, 0);
        tblclmnContents.setWidth(750);
        tblclmnContents.setText("Contents");
        StyledText styledText = new StyledText((Composite)this.smaliTabFolder, 2048);
        sashForm_1.setWeights(new int[]{1, 5});
        CTabItem tbtmJavaToSmali = new CTabItem(this.tabFolder, 0);
        tbtmJavaToSmali.setText("Java to Smali");
        Composite composite_13 = new Composite((Composite)this.tabFolder, 0);
        tbtmJavaToSmali.setControl((Control)composite_13);
        composite_13.setLayout((Layout)new FillLayout(256));
        SashForm sashForm = new SashForm(composite_13, 0);
        Composite composite_14 = new Composite((Composite)sashForm, 0);
        GridLayout gl_composite_14 = new GridLayout(1, false);
        gl_composite_14.verticalSpacing = 0;
        gl_composite_14.marginWidth = 0;
        gl_composite_14.marginHeight = 0;
        gl_composite_14.horizontalSpacing = 0;
        composite_14.setLayout((Layout)gl_composite_14);
        Label lblJava = new Label(composite_14, 0);
        lblJava.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblJava.setText("Java");
        this.javaToSmaliJavaStyledText = new StyledText(composite_14, 2880);
        this.javaToSmaliJavaStyledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.javaToSmaliJavaStyledText.setText("import android.util.Log;\n\npublic class OterTool {\n\n\t// Youll need to include everything that would exist in a full \n\t// java source file. I typically just write a class in Eclipse\n\t// and allow it to handle all imports, and paste it here.\n\n\t// You will also need to include the android.jar file in the \n\t// classpath to use thing like 'Log'. This can be configured\n\t// through the configuration dialog (File->Configure) or you\n\t// can attempt to have otertool attempt to automatically add it\n\t// for you through Java to Smali->Add android.jar to classpath\n\n\tpublic static void main(String[] args) {\n\t\t// Placing a method here, with its arguments will show you \n\t\t// the calling convention, and allow you to easily paste\n\t\t// the code in the smali class\n\t\toterToolMethod(\"calling argument\");\n\t\tLog.e(\"Tag\", \"Test\");\n\t}\n\t\n\tpublic static void oterToolMethod(String arg){\n\t\t// You can paste this portion of the smali code directly in\n\t\t// the end of the original package, and call it from everywhere\n\t\tSystem.out.println(arg);\n\t}\n}");
        Composite composite_15 = new Composite((Composite)sashForm, 0);
        GridLayout gl_composite_15 = new GridLayout(1, false);
        gl_composite_15.marginHeight = 0;
        gl_composite_15.verticalSpacing = 0;
        gl_composite_15.marginWidth = 0;
        gl_composite_15.horizontalSpacing = 0;
        composite_15.setLayout((Layout)gl_composite_15);
        Label lblSmali = new Label(composite_15, 0);
        lblSmali.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSmali.setText("Smali");
        this.javaToSmaliSmaliStyledText = new StyledText(composite_15, 2880);
        this.javaToSmaliSmaliStyledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.javaToSmaliSmaliStyledText.addLineStyleListener((LineStyleListener)new SmaliLineStyler());
        sashForm.setWeights(new int[]{1, 1});
        CTabItem tbtmPackageManager = new CTabItem(this.tabFolder, 0);
        tbtmPackageManager.setText("Package Manager");
        Composite composite_4 = new Composite((Composite)this.tabFolder, 0);
        tbtmPackageManager.setControl((Control)composite_4);
        composite_4.setLayout((Layout)new FillLayout(256));
        SashForm packageManagerSashForm = new SashForm(composite_4, 0);
        this.apkTable = new ApkTable((Composite)packageManagerSashForm, 67586);
        this.apkTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                logger.debug((Object)Gui.this.apkTable.getTable().getSelection().length);
                Gui.this.packageManagerController.loadPackageDetails(Gui.this.apkTable.getTable().getSelection());
            }
        });
        Menu menu_5 = new Menu((Control)this.apkTable.getTable());
        this.apkTable.getTable().setMenu(menu_5);
        MenuItem mntmInstall = new MenuItem(menu_5, 0);
        mntmInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.installApk();
                Gui.this.apkTable.loadPackages();
            }
        });
        mntmInstall.setText("Install APK");
        MenuItem mntmUninstall = new MenuItem(menu_5, 0);
        mntmUninstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.setStatus("UnInstalling package: " + Gui.this.apkTable.getTable().getSelection()[0].getText(0));
                Gui.this.packageManagerController.uninstallPackages(Gui.this.apkTable.getTable().getSelection());
                Gui.this.clearStatus();
                Gui.this.apkTable.loadPackages();
            }
        });
        mntmUninstall.setText("Uninstall Package(s)");
        MenuItem mntmPullPackages = new MenuItem(menu_5, 0);
        mntmPullPackages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String dir = GuiWorkshop.selectDirectory(Gui.this.shlOterTool);
                if (dir != null) {
                    Gui.this.packageManagerController.pullPackages(dir);
                }
            }
        });
        mntmPullPackages.setText("Pull Package(s)");
        new MenuItem(menu_5, 2);
        MenuItem mntmRefreshList = new MenuItem(menu_5, 0);
        mntmRefreshList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Gui.this.apkTable.loadPackages();
            }
        });
        mntmRefreshList.setText("Refresh List");
        this.packageManagerTabFolder = new CTabFolder((Composite)packageManagerSashForm, 0x800800);
        this.packageManagerTabFolder.setSimple(false);
        this.packageManagerTabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        CTabItem tbtmAapt = new CTabItem(this.packageManagerTabFolder, 0);
        tbtmAapt.setText("Aapt");
        Composite composite_16 = new Composite((Composite)this.packageManagerTabFolder, 0);
        tbtmAapt.setControl((Control)composite_16);
        GridLayout gl_composite_16 = new GridLayout(1, false);
        gl_composite_16.verticalSpacing = 0;
        gl_composite_16.marginWidth = 0;
        gl_composite_16.marginHeight = 0;
        gl_composite_16.horizontalSpacing = 0;
        composite_16.setLayout((Layout)gl_composite_16);
        this.packageManagerStyledText = new StyledText(composite_16, 2824);
        this.packageManagerStyledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CTabItem tbtmFiles = new CTabItem(this.packageManagerTabFolder, 0);
        tbtmFiles.setText("Files");
        SashForm sashForm_2 = new SashForm((Composite)this.packageManagerTabFolder, 0);
        tbtmFiles.setControl((Control)sashForm_2);
        Composite composite_17 = new Composite((Composite)sashForm_2, 0);
        GridLayout gl_composite_17 = new GridLayout(1, false);
        gl_composite_17.verticalSpacing = 0;
        gl_composite_17.marginWidth = 0;
        gl_composite_17.marginHeight = 0;
        gl_composite_17.horizontalSpacing = 0;
        composite_17.setLayout((Layout)gl_composite_17);
        this.packageManagerFilesTree = new Tree(composite_17, 2048);
        this.packageManagerFilesTree.setHeaderVisible(true);
        this.packageManagerFilesTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                try {
                    Tree tree = Gui.this.packageManagerFilesTree;
                    if (tree.getSelectionCount() == 1) {
                        TreeItem[] items = tree.getSelection();
                        FsNode node = (FsNode)items[0].getData(FsNode.class.getName());
                        CTabItem[] cTabItemArray = Gui.this.packageManagerFilesTabs.getItems();
                        int n = cTabItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CTabItem cti = cTabItemArray[n2];
                            if (cti.getText().equals(node.getName())) {
                                Gui.this.packageManagerFilesTabs.setSelection(cti);
                                return;
                            }
                            ++n2;
                        }
                        logger.debug((Object)("Selected item: " + node.toString()));
                        Gui.this.packageManagerController.loadFileContentsToTab(node);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Could not load file: ", (Throwable)e);
                    GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Could not load file: " + e.getMessage());
                }
            }
        });
        this.packageManagerFilesTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Menu menu_9 = new Menu((Control)this.packageManagerFilesTree);
        this.packageManagerFilesTree.setMenu(menu_9);
        MenuItem mntmSqlite = new MenuItem(menu_9, 0);
        mntmSqlite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Gui.this.packageManagerFilesTree.getSelectionCount() == 1) {
                    try {
                        TreeItem[] items = Gui.this.packageManagerFilesTree.getSelection();
                        FsNode node = (FsNode)items[0].getData(FsNode.class.getName());
                        Gui.this.packageManagerController.loadFileContentsToSQLiteTab(node);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not load file: ", (Throwable)e);
                        GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Could not load file: " + e.getMessage());
                    }
                }
            }
        });
        mntmSqlite.setText("SQLite view");
        MenuItem mntmHexView = new MenuItem(menu_9, 0);
        mntmHexView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Gui.this.packageManagerFilesTree.getSelectionCount() == 1) {
                    try {
                        TreeItem[] items = Gui.this.packageManagerFilesTree.getSelection();
                        FsNode node = (FsNode)items[0].getData(FsNode.class.getName());
                        Gui.this.packageManagerController.loadFileContentsToHexTab(node);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not load file: ", (Throwable)e);
                        GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Could not load file: " + e.getMessage());
                    }
                }
            }
        });
        mntmHexView.setText("Hex view");
        MenuItem mntmTextView = new MenuItem(menu_9, 0);
        mntmTextView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Gui.this.packageManagerFilesTree.getSelectionCount() == 1) {
                    try {
                        TreeItem[] items = Gui.this.packageManagerFilesTree.getSelection();
                        FsNode node = (FsNode)items[0].getData(FsNode.class.getName());
                        Gui.this.packageManagerController.loadFileContentsToTextTab(node);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not load file: ", (Throwable)e);
                        GuiWorkshop.messageDialog(Gui.this.shlOterTool, "Could not load file: " + e.getMessage());
                    }
                }
            }
        });
        mntmTextView.setText("Text view");
        Composite composite_18 = new Composite((Composite)sashForm_2, 0);
        GridLayout gl_composite_18 = new GridLayout(1, false);
        gl_composite_18.verticalSpacing = 0;
        gl_composite_18.marginWidth = 0;
        gl_composite_18.marginHeight = 0;
        gl_composite_18.horizontalSpacing = 0;
        composite_18.setLayout((Layout)gl_composite_18);
        sashForm_2.setWeights(new int[]{197, 525});
        this.packageManagerFilesTabs = new CTabFolder(composite_18, 2048);
        this.packageManagerFilesTabs.setSimple(false);
        this.packageManagerFilesTabs.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.packageManagerFilesTabs.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.packageManagerAndroidManifestTab = new CTabItemWithTreeForAndroidManifest(this.packageManagerTabFolder, 0);
        this.packageManagerAndroidManifestTab.setText("AndroidManifest");
        packageManagerSashForm.setWeights(new int[]{1, 2});
        FormData fd_statusLabel = new FormData();
        fd_statusLabel.bottom = new FormAttachment(100, -2);
        fd_statusLabel.left = new FormAttachment((Control)this.tabFolder, 0, 16384);
        fd_statusLabel.right = new FormAttachment(100);
        this.statusLabel.setLayoutData((Object)fd_statusLabel);
        this.statusLabel.setText("Welcome");
    }

    private void installApk() {
        this.setStatus("Installing APK.");
        String file = GuiWorkshop.selectFile(this.shlOterTool, new String[]{"*.apk"});
        if (file != null) {
            this.display.asyncExec((Runnable)new InstallApk(file));
        }
    }

    public void runRunnableAsync(Runnable r) {
        this.display.asyncExec(r);
    }

    public void messageError(String error) {
        this.display.asyncExec((Runnable)new MessageErrorRunnable(this.shlOterTool, error));
    }

    public void setSashFormWeights(SashForm sash, int[] weights) {
        this.getDisplay().asyncExec((Runnable)new SetSashFormWeights(sash, weights));
    }

    public void setStatus(final String status) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Gui.this.statusLabel.setText(status);
                Gui.this.statusLabel.update();
                Gui.this.statusLabel.redraw();
            }
        });
    }

    public void setStatusBlocking(String status) {
        this.statusLabel.setText(status);
        this.statusLabel.update();
        this.statusLabel.redraw();
    }

    public void clearStatus() {
        this.setStatus("");
    }

    public Table getLogcatTable() {
        return this.logcatTable;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Button getLogcatCheckAutoscroll() {
        return this.logcatCheckAutoscroll;
    }

    public Button getLogcatCheckDebug() {
        return this.logcatCheckDebug;
    }

    public Button getLogcatCheckInfo() {
        return this.logcatCheckInfo;
    }

    public Button getLogcatCheckWarn() {
        return this.logcatCheckWarn;
    }

    public Button getLogcatCheckError() {
        return this.logcatCheckError;
    }

    public Button getLogcatCheckVerbose() {
        return this.logcatCheckVerbose;
    }

    public Text getLogcatTextFilter() {
        return this.logcatTextFilter;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public Tree getFsDiffFirstTree() {
        return this.fsDiffFirstTree;
    }

    public Tree getFsDiffSecondTree() {
        return this.fsDiffSecondTree;
    }

    public Tree getFsDifferencesTree() {
        return this.fsDifferencesTree;
    }

    public Shell getShell() {
        return this.shlOterTool;
    }

    public SashForm getFsDiffSashForm() {
        return this.fsDiffSashForm;
    }

    public Tree getSmaliTree() {
        return this.smaliTree;
    }

    public CTabFolder getSmaliTabFolder() {
        return this.smaliTabFolder;
    }

    public StyledText getPackageManagerStyledText() {
        return this.packageManagerStyledText;
    }

    public ApkTable getApkTable() {
        return this.apkTable;
    }

    public Text getSmaliSearchText() {
        return this.smaliSearchText;
    }

    public Table getSmaliSearchTable() {
        return this.smaliSearchTable;
    }

    public Button getSmaliSearchIgnoreCase() {
        return this.smaliSearchIgnoreCase;
    }

    public Button getSmaliSearchRegex() {
        return this.smaliSearchRegex;
    }

    public Tree getPackageManagerFilesTree() {
        return this.packageManagerFilesTree;
    }

    public CTabFolder getPackageManagerFilesTabs() {
        return this.packageManagerFilesTabs;
    }

    public CTabItem getSmaliTabSearchTab() {
        return this.smaliTabSearchTab;
    }

    public CTabItemWithTreeForAndroidManifest getPackageManagerAndroidManifestTab() {
        return this.packageManagerAndroidManifestTab;
    }

    private class InstallApk
    implements Runnable {
        private String file;

        public InstallApk(String file) {
            this.file = file;
        }

        @Override
        public void run() {
            Gui.this.setStatus("Installing APK: " + this.file);
            try {
                AdbWorkshop.installApk(this.file);
                GuiWorkshop.messageDialog(Gui.this.shlOterTool, "The APK has been sucessfully installed");
            }
            catch (Exception e) {
                GuiWorkshop.messageError(Gui.this.shlOterTool, "Could not install APK: " + e.getMessage());
                logger.error((Object)"Could not install APK:", (Throwable)e);
            }
            Gui.this.clearStatus();
        }
    }

    private class MessageErrorRunnable
    implements Runnable {
        private Shell shlOterTool;
        private String error;

        public MessageErrorRunnable(Shell shell, String error) {
            this.shlOterTool = shell;
            this.error = error;
        }

        @Override
        public void run() {
            GuiWorkshop.messageError(this.shlOterTool, this.error);
        }
    }

    private class SetSashFormWeights
    implements Runnable {
        private SashForm sash;
        private int[] weights;

        public SetSashFormWeights(SashForm sash, int[] weights) {
            this.sash = sash;
            this.weights = weights;
        }

        @Override
        public void run() {
            this.sash.setWeights(this.weights);
        }
    }

    public class SetStatus
    implements Runnable {
        private String status;

        public SetStatus(String status) {
            this.status = status;
        }

        @Override
        public void run() {
            Gui.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Gui.this.statusLabel.setText(SetStatus.this.status);
                }
            });
        }
    }
}

