/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.view;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.smali.SmaliWorkshop;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.bean.BuildAndSignApkBean;
import java.io.File;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import sun.security.tools.KeyStoreUtil;

public class BuildAndSignApkDialog
extends Dialog {
    private static Logger logger = Logger.getLogger(BuildAndSignApkDialog.class);
    protected BuildAndSignApkBean result;
    protected Shell shlBuildAndSign;
    private Text certFileTextbox;
    private Text passwordTextbox;
    private Table aliasTable;
    private Text apkFileTextbox;
    private Button btnSelectFile;
    private Label lblKeystoreFile;
    private Label lblCertificate;
    private Label lblPassword;
    private Control[] keystoreObj;
    private Control[] signObj;
    private Composite composite_1;
    private Composite composite_2;
    private Composite composite_3;
    private Button btnSignApk;

    public BuildAndSignApkDialog(Shell parent) {
        this(parent, 67680);
    }

    public BuildAndSignApkDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("Select certificate");
        this.result = new BuildAndSignApkBean();
    }

    public BuildAndSignApkBean open() {
        this.createContents();
        this.shlBuildAndSign.open();
        this.shlBuildAndSign.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlBuildAndSign.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shlBuildAndSign = new Shell(this.getParent(), 2160);
        this.shlBuildAndSign.setSize(420, 471);
        this.shlBuildAndSign.setText("Build and sign APK");
        GridLayout gl_shlBuildAndSign = new GridLayout(1, false);
        gl_shlBuildAndSign.horizontalSpacing = 0;
        gl_shlBuildAndSign.marginBottom = 5;
        gl_shlBuildAndSign.marginRight = 5;
        gl_shlBuildAndSign.marginLeft = 5;
        gl_shlBuildAndSign.verticalSpacing = 0;
        gl_shlBuildAndSign.marginWidth = 0;
        gl_shlBuildAndSign.marginTop = 5;
        gl_shlBuildAndSign.marginHeight = 0;
        this.shlBuildAndSign.setLayout((Layout)gl_shlBuildAndSign);
        Label lblDestinationApkFile = new Label((Composite)this.shlBuildAndSign, 0);
        lblDestinationApkFile.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblDestinationApkFile.setText("Destination APK file:");
        Composite composite = new Composite((Composite)this.shlBuildAndSign, 0);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.apkFileTextbox = new Text(composite, 2048);
        this.apkFileTextbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSelectFile = new Button(composite, 0);
        this.btnSelectFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnSelectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String file = GuiWorkshop.selectSaveFile(BuildAndSignApkDialog.this.getParent(), new String[]{"*.apk"});
                if (file != null) {
                    BuildAndSignApkDialog.this.apkFileTextbox.setText(file);
                }
            }
        });
        this.btnSelectFile.setText("Select File");
        this.btnSignApk = new Button((Composite)this.shlBuildAndSign, 32);
        this.btnSignApk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!BuildAndSignApkDialog.this.btnSignApk.getSelection()) {
                    Control[] controlArray = BuildAndSignApkDialog.this.signObj;
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        logger.debug((Object)c);
                        c.setEnabled(false);
                        ++n2;
                    }
                } else {
                    Control[] controlArray = BuildAndSignApkDialog.this.signObj;
                    int n = controlArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Control c = controlArray[n3];
                        c.setEnabled(true);
                        ++n3;
                    }
                }
            }
        });
        this.btnSignApk.setText("Sign APK");
        new Label((Composite)this.shlBuildAndSign, 0);
        final Button btnGenerateKeystoreOn = new Button((Composite)this.shlBuildAndSign, 32);
        btnGenerateKeystoreOn.setEnabled(false);
        btnGenerateKeystoreOn.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        btnGenerateKeystoreOn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (btnGenerateKeystoreOn.getSelection()) {
                    Control[] controlArray = BuildAndSignApkDialog.this.keystoreObj;
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control c = controlArray[n2];
                        logger.debug((Object)c);
                        c.setEnabled(false);
                        ++n2;
                    }
                } else {
                    Control[] controlArray = BuildAndSignApkDialog.this.keystoreObj;
                    int n = controlArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Control c = controlArray[n3];
                        c.setEnabled(true);
                        ++n3;
                    }
                }
            }
        });
        btnGenerateKeystoreOn.setText("Automatically generate keystore");
        this.lblKeystoreFile = new Label((Composite)this.shlBuildAndSign, 0);
        this.lblKeystoreFile.setEnabled(false);
        this.lblKeystoreFile.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblKeystoreFile.setText("Keystore file:");
        this.composite_1 = new Composite((Composite)this.shlBuildAndSign, 0);
        this.composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_1 = new GridLayout(3, false);
        gl_composite_1.verticalSpacing = 0;
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        gl_composite_1.horizontalSpacing = 0;
        this.composite_1.setLayout((Layout)gl_composite_1);
        this.certFileTextbox = new Text(this.composite_1, 2048);
        this.certFileTextbox.setEnabled(false);
        this.certFileTextbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnNewButton = new Button(this.composite_1, 0);
        btnNewButton.setEnabled(false);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String file = GuiWorkshop.selectFile(BuildAndSignApkDialog.this.getParent(), new String[]{"*"});
                if (file != null) {
                    BuildAndSignApkDialog.this.certFileTextbox.setText(file);
                }
            }
        });
        btnNewButton.setText("Select File");
        new Label(this.composite_1, 0);
        this.lblPassword = new Label((Composite)this.shlBuildAndSign, 0);
        this.lblPassword.setEnabled(false);
        this.lblPassword.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblPassword.setText("Password:");
        this.composite_2 = new Composite((Composite)this.shlBuildAndSign, 0);
        this.composite_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.marginBottom = 5;
        gl_composite_2.marginTop = 5;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.verticalSpacing = 0;
        this.composite_2.setLayout((Layout)gl_composite_2);
        this.passwordTextbox = new Text(this.composite_2, 0x400800);
        this.passwordTextbox.setEnabled(false);
        this.passwordTextbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.passwordTextbox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                try {
                    KeyStore ks = KeyStore.getInstance(KeyStoreUtil.niceStoreTypeName(KeyStore.getDefaultType()));
                    ks.load(new File(BuildAndSignApkDialog.this.certFileTextbox.getText()).toURI().toURL().openStream(), BuildAndSignApkDialog.this.passwordTextbox.getTextChars());
                    Enumeration<String> aliases = ks.aliases();
                    BuildAndSignApkDialog.this.aliasTable.clearAll();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        Certificate cert = ks.getCertificate(alias);
                        byte[] encCertInfo = cert.getEncoded();
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        byte[] digest = md.digest(encCertInfo);
                        String key = BuildAndSignApkDialog.this.toHexString(digest);
                        TableItem tableItem = new TableItem(BuildAndSignApkDialog.this.aliasTable, 0);
                        tableItem.setText(new String[]{alias, ks.getCreationDate(alias).toString(), key});
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.lblCertificate = new Label((Composite)this.shlBuildAndSign, 0);
        this.lblCertificate.setEnabled(false);
        this.lblCertificate.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lblCertificate.setText("Certificate:");
        this.aliasTable = new Table((Composite)this.shlBuildAndSign, 67584);
        this.aliasTable.setEnabled(false);
        GridData gd_aliasTable = new GridData(4, 4, true, true, 3, 1);
        gd_aliasTable.heightHint = 72;
        this.aliasTable.setLayoutData((Object)gd_aliasTable);
        this.aliasTable.setHeaderVisible(true);
        this.aliasTable.setLinesVisible(true);
        TableColumn tblclmnName = new TableColumn(this.aliasTable, 0);
        tblclmnName.setWidth(100);
        tblclmnName.setText("Name");
        TableColumn tblclmnDate = new TableColumn(this.aliasTable, 0);
        tblclmnDate.setWidth(100);
        tblclmnDate.setText("Date");
        TableColumn tblclmnChecksum = new TableColumn(this.aliasTable, 0);
        tblclmnChecksum.setWidth(149);
        tblclmnChecksum.setText("Checksum");
        this.composite_3 = new Composite((Composite)this.shlBuildAndSign, 0);
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.horizontalSpacing = 0;
        gl_composite_3.marginWidth = 0;
        gl_composite_3.marginHeight = 0;
        gl_composite_3.verticalSpacing = 0;
        this.composite_3.setLayout((Layout)gl_composite_3);
        this.composite_3.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        Button btnSelect = new Button(this.composite_3, 0);
        btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void widgetSelected(SelectionEvent arg0) {
                if (BuildAndSignApkDialog.this.apkFileTextbox.getText().trim().equals("")) {
                    GuiWorkshop.messageError(BuildAndSignApkDialog.this.shlBuildAndSign, "Please select a filename.");
                    return;
                }
                if (!BuildAndSignApkDialog.this.btnSignApk.getSelection()) {
                    BuildAndSignApkDialog.this.result.setApkFilename(BuildAndSignApkDialog.this.apkFileTextbox.getText());
                    BuildAndSignApkDialog.this.result.setSign(BuildAndSignApkDialog.this.btnSignApk.getSelection());
                    BuildAndSignApkDialog.this.shlBuildAndSign.close();
                    return;
                }
                if (btnGenerateKeystoreOn.getSelection()) {
                    try {
                        String alias = OterStatics.SOME_STRING;
                        String password = OterStatics.SOME_STRING;
                        KeyStore ks = SmaliWorkshop.createKeystoreWithSecretKey(alias);
                        File ksFile = SmaliWorkshop.writeKeystoreToTemporaryFile(ks, password);
                        BuildAndSignApkDialog.this.result.setApkFilename(BuildAndSignApkDialog.this.apkFileTextbox.getText());
                        BuildAndSignApkDialog.this.result.setSign(BuildAndSignApkDialog.this.btnSignApk.getSelection());
                        BuildAndSignApkDialog.this.result.setCertFilename(ksFile.getAbsolutePath());
                        BuildAndSignApkDialog.this.result.setPassword(password);
                        BuildAndSignApkDialog.this.result.setCertAlias(alias);
                        BuildAndSignApkDialog.this.shlBuildAndSign.close();
                        return;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error generating keystore: ", (Throwable)e);
                        GuiWorkshop.messageError(BuildAndSignApkDialog.this.shlBuildAndSign, "There was an error generating the keystore: " + e.getMessage());
                        return;
                    }
                }
                if (BuildAndSignApkDialog.this.aliasTable.getSelection().length > 0) {
                    BuildAndSignApkDialog.this.result.setApkFilename(BuildAndSignApkDialog.this.apkFileTextbox.getText());
                    BuildAndSignApkDialog.this.result.setSign(BuildAndSignApkDialog.this.btnSignApk.getSelection());
                    BuildAndSignApkDialog.this.result.setCertFilename(BuildAndSignApkDialog.this.certFileTextbox.getText());
                    BuildAndSignApkDialog.this.result.setPassword(BuildAndSignApkDialog.this.passwordTextbox.getText());
                    BuildAndSignApkDialog.this.result.setCertAlias(BuildAndSignApkDialog.this.aliasTable.getSelection()[0].getText(0));
                    BuildAndSignApkDialog.this.result.setSign(BuildAndSignApkDialog.this.btnSignApk.getSelection());
                    BuildAndSignApkDialog.this.shlBuildAndSign.close();
                    return;
                }
                logger.error((Object)"No alias selected.");
                GuiWorkshop.messageError(BuildAndSignApkDialog.this.shlBuildAndSign, "Please select an alias.");
            }
        });
        btnSelect.setText("Save");
        Button btnCancel = new Button(this.composite_3, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BuildAndSignApkDialog.this.result = null;
                BuildAndSignApkDialog.this.shlBuildAndSign.close();
            }
        });
        btnCancel.setText("Cancel");
        this.keystoreObj = new Control[]{this.certFileTextbox, this.passwordTextbox, this.aliasTable, btnNewButton, this.lblKeystoreFile, this.lblCertificate, this.lblPassword};
        this.signObj = new Control[]{btnGenerateKeystoreOn, this.certFileTextbox, this.passwordTextbox, this.aliasTable, btnNewButton, this.lblKeystoreFile, this.lblCertificate, this.lblPassword};
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        int i = 0;
        while (i < len) {
            this.byte2hex(block[i], buf);
            if (i < len - 1) {
                buf.append(":");
            }
            ++i;
        }
        return buf.toString();
    }

    private void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }
}

