/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.styler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SmaliLineStyler
implements LineStyleListener {
    private static Logger logger = Logger.getLogger(SmaliLineStyler.class);
    private Display display = Display.getDefault();
    private Map<String, Color> colorMap = new HashMap<String, Color>();

    public SmaliLineStyler() {
        this.colorMap.put("quote", new Color((Device)this.display, new RGB(0, 0, 255)));
        this.colorMap.put("comment", this.display.getSystemColor(6));
        this.colorMap.put("colon", new Color((Device)this.display, new RGB(128, 0, 128)));
        this.colorMap.put("dot", this.display.getSystemColor(14));
        this.colorMap.put("register", this.display.getSystemColor(4));
    }

    public void lineGetStyle(LineStyleEvent event) {
        boolean midStyle = false;
        int start = 0;
        int terminator = 59;
        int lastChar = 126;
        LinkedList<StyleRange> styles = new LinkedList<StyleRange>();
        StyleRange x = new StyleRange();
        StyleRange style = null;
        int i = 0;
        while (i < event.lineText.length()) {
            int subj = event.lineText.charAt(i);
            if (!midStyle) {
                if (subj == 35) {
                    logger.debug((Object)"Comment");
                    style = new StyleRange();
                    style.start = event.lineOffset + i;
                    style.foreground = this.colorMap.get("comment");
                    midStyle = true;
                    start = i;
                } else if (subj == 34 || subj == 39) {
                    logger.debug((Object)"Quote");
                    style = new StyleRange();
                    style.start = event.lineOffset + i;
                    style.foreground = this.colorMap.get("quote");
                    midStyle = true;
                    start = i;
                } else if (subj == 58 && lastChar == 32) {
                    logger.debug((Object)"Colon");
                    style = new StyleRange();
                    style.start = event.lineOffset + i;
                    style.foreground = this.colorMap.get("colon");
                    terminator = 32;
                    midStyle = true;
                    start = i;
                } else if (subj == 46) {
                    logger.debug((Object)"Dot");
                    style = new StyleRange();
                    style.start = event.lineOffset + i;
                    style.foreground = this.colorMap.get("dot");
                    terminator = 32;
                    midStyle = true;
                    start = i;
                }
            } else if (i == event.lineText.length() - 1) {
                style.length = event.lineText.length() - start;
                styles.add(style);
                logger.debug((Object)("Adding: start: " + style.start + ", length = " + style.length));
                midStyle = false;
                start = 0;
            } else if (subj != 59) {
                if (subj == 34 || subj == 39) {
                    style.length = i - start;
                    styles.add(style);
                    logger.debug((Object)("Adding: start: " + style.start + ", length = " + style.length));
                    midStyle = false;
                    start = 0;
                    terminator = 59;
                } else if (subj == 125 || subj == 44) {
                    style.length = i - start;
                    styles.add(style);
                    logger.debug((Object)("Adding: start: " + style.start + ", length = " + style.length));
                    midStyle = false;
                    start = 0;
                    terminator = 59;
                } else if (subj == terminator) {
                    style.length = i - start;
                    styles.add(style);
                    logger.debug((Object)("Adding: start: " + style.start + ", length = " + style.length));
                    midStyle = false;
                    start = 0;
                    terminator = 59;
                }
            }
            lastChar = subj;
            ++i;
        }
        if (style != null) {
            styles.add(style);
        }
        event.styles = styles.toArray(new StyleRange[0]);
    }
}

