/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.smali;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.command.TerminatingCommand;
import com.wuntee.oter.exception.BuildApkException;
import com.wuntee.oter.exception.SmaliDexException;
import com.wuntee.oter.exception.SmaliSyntaxException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.log4j.Logger;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;
import org.jf.util.IndentingWriter;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;

public class SmaliWorkshop {
    private static Logger logger = Logger.getLogger(SmaliWorkshop.class);
    public static String CLASSTYPE_HEAD = "type_id_item: L";

    public static String classDefItemToFilename(ClassDefItem c) {
        String ct = c.getClassType().toString();
        String ret = ct.substring(CLASSTYPE_HEAD.length(), ct.length() - 1).replace("/", ".");
        return ret;
    }

    public static File createSmaliClassFile(File tmpDir, ClassDefItem c) throws IOException {
        String ct = c.getClassType().toString();
        ct = ct.replace("/", System.getProperty("file.separator"));
        String fullPath = String.valueOf(tmpDir.getAbsolutePath()) + System.getProperty("file.separator") + ct.substring(CLASSTYPE_HEAD.length(), ct.length() - 1) + ".smali";
        logger.debug((Object)("Full path: " + fullPath));
        String dirPath = fullPath.substring(0, fullPath.lastIndexOf(System.getProperty("file.separator")));
        logger.debug((Object)("Creating directory: " + dirPath));
        File dir = OterWorkshop.createDirectoryRecursive(dirPath);
        File ret = new File(fullPath);
        if (!ret.exists()) {
            ret.createNewFile();
        }
        return ret;
    }

    public static Map<String, File> getSmaliSource(File sourceSmaliOrDexFile, File destinationDirectory) throws IOException {
        HashMap<String, File> ret = new HashMap<String, File>();
        DexFile dexFile = new DexFile(sourceSmaliOrDexFile);
        for (ClassDefItem c : dexFile.ClassDefsSection.getItems()) {
            File classFile = SmaliWorkshop.createSmaliClassFile(destinationDirectory, c);
            String className = SmaliWorkshop.classDefItemToFilename(c);
            logger.debug((Object)("Got class: " + className + " [" + classFile + "]"));
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            IndentingWriter idWriter = new IndentingWriter((Writer)fileWriter);
            ClassDefinition cd = new ClassDefinition(c);
            cd.writeTo(idWriter);
            ret.put(className, classFile);
            idWriter.close();
        }
        return SmaliWorkshop.sortMapByKey(ret);
    }

    private static Map<String, File> sortMapByKey(Map<String, File> aItems) {
        TreeMap<String, File> result = new TreeMap<String, File>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(aItems);
        return result;
    }

    public static void buildApk(File sourceApk, File smaliSourceDirectory, File destinationApkFile) throws BuildApkException {
        try {
            File apkDirectory = OterWorkshop.createTemporaryDirectory("aat.newapk");
            OterWorkshop.unzipArchive(sourceApk, apkDirectory);
            File metaInfDirectory = new File(String.valueOf(apkDirectory.getAbsolutePath()) + System.getProperty("file.separator") + "META-INF");
            if (metaInfDirectory.exists() && metaInfDirectory.isDirectory()) {
                logger.info((Object)("Deleting: " + metaInfDirectory.getAbsolutePath()));
                File[] fileArray = metaInfDirectory.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    f.delete();
                    ++n2;
                }
            } else {
                logger.warn((Object)"META-INF directory did not exist");
            }
            logger.debug((Object)metaInfDirectory.getAbsoluteFile());
            metaInfDirectory.mkdir();
            File destinationDexFile = new File(apkDirectory.getAbsoluteFile() + System.getProperty("file.separator") + OterStatics.CLASSES_DEX);
            logger.debug((Object)("Building dex file: " + destinationDexFile.getAbsolutePath()));
            SmaliWorkshop.buildDex(smaliSourceDirectory, destinationDexFile);
            logger.debug((Object)("Ziping archive to: " + destinationApkFile.getAbsolutePath()));
            OterWorkshop.zipArchive(destinationApkFile, apkDirectory);
        }
        catch (Exception e) {
            logger.error((Object)"Could not build apk: ", (Throwable)e);
            throw new BuildApkException(e.getMessage());
        }
    }

    private static void buildDex(File smaliSourceDirectory, File destination) throws RecognitionException, SmaliSyntaxException, SmaliDexException, IOException {
        DexFile dexFile = new DexFile();
        logger.debug((Object)"Loading smali files");
        LinkedHashSet<File> filesToProcess = new LinkedHashSet<File>();
        SmaliWorkshop.getSmaliFilesInDir(smaliSourceDirectory, filesToProcess);
        logger.debug((Object)"Processing files");
        for (File file : filesToProcess) {
            logger.debug((Object)("Processing: " + file.getAbsolutePath()));
            FileInputStream fis = new FileInputStream(file.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            smaliFlexLexer lexer = new smaliFlexLexer((Reader)reader);
            lexer.setSourceFile(file);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            smaliParser parser = new smaliParser((TokenStream)tokens);
            smaliParser.smali_file_return result = parser.smali_file();
            if (parser.getNumberOfSyntaxErrors() > 0) {
                throw new SmaliSyntaxException(file, parser.getNumberOfSyntaxErrors());
            }
            if (lexer.getNumberOfSyntaxErrors() > 0) {
                throw new SmaliSyntaxException(file, lexer.getNumberOfSyntaxErrors());
            }
            CommonTree t = (CommonTree)result.getTree();
            CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)t);
            treeStream.setTokenStream((TokenStream)tokens);
            smaliTreeWalker dexGen = new smaliTreeWalker((TreeNodeStream)treeStream);
            dexGen.dexFile = dexFile;
            dexGen.smali_file();
            if (dexGen.getNumberOfSyntaxErrors() <= 0) continue;
            throw new SmaliDexException(file, dexGen.getNumberOfSyntaxErrors());
        }
        logger.debug((Object)"Writing dex file.");
        dexFile.place();
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        dexFile.writeTo((AnnotatedOutput)out);
        byte[] bytes = out.toByteArray();
        DexFile.calcSignature((byte[])bytes);
        DexFile.calcChecksum((byte[])bytes);
        FileOutputStream fileOutputStream = new FileOutputStream(destination);
        fileOutputStream.write(bytes);
        fileOutputStream.close();
    }

    private static void getSmaliFilesInDir(File dir, Set<File> smaliFiles) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                SmaliWorkshop.getSmaliFilesInDir(file, smaliFiles);
            } else if (file.getName().endsWith(".smali")) {
                smaliFiles.add(file);
            }
            ++n2;
        }
    }

    public static void signJar(String keystore, String keystorePassword, String jarFile, String alias) throws Exception {
        TerminatingCommand c = new TerminatingCommand(new String[]{"jarsigner", "-digestalg", "SHA1", "-sigalg", "MD5withRSA", "-keystore", keystore, "-storepass", keystorePassword, jarFile, alias});
        int ret = c.execute();
        if (ret != 0) {
            String output = "";
            for (String o : c.getOutput()) {
                output = String.valueOf(output) + o + "\n";
            }
            throw new Exception("Could not sign jar, jarsigner returned:\n" + output);
        }
    }

    public static KeyStore createKeystoreWithSecretKey(String alias) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, IOException, InvalidKeyException, SignatureException {
        KeyStore ret = KeyStore.getInstance(KeyStore.getDefaultType());
        ret.load(null);
        int keysize = 1024;
        int validity = 10000;
        String keyAlgName = "RSA";
        String sigAlgName = "SHA1WithRSA";
        CertAndKeyGen keypair = new CertAndKeyGen(keyAlgName, sigAlgName, null);
        X500Name x500Name = new X500Name(OterStatics.SOME_STRING, OterStatics.SOME_STRING, OterStatics.SOME_STRING, OterStatics.SOME_STRING, OterStatics.SOME_STRING, OterStatics.SOME_STRING);
        keypair.generate(keysize);
        PrivateKey privKey = keypair.getPrivateKey();
        Certificate[] chain = new X509Certificate[]{keypair.getSelfCertificate(x500Name, (long)validity * 24L * 60L * 60L)};
        ret.setKeyEntry(alias, privKey, OterStatics.SOME_STRING.toCharArray(), chain);
        return ret;
    }

    public static File writeKeystoreToTemporaryFile(KeyStore ks, String password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        File tmp = File.createTempFile(OterStatics.TEMP_PREFIX, "keystore");
        logger.debug((Object)("Writing keystore to: " + tmp.getAbsolutePath()));
        FileOutputStream out = new FileOutputStream(tmp);
        ks.store(out, password.toCharArray());
        return tmp;
    }
}

