/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.smali;

import com.wuntee.oter.OterStatics;
import com.wuntee.oter.OterWorkshop;
import com.wuntee.oter.adb.AdbWorkshop;
import com.wuntee.oter.exception.BuildApkException;
import com.wuntee.oter.packagemanager.PackageBean;
import com.wuntee.oter.smali.SmaliWorkshop;
import com.wuntee.oter.styler.SmaliLineStyler;
import com.wuntee.oter.view.FindDialog;
import com.wuntee.oter.view.Gui;
import com.wuntee.oter.view.GuiWorkshop;
import com.wuntee.oter.view.bean.BuildAndSignApkBean;
import com.wuntee.oter.view.widgets.CTabItemWithStyledText;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class SmaliController {
    private static Logger logger = Logger.getLogger(SmaliController.class);
    private Map<String, File> smaliMap;
    private File currentApk;
    private File baksmaliDir;
    public static final String FILENAME = "filename";
    public static final String LINENUMBER = "linenum";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    public static final String PACKAGE = "package";
    public static final String MODIFIED = "modified";
    public static final String ORIGINAL_TEXT = "originaltext";
    private Gui gui;

    public SmaliController(Gui gui) {
        this.gui = gui;
    }

    public void search() {
        String searchString = this.gui.getSmaliSearchText().getText();
        this.gui.setStatus("Searching: " + searchString);
        logger.debug((Object)("Searching for: '" + searchString + "'"));
        if (this.currentApk == null) {
            GuiWorkshop.messageError(this.gui.getShell(), "Please load an APK prior to searching.");
        } else if (searchString == null || searchString.equals("")) {
            GuiWorkshop.messageError(this.gui.getShell(), "Please enter a string to search for.");
        } else {
            if (this.gui.getSmaliSearchRegex().getSelection()) {
                try {
                    OterStatics.SOME_STRING.matches(searchString);
                }
                catch (Exception e) {
                    GuiWorkshop.messageError(this.gui.getShell(), "Please enter a correct regex: " + e.getMessage());
                    return;
                }
            }
            this.gui.runRunnableAsync(new SearchRunnable(searchString));
        }
    }

    public void saveTab(CTabItem tab) throws IOException {
        if (((Boolean)tab.getData(MODIFIED)).booleanValue()) {
            String file = (String)tab.getData(FILENAME);
            logger.debug((Object)("Saving file: " + file));
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            StyledText styledText = (StyledText)tab.getData(StyledText.class.getName());
            out.write(styledText.getText());
            out.flush();
            out.close();
            tab.setData(ORIGINAL_TEXT, (Object)styledText.getText());
            tab.setData(MODIFIED, (Object)false);
            tab.setText(tab.getText().substring(2));
        }
    }

    public void loadApk(File apk) {
        Thread x = new Thread(new LoadApkRunnable(apk));
        x.start();
    }

    public void loadApkFromDevice(PackageBean bean) {
        try {
            File f = AdbWorkshop.pullFile(bean.getApk());
            this.loadApk(f);
        }
        catch (Exception e) {
            logger.error((Object)"Could not load package: ", (Throwable)e);
            GuiWorkshop.messageError(this.gui.getShell(), "Could not load package: " + e.getMessage());
        }
    }

    public void loadSmaliSource(String pkg, String name) {
        logger.debug((Object)("pkg: " + pkg));
        logger.debug((Object)("name: " + name));
        this.gui.runRunnableAsync(new LoadSmaliSource(pkg, name));
    }

    public void loadSmaliSourceWithLineNumber(String pkg, String name, int line) {
        logger.debug((Object)("pkg: " + pkg));
        logger.debug((Object)("name: " + name));
        this.gui.runRunnableAsync(new LoadSmaliSource(pkg, name, line));
    }

    public File rebuildApk(String filename) {
        this.gui.setStatus("Building APK: " + filename);
        try {
            SmaliWorkshop.buildApk(this.currentApk, this.baksmaliDir, new File(filename));
            GuiWorkshop.messageDialog(this.gui.getShell(), "The APK has been built.");
        }
        catch (Exception e) {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not build APK: " + e.getMessage());
            logger.error((Object)"Could not build APK: ", (Throwable)e);
        }
        this.gui.clearStatus();
        return new File(filename);
    }

    public void rebuildAndSignApk(BuildAndSignApkBean bean) {
        try {
            this.gui.setStatus("Building APK: " + bean.getApkFilename());
            SmaliWorkshop.buildApk(this.currentApk, this.baksmaliDir, new File(bean.getApkFilename()));
            try {
                this.gui.setStatus("Signing APK: " + bean.getApkFilename());
                SmaliWorkshop.signJar(bean.getCertFilename(), bean.getPassword(), bean.getApkFilename(), bean.getCertAlias());
                GuiWorkshop.messageDialog(this.gui.getShell(), "The APK has been built and signed.");
            }
            catch (Exception e) {
                GuiWorkshop.messageError(this.gui.getShell(), "Could not sign APK: " + e.getMessage());
                logger.error((Object)"Could not sign APK: ", (Throwable)e);
            }
        }
        catch (BuildApkException e) {
            GuiWorkshop.messageError(this.gui.getShell(), "Could not build APK: " + e.getMessage());
            logger.error((Object)"Could not build APK: ", (Throwable)e);
        }
        this.gui.clearStatus();
    }

    public boolean unsavedFilesOpen() {
        CTabItem[] cTabItemArray = this.gui.getSmaliTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getShowClose() && ((Boolean)tab.getData(MODIFIED)).booleanValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private CTabItem getTabByFullClasspath(String classPath) {
        CTabItem[] cTabItemArray = this.gui.getSmaliTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getShowClose() && ((String)tab.getData(CLASS)).equals(classPath)) {
                return tab;
            }
            ++n2;
        }
        return null;
    }

    private StyledText getStyledTextByFullClasspath(String classPath) {
        CTabItem[] cTabItemArray = this.gui.getSmaliTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getShowClose() && ((String)tab.getData(CLASS)).equals(classPath)) {
                return (StyledText)tab.getData(StyledText.class.getName());
            }
            ++n2;
        }
        return null;
    }

    private void addTextMenu(final StyledText styledText) {
        Shell shell = styledText.getShell();
        Menu menu = new Menu((Decorations)shell, 8);
        MenuItem findItem = new MenuItem(menu, 0);
        findItem.setText("Find");
        findItem.setAccelerator(SWT.MOD1 + 70);
        findItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new FindDialog(SmaliController.this.gui.getShell(), styledText).open();
            }
        });
        MenuItem item = new MenuItem(menu, 0);
        item.setText("Cut");
        item.setAccelerator(SWT.MOD1 + 88);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                styledText.cut();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Copy");
        item.setAccelerator(SWT.MOD1 + 67);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                styledText.copy();
            }
        });
        item = new MenuItem(menu, 0);
        item.setText("Paste");
        item.setAccelerator(SWT.MOD1 + 86);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                styledText.paste();
            }
        });
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 0);
        item.setText("Select All");
        item.setAccelerator(SWT.MOD1 + 65);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                styledText.selectAll();
            }
        });
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 0);
        item.setText("Save");
        item.setAccelerator(SWT.MOD1 + 115);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    SmaliController.this.saveTab(SmaliController.this.getOpenSmaliTabByStyledText(styledText));
                }
                catch (IOException e) {
                    GuiWorkshop.messageError(SmaliController.this.gui.getShell(), "Could not save the file: " + e.getMessage());
                    logger.error((Object)"Could not save the file: ", (Throwable)e);
                }
            }
        });
        styledText.setMenu(menu);
    }

    private CTabItem getOpenSmaliTabByStyledText(StyledText item) {
        CTabItem[] cTabItemArray = this.gui.getSmaliTabFolder().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getShowClose() && ((StyledText)tab.getData(StyledText.class.getName())).equals(item)) {
                return tab;
            }
            ++n2;
        }
        return null;
    }

    private class LoadApkRunnable
    implements Runnable {
        private Tree tree;
        private File apk;

        public LoadApkRunnable(File apk) {
            this.apk = apk;
            this.tree = SmaliController.this.gui.getSmaliTree();
        }

        @Override
        public void run() {
            SmaliController.this.gui.setStatus("Loading APK: " + this.apk.getAbsolutePath());
            try {
                SmaliController.this.baksmaliDir = OterWorkshop.createTemporaryDirectory("aat.baksmali");
                SmaliController.this.smaliMap = SmaliWorkshop.getSmaliSource(this.apk, SmaliController.this.baksmaliDir);
                SmaliController.this.gui.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LoadApkRunnable.this.tree.removeAll();
                        SmaliController.this.currentApk = LoadApkRunnable.this.apk;
                        for (String c : SmaliController.this.smaliMap.keySet()) {
                            String name;
                            int lastSlash = c.lastIndexOf(".");
                            String pkg = "";
                            if (lastSlash == -1) {
                                name = c;
                                TreeItem item = new TreeItem(LoadApkRunnable.this.tree, 0);
                                item.setText(name);
                                continue;
                            }
                            pkg = c.substring(0, lastSlash);
                            name = c.substring(lastSlash + 1, c.length());
                            TreeItem existsInTree = LoadApkRunnable.this.getInTree(pkg);
                            if (existsInTree != null) {
                                TreeItem item = new TreeItem(existsInTree, 0);
                                item.setText(name);
                                continue;
                            }
                            TreeItem pkgTreeItem = new TreeItem(LoadApkRunnable.this.tree, 0);
                            pkgTreeItem.setImage(SWTResourceManager.getImage(Gui.class, OterStatics.ICON_PACKAGE));
                            pkgTreeItem.setText(pkg);
                            TreeItem item = new TreeItem(pkgTreeItem, 0);
                            item.setText(name);
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)"Could not load file: ", (Throwable)e);
                GuiWorkshop.messageErrorThreaded(SmaliController.this.gui, "Could not load file: " + e.getMessage());
            }
            SmaliController.this.gui.clearStatus();
        }

        private TreeItem getInTree(String pkg) {
            TreeItem[] treeItemArray = this.tree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem i = treeItemArray[n2];
                if (i.getText().equals(pkg)) {
                    return i;
                }
                ++n2;
            }
            return null;
        }
    }

    private class LoadSmaliSource
    implements Runnable {
        private int line = -1;
        private String pkg;
        private String name;
        private String full;

        public LoadSmaliSource(String pkg, String name, int line) {
            this.line = line;
            this.pkg = pkg;
            this.name = name;
            this.full = pkg.equals("") ? name : String.valueOf(pkg) + "." + name;
        }

        public LoadSmaliSource(String pkg, String name) {
            this.pkg = pkg;
            this.name = name;
            this.full = pkg.equals("") ? name : String.valueOf(pkg) + "." + name;
        }

        @Override
        public void run() {
            CTabFolder smaliTabFolder = SmaliController.this.gui.getSmaliTabFolder();
            CTabItem openFileTab = SmaliController.this.getTabByFullClasspath(this.full);
            if (openFileTab != null) {
                StyledText styledText;
                smaliTabFolder.setSelection(openFileTab);
                if (this.line > -1 && (styledText = SmaliController.this.getStyledTextByFullClasspath(this.full)) != null) {
                    styledText.setTopIndex(this.line);
                }
            } else {
                try {
                    String line;
                    File source = (File)SmaliController.this.smaliMap.get(this.full);
                    logger.debug((Object)("Loading: " + this.full + " : " + source));
                    BufferedReader in = new BufferedReader(new FileReader(source));
                    String buf = "";
                    while ((line = in.readLine()) != null) {
                        buf = String.valueOf(buf) + "\n" + line;
                    }
                    CTabItemWithStyledText tabItem = new CTabItemWithStyledText(smaliTabFolder, this.name, 64);
                    tabItem.getStyledText().addLineStyleListener((LineStyleListener)new SmaliLineStyler());
                    tabItem.getStyledText().setText(buf);
                    tabItem.getStyledText().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            CTabItem[] cTabItemArray = SmaliController.this.gui.getSmaliTabFolder().getItems();
                            int n = cTabItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                StyledText styledText;
                                CTabItem tab = cTabItemArray[n2];
                                if (tab.getShowClose() && (styledText = (StyledText)tab.getData(StyledText.class.getName())) == arg0.getSource()) {
                                    if (!((Boolean)tab.getData(SmaliController.MODIFIED)).booleanValue()) {
                                        tab.setData(SmaliController.MODIFIED, (Object)true);
                                        tab.setText("* " + tab.getText());
                                    } else if (styledText.getText().equals(tab.getData(SmaliController.ORIGINAL_TEXT))) {
                                        tab.setData(SmaliController.MODIFIED, (Object)false);
                                        tab.setText(tab.getText().substring(2));
                                    }
                                }
                                ++n2;
                            }
                        }
                    });
                    SmaliController.this.addTextMenu(tabItem.getStyledText());
                    if (this.line > -1) {
                        tabItem.getStyledText().setTopIndex(this.line);
                    }
                    tabItem.setData(SmaliController.ORIGINAL_TEXT, buf);
                    tabItem.setData(SmaliController.MODIFIED, false);
                    tabItem.setData(SmaliController.CLASS, this.full);
                    tabItem.setData(SmaliController.FILENAME, source.getAbsolutePath());
                }
                catch (Exception e) {
                    SmaliController.this.gui.messageError("Could not open load smali: " + e.getMessage());
                    logger.error((Object)"Could not open load smali:", (Throwable)e);
                }
            }
        }
    }

    private class SearchRunnable
    implements Runnable {
        private Table table;
        private String searchString;

        public SearchRunnable(String searchString) {
            this.searchString = searchString;
            this.table = SmaliController.this.gui.getSmaliSearchTable();
            this.table.removeAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = SmaliController.this.baksmaliDir;
            synchronized (file) {
                this.search(SmaliController.this.baksmaliDir);
            }
            SmaliController.this.gui.clearStatus();
        }

        private void search(File file) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.search(f);
                    ++n2;
                }
            } else {
                this.searchFile(file);
            }
        }

        private void searchFile(File f) {
            try {
                String strLine;
                int start = SmaliController.this.baksmaliDir.getAbsolutePath().length() + 1;
                String clazz = f.getAbsolutePath().substring(start, f.getAbsolutePath().length() - ".smali".length()).replace(System.getProperty("file.separator"), ".");
                logger.debug((Object)("Searching for '" + this.searchString + "' in: " + f.getAbsolutePath()));
                FileInputStream fstream = new FileInputStream(f);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                int line = 0;
                while ((strLine = br.readLine()) != null) {
                    String searchStrLine = strLine;
                    if (SmaliController.this.gui.getSmaliSearchIgnoreCase().getSelection()) {
                        searchStrLine = strLine.toLowerCase();
                        this.searchString = this.searchString.toLowerCase();
                    }
                    if (SmaliController.this.gui.getSmaliSearchRegex().getSelection()) {
                        if (searchStrLine.matches(this.searchString)) {
                            this.addResult(f, line, strLine);
                        }
                    } else if (searchStrLine.indexOf(this.searchString) != -1) {
                        this.addResult(f, line, strLine);
                    }
                    ++line;
                }
            }
            catch (Exception e) {
                GuiWorkshop.messageError(SmaliController.this.gui.getShell(), "Could not search files: " + e.getMessage());
                logger.error((Object)"Could not search files:", (Throwable)e);
            }
        }

        private void addResult(File f, int line, String lineContents) {
            TableItem ti = new TableItem(this.table, 0);
            int start = SmaliController.this.baksmaliDir.getAbsolutePath().length() + 1;
            String clazz = f.getAbsolutePath().substring(start, f.getAbsolutePath().length() - ".smali".length()).replace(System.getProperty("file.separator"), ".");
            String name = f.getName().substring(0, f.getName().length() - ".smali".length());
            String pkg = "";
            if (clazz.length() != name.length()) {
                pkg = clazz.substring(0, clazz.length() - name.length() - 1);
            }
            logger.debug((Object)("Class: " + clazz));
            logger.debug((Object)("Pkg: " + pkg));
            logger.debug((Object)("Name: " + name));
            ti.setText(new String[]{clazz, lineContents});
            ti.setData(SmaliController.NAME, (Object)name);
            ti.setData(SmaliController.FILENAME, (Object)clazz);
            ti.setData(SmaliController.LINENUMBER, (Object)line);
            ti.setData(SmaliController.CLASS, (Object)clazz);
            ti.setData(SmaliController.PACKAGE, (Object)pkg);
        }
    }
}

