/*
 * Decompiled with CFR 0.152.
 */
package com.wuntee.oter.security.tools;

import com.sun.jarsigner.ContentSigner;
import com.sun.jarsigner.ContentSignerParameters;
import com.wuntee.oter.exception.JarSigningException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.IdentityScope;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.TimestampedSigner;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ManifestDigester;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.NetscapeCertTypeExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public class JarSigner {
    private static Logger logger = Logger.getLogger(JarSigner.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.tools.JarSignerResources");
    private static final Collator collator = Collator.getInstance();
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final Class[] PARAM_STRING;
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final long SIX_MONTHS = 15552000000L;
    static final int IN_KEYSTORE = 1;
    static final int IN_SCOPE = 2;
    X509Certificate[] certChain;
    PrivateKey privateKey;
    KeyStore store;
    IdentityScope scope;
    String keystore;
    boolean nullStream = false;
    boolean token = false;
    String jarfile;
    String alias;
    char[] storepass;
    boolean protectedPath;
    String storetype;
    String providerName;
    Vector<String> providers = null;
    HashMap<String, String> providerArgs = new HashMap();
    char[] keypass;
    String sigfile;
    String sigalg;
    String digestalg = "SHA1";
    String signedjar;
    String tsaUrl;
    String tsaAlias;
    boolean verify = false;
    boolean verbose = false;
    boolean showcerts = false;
    boolean debug = false;
    boolean signManifest = true;
    boolean externalSF = true;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
    private byte[] buffer = new byte[8192];
    private ContentSigner signingMechanism = null;
    private String altSignerClass = null;
    private String altSignerClasspath = null;
    private ZipFile zipFile = null;
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean notYetValidCert = false;
    private boolean badKeyUsage = false;
    private boolean badExtendedKeyUsage = false;
    private boolean badNetscapeCertType = false;

    static {
        collator.setStrength(0);
        PARAM_STRING = new Class[]{String.class};
    }

    public void signJar(String keystore, String keystorePassword, String jarName, String alias) throws Exception {
        this.keystore = keystore;
        this.storepass = keystorePassword.toCharArray();
        this.storetype = KeyStoreUtil.niceStoreTypeName(KeyStore.getDefaultType());
        if (P11KEYSTORE.equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.token = true;
        }
        this.hasExpiredCert = false;
        this.hasExpiringCert = false;
        this.notYetValidCert = false;
        this.badKeyUsage = false;
        this.badExtendedKeyUsage = false;
        this.badNetscapeCertType = false;
        this.loadKeyStore(keystore, true);
        this.getAliasInfo(alias);
        this.signJar(jarName, alias, null);
    }

    void signJar(String jarName, String alias, String[] args) throws Exception {
        File signedJarFile;
        File jarFile;
        block50: {
            boolean aliasUsed = false;
            X509Certificate tsaCert = null;
            if (this.sigfile == null) {
                this.sigfile = alias;
                aliasUsed = true;
            }
            this.sigfile = this.sigfile.length() > 8 ? this.sigfile.substring(0, 8).toUpperCase() : this.sigfile.toUpperCase();
            StringBuilder tmpSigFile = new StringBuilder(this.sigfile.length());
            int j = 0;
            while (j < this.sigfile.length()) {
                int c = this.sigfile.charAt(j);
                if (!(c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 95)) {
                    if (aliasUsed) {
                        c = 95;
                    } else {
                        throw new RuntimeException(rb.getString("signature filename must consist of the following characters: A-Z, 0-9, _ or -"));
                    }
                }
                tmpSigFile.append((char)c);
                ++j;
            }
            this.sigfile = tmpSigFile.toString();
            String tmpJarName = this.signedjar == null ? String.valueOf(jarName) + ".sig" : this.signedjar;
            jarFile = new File(jarName);
            signedJarFile = new File(tmpJarName);
            try {
                this.zipFile = new ZipFile(jarName);
            }
            catch (IOException ioe) {
                this.error(String.valueOf(rb.getString("unable to open jar file: ")) + jarName, ioe);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(signedJarFile);
            }
            catch (IOException ioe) {
                this.error(String.valueOf(rb.getString("unable to create: ")) + tmpJarName, ioe);
            }
            PrintStream ps = new PrintStream(fos);
            ZipOutputStream zos = new ZipOutputStream(ps);
            String sfFilename = (META_INF + this.sigfile + ".SF").toUpperCase();
            String bkFilename = (META_INF + this.sigfile + ".DSA").toUpperCase();
            Manifest manifest = new Manifest();
            Map<String, Attributes> mfEntries = manifest.getEntries();
            Attributes oldAttr = null;
            boolean mfModified = false;
            boolean mfCreated = false;
            byte[] mfRawBytes = null;
            try {
                try {
                    ZipEntry ze;
                    MessageDigest[] digests = new MessageDigest[]{MessageDigest.getInstance(this.digestalg)};
                    ZipEntry mfFile = this.getManifestFile(this.zipFile);
                    if (mfFile != null) {
                        mfRawBytes = this.getBytes(this.zipFile, mfFile);
                        manifest.read(new ByteArrayInputStream(mfRawBytes));
                        oldAttr = (Attributes)manifest.getMainAttributes().clone();
                    } else {
                        Attributes mattr = manifest.getMainAttributes();
                        mattr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                        String javaVendor = System.getProperty("java.vendor");
                        String jdkVersion = System.getProperty("java.version");
                        mattr.putValue("Created-By", String.valueOf(jdkVersion) + " (" + javaVendor + ")");
                        mfFile = new ZipEntry("META-INF/MANIFEST.MF");
                        mfCreated = true;
                    }
                    JarBASE64Encoder encoder = new JarBASE64Encoder();
                    Vector<ZipEntry> mfFiles = new Vector<ZipEntry>();
                    Enumeration<? extends ZipEntry> enum_ = this.zipFile.entries();
                    while (enum_.hasMoreElements()) {
                        ZipEntry ze2 = enum_.nextElement();
                        if (ze2.getName().startsWith(META_INF)) {
                            mfFiles.addElement(ze2);
                            if (this.signatureRelated(ze2.getName())) continue;
                        }
                        if (manifest.getAttributes(ze2.getName()) != null) {
                            if (!this.updateDigests(ze2, this.zipFile, digests, encoder, manifest)) continue;
                            mfModified = true;
                            continue;
                        }
                        if (ze2.isDirectory()) continue;
                        Attributes attrs = this.getDigestAttributes(ze2, this.zipFile, digests, encoder);
                        mfEntries.put(ze2.getName(), attrs);
                        mfModified = true;
                    }
                    if (mfModified) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        manifest.write(baos);
                        byte[] newBytes = baos.toByteArray();
                        if (mfRawBytes != null && oldAttr.equals(manifest.getMainAttributes())) {
                            int oldPos;
                            int newPos = this.findHeaderEnd(newBytes);
                            if (newPos == (oldPos = this.findHeaderEnd(mfRawBytes))) {
                                System.arraycopy(mfRawBytes, 0, newBytes, 0, oldPos);
                            } else {
                                byte[] lastBytes = new byte[oldPos + newBytes.length - newPos];
                                System.arraycopy(mfRawBytes, 0, lastBytes, 0, oldPos);
                                System.arraycopy(newBytes, newPos, lastBytes, oldPos, newBytes.length - newPos);
                                newBytes = lastBytes;
                            }
                        }
                        mfRawBytes = newBytes;
                    }
                    if (mfModified) {
                        mfFile = new ZipEntry("META-INF/MANIFEST.MF");
                    }
                    zos.putNextEntry(mfFile);
                    zos.write(mfRawBytes);
                    ManifestDigester manDig = new ManifestDigester(mfRawBytes);
                    SignatureFile sf = new SignatureFile(digests, manifest, manDig, this.sigfile, this.signManifest);
                    if (this.tsaAlias != null) {
                        tsaCert = this.getTsaCert(this.tsaAlias);
                    }
                    SignatureFile.Block block = null;
                    try {
                        block = sf.generateBlock(this.privateKey, this.sigalg, this.certChain, this.externalSF, this.tsaUrl, tsaCert, this.signingMechanism, args, this.zipFile);
                    }
                    catch (SocketTimeoutException e) {
                        this.error(String.valueOf(rb.getString("unable to sign jar: ")) + rb.getString("no response from the Timestamping Authority. ") + rb.getString("When connecting from behind a firewall then an HTTP proxy may need to be specified. ") + rb.getString("Supply the following options to jarsigner: ") + "\n  -J-Dhttp.proxyHost=<hostname> " + "\n  -J-Dhttp.proxyPort=<portnumber> ", e);
                    }
                    sfFilename = sf.getMetaName();
                    bkFilename = block.getMetaName();
                    ZipEntry sfFile = new ZipEntry(sfFilename);
                    ZipEntry bkFile = new ZipEntry(bkFilename);
                    long time = System.currentTimeMillis();
                    sfFile.setTime(time);
                    bkFile.setTime(time);
                    zos.putNextEntry(sfFile);
                    sf.write(zos);
                    zos.putNextEntry(bkFile);
                    block.write(zos);
                    int i = 0;
                    while (i < mfFiles.size()) {
                        ze = (ZipEntry)mfFiles.elementAt(i);
                        if (!(ze.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || ze.getName().equalsIgnoreCase(sfFilename) || ze.getName().equalsIgnoreCase(bkFilename))) {
                            this.writeEntry(this.zipFile, zos, ze);
                        }
                        ++i;
                    }
                    Enumeration<? extends ZipEntry> enum_2 = this.zipFile.entries();
                    while (enum_2.hasMoreElements()) {
                        ze = enum_2.nextElement();
                        if (ze.getName().startsWith(META_INF)) continue;
                        this.writeEntry(this.zipFile, zos, ze);
                    }
                }
                catch (IOException ioe) {
                    this.error(String.valueOf(rb.getString("unable to sign jar: ")) + ioe, ioe);
                    if (this.zipFile != null) {
                        this.zipFile.close();
                        this.zipFile = null;
                    }
                    if (zos != null) {
                        zos.close();
                    }
                    break block50;
                }
            }
            catch (Throwable throwable) {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
                if (zos != null) {
                    zos.close();
                }
                throw throwable;
            }
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
            if (zos != null) {
                zos.close();
            }
        }
        if (this.signedjar == null && !signedJarFile.renameTo(jarFile)) {
            Object[] source;
            MessageFormat form;
            File origJar = new File(String.valueOf(jarName) + ".orig");
            if (jarFile.renameTo(origJar)) {
                if (signedJarFile.renameTo(jarFile)) {
                    origJar.delete();
                } else {
                    form = new MessageFormat(rb.getString("attempt to rename signedJarFile to jarFile failed"));
                    source = new Object[]{signedJarFile, jarFile};
                    this.error(form.format(source));
                }
            } else {
                form = new MessageFormat(rb.getString("attempt to rename jarFile to origJar failed"));
                source = new Object[]{jarFile, origJar};
                this.error(form.format(source));
            }
        }
        if (this.hasExpiredCert || this.hasExpiringCert || this.notYetValidCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType) {
            logger.warn((Object)rb.getString("Warning: "));
            if (this.badKeyUsage) {
                logger.warn((Object)rb.getString("The signer certificate's KeyUsage extension doesn't allow code signing."));
            }
            if (this.badExtendedKeyUsage) {
                logger.warn((Object)rb.getString("The signer certificate's ExtendedKeyUsage extension doesn't allow code signing."));
            }
            if (this.badNetscapeCertType) {
                logger.warn((Object)rb.getString("The signer certificate's NetscapeCertType extension doesn't allow code signing."));
            }
            if (this.hasExpiredCert) {
                logger.warn((Object)rb.getString("The signer certificate has expired."));
            } else if (this.hasExpiringCert) {
                logger.warn((Object)rb.getString("The signer certificate will expire within six months."));
            } else if (this.notYetValidCert) {
                logger.warn((Object)rb.getString("The signer certificate is not yet valid."));
            }
        }
    }

    private int findHeaderEnd(byte[] bs) {
        int i = 0;
        while (i < bs.length - 3) {
            if (bs[i] == 13 && bs[i + 1] == 10 && bs[i + 2] == 13 && bs[i + 3] == 10) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private boolean signatureRelated(String name) {
        String ucName = name.toUpperCase();
        if (ucName.equals("META-INF/MANIFEST.MF") || ucName.equals(META_INF) || ucName.startsWith(SIG_PREFIX) && ucName.indexOf("/") == ucName.lastIndexOf("/")) {
            return true;
        }
        if (ucName.startsWith(META_INF) && SignatureFileVerifier.isBlockOrSF(ucName)) {
            return ucName.indexOf("/") == ucName.lastIndexOf("/");
        }
        return false;
    }

    private void writeEntry(ZipFile zf, ZipOutputStream os, ZipEntry ze) throws IOException {
        ZipEntry ze2 = new ZipEntry(ze.getName());
        ze2.setMethod(ze.getMethod());
        ze2.setTime(ze.getTime());
        ze2.setComment(ze.getComment());
        ze2.setExtra(ze.getExtra());
        if (ze.getMethod() == 0) {
            ze2.setSize(ze.getSize());
            ze2.setCrc(ze.getCrc());
        }
        os.putNextEntry(ze2);
        this.writeBytes(zf, ze, os);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void writeBytes(ZipFile zf, ZipEntry ze, ZipOutputStream os) throws IOException {
        InputStream is = null;
        try {
            block7: {
                int n;
                long left;
                block6: {
                    is = zf.getInputStream(ze);
                    left = ze.getSize();
                    if (!true) break block6;
                    if (left <= 0L) return;
                    if ((n = is.read(this.buffer, 0, this.buffer.length)) == -1) break block7;
                }
                do {
                    os.write(this.buffer, 0, n);
                    left -= (long)n;
                    if (left <= 0L) return;
                } while ((n = is.read(this.buffer, 0, this.buffer.length)) != -1);
            }
            return;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    X509Certificate getTsaCert(String alias) throws JarSigningException {
        Certificate cs = null;
        try {
            cs = this.store.getCertificate(alias);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (cs == null || !(cs instanceof X509Certificate)) {
            MessageFormat form = new MessageFormat(rb.getString("Certificate not found for: alias.  alias must reference a valid KeyStore entry containing an X.509 public key certificate for the Timestamping Authority."));
            Object[] source = new Object[]{alias, alias};
            this.error(form.format(source));
        }
        return (X509Certificate)cs;
    }

    void checkCertUsage(X509Certificate userCert, boolean[] bad) {
        boolean[] keyUsage;
        if (bad != null) {
            bad[2] = false;
            bad[1] = false;
            bad[0] = false;
        }
        if (!((keyUsage = userCert.getKeyUsage()) == null || keyUsage.length >= 1 && keyUsage[0])) {
            if (bad != null) {
                bad[0] = true;
            } else {
                this.badKeyUsage = true;
            }
        }
        try {
            List<String> xKeyUsage = userCert.getExtendedKeyUsage();
            if (xKeyUsage != null && !xKeyUsage.contains("2.5.29.37.0") && !xKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
                if (bad != null) {
                    bad[1] = true;
                } else {
                    this.badExtendedKeyUsage = true;
                }
            }
        }
        catch (CertificateParsingException xKeyUsage) {
            // empty catch block
        }
        try {
            byte[] netscapeEx = userCert.getExtensionValue("2.16.840.1.113730.1.1");
            if (netscapeEx != null) {
                DerInputStream in = new DerInputStream(netscapeEx);
                byte[] encoded = in.getOctetString();
                NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded = new DerValue(encoded).getUnalignedBitString().toByteArray());
                Boolean val = (Boolean)extn.get("object_signing");
                if (!val.booleanValue()) {
                    if (bad != null) {
                        bad[2] = true;
                    } else {
                        this.badNetscapeCertType = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void error(String message) throws JarSigningException {
        logger.error((Object)(String.valueOf(rb.getString("jarsigner: ")) + message));
        throw new JarSigningException(message);
    }

    void error(String message, Exception e) throws JarSigningException {
        logger.error((Object)(String.valueOf(rb.getString("jarsigner: ")) + message), (Throwable)e);
        throw new JarSigningException(e.getMessage());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] getBytes(ZipFile zf, ZipEntry ze) throws IOException {
        InputStream is = null;
        try {
            block7: {
                int n;
                long left;
                block6: {
                    is = zf.getInputStream(ze);
                    this.baos.reset();
                    left = ze.getSize();
                    if (!true) break block6;
                    if (left <= 0L) return this.baos.toByteArray();
                    if ((n = is.read(this.buffer, 0, this.buffer.length)) == -1) break block7;
                }
                do {
                    this.baos.write(this.buffer, 0, n);
                    left -= (long)n;
                    if (left <= 0L) return this.baos.toByteArray();
                } while ((n = is.read(this.buffer, 0, this.buffer.length)) != -1);
            }
            return this.baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private ZipEntry getManifestFile(ZipFile zf) {
        ZipEntry ze = zf.getEntry("META-INF/MANIFEST.MF");
        if (ze == null) {
            Enumeration<? extends ZipEntry> enum_ = zf.entries();
            while (enum_.hasMoreElements() && ze == null) {
                ze = enum_.nextElement();
                if ("META-INF/MANIFEST.MF".equalsIgnoreCase(ze.getName())) continue;
                ze = null;
            }
        }
        return ze;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String[] getDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder) throws IOException {
        int i;
        InputStream is = null;
        try {
            int n;
            is = zf.getInputStream(ze);
            long left = ze.getSize();
            while (left > 0L && (n = is.read(this.buffer, 0, this.buffer.length)) != -1) {
                i = 0;
                while (i < digests.length) {
                    digests[i].update(this.buffer, 0, n);
                    ++i;
                }
                left -= (long)n;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String[] base64Digests = new String[digests.length];
        i = 0;
        while (i < digests.length) {
            base64Digests[i] = encoder.encode(digests[i].digest());
            ++i;
        }
        return base64Digests;
    }

    private Attributes getDigestAttributes(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder) throws IOException {
        String[] base64Digests = this.getDigests(ze, zf, digests, encoder);
        Attributes attrs = new Attributes();
        int i = 0;
        while (i < digests.length) {
            attrs.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest", base64Digests[i]);
            ++i;
        }
        return attrs;
    }

    private boolean updateDigests(ZipEntry ze, ZipFile zf, MessageDigest[] digests, BASE64Encoder encoder, Manifest mf) throws IOException {
        boolean update = false;
        Attributes attrs = mf.getAttributes(ze.getName());
        String[] base64Digests = this.getDigests(ze, zf, digests, encoder);
        int i = 0;
        while (i < digests.length) {
            String name = String.valueOf(digests[i].getAlgorithm()) + "-Digest";
            String mfDigest = attrs.getValue(name);
            if (mfDigest == null && digests[i].getAlgorithm().equalsIgnoreCase("SHA")) {
                mfDigest = attrs.getValue("SHA-Digest");
            }
            if (mfDigest == null) {
                attrs.putValue(name, base64Digests[i]);
                update = true;
            } else if (!mfDigest.equalsIgnoreCase(base64Digests[i])) {
                attrs.putValue(name, base64Digests[i]);
                update = true;
            }
            ++i;
        }
        return update;
    }

    void loadKeyStore(String keyStoreName, boolean prompt) {
        block14: {
            if (!this.nullStream && keyStoreName == null) {
                keyStoreName = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
            }
            try {
                this.store = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
                if (this.nullStream) {
                    this.store.load(null, this.storepass);
                    break block14;
                }
                keyStoreName = keyStoreName.replace(File.separatorChar, '/');
                URL url = null;
                try {
                    url = new URL(keyStoreName);
                }
                catch (MalformedURLException e) {
                    url = new File(keyStoreName).toURI().toURL();
                }
                InputStream is = null;
                try {
                    is = url.openStream();
                    this.store.load(is, this.storepass);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + ioe.getMessage());
            }
            catch (CertificateException ce) {
                throw new RuntimeException(String.valueOf(rb.getString("certificate exception: ")) + ce.getMessage());
            }
            catch (NoSuchProviderException pe) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + pe.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException(String.valueOf(rb.getString("keystore load: ")) + nsae.getMessage());
            }
            catch (KeyStoreException kse) {
                throw new RuntimeException(String.valueOf(rb.getString("unable to instantiate keystore class: ")) + kse.getMessage());
            }
        }
    }

    void getAliasInfo(String alias) throws JarSigningException {
        Key key = null;
        try {
            Certificate[] cs = null;
            try {
                cs = this.store.getCertificateChain(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            if (cs == null) {
                MessageFormat form = new MessageFormat(rb.getString("Certificate chain not found for: alias.  alias must reference a valid KeyStore key entry containing a private key and corresponding public key certificate chain."));
                Object[] source = new Object[]{alias, alias};
                this.error(form.format(source));
            }
            this.certChain = new X509Certificate[cs.length];
            int i = 0;
            while (i < cs.length) {
                if (!(cs[i] instanceof X509Certificate)) {
                    this.error(rb.getString("found non-X.509 certificate in signer's chain"));
                }
                this.certChain[i] = (X509Certificate)cs[i];
                ++i;
            }
            X509Certificate userCert = (X509Certificate)this.store.getCertificate(alias);
            try {
                userCert.checkValidity();
                if (userCert.getNotAfter().getTime() < System.currentTimeMillis() + 15552000000L) {
                    this.hasExpiringCert = true;
                }
            }
            catch (CertificateExpiredException cee) {
                this.hasExpiredCert = true;
            }
            catch (CertificateNotYetValidException cnyve) {
                this.notYetValidCert = true;
            }
            this.checkCertUsage(userCert, null);
            if (!userCert.equals(this.certChain[0])) {
                X509Certificate[] certChainTmp = new X509Certificate[this.certChain.length];
                certChainTmp[0] = userCert;
                Principal issuer = userCert.getIssuerDN();
                int i2 = 1;
                while (i2 < this.certChain.length) {
                    int j = 0;
                    while (j < certChainTmp.length) {
                        Principal subject;
                        if (certChainTmp[j] != null && issuer.equals(subject = certChainTmp[j].getSubjectDN())) {
                            this.certChain[i2] = certChainTmp[j];
                            issuer = certChainTmp[j].getIssuerDN();
                            certChainTmp[j] = null;
                            break;
                        }
                        ++j;
                    }
                    if (j == certChainTmp.length) {
                        this.error(rb.getString("incomplete certificate chain"));
                    }
                    ++i2;
                }
                this.certChain = certChainTmp;
            }
            try {
                key = !this.token && this.keypass == null ? this.store.getKey(alias, this.storepass) : this.store.getKey(alias, this.keypass);
            }
            catch (UnrecoverableKeyException e) {
                if (this.token) {
                    throw e;
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.error(e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            this.error(rb.getString("unable to recover key from keystore"));
        }
        catch (KeyStoreException e) {
            // empty catch block
        }
        if (!(key instanceof PrivateKey)) {
            MessageFormat form = new MessageFormat(rb.getString("key associated with alias not a private key"));
            Object[] source = new Object[]{alias};
            this.error(form.format(source));
        } else {
            this.privateKey = (PrivateKey)key;
        }
    }

    class JarBASE64Encoder
    extends BASE64Encoder {
        JarBASE64Encoder() {
        }

        protected void encodeLineSuffix(OutputStream aStream) throws IOException {
        }
    }

    class JarSignerParameters
    implements ContentSignerParameters {
        private String[] args;
        private URI tsa;
        private X509Certificate tsaCertificate;
        private byte[] signature;
        private String signatureAlgorithm;
        private X509Certificate[] signerCertificateChain;
        private byte[] content;
        private ZipFile source;

        JarSignerParameters(String[] args, URI tsa, X509Certificate tsaCertificate, byte[] signature, String signatureAlgorithm, X509Certificate[] signerCertificateChain, byte[] content, ZipFile source) {
            if (signature == null || signatureAlgorithm == null || signerCertificateChain == null) {
                throw new NullPointerException();
            }
            this.args = args;
            this.tsa = tsa;
            this.tsaCertificate = tsaCertificate;
            this.signature = signature;
            this.signatureAlgorithm = signatureAlgorithm;
            this.signerCertificateChain = signerCertificateChain;
            this.content = content;
            this.source = source;
        }

        public String[] getCommandLine() {
            return this.args;
        }

        public URI getTimestampingAuthority() {
            return this.tsa;
        }

        public X509Certificate getTimestampingAuthorityCertificate() {
            return this.tsaCertificate;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public X509Certificate[] getSignerCertificateChain() {
            return this.signerCertificateChain;
        }

        public byte[] getContent() {
            return this.content;
        }

        public ZipFile getSource() {
            return this.source;
        }
    }

    class SignatureFile {
        Manifest sf;
        String baseName;

        public SignatureFile(MessageDigest[] digests, Manifest mf, ManifestDigester md, String baseName, boolean signManifest) {
            ManifestDigester.Entry mde;
            this.baseName = baseName;
            String version = System.getProperty("java.version");
            String javaVendor = System.getProperty("java.vendor");
            this.sf = new Manifest();
            Attributes mattr = this.sf.getMainAttributes();
            JarBASE64Encoder encoder = new JarBASE64Encoder();
            mattr.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
            mattr.putValue("Created-By", String.valueOf(version) + " (" + javaVendor + ")");
            if (signManifest) {
                int i = 0;
                while (i < digests.length) {
                    mattr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest-Manifest", encoder.encode(md.manifestDigest(digests[i])));
                    ++i;
                }
            }
            if ((mde = md.get("Manifest-Main-Attributes", false)) != null) {
                int i = 0;
                while (i < digests.length) {
                    mattr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest-" + "Manifest-Main-Attributes", encoder.encode(mde.digest(digests[i])));
                    ++i;
                }
            } else {
                throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
            }
            Map<String, Attributes> entries = this.sf.getEntries();
            for (Map.Entry<String, Attributes> e : mf.getEntries().entrySet()) {
                String name = e.getKey();
                mde = md.get(name, false);
                if (mde == null) continue;
                Attributes attr = new Attributes();
                int i = 0;
                while (i < digests.length) {
                    attr.putValue(String.valueOf(digests[i].getAlgorithm()) + "-Digest", encoder.encode(mde.digest(digests[i])));
                    ++i;
                }
                entries.put(name, attr);
            }
        }

        public void write(OutputStream out) throws IOException {
            this.sf.write(out);
        }

        public String getMetaName() {
            return JarSigner.META_INF + this.baseName + ".SF";
        }

        public String getBaseName() {
            return this.baseName;
        }

        public Block generateBlock(PrivateKey privateKey, String sigalg, X509Certificate[] certChain, boolean externalSF, String tsaUrl, X509Certificate tsaCert, ContentSigner signingMechanism, String[] args, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            return new Block(this, privateKey, sigalg, certChain, externalSF, tsaUrl, tsaCert, signingMechanism, args, zipFile);
        }

        public class Block {
            private byte[] block;
            private String blockFileName;

            Block(SignatureFile sfg, PrivateKey privateKey, String sigalg, X509Certificate[] certChain, boolean externalSF, String tsaUrl, X509Certificate tsaCert, ContentSigner signingMechanism, String[] args, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
                String signatureAlgorithm;
                Principal issuerName = certChain[0].getIssuerDN();
                if (!(issuerName instanceof X500Name)) {
                    X509CertInfo tbsCert = new X509CertInfo(certChain[0].getTBSCertificate());
                    issuerName = (Principal)tbsCert.get("issuer.dname");
                }
                BigInteger serial = certChain[0].getSerialNumber();
                String keyAlgorithm = privateKey.getAlgorithm();
                if (sigalg == null) {
                    String digestAlgorithm;
                    if (keyAlgorithm.equalsIgnoreCase("DSA")) {
                        digestAlgorithm = "SHA1";
                    } else if (keyAlgorithm.equalsIgnoreCase("RSA")) {
                        digestAlgorithm = "SHA1";
                    } else {
                        throw new RuntimeException("private key is not a DSA or RSA key");
                    }
                    signatureAlgorithm = String.valueOf(digestAlgorithm) + "with" + keyAlgorithm;
                } else {
                    signatureAlgorithm = sigalg;
                }
                String sigAlgUpperCase = signatureAlgorithm.toUpperCase();
                if (sigAlgUpperCase.endsWith("WITHRSA") && !keyAlgorithm.equalsIgnoreCase("RSA") || sigAlgUpperCase.endsWith("WITHDSA") && !keyAlgorithm.equalsIgnoreCase("DSA")) {
                    throw new SignatureException("private key algorithm is not compatible with signature algorithm");
                }
                this.blockFileName = JarSigner.META_INF + sfg.getBaseName() + "." + keyAlgorithm;
                AlgorithmId sigAlg = AlgorithmId.get(signatureAlgorithm);
                AlgorithmId digEncrAlg = AlgorithmId.get(keyAlgorithm);
                Signature sig = Signature.getInstance(signatureAlgorithm);
                sig.initSign(privateKey);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                sfg.write(baos);
                byte[] content = baos.toByteArray();
                sig.update(content);
                byte[] signature = sig.sign();
                if (signingMechanism == null) {
                    signingMechanism = new TimestampedSigner();
                }
                URI tsaUri = null;
                try {
                    if (tsaUrl != null) {
                        tsaUri = new URI(tsaUrl);
                    }
                }
                catch (URISyntaxException e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                JarSignerParameters params = new JarSignerParameters(args, tsaUri, tsaCert, signature, signatureAlgorithm, certChain, content, zipFile);
                this.block = signingMechanism.generateSignedData((ContentSignerParameters)params, externalSF, tsaUrl != null || tsaCert != null);
            }

            public String getMetaName() {
                return this.blockFileName;
            }

            public void write(OutputStream out) throws IOException {
                out.write(this.block);
            }
        }
    }
}

